/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.util.ProbUtils;
import java.util.Arrays;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.util.FastMath;

public class EstimateRank {
    public static double[] CanCor(double[][] A, double[][] B) {
        RealMatrix Ua = new SingularValueDecomposition(new BlockRealMatrix(A)).getU();
        RealMatrix UTa = Ua.transpose();
        RealMatrix Ub = new SingularValueDecomposition(new BlockRealMatrix(B)).getU();
        return new SingularValueDecomposition(UTa.multiply(Ub)).getSingularValues();
    }

    public static double[] CanCor(int[] iA, int[] iB, double[][] cov) {
        RealMatrix covA = new BlockRealMatrix(cov).getSubMatrix(iA, iA);
        RealMatrix covB = new BlockRealMatrix(cov).getSubMatrix(iB, iB);
        RealMatrix covAB = new BlockRealMatrix(cov).getSubMatrix(iA, iB);
        RealMatrix covBA = new BlockRealMatrix(cov).getSubMatrix(iB, iA);
        RealMatrix S = EstimateRank.getInverse(covA).multiply(covAB).multiply(EstimateRank.getInverse(covB)).multiply(covBA);
        double[] rtCors = new EigenDecomposition(S).getRealEigenvalues();
        Arrays.sort(rtCors);
        double[] Cors = new double[rtCors.length];
        for (int i = rtCors.length; i > 0; --i) {
            Cors[rtCors.length - i] = FastMath.pow(rtCors[i - 1], 0.5);
        }
        return Cors;
    }

    public static int Estimate(double[][] A, double[][] B, double alpha) {
        double[] Cors = EstimateRank.CanCor(A, B);
        int rank = 0;
        boolean reject = true;
        while (reject) {
            double sum = 0.0;
            for (int i = rank; i < FastMath.min(A[0].length, B[0].length); ++i) {
                sum += FastMath.log(1.0 - FastMath.pow(Cors[i], 2));
            }
            double stat = -((double)A.length - 0.5 * (double)(A[0].length + B[0].length + 3)) * sum;
            reject = ProbUtils.chisqCdf(stat, (A[0].length - rank) * (B[0].length - rank)) > 1.0 - alpha;
            if (reject & rank < FastMath.min(A[0].length, B[0].length)) {
                ++rank;
                continue;
            }
            reject = false;
        }
        return rank;
    }

    public static int Estimate(int[] iA, int[] iB, double[][] cov, int N, double alpha) {
        double[] Cors = EstimateRank.CanCor(iA, iB, cov);
        int rank = 0;
        boolean reject = true;
        while (reject) {
            double sum = 0.0;
            for (int i = rank; i < FastMath.min(iA.length, iB.length); ++i) {
                sum += FastMath.log(1.0 - FastMath.pow(Cors[i], 2));
            }
            double stat = -((double)N - 0.5 * (double)(iA.length + iB.length + 3)) * sum;
            reject = ProbUtils.chisqCdf(stat, (iA.length - rank) * (iB.length - rank)) > 1.0 - alpha;
            if (reject & rank < FastMath.min(iA.length, iB.length)) {
                ++rank;
                continue;
            }
            reject = false;
        }
        return rank;
    }

    private static RealMatrix getInverse(RealMatrix covA) {
        return new LUDecomposition(covA).getSolver().getInverse();
    }
}

