/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.utils.SepsetProducer;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class FciOrient {
    private final SepsetProducer sepsets;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Knowledge knowledge = new Knowledge();
    private boolean changeFlag = true;
    private boolean completeRuleSetUsed = true;
    private int maxPathLength = -1;
    private boolean verbose;
    private Graph truePag;
    private boolean doDiscriminatingPathColliderRule = true;
    private boolean doDiscriminatingPathTailRule = true;

    public FciOrient(SepsetProducer sepsets) {
        this.sepsets = sepsets;
    }

    public static List<List<Node>> getUcPdPaths(Node n1, Node n2, Graph graph) {
        LinkedList<List<Node>> ucPdPaths = new LinkedList<List<Node>>();
        LinkedList<Node> soFar = new LinkedList<Node>();
        soFar.add(n1);
        List<Node> adjacencies = graph.getAdjacentNodes(n1);
        for (Node curr : adjacencies) {
            FciOrient.getUcPdPsHelper(curr, soFar, n2, ucPdPaths, graph);
        }
        return ucPdPaths;
    }

    private static void getUcPdPsHelper(Node curr, List<Node> soFar, Node end, List<List<Node>> ucPdPaths, Graph graph) {
        Node prev2;
        if (soFar.contains(curr)) {
            return;
        }
        Node prev = soFar.get(soFar.size() - 1);
        if (graph.getEndpoint(prev, curr) == Endpoint.TAIL || graph.getEndpoint(curr, prev) == Endpoint.ARROW) {
            return;
        }
        if (soFar.size() >= 2 && graph.isAdjacentTo(prev2 = soFar.get(soFar.size() - 2), curr)) {
            return;
        }
        soFar.add(curr);
        if (curr.equals(end)) {
            ucPdPaths.add(new LinkedList<Node>(soFar));
        } else {
            List<Node> adjacents = graph.getAdjacentNodes(curr);
            for (Node next : adjacents) {
                FciOrient.getUcPdPsHelper(next, soFar, end, ucPdPaths, graph);
            }
        }
        soFar.remove(soFar.get(soFar.size() - 1));
    }

    public static List<List<Node>> getUcCirclePaths(Node n1, Node n2, Graph graph) {
        LinkedList<List<Node>> ucCirclePaths = new LinkedList<List<Node>>();
        List<List<Node>> ucPdPaths = FciOrient.getUcPdPaths(n1, n2, graph);
        for (List<Node> path : ucPdPaths) {
            Node sj;
            Node j;
            for (int i = 0; i < path.size() - 1 && graph.getEndpoint(j = path.get(i), sj = path.get(i + 1)) == Endpoint.CIRCLE && graph.getEndpoint(sj, j) == Endpoint.CIRCLE; ++i) {
                if (i != path.size() - 2) continue;
                ucCirclePaths.add(path);
            }
        }
        return ucCirclePaths;
    }

    public static boolean isArrowheadAllowed(Node x, Node y, Graph graph, Knowledge knowledge) {
        if (!graph.isAdjacentTo(x, y)) {
            return false;
        }
        if (graph.getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (graph.getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (graph.getEndpoint(y, x) == Endpoint.ARROW && graph.getEndpoint(x, y) == Endpoint.CIRCLE && knowledge.isForbidden(x.getName(), y.getName())) {
            return true;
        }
        if (graph.getEndpoint(y, x) == Endpoint.TAIL && graph.getEndpoint(x, y) == Endpoint.CIRCLE && knowledge.isForbidden(x.getName(), y.getName())) {
            return false;
        }
        return graph.getEndpoint(x, y) == Endpoint.CIRCLE;
    }

    public Graph orient(Graph graph) {
        this.logger.forceLogMessage("Starting FCI algorithm.");
        this.ruleR0(graph);
        if (this.verbose) {
            this.logger.forceLogMessage("R0");
        }
        this.doFinalOrientation(graph);
        if (this.verbose) {
            this.logger.forceLogMessage("Returning graph: " + graph);
        }
        return graph;
    }

    public SepsetProducer getSepsets() {
        return this.sepsets;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = new Knowledge(knowledge);
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public void ruleR0(Graph graph) {
        graph.reorientAllWith(Endpoint.CIRCLE);
        this.fciOrientbk(this.knowledge, graph, graph.getNodes());
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            if (Thread.currentThread().isInterrupted()) break;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(graph.getAdjacentNodes(b));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                Node c;
                Node a = (Node)adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(a, c = (Node)adjacentNodes.get(combination[1])) || graph.isDefCollider(a, b, c) || !this.sepsets.isUnshieldedCollider(a, b, c) || !FciOrient.isArrowheadAllowed(a, b, graph, this.knowledge) || !FciOrient.isArrowheadAllowed(c, b, graph, this.knowledge)) continue;
                graph.setEndpoint(a, b, Endpoint.ARROW);
                graph.setEndpoint(c, b, Endpoint.ARROW);
                if (!this.verbose) continue;
                this.logger.forceLogMessage(LogUtilsSearch.colliderOrientedMsg(a, b, c));
                this.printWrongColliderMessage(a, b, c, graph);
            }
        }
    }

    public void doFinalOrientation(Graph graph) {
        if (this.completeRuleSetUsed) {
            this.zhangFinalOrientation(graph);
        } else {
            this.spirtesFinalOrientation(graph);
        }
    }

    public void spirtesFinalOrientation(Graph graph) {
        this.changeFlag = true;
        boolean firstTime = true;
        while (this.changeFlag && !Thread.currentThread().isInterrupted()) {
            this.changeFlag = false;
            this.rulesR1R2cycle(graph);
            this.ruleR3(graph);
            if (this.changeFlag || firstTime && !this.knowledge.isEmpty()) {
                this.ruleR4B(graph);
                firstTime = false;
            }
            if (!this.verbose) continue;
            this.logger.forceLogMessage("Epoch");
        }
    }

    public void zhangFinalOrientation(Graph graph) {
        this.changeFlag = true;
        boolean firstTime = true;
        while (this.changeFlag && !Thread.currentThread().isInterrupted()) {
            this.changeFlag = false;
            this.rulesR1R2cycle(graph);
            this.ruleR3(graph);
            if (this.changeFlag || firstTime && !this.knowledge.isEmpty()) {
                this.ruleR4B(graph);
                firstTime = false;
            }
            if (!this.verbose) continue;
            this.logger.forceLogMessage("Epoch");
        }
        if (this.isCompleteRuleSetUsed()) {
            this.ruleR5(graph);
            this.changeFlag = true;
            while (this.changeFlag && !Thread.currentThread().isInterrupted()) {
                this.changeFlag = false;
                this.ruleR6R7(graph);
            }
            this.changeFlag = true;
            while (this.changeFlag && !Thread.currentThread().isInterrupted()) {
                this.changeFlag = false;
                this.rulesR8R9R10(graph);
            }
        }
    }

    public void rulesR1R2cycle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            if (Thread.currentThread().isInterrupted()) break;
            ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(B));
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                Node A = (Node)adj.get(combination[0]);
                Node C = (Node)adj.get(combination[1]);
                this.ruleR1(A, B, C, graph);
                this.ruleR1(C, B, A, graph);
                this.ruleR2(A, B, C, graph);
                this.ruleR2(C, B, A, graph);
            }
        }
    }

    public void ruleR1(Node a, Node b, Node c, Graph graph) {
        if (graph.isAdjacentTo(a, c)) {
            return;
        }
        if (graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(c, b) == Endpoint.CIRCLE) {
            if (!FciOrient.isArrowheadAllowed(b, c, graph, this.knowledge)) {
                return;
            }
            graph.setEndpoint(c, b, Endpoint.TAIL);
            graph.setEndpoint(b, c, Endpoint.ARROW);
            this.changeFlag = true;
            if (this.verbose) {
                this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R1: Away from collider", graph.getEdge(b, c)));
            }
        }
    }

    public void ruleR2(Node a, Node b, Node c, Graph graph) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.CIRCLE && graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(b, c) == Endpoint.ARROW && (graph.getEndpoint(b, a) == Endpoint.TAIL || graph.getEndpoint(c, b) == Endpoint.TAIL)) {
            if (!FciOrient.isArrowheadAllowed(a, c, graph, this.knowledge)) {
                return;
            }
            graph.setEndpoint(a, c, Endpoint.ARROW);
            if (this.verbose) {
                this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R2: Away from ancestor", graph.getEdge(a, c)));
            }
            this.changeFlag = true;
        }
    }

    public void ruleR3(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            int[] choice;
            if (Thread.currentThread().isInterrupted()) break;
            List<Node> intoBArrows = graph.getNodesInTo(b, Endpoint.ARROW);
            if (intoBArrows.size() < 2) continue;
            ChoiceGenerator gen = new ChoiceGenerator(intoBArrows.size(), 2);
            while ((choice = gen.next()) != null) {
                List<Node> B = GraphUtils.asList(choice, intoBArrows);
                Node a = B.get(0);
                Node c = B.get(1);
                ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(a));
                adj.retainAll(graph.getAdjacentNodes(c));
                for (Node d : adj) {
                    if (d == a || graph.getEndpoint(a, d) != Endpoint.CIRCLE || graph.getEndpoint(c, d) != Endpoint.CIRCLE || graph.isAdjacentTo(a, c) || graph.getEndpoint(d, b) != Endpoint.CIRCLE) continue;
                    if (!FciOrient.isArrowheadAllowed(d, b, graph, this.knowledge)) {
                        return;
                    }
                    graph.setEndpoint(d, b, Endpoint.ARROW);
                    if (this.verbose) {
                        this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R3: Double triangle", graph.getEdge(d, b)));
                    }
                    this.changeFlag = true;
                }
            }
        }
    }

    public void ruleR4B(Graph graph) {
        if (this.doDiscriminatingPathColliderRule || this.doDiscriminatingPathTailRule) {
            List<Node> nodes = graph.getNodes();
            block0: for (Node b : nodes) {
                if (Thread.currentThread().isInterrupted()) break;
                List<Node> possA = graph.getNodesOutTo(b, Endpoint.ARROW);
                List<Node> possC = graph.getNodesInTo(b, Endpoint.CIRCLE);
                block1: for (Node a : possA) {
                    if (Thread.currentThread().isInterrupted()) continue block0;
                    for (Node c : possC) {
                        if (Thread.currentThread().isInterrupted()) continue block1;
                        if (a == c || !graph.isParentOf(a, c) || graph.getEndpoint(b, c) != Endpoint.ARROW) continue;
                        this.ddpOrient(a, b, c, graph);
                    }
                }
            }
        }
    }

    public void ddpOrient(Node a, Node b, Node c, Graph graph) {
        ArrayDeque<Node> Q = new ArrayDeque<Node>(20);
        HashSet<Node> V = new HashSet<Node>();
        Node e = null;
        int distance = 0;
        HashMap<Node, Node> previous = new HashMap<Node, Node>();
        List<Node> cParents = graph.getParents(c);
        Q.offer(a);
        V.add(a);
        V.add(b);
        previous.put(a, b);
        block0: while (!Q.isEmpty() && !Thread.currentThread().isInterrupted()) {
            Node t = (Node)Q.poll();
            if (e == null || e == t) {
                e = t;
                if (++distance > 0 && distance > (this.maxPathLength == -1 ? 1000 : this.maxPathLength)) {
                    return;
                }
            }
            List<Node> nodesInTo = graph.getNodesInTo(t, Endpoint.ARROW);
            for (Node d : nodesInTo) {
                if (Thread.currentThread().isInterrupted()) continue block0;
                if (V.contains(d)) continue;
                previous.put(d, t);
                Node p = (Node)previous.get(t);
                if (!graph.isDefCollider(d, t, p)) continue;
                previous.put(d, t);
                if (!graph.isAdjacentTo(d, c) && this.doDdpOrientation(d, a, b, c, graph)) {
                    return;
                }
                if (!cParents.contains(d)) continue;
                Q.offer(d);
                V.add(d);
            }
        }
    }

    public void ruleR5(Graph graph) {
        List<Node> nodes = graph.getNodes();
        block0: for (Node a : nodes) {
            if (Thread.currentThread().isInterrupted()) break;
            List<Node> adjacents = graph.getNodesInTo(a, Endpoint.CIRCLE);
            block1: for (Node b : adjacents) {
                if (Thread.currentThread().isInterrupted()) continue block0;
                if (graph.getEndpoint(a, b) != Endpoint.CIRCLE) continue;
                List<List<Node>> ucCirclePaths = FciOrient.getUcCirclePaths(a, b, graph);
                for (List<Node> u : ucCirclePaths) {
                    if (Thread.currentThread().isInterrupted()) continue block1;
                    if (u.size() < 3) continue;
                    Node c = u.get(1);
                    Node d = u.get(u.size() - 2);
                    if (graph.isAdjacentTo(a, d) || graph.isAdjacentTo(b, c)) continue;
                    graph.setEndpoint(a, b, Endpoint.TAIL);
                    graph.setEndpoint(b, a, Endpoint.TAIL);
                    if (this.verbose) {
                        this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R5: Orient circle path", graph.getEdge(a, b)));
                    }
                    this.orientTailPath(u, graph);
                    this.changeFlag = true;
                }
            }
        }
    }

    public void ruleR6R7(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            if (Thread.currentThread().isInterrupted()) break;
            ArrayList<Node> adjacents = new ArrayList<Node>(graph.getAdjacentNodes(b));
            if (adjacents.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacents.size(), 2);
            int[] choice = cg.next();
            while (choice != null && !Thread.currentThread().isInterrupted()) {
                Node c;
                Node a = (Node)adjacents.get(choice[0]);
                if (!graph.isAdjacentTo(a, c = (Node)adjacents.get(choice[1])) && graph.getEndpoint(b, a) == Endpoint.TAIL && graph.getEndpoint(c, b) == Endpoint.CIRCLE) {
                    if (graph.getEndpoint(a, b) == Endpoint.TAIL) {
                        graph.setEndpoint(c, b, Endpoint.TAIL);
                        if (this.verbose) {
                            this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R6: Single tails (tail)", graph.getEdge(c, b)));
                        }
                        this.changeFlag = true;
                    }
                    if (graph.getEndpoint(a, b) == Endpoint.CIRCLE) {
                        graph.setEndpoint(c, b, Endpoint.TAIL);
                        if (this.verbose) {
                            this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R7: Single tails (tail)", graph.getEdge(c, b)));
                        }
                        this.changeFlag = true;
                    }
                }
                choice = cg.next();
            }
        }
    }

    public void rulesR8R9R10(Graph graph) {
        List<Node> nodes = graph.getNodes();
        block0: for (Node c : nodes) {
            if (Thread.currentThread().isInterrupted()) break;
            List<Node> intoCArrows = graph.getNodesInTo(c, Endpoint.ARROW);
            for (Node a : intoCArrows) {
                boolean b;
                if (Thread.currentThread().isInterrupted()) continue block0;
                if (graph.getEndpoint(c, a) != Endpoint.CIRCLE || this.ruleR8(a, c, graph) || (b = this.ruleR9(a, c, graph))) continue;
                this.ruleR10(a, c, graph);
            }
        }
    }

    public boolean doDdpOrientation(Node d, Node a, Node b, Node c, Graph graph) {
        if (graph.isAdjacentTo(d, c)) {
            throw new IllegalArgumentException();
        }
        Set<Node> sepset = this.getSepsets().getSepset(d, c);
        if (this.verbose) {
            this.logger.forceLogMessage("Sepset for d = " + d + " and c = " + c + " = " + sepset);
        }
        if (sepset == null) {
            if (this.verbose) {
                this.logger.forceLogMessage("Must be a sepset: " + d + " and " + c + "; they're non-adjacent.");
            }
            return false;
        }
        if (!sepset.contains(b) && this.doDiscriminatingPathColliderRule) {
            if (!FciOrient.isArrowheadAllowed(a, b, graph, this.knowledge)) {
                return false;
            }
            if (!FciOrient.isArrowheadAllowed(c, b, graph, this.knowledge)) {
                return false;
            }
            graph.setEndpoint(a, b, Endpoint.ARROW);
            graph.setEndpoint(c, b, Endpoint.ARROW);
            if (this.verbose) {
                this.logger.forceLogMessage("R4: Definite discriminating path collider rule d = " + d + " " + GraphUtils.pathString(graph, a, b, c));
            }
            this.changeFlag = true;
        } else if (this.doDiscriminatingPathTailRule) {
            graph.setEndpoint(c, b, Endpoint.TAIL);
            if (this.verbose) {
                this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R4: Definite discriminating path tail rule d = " + d, graph.getEdge(b, c)));
            }
            this.changeFlag = true;
            return true;
        }
        return false;
    }

    public void orientTailPath(List<Node> path, Graph graph) {
        for (int i = 0; i < path.size() - 1; ++i) {
            Node n1 = path.get(i);
            Node n2 = path.get(i + 1);
            graph.setEndpoint(n1, n2, Endpoint.TAIL);
            graph.setEndpoint(n2, n1, Endpoint.TAIL);
            this.changeFlag = true;
            if (!this.verbose) continue;
            this.logger.forceLogMessage("R8: Orient circle undirectedPaths " + GraphUtils.pathString(graph, n1, n2));
        }
    }

    public boolean ruleR8(Node a, Node c, Graph graph) {
        List<Node> intoCArrows = graph.getNodesInTo(c, Endpoint.ARROW);
        for (Node b : intoCArrows) {
            if (!graph.isAdjacentTo(a, b) || !graph.isAdjacentTo(b, c) || graph.getEndpoint(b, a) != Endpoint.TAIL || graph.getEndpoint(c, b) != Endpoint.TAIL || graph.getEndpoint(a, b) == Endpoint.TAIL) continue;
            graph.setEndpoint(c, a, Endpoint.TAIL);
            if (this.verbose) {
                this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R8: ", graph.getEdge(c, a)));
            }
            this.changeFlag = true;
            return true;
        }
        return false;
    }

    public boolean ruleR9(Node a, Node c, Graph graph) {
        Edge e = graph.getEdge(a, c);
        if (e == null) {
            return false;
        }
        if (!e.equals(Edges.partiallyOrientedEdge(a, c))) {
            return false;
        }
        List<List<Node>> ucPdPsToC = FciOrient.getUcPdPaths(a, c, graph);
        for (List<Node> u : ucPdPsToC) {
            Node b = u.get(1);
            if (graph.isAdjacentTo(b, c) || b == c) continue;
            graph.setEndpoint(c, a, Endpoint.TAIL);
            if (this.verbose) {
                this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R9: ", graph.getEdge(c, a)));
            }
            this.changeFlag = true;
            return true;
        }
        return false;
    }

    public void fciOrientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        this.logger.forceLogMessage("Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), variables);
            to = GraphSearchUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            if (!FciOrient.isArrowheadAllowed(to, from, graph, this.knowledge)) {
                return;
            }
            graph.setEndpoint(to, from, Endpoint.ARROW);
            this.changeFlag = true;
            this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext() && !Thread.currentThread().isInterrupted()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), variables);
            to = GraphSearchUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            if (!FciOrient.isArrowheadAllowed(from, to, graph, this.knowledge)) {
                return;
            }
            graph.setEndpoint(to, from, Endpoint.TAIL);
            graph.setEndpoint(from, to, Endpoint.ARROW);
            this.changeFlag = true;
            this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        this.logger.forceLogMessage("Finishing BK Orientation.");
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        if (maxPathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxPathLength);
        }
        this.maxPathLength = maxPathLength;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Graph getTruePag() {
        return this.truePag;
    }

    public void setTruePag(Graph truePag) {
        this.truePag = truePag;
    }

    public boolean isChangeFlag() {
        return this.changeFlag;
    }

    public void setChangeFlag(boolean changeFlag) {
        this.changeFlag = changeFlag;
    }

    public void setDoDiscriminatingPathColliderRule(boolean doDiscriminatingPathColliderRule) {
        this.doDiscriminatingPathColliderRule = doDiscriminatingPathColliderRule;
    }

    public void setDoDiscriminatingPathTailRule(boolean doDiscriminatingPathTailRule) {
        this.doDiscriminatingPathTailRule = doDiscriminatingPathTailRule;
    }

    public void ruleR10(Node a, Node c, Graph graph) {
        List<Node> intoCArrows = graph.getNodesInTo(c, Endpoint.ARROW);
        block0: for (Node b : intoCArrows) {
            if (Thread.currentThread().isInterrupted()) break;
            if (b == a || graph.getEndpoint(c, b) != Endpoint.TAIL) continue;
            block1: for (Node d : intoCArrows) {
                if (Thread.currentThread().isInterrupted()) continue block0;
                if (d == a || d == b || graph.getEndpoint(d, c) != Endpoint.TAIL) continue;
                List<List<Node>> ucPdPsToB = FciOrient.getUcPdPaths(a, b, graph);
                List<List<Node>> ucPdPsToD = FciOrient.getUcPdPaths(a, d, graph);
                block2: for (List<Node> u1 : ucPdPsToB) {
                    if (Thread.currentThread().isInterrupted()) continue block1;
                    Node m = u1.get(1);
                    for (List<Node> u2 : ucPdPsToD) {
                        if (Thread.currentThread().isInterrupted()) continue block2;
                        Node n = u2.get(1);
                        if (m.equals(n) || graph.isAdjacentTo(m, n)) continue;
                        graph.setEndpoint(c, a, Endpoint.TAIL);
                        if (this.verbose) {
                            this.logger.forceLogMessage(LogUtilsSearch.edgeOrientedMsg("R10: ", graph.getEdge(c, a)));
                        }
                        this.changeFlag = true;
                        return;
                    }
                }
            }
        }
    }

    private void printWrongColliderMessage(Node a, Node b, Node c, Graph graph) {
        if (this.truePag != null && graph.isDefCollider(a, b, c) && !this.truePag.isDefCollider(a, b, c)) {
            this.logger.forceLogMessage("R0: Orienting collider by mistake: " + a + "*->;" + b + "<-*" + c);
        }
    }
}

