/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.algcomparison.CompareTwoGraphs;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LegalPairs;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.math3.util.FastMath;

public final class GraphSearchUtils {
    public static void pcOrientbk(Knowledge bk, Graph graph, List<Node> nodes) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        TetradLogger.getInstance().log("details", "Staring BK Orientation.");
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), nodes);
            to = GraphSearchUtils.translate(edge.getTo(), nodes);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.removeEdge(from, to);
            graph.addDirectedEdge(to, from);
            TetradLogger.getInstance().log("knowledgeOrientations", LogUtilsSearch.edgeOrientedMsg("Knowledge", graph.getEdge(to, from)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = GraphSearchUtils.translate(edge.getFrom(), nodes);
            to = GraphSearchUtils.translate(edge.getTo(), nodes);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.removeEdges(from, to);
            graph.addDirectedEdge(from, to);
            TetradLogger.getInstance().log("knowledgeOrientations", LogUtilsSearch.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        TetradLogger.getInstance().log("details", "Finishing BK Orientation.");
    }

    public static void pcdOrientC(IndependenceTest test, Knowledge knowledge, Graph graph) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node y : nodes) {
            int[] combination;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(graph.getAdjacentNodes(y));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Set<Node> sepset;
                Node z;
                Node x = (Node)adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(x, z = (Node)adjacentNodes.get(combination[1])) || (sepset = GraphSearchUtils.sepset(graph, x, z, new HashSet<Node>(), new HashSet<Node>(), test)) == null || sepset.contains(y)) continue;
                HashSet<Node> augmentedSet = new HashSet<Node>(sepset);
                augmentedSet.add(y);
                if (test.determines(sepset, x) || test.determines(sepset, z) || test.determines(augmentedSet, x) || test.determines(augmentedSet, z) || !GraphSearchUtils.isArrowheadAllowed(x, y, knowledge) || !GraphSearchUtils.isArrowheadAllowed(z, y, knowledge)) continue;
                graph.setEndpoint(x, y, Endpoint.ARROW);
                graph.setEndpoint(z, y, Endpoint.ARROW);
                System.out.println(LogUtilsSearch.colliderOrientedMsg(x, y, z) + " sepset = " + sepset);
                TetradLogger.getInstance().log("colliderOrientations", LogUtilsSearch.colliderOrientedMsg(x, y, z));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private static Set<Node> sepset(Graph graph, Node a, Node c, Set<Node> containing, Set<Node> notContaining, IndependenceTest independenceTest) {
        ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(a));
        adj.addAll(graph.getAdjacentNodes(c));
        adj.remove(c);
        adj.remove(a);
        for (int d = 0; d <= FastMath.min(1000, adj.size()); ++d) {
            int[] choice;
            ChoiceGenerator gen = new ChoiceGenerator(adj.size(), d);
            while ((choice = gen.next()) != null) {
                Set<Node> v2 = GraphUtils.asSet(choice, adj);
                v2.addAll(containing);
                v2.removeAll(notContaining);
                v2.remove(a);
                v2.remove(c);
                IndependenceResult result = independenceTest.checkIndependence(a, c, new HashSet<Node>(v2));
                double p2 = result.getScore();
                if (!(p2 < 0.0)) continue;
                return v2;
            }
        }
        return null;
    }

    public static void orientCollidersUsingSepsets(SepsetMap set, Knowledge knowledge, Graph graph, boolean verbose, boolean enforceCpdag) {
        TetradLogger.getInstance().log("details", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(graph.getAdjacentNodes(b));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Set<Node> sepset;
                Node c;
                Node a = (Node)adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(a, c = (Node)adjacentNodes.get(combination[1])) || (sepset = set.get(a, c)) == null || sepset.contains(b) || !GraphSearchUtils.isArrowheadAllowed(a, b, knowledge)) continue;
                boolean result = true;
                if (knowledge != null) {
                    boolean bl = result = !knowledge.isRequired(((Object)b).toString(), ((Object)c).toString()) && !knowledge.isForbidden(((Object)c).toString(), ((Object)b).toString());
                }
                if (!result) continue;
                if (verbose) {
                    System.out.println("Collider orientation <" + a + ", " + b + ", " + c + "> sepset = " + sepset);
                }
                if (enforceCpdag && (graph.getEndpoint(b, a) == Endpoint.ARROW || graph.getEndpoint(b, c) == Endpoint.ARROW)) continue;
                graph.removeEdge(a, b);
                graph.removeEdge(c, b);
                graph.addDirectedEdge(a, b);
                graph.addDirectedEdge(c, b);
                TetradLogger.getInstance().log("colliderOrientations", LogUtilsSearch.colliderOrientedMsg(a, b, c, sepset));
            }
        }
        TetradLogger.getInstance().log("details", "Finishing Collider Orientation.");
    }

    public static boolean isArrowheadAllowed(Object from, Object to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.isRequired(to.toString(), from.toString()) && !knowledge.isForbidden(from.toString(), to.toString());
    }

    public static void basicCpdag(Graph graph) {
        HashSet<Edge> undirectedEdges = new HashSet<Edge>();
        block0: for (Edge edge : graph.getEdges()) {
            if (!edge.isDirected()) continue;
            Node x = Edges.getDirectedEdgeTail(edge);
            Node y = Edges.getDirectedEdgeHead(edge);
            for (Node parent : graph.getParents(y)) {
                if (parent == x || graph.isAdjacentTo(parent, x)) continue;
                continue block0;
            }
            undirectedEdges.add(edge);
        }
        for (Edge nextUndirected : undirectedEdges) {
            Node node1 = nextUndirected.getNode1();
            Node node2 = nextUndirected.getNode2();
            graph.removeEdges(node1, node2);
            graph.addUndirectedEdge(node1, node2);
        }
    }

    public static void basicCpdagRestricted2(Graph graph, Node node) {
        HashSet<Edge> undirectedEdges = new HashSet<Edge>();
        block0: for (Edge edge : graph.getEdges(node)) {
            if (!edge.isDirected()) continue;
            Node _x = Edges.getDirectedEdgeTail(edge);
            Node _y = Edges.getDirectedEdgeHead(edge);
            for (Node parent : graph.getParents(_y)) {
                if (parent == _x || graph.isAdjacentTo(parent, _x)) continue;
                continue block0;
            }
            undirectedEdges.add(edge);
        }
        for (Edge nextUndirected : undirectedEdges) {
            Node node1 = nextUndirected.getNode1();
            Node node2 = nextUndirected.getNode2();
            graph.removeEdge(nextUndirected);
            graph.addUndirectedEdge(node1, node2);
        }
    }

    public static LegalPagRet isLegalPag(Graph pag) {
        for (Node n : pag.getNodes()) {
            if (n.getNodeType() == NodeType.MEASURED) continue;
            return new LegalPagRet(false, "Node " + n + " is not measured");
        }
        Graph mag = GraphTransforms.pagToMag(pag);
        LegalMagRet legalMag = GraphSearchUtils.isLegalMag(mag);
        if (!legalMag.isLegalMag()) {
            return new LegalPagRet(false, legalMag.getReason() + " in a MAG implied by this graph");
        }
        Graph pag2 = GraphTransforms.dagToPag(mag);
        if (!pag.equals(pag2)) {
            String edgeMismatch = "";
            for (Edge e : pag.getEdges()) {
                Edge e2;
                if (e.equals(e2 = pag2.getEdge(e.getNode1(), e.getNode2()))) continue;
                edgeMismatch = "For example, the original PAG has edge " + e + " whereas the reconstituted graph has edge " + e2;
            }
            String reason = legalMag.isLegalMag() ? "The MAG implied by this graph was a legal MAG, but still one cannot recover the original graph by finding the PAG of an implied MAG, so this is between a MAG and PAG" : "The MAG implied by this graph was not legal MAG, but in any case one cannot recover the original graph by finding the PAG of an implied MAG, so this is could be between a MAG and PAG";
            if (!edgeMismatch.equals("")) {
                reason = reason + ". " + edgeMismatch;
            }
            return new LegalPagRet(false, reason);
        }
        return new LegalPagRet(true, "This is a legal PAG");
    }

    private static LegalMagRet isLegalMag(Graph mag) {
        int i;
        Edge e;
        Node y;
        Node x;
        for (Node n : mag.getNodes()) {
            if (n.getNodeType() != NodeType.LATENT) continue;
            return new LegalMagRet(false, "Node " + n + " is not measured");
        }
        List<Node> nodes = mag.getNodes();
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            for (int j = i2 + 1; j < nodes.size(); ++j) {
                x = nodes.get(i2);
                if (!mag.isAdjacentTo(x, y = nodes.get(j))) continue;
                if (mag.getEdges(x, y).size() > 1) {
                    return new LegalMagRet(false, "There is more than one edge between " + x + " and " + y);
                }
                e = mag.getEdge(x, y);
                if (Edges.isDirectedEdge(e) || Edges.isBidirectedEdge(e) || Edges.isUndirectedEdge(e)) continue;
                return new LegalMagRet(false, "Edge " + e + " should be directed, bidirected, or undirected.");
            }
        }
        for (Node n : mag.getNodes()) {
            if (!mag.paths().existsDirectedPathFromTo(n, n)) continue;
            return new LegalMagRet(false, "Acyclicity violated: There is a directed cyclic path from from " + n + " to itself");
        }
        for (Edge e2 : mag.getEdges()) {
            List<Node> path;
            x = e2.getNode1();
            y = e2.getNode2();
            if (!Edges.isBidirectedEdge(e2)) continue;
            if (mag.paths().existsDirectedPathFromTo(x, y)) {
                path = mag.paths().directedPathsFromTo(x, y, 100).get(0);
                return new LegalMagRet(false, "Bidirected edge semantics is violated: there is a directed path for " + e2 + " from " + x + " to " + y + ". This is \"almost cyclic\"; for <-> edges there should not be a path from either endpoint to the other. An example path is " + GraphUtils.pathString(mag, path));
            }
            if (!mag.paths().existsDirectedPathFromTo(y, x)) continue;
            path = mag.paths().directedPathsFromTo(y, x, 100).get(0);
            return new LegalMagRet(false, "Bidirected edge semantics is violated: There is an a directed path for " + e2 + " from " + y + " to " + x + ". This is \"almost cyclic\"; for <-> edges there should not be a path from either endpoint to the other. An example path is " + GraphUtils.pathString(mag, path));
        }
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                x = nodes.get(i);
                if (mag.isAdjacentTo(x, y = nodes.get(j)) || !mag.paths().existsInducingPath(x, y)) continue;
                return new LegalMagRet(false, "This is not maximal; there is an inducing path between non-adjacent " + x + " and " + y);
            }
        }
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                x = nodes.get(i);
                if (!mag.isAdjacentTo(x, y = nodes.get(j)) || !Edges.isUndirectedEdge(e = mag.getEdge(x, y))) continue;
                for (Node z : mag.getAdjacentNodes(x)) {
                    if (!mag.isParentOf(z, x) && !Edges.isBidirectedEdge(mag.getEdge(z, x))) continue;
                    return new LegalMagRet(false, "For undirected edge " + e + ", " + z + " should not be a parent or a spouse of " + x);
                }
                for (Node z : mag.getAdjacentNodes(y)) {
                    if (!mag.isParentOf(z, y) && !Edges.isBidirectedEdge(mag.getEdge(z, y))) continue;
                    return new LegalMagRet(false, "For undirected edge " + e + ", " + z + " should not be a parent or a spouse of " + y);
                }
            }
        }
        return new LegalMagRet(true, "This is a legal MAG");
    }

    public static void arrangeByKnowledgeTiers(Graph graph, Knowledge knowledge) {
        if (knowledge.getNumTiers() == 0) {
            throw new IllegalArgumentException("There are no Tiers to arrange.");
        }
        int ySpace = 500 / knowledge.getNumTiers();
        ySpace = FastMath.max(ySpace, 50);
        List<String> notInTier = knowledge.getVariablesNotInTiers();
        Collections.sort(notInTier);
        int x = 0;
        int y = 50 - ySpace;
        if (notInTier.size() > 0) {
            y += ySpace;
            for (String name : notInTier) {
                x += 90;
                Node node = graph.getNode(name);
                if (node == null) continue;
                node.setCenterX(x);
                node.setCenterY(y);
            }
        }
        for (int i = 0; i < knowledge.getNumTiers(); ++i) {
            List<String> tier = knowledge.getTier(i);
            Collections.sort(tier);
            y += ySpace;
            x = -25;
            for (String name : tier) {
                x += 90;
                Node node = graph.getNode(name);
                if (node == null) continue;
                node.setCenterX(x);
                node.setCenterY(y);
            }
        }
    }

    public static void arrangeByKnowledgeTiers(Graph graph) {
        int maxLag = 0;
        for (Node node : graph.getNodes()) {
            String name = node.getName();
            String[] tokens1 = name.split(":");
            int index = tokens1.length > 1 ? Integer.parseInt(tokens1[tokens1.length - 1]) : 0;
            if (index < maxLag) continue;
            maxLag = index;
        }
        ArrayList tiers = new ArrayList();
        for (int i = 0; i <= maxLag; ++i) {
            tiers.add(new ArrayList());
        }
        for (Node node : graph.getNodes()) {
            String name = node.getName();
            String[] tokens = name.split(":");
            int index = tokens.length > 1 ? Integer.parseInt(tokens[tokens.length - 1]) : 0;
            if (((List)tiers.get(index)).contains(node)) continue;
            ((List)tiers.get(index)).add(node);
        }
        for (int i = 0; i <= maxLag; ++i) {
            Collections.sort((List)tiers.get(i));
        }
        int ySpace = maxLag == 0 ? 150 : 150 / maxLag;
        int y = 60;
        for (int i = maxLag; i >= 0; --i) {
            List tier = (List)tiers.get(i);
            int x = 60;
            for (Node node : tier) {
                System.out.println(node + " " + x + " " + y);
                node.setCenterX(x);
                node.setCenterY(y);
                x += 90;
            }
            y += ySpace;
        }
    }

    public static Set<Node> getReachableNodes(List<Node> initialNodes, LegalPairs legalPairs, List<Node> c, List<Node> d, Graph graph, int maxPathLength) {
        HashSet<Node> reachable = new HashSet<Node>();
        MultiKeyMap<Node, Boolean> visited = new MultiKeyMap<Node, Boolean>();
        LinkedList<ReachabilityEdge> nextEdges = new LinkedList<ReachabilityEdge>();
        for (Node x : initialNodes) {
            List<Node> adjX = graph.getAdjacentNodes(x);
            for (Node y : adjX) {
                if (!legalPairs.isLegalFirstEdge(x, y)) continue;
                reachable.add(y);
                nextEdges.add(new ReachabilityEdge(x, y));
                visited.put(x, y, Boolean.TRUE);
            }
        }
        int pathLength = 1;
        while (nextEdges.size() > 0) {
            if (++pathLength > maxPathLength) {
                return reachable;
            }
            LinkedList<ReachabilityEdge> currEdges = nextEdges;
            nextEdges = new LinkedList();
            for (ReachabilityEdge edge : currEdges) {
                Node x = edge.getFrom();
                Node y = edge.getTo();
                List<Node> adjY = graph.getAdjacentNodes(y);
                for (Node z : adjY) {
                    if (visited.get(y, z) == Boolean.TRUE || !legalPairs.isLegalPair(x, y, z, c, d)) continue;
                    reachable.add(z);
                    nextEdges.add(new ReachabilityEdge(y, z));
                    visited.put(y, z, Boolean.TRUE);
                }
            }
        }
        return reachable;
    }

    public static Node translate(String a, List<Node> nodes) {
        for (Node node : nodes) {
            if (!node.getName().equals(a)) continue;
            return node;
        }
        return null;
    }

    public static List<Set<Node>> powerSet(List<Node> nodes) {
        ArrayList<Set<Node>> subsets = new ArrayList<Set<Node>>();
        int total = (int)FastMath.pow(2.0, nodes.size());
        for (int i = 0; i < total; ++i) {
            HashSet<Node> newSet = new HashSet<Node>();
            String selection = Integer.toBinaryString(i);
            for (int j = selection.length() - 1; j >= 0; --j) {
                if (selection.charAt(j) != '1') continue;
                newSet.add(nodes.get(selection.length() - j - 1));
            }
            subsets.add(newSet);
        }
        return subsets;
    }

    public static CpcTripleType getCpcTripleType(Node x, Node y, Node z, IndependenceTest test, int depth, Graph graph) {
        Set<Node> cond;
        int[] choice;
        ChoiceGenerator cg;
        int d;
        int numSepsetsContainingY = 0;
        int numSepsetsNotContainingY = 0;
        ArrayList<Node> _nodes = new ArrayList<Node>(graph.getAdjacentNodes(x));
        _nodes.remove(z);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                cond = GraphUtils.asSet(choice, _nodes);
                if (test.checkIndependence(x, z, cond).isIndependent()) {
                    if (cond.contains(y)) {
                        ++numSepsetsContainingY;
                    } else {
                        ++numSepsetsNotContainingY;
                    }
                }
                if (numSepsetsContainingY <= 0 || numSepsetsNotContainingY <= 0) continue;
                return CpcTripleType.AMBIGUOUS;
            }
        }
        _nodes = new ArrayList<Node>(graph.getAdjacentNodes(z));
        _nodes.remove(x);
        TetradLogger.getInstance().log("adjacencies", "Adjacents for " + x + "--" + y + "--" + z + " = " + _nodes);
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                cond = GraphUtils.asSet(choice, _nodes);
                if (test.checkIndependence(x, z, cond).isIndependent()) {
                    if (cond.contains(y)) {
                        ++numSepsetsContainingY;
                    } else {
                        ++numSepsetsNotContainingY;
                    }
                }
                if (numSepsetsContainingY <= 0 || numSepsetsNotContainingY <= 0) continue;
                return CpcTripleType.AMBIGUOUS;
            }
        }
        if (numSepsetsContainingY > 0) {
            return CpcTripleType.NONCOLLIDER;
        }
        return CpcTripleType.COLLIDER;
    }

    public static int structuralHammingDistance(Graph trueGraph, Graph estGraph) {
        int shd = 0;
        try {
            estGraph = GraphUtils.replaceNodes(estGraph, trueGraph.getNodes());
            trueGraph = GraphTransforms.cpdagForDag(trueGraph);
            estGraph = GraphTransforms.cpdagForDag(estGraph);
            if (trueGraph.paths().existsDirectedCycle()) {
                TetradLogger.getInstance().forceLogMessage("SHD failed: True graph couldn't be converted to a CPDAG");
            }
            if (estGraph.paths().existsDirectedCycle()) {
                TetradLogger.getInstance().forceLogMessage("SHD failed: Estimated graph couldn't be converted to a CPDAG");
                return -99;
            }
            List<Node> _allNodes = estGraph.getNodes();
            for (int i1 = 0; i1 < _allNodes.size(); ++i1) {
                for (int i2 = i1 + 1; i2 < _allNodes.size(); ++i2) {
                    Node n1 = _allNodes.get(i1);
                    Node n2 = _allNodes.get(i2);
                    Edge e1 = trueGraph.getEdge(n1, n2);
                    Edge e2 = estGraph.getEdge(n1, n2);
                    if (e1 != null && !Edges.isDirectedEdge(e1) && !Edges.isUndirectedEdge(e1)) {
                        TetradLogger.getInstance().forceLogMessage("SHD failed: True graph couldn't be converted to a CPDAG");
                        return -99;
                    }
                    if (e2 != null && !Edges.isDirectedEdge(e2) && !Edges.isUndirectedEdge(e2)) {
                        TetradLogger.getInstance().forceLogMessage("SHD failed: Estimated graph couldn't be converted to a CPDAG");
                        return -99;
                    }
                    int error = GraphSearchUtils.structuralHammingDistanceOneEdge(e1, e2);
                    shd += error;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -99;
        }
        return shd;
    }

    private static int structuralHammingDistanceOneEdge(Edge e1, Edge e2) {
        int error = 0;
        if (e1 != null || e2 != null) {
            if (e1 != null && e2 != null) {
                if (!e1.equals(e2)) {
                    ++error;
                }
            } else if (e2 == null) {
                if (Edges.isUndirectedEdge(e1)) {
                    ++error;
                } else {
                    ++error;
                    ++error;
                }
            } else if (Edges.isUndirectedEdge(e2)) {
                ++error;
            } else {
                ++error;
                ++error;
            }
        }
        return error;
    }

    public static GraphUtils.GraphComparison getGraphComparison(Graph trueGraph, Graph targetGraph) {
        Node y;
        Node x;
        int i;
        Edge graphEdge;
        Edge trueGraphEdge;
        Node n2;
        Node n1;
        targetGraph = GraphUtils.replaceNodes(targetGraph, trueGraph.getNodes());
        int adjFn = GraphUtils.countAdjErrors(trueGraph, targetGraph);
        int adjFp = GraphUtils.countAdjErrors(targetGraph, trueGraph);
        Graph undirectedGraph = GraphUtils.undirectedGraph(targetGraph);
        int adjCorrect = undirectedGraph.getNumEdges() - adjFp;
        ArrayList<Edge> edgesAdded = new ArrayList<Edge>();
        ArrayList<Edge> edgesRemoved = new ArrayList<Edge>();
        for (Edge edge : trueGraph.getEdges()) {
            n1 = edge.getNode1();
            if (targetGraph.isAdjacentTo(n1, n2 = edge.getNode2())) continue;
            trueGraphEdge = trueGraph.getEdge(n1, n2);
            graphEdge = targetGraph.getEdge(n1, n2);
            edgesRemoved.add(trueGraphEdge == null ? graphEdge : trueGraphEdge);
        }
        for (Edge edge : targetGraph.getEdges()) {
            n1 = edge.getNode1();
            if (trueGraph.isAdjacentTo(n1, n2 = edge.getNode2())) continue;
            trueGraphEdge = trueGraph.getEdge(n1, n2);
            graphEdge = targetGraph.getEdge(n1, n2);
            edgesAdded.add(trueGraphEdge == null ? graphEdge : trueGraphEdge);
        }
        List<Node> nodes = trueGraph.getNodes();
        int arrowptFn = 0;
        int arrowptFp = 0;
        int arrowptCorrect = 0;
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                boolean _existsArrow;
                if (i == j) continue;
                x = nodes.get(i);
                y = nodes.get(j);
                Edge edge = trueGraph.getEdge(x, y);
                Edge _edge = targetGraph.getEdge(x, y);
                boolean existsArrow = edge != null && edge.getProximalEndpoint(y) == Endpoint.ARROW;
                boolean bl = _existsArrow = _edge != null && _edge.getProximalEndpoint(y) == Endpoint.ARROW;
                if (existsArrow && !_existsArrow) {
                    ++arrowptFn;
                }
                if (!existsArrow && _existsArrow) {
                    ++arrowptFp;
                }
                if (!existsArrow || !_existsArrow) continue;
                ++arrowptCorrect;
            }
        }
        for (i = 0; i < nodes.size(); ++i) {
            for (int j = i + 1; j < nodes.size(); ++j) {
                boolean _existsArrow;
                if (i == j) continue;
                x = nodes.get(i);
                y = nodes.get(j);
                Node _x = targetGraph.getNode(x.getName());
                Node _y = targetGraph.getNode(y.getName());
                Edge edge = trueGraph.getEdge(x, y);
                Edge _edge = targetGraph.getEdge(_x, _y);
                boolean existsArrow = edge != null && edge.getDistalEndpoint(y) == Endpoint.ARROW;
                boolean bl = _existsArrow = _edge != null && _edge.getDistalEndpoint(_y) == Endpoint.ARROW;
                if (existsArrow && !_existsArrow) {
                    ++arrowptFn;
                }
                if (!existsArrow && _existsArrow) {
                    ++arrowptFp;
                }
                if (!existsArrow || !_existsArrow) continue;
                ++arrowptCorrect;
            }
        }
        for (Edge edge : trueGraph.getEdges()) {
            if (targetGraph.containsEdge(edge)) continue;
            Node node1 = edge.getNode1();
            Node node2 = edge.getNode2();
            for (Edge _edge : targetGraph.getEdges(node1, node2)) {
                Endpoint e1a = edge.getProximalEndpoint(node1);
                Endpoint e1b = edge.getProximalEndpoint(node2);
                Endpoint e2a = _edge.getProximalEndpoint(node1);
                Endpoint e2b = _edge.getProximalEndpoint(node2);
                if ((e1a == Endpoint.CIRCLE || e2a == Endpoint.CIRCLE || e1a == e2a) && e1b != Endpoint.CIRCLE && e2b != Endpoint.CIRCLE && e1b != e2b) continue;
            }
        }
        double adjPrec = (double)adjCorrect / (double)(adjCorrect + adjFp);
        double adjRec = (double)adjCorrect / (double)(adjCorrect + adjFn);
        double arrowptPrec = (double)arrowptCorrect / (double)(arrowptCorrect + arrowptFp);
        double arrowptRec = (double)arrowptCorrect / (double)(arrowptCorrect + arrowptFn);
        int shd = GraphSearchUtils.structuralHammingDistance(trueGraph, targetGraph);
        targetGraph = GraphUtils.replaceNodes(targetGraph, trueGraph.getNodes());
        int[][] counts = GraphUtils.edgeMisclassificationCounts(trueGraph, targetGraph, false);
        return new GraphUtils.GraphComparison(adjFn, adjFp, adjCorrect, arrowptFn, arrowptFp, arrowptCorrect, adjPrec, adjRec, arrowptPrec, arrowptRec, shd, edgesAdded, edgesRemoved, counts);
    }

    public static String getEdgewiseComparisonString(String trueGraphName, Graph trueGraph, String targetGraphName, Graph targetGraph) {
        targetGraph = GraphUtils.replaceNodes(targetGraph, trueGraph.getNodes());
        trueGraph = new EdgeListGraph(trueGraph);
        targetGraph = new EdgeListGraph(targetGraph);
        StringBuilder builder0 = new StringBuilder();
        targetGraph = GraphUtils.replaceNodes(targetGraph, trueGraph.getNodes());
        String trueGraphAndTarget = "True graph from " + trueGraphName + "\nTarget graph from " + targetGraphName;
        builder0.append(trueGraphAndTarget).append("\n");
        String builder = CompareTwoGraphs.getEdgewiseComparisonString(trueGraph, targetGraph);
        builder0.append(builder);
        return builder0.toString();
    }

    public static int[][] graphComparison(Graph trueCpdag, Graph estCpdag, PrintStream out) {
        GraphUtils.GraphComparison comparison = GraphSearchUtils.getGraphComparison(estCpdag, trueCpdag);
        if (out != null) {
            out.println("Adjacencies:");
        }
        int adjTp = comparison.getAdjCor();
        int adjFp = comparison.getAdjFp();
        int adjFn = comparison.getAdjFn();
        int arrowptTp = comparison.getAhdCor();
        int arrowptFp = comparison.getAhdFp();
        int arrowptFn = comparison.getAhdFn();
        if (out != null) {
            out.println("TP " + adjTp + " FP = " + adjFp + " FN = " + adjFn);
            out.println("Arrow Orientations:");
            out.println("TP " + arrowptTp + " FP = " + arrowptFp + " FN = " + arrowptFn);
        }
        estCpdag = GraphUtils.replaceNodes(estCpdag, trueCpdag.getNodes());
        int[][] counts = GraphUtils.edgeMisclassificationCounts(trueCpdag, estCpdag, false);
        if (out != null) {
            out.println(GraphUtils.edgeMisclassifications(counts));
        }
        double adjRecall = (double)adjTp / (double)(adjTp + adjFn);
        double adjPrecision = (double)adjTp / (double)(adjTp + adjFp);
        double arrowRecall = (double)arrowptTp / (double)(arrowptTp + arrowptFn);
        double arrowPrecision = (double)arrowptTp / (double)(arrowptTp + arrowptFp);
        DecimalFormat nf = new DecimalFormat("0.0");
        if (out != null) {
            out.println();
            out.println("APRE\tAREC\tOPRE\tOREC");
            out.println(nf.format(adjPrecision * 100.0) + "%\t" + nf.format(adjRecall * 100.0) + "%\t" + nf.format(arrowPrecision * 100.0) + "%\t" + nf.format(arrowRecall * 100.0) + "%");
            out.println();
        }
        return counts;
    }

    public static class LegalPagRet {
        private final boolean legalPag;
        private final String reason;

        public LegalPagRet(boolean legalPag, String reason) {
            if (reason == null) {
                throw new NullPointerException("Reason must be given.");
            }
            this.legalPag = legalPag;
            this.reason = reason;
        }

        public boolean isLegalPag() {
            return this.legalPag;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static class LegalMagRet {
        private final boolean legalMag;
        private final String reason;

        public LegalMagRet(boolean legalPag, String reason) {
            if (reason == null) {
                throw new NullPointerException("Reason must be given.");
            }
            this.legalMag = legalPag;
            this.reason = reason;
        }

        public boolean isLegalMag() {
            return this.legalMag;
        }

        public String getReason() {
            return this.reason;
        }
    }

    private static class ReachabilityEdge {
        private final Node from;
        private final Node to;

        public ReachabilityEdge(Node from, Node to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int hash = 17;
            hash += 63 * this.getFrom().hashCode();
            return hash += 71 * this.getTo().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReachabilityEdge)) {
                return false;
            }
            ReachabilityEdge edge = (ReachabilityEdge)obj;
            if (!edge.getFrom().equals(this.getFrom())) {
                return false;
            }
            return edge.getTo().equals(this.getTo());
        }

        public Node getFrom() {
            return this.from;
        }

        public Node getTo() {
            return this.to;
        }
    }

    public static enum CpcTripleType {
        COLLIDER,
        NONCOLLIDER,
        AMBIGUOUS;

    }
}

