/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import java.util.Arrays;
import java.util.LinkedHashSet;

public class HungarianAlgorithm {
    double[][] costMatrix;
    int[] squareInRow;
    int[] squareInCol;
    int[] rowIsCovered;
    int[] colIsCovered;
    int[] staredZeroesInRow;

    public HungarianAlgorithm(double[][] costMatrix) {
        if (costMatrix.length != costMatrix[0].length) {
            try {
                throw new IllegalAccessException("The costMatrix is not square!");
            }
            catch (IllegalAccessException ex) {
                System.err.println(ex);
                System.exit(1);
            }
        }
        this.costMatrix = costMatrix;
        this.squareInRow = new int[costMatrix.length];
        this.squareInCol = new int[costMatrix[0].length];
        this.rowIsCovered = new int[costMatrix.length];
        this.colIsCovered = new int[costMatrix[0].length];
        this.staredZeroesInRow = new int[costMatrix.length];
        Arrays.fill(this.staredZeroesInRow, -1);
        Arrays.fill(this.squareInRow, -1);
        Arrays.fill(this.squareInCol, -1);
    }

    public static void main(String[] args) {
        double[][] dataMatrix = new double[][]{{70.0, 40.0, 20.0, 55.0}, {65.0, 60.0, 45.0, 90.0}, {30.0, 45.0, 50.0, 75.0}, {25.0, 30.0, 55.0, 40.0}};
        HungarianAlgorithm ha = new HungarianAlgorithm(dataMatrix);
        int[][] assignment = ha.findOptimalAssignment();
        if (assignment.length > 0) {
            for (int[] ints : assignment) {
                System.out.print("Col" + ints[0] + " => Row" + ints[1] + " (" + dataMatrix[ints[0]][ints[1]] + ")");
                System.out.println();
            }
        } else {
            System.out.println("no assignment found!");
        }
    }

    public int[][] findOptimalAssignment() {
        this.step1();
        this.step2();
        this.step3();
        while (!this.allColumnsAreCovered()) {
            int[] mainZero = this.step4();
            while (mainZero == null) {
                this.step7();
                mainZero = this.step4();
            }
            if (this.squareInRow[mainZero[0]] == -1) {
                this.step6(mainZero);
                this.step3();
                continue;
            }
            this.rowIsCovered[mainZero[0]] = 1;
            this.colIsCovered[this.squareInRow[mainZero[0]]] = 0;
            this.step7();
        }
        int[][] optimalAssignment = new int[this.costMatrix.length][];
        for (int i = 0; i < this.squareInCol.length; ++i) {
            optimalAssignment[i] = new int[]{i, this.squareInCol[i]};
        }
        return optimalAssignment;
    }

    private boolean allColumnsAreCovered() {
        for (int i : this.colIsCovered) {
            if (i != 0) continue;
            return false;
        }
        return true;
    }

    private void step1() {
        int k;
        int i;
        for (i = 0; i < this.costMatrix.length; ++i) {
            double currentRowMin = Double.POSITIVE_INFINITY;
            for (int j = 0; j < this.costMatrix[i].length; ++j) {
                if (!(this.costMatrix[i][j] < currentRowMin)) continue;
                currentRowMin = this.costMatrix[i][j];
            }
            k = 0;
            while (k < this.costMatrix[i].length) {
                double[] dArray = this.costMatrix[i];
                int n = k++;
                dArray[n] = dArray[n] - currentRowMin;
            }
        }
        for (i = 0; i < this.costMatrix[0].length; ++i) {
            double currentColMin = Double.POSITIVE_INFINITY;
            for (double[] doubles : this.costMatrix) {
                if (!(doubles[i] < currentColMin)) continue;
                currentColMin = doubles[i];
            }
            for (k = 0; k < this.costMatrix.length; ++k) {
                double[] dArray = this.costMatrix[k];
                int n = i;
                dArray[n] = dArray[n] - currentColMin;
            }
        }
    }

    private void step2() {
        int[] rowHasSquare = new int[this.costMatrix.length];
        int[] colHasSquare = new int[this.costMatrix[0].length];
        for (int i = 0; i < this.costMatrix.length; ++i) {
            for (int j = 0; j < this.costMatrix.length; ++j) {
                if (this.costMatrix[i][j] != 0.0 || rowHasSquare[i] != 0 || colHasSquare[j] != 0) continue;
                rowHasSquare[i] = 1;
                colHasSquare[j] = 1;
                this.squareInRow[i] = j;
                this.squareInCol[j] = i;
            }
        }
    }

    private void step3() {
        for (int i = 0; i < this.squareInCol.length; ++i) {
            this.colIsCovered[i] = this.squareInCol[i] != -1 ? 1 : 0;
        }
    }

    private void step7() {
        int j;
        int i;
        double minUncoveredValue = Double.POSITIVE_INFINITY;
        for (i = 0; i < this.costMatrix.length; ++i) {
            if (this.rowIsCovered[i] == 1) continue;
            for (j = 0; j < this.costMatrix[0].length; ++j) {
                if (this.colIsCovered[j] != 0 || !(this.costMatrix[i][j] < minUncoveredValue)) continue;
                minUncoveredValue = this.costMatrix[i][j];
            }
        }
        if (minUncoveredValue > 0.0) {
            for (i = 0; i < this.costMatrix.length; ++i) {
                for (j = 0; j < this.costMatrix[0].length; ++j) {
                    if (this.rowIsCovered[i] == 1 && this.colIsCovered[j] == 1) {
                        double[] dArray = this.costMatrix[i];
                        int n = j;
                        dArray[n] = dArray[n] + minUncoveredValue;
                        continue;
                    }
                    if (this.rowIsCovered[i] != 0 || this.colIsCovered[j] != 0) continue;
                    double[] dArray = this.costMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] - minUncoveredValue;
                }
            }
        }
    }

    private int[] step4() {
        for (int i = 0; i < this.costMatrix.length; ++i) {
            if (this.rowIsCovered[i] != 0) continue;
            for (int j = 0; j < this.costMatrix[i].length; ++j) {
                if (this.costMatrix[i][j] != 0.0 || this.colIsCovered[j] != 0) continue;
                this.staredZeroesInRow[i] = j;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private void step6(int[] mainZero) {
        int i = mainZero[0];
        int j = mainZero[1];
        LinkedHashSet<int[]> K = new LinkedHashSet<int[]>();
        K.add(mainZero);
        boolean found = false;
        do {
            if (this.squareInCol[j] != -1) {
                K.add(new int[]{this.squareInCol[j], j});
                found = true;
            } else {
                found = false;
            }
            if (!found) break;
            i = this.squareInCol[j];
            if ((j = this.staredZeroesInRow[i]) != -1) {
                K.add(new int[]{i, j});
                found = true;
                continue;
            }
            found = false;
        } while (found);
        for (int[] zero : K) {
            if (this.squareInCol[zero[1]] == zero[0]) {
                this.squareInCol[zero[1]] = -1;
                this.squareInRow[zero[0]] = -1;
            }
            if (this.staredZeroesInRow[zero[0]] != zero[1]) continue;
            this.squareInRow[zero[0]] = zero[1];
            this.squareInCol[zero[1]] = zero[0];
        }
        Arrays.fill(this.staredZeroesInRow, -1);
        Arrays.fill(this.rowIsCovered, 0);
        Arrays.fill(this.colIsCovered, 0);
    }
}

