/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.utils.Kernel;
import org.apache.commons.math3.util.FastMath;

public final class KernelGaussian
implements Kernel {
    private double sigma;

    public KernelGaussian(double sigma) {
        if (sigma <= 0.0) {
            throw new IllegalArgumentException("Sigma must be > 0");
        }
        this.sigma = sigma;
    }

    public KernelGaussian(DataSet dataset, Node node) {
        this.setMedianBandwidth(dataset, node);
    }

    @Override
    public double getBandwidth() {
        return this.sigma;
    }

    @Override
    public double eval(double i, double j) {
        return FastMath.exp(-0.5 * (FastMath.pow(i - j, 2) / FastMath.pow(this.sigma, 2)));
    }

    @Override
    public void setDefaultBw(DataSet dataset, Node node) {
        this.setMedianBandwidth(dataset, node);
    }

    public void setMedianBandwidth(DataSet dataset, Node node) {
        int col = dataset.getColumn(node);
        int m = dataset.getNumRows();
        double[] diff = new double[(int)FastMath.pow((double)m, 2) - m];
        int c = 0;
        for (int i = 0; i < m - 1; ++i) {
            for (int j = i + 1; j < m; ++j) {
                diff[c] = FastMath.abs(dataset.getDouble(i, col) - dataset.getDouble(j, col));
                ++c;
            }
        }
        this.sigma = this.find(diff, m - 1);
    }

    private double find(double[] a, int to) {
        int low = 0;
        int high = to;
        int median = (low + high) / 2;
        while (high > low) {
            if (high == low + 1) {
                if (a[low] > a[high]) {
                    this.swap(a, low, high);
                }
                return a[median];
            }
            int middle = (low + high) / 2;
            if (a[middle] > a[high]) {
                this.swap(a, middle, high);
            }
            if (a[low] > a[high]) {
                this.swap(a, low, high);
            }
            if (a[middle] > a[low]) {
                this.swap(a, middle, low);
            }
            this.swap(a, middle, low + 1);
            int ll = low + 1;
            int hh = high;
            while (true) {
                if (a[low] > a[++ll]) {
                    continue;
                }
                while (a[--hh] > a[low]) {
                }
                if (hh < ll) break;
                this.swap(a, ll, hh);
            }
            this.swap(a, low, hh);
            if (hh <= median) {
                low = ll;
            }
            if (hh < median) continue;
            high = hh - 1;
        }
        return a[median];
    }

    private void swap(double[] a, int i1, int i2) {
        double temp = a[i1];
        a[i1] = a[i2];
        a[i2] = temp;
    }
}

