/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.algcomparison.statistic.BicEst;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.util.NumberFormatUtil;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LogUtilsSearch {
    public static String edgeOrientedMsg(String reason, Edge edge) {
        return "Orienting edge (" + reason + "): " + edge;
    }

    public static String colliderOrientedMsg(String note, Node x, Node y, Node z) {
        return "Orienting collider (" + note + "): " + x.getName() + " *-> " + y.getName() + " <-* " + z.getName();
    }

    public static String colliderOrientedMsg(Node x, Node y, Node z) {
        return "Orienting collider: " + x.getName() + " *-> " + y.getName() + " <-* " + z.getName();
    }

    public static String colliderOrientedMsg(Node x, Node y, Node z, Set<Node> sepset) {
        return "Orienting collider: " + x.getName() + " *-&gt; " + y.getName() + " <-* " + z.getName() + "\t(Sepset = " + sepset + ")";
    }

    public static String determinismDetected(Set<Node> sepset, Node x) {
        return "Determinism detected: " + sepset + " -> " + x.getName();
    }

    public static String independenceFactMsg(Node x, Node y, Set<Node> condSet, double pValue) {
        StringBuilder sb = new StringBuilder();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        sb.append("Independence accepted: ");
        sb.append(LogUtilsSearch.independenceFact(x, y, condSet));
        if (!Double.isNaN(pValue)) {
            sb.append("\tp = ").append(nf.format(pValue));
        }
        return sb.toString();
    }

    public static String dependenceFactMsg(Node x, Node y, Set<Node> condSet, double pValue) {
        StringBuilder sb = new StringBuilder();
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        sb.append("Dependent: ");
        sb.append(LogUtilsSearch.independenceFact(x, y, condSet));
        if (!Double.isNaN(pValue)) {
            sb.append("\tp = ").append(nf.format(pValue));
        }
        return sb.toString();
    }

    public static String independenceFact(Node x, Node y, Set<Node> condSet) {
        StringBuilder sb = new StringBuilder();
        sb.append(x.getName());
        sb.append(" _||_ ");
        sb.append(y.getName());
        Iterator<Node> it = condSet.iterator();
        if (it.hasNext()) {
            sb.append(" | ");
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(", ");
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static String getScoreFact(int i, int[] parents, List<Node> variables) {
        StringBuilder fact = new StringBuilder(variables.get(i) + " | ");
        for (int j = 0; j < parents.length; ++j) {
            int p = parents[j];
            fact.append(variables.get(p));
            if (j >= parents.length - 1) continue;
            fact.append(", ");
        }
        return fact.toString();
    }

    public static String getScoreFact(Node i, List<Node> parents) {
        StringBuilder fact = new StringBuilder(i + " | ");
        for (int p = 0; p < parents.size(); ++p) {
            fact.append(parents.get(p));
            if (p >= parents.size() - 1) continue;
            fact.append(", ");
        }
        return fact.toString();
    }

    public static Map<Node, Integer> buildIndexing(List<Node> nodes) {
        HashMap<Node, Integer> hashIndices = new HashMap<Node, Integer>();
        int i = -1;
        for (Node n : nodes) {
            hashIndices.put(n, ++i);
        }
        return hashIndices;
    }

    @NotNull
    public static void stampWithScores(Graph graph, DataModel dataModel, Score score) {
        if (!graph.getAllAttributes().containsKey("Score")) {
            Graph dag = GraphTransforms.dagFromCPDAG(graph);
            Map<Node, Integer> hashIndices = LogUtilsSearch.buildIndexing(dag.getNodes());
            double _score = 0.0;
            for (Node node : dag.getNodes()) {
                List<Node> x = dag.getParents(node);
                int[] parentIndices = new int[x.size()];
                int count = 0;
                for (Node parent : x) {
                    parentIndices[count++] = hashIndices.get(parent);
                }
                _score += score.localScore((int)hashIndices.get(node), parentIndices);
            }
            graph.addAttribute("Score", _score);
        }
        LogUtilsSearch.stampWithBic(graph, dataModel);
    }

    public static void stampWithBic(Graph graph, DataModel dataModel) {
        if (!graph.getAllAttributes().containsKey("BIC")) {
            graph.addAttribute("BIC", new BicEst().getValue(null, graph, dataModel));
        }
    }
}

