/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.search.utils.PcCommon;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.SublistGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.util.FastMath;

public final class MaxP {
    private final IndependenceTest independenceTest;
    private int depth = -1;
    private Knowledge knowledge = new Knowledge();
    private boolean useHeuristic;
    private int maxPathLength = 3;
    private PcCommon.ConflictRule conflictRule = PcCommon.ConflictRule.PRIORITIZE_EXISTING;

    public MaxP(IndependenceTest test) {
        if (test == null) {
            throw new NullPointerException();
        }
        this.independenceTest = test;
    }

    public synchronized void orient(Graph graph) {
        this.addColliders(graph);
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setUseHeuristic(boolean useHeuristic) {
        this.useHeuristic = useHeuristic;
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public void setConflictRule(PcCommon.ConflictRule conflictRule) {
        this.conflictRule = conflictRule;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    private void addColliders(Graph graph) {
        ConcurrentHashMap<Triple, Double> scores = new ConcurrentHashMap<Triple, Double>();
        List<Node> nodes = graph.getNodes();
        for (Node node : nodes) {
            this.doNode(graph, scores, node);
        }
        ArrayList tripleList = new ArrayList(scores.keySet());
        tripleList.sort((o1, o2) -> Double.compare((Double)scores.get(o2), (Double)scores.get(o1)));
        for (Triple triple : tripleList) {
            System.out.println(triple + " score = " + scores.get(triple));
        }
        for (Triple triple : tripleList) {
            Node a = triple.getX();
            Node b = triple.getY();
            Node c = triple.getZ();
            this.orientCollider(graph, a, b, c, this.conflictRule);
        }
    }

    private void doNode(Graph graph, Map<Triple, Double> scores, Node b) {
        int[] combination;
        ArrayList<Node> adjacentNodes = new ArrayList<Node>(graph.getAdjacentNodes(b));
        if (adjacentNodes.size() < 2) {
            return;
        }
        ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
        while ((combination = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
            Node c;
            Node a = (Node)adjacentNodes.get(combination[0]);
            if (graph.isAdjacentTo(a, c = (Node)adjacentNodes.get(combination[1]))) continue;
            if (this.useHeuristic) {
                if (this.existsShortPath(a, c, this.maxPathLength, graph)) {
                    this.testColliderMaxP(graph, scores, a, b, c);
                    continue;
                }
                this.testColliderHeuristic(graph, scores, a, b, c);
                continue;
            }
            this.testColliderMaxP(graph, scores, a, b, c);
        }
    }

    private void testColliderMaxP(Graph graph, Map<Triple, Double> scores, Node a, Node b, Node c) {
        int[] comb3;
        int[] comb2;
        ArrayList<Node> adja = new ArrayList<Node>(graph.getAdjacentNodes(a));
        ArrayList<Node> adjc = new ArrayList<Node>(graph.getAdjacentNodes(c));
        adja.remove(c);
        adjc.remove(a);
        if (!GraphSearchUtils.isArrowheadAllowed(a, b, this.knowledge) || !GraphSearchUtils.isArrowheadAllowed(c, b, this.knowledge)) {
            return;
        }
        double p = 0.0;
        Set<Node> S = null;
        SublistGenerator cg1 = new SublistGenerator(adja.size(), this.depth);
        while ((comb2 = cg1.next()) != null && !Thread.currentThread().isInterrupted()) {
            Set<Node> s = GraphUtils.asSet(comb2, adja);
            IndependenceResult result = this.independenceTest.checkIndependence(a, c, s);
            double _p = result.getPValue();
            if (!(_p > p)) continue;
            p = _p;
            S = s;
        }
        SublistGenerator cg2 = new SublistGenerator(adjc.size(), this.depth);
        while ((comb3 = cg2.next()) != null && !Thread.currentThread().isInterrupted()) {
            Set<Node> s = GraphUtils.asSet(comb3, adjc);
            IndependenceResult result = this.independenceTest.checkIndependence(a, c, s);
            double _p = result.getPValue();
            if (!(_p > p)) continue;
            p = _p;
            S = s;
        }
        if (S != null && !S.contains(b)) {
            scores.put(new Triple(a, b, c), p);
        }
    }

    private void testColliderHeuristic(Graph graph, Map<Triple, Double> colliders, Node a, Node b, Node c) {
        boolean mycollider2;
        if (this.knowledge.isForbidden(a.getName(), b.getName())) {
            return;
        }
        if (this.knowledge.isForbidden(c.getName(), b.getName())) {
            return;
        }
        IndependenceResult result1 = this.independenceTest.checkIndependence(a, c, new Node[0]);
        double s1 = result1.getScore();
        IndependenceResult result2 = this.independenceTest.checkIndependence(a, c, b);
        double s2 = result2.getScore();
        boolean bl = mycollider2 = s2 > s1;
        if (graph.isAdjacentTo(a, c)) {
            return;
        }
        if (graph.getEdges(a, b).size() > 1 || graph.getEdges(b, c).size() > 1) {
            return;
        }
        if (mycollider2) {
            colliders.put(new Triple(a, b, c), FastMath.abs(s2));
        }
    }

    private void orientCollider(Graph graph, Node a, Node b, Node c, PcCommon.ConflictRule conflictRule) {
        if (this.knowledge.isForbidden(a.getName(), b.getName())) {
            return;
        }
        if (this.knowledge.isForbidden(c.getName(), b.getName())) {
            return;
        }
        PcCommon.orientCollider(a, b, c, conflictRule, graph);
    }

    private boolean existsShortPath(Node x, Node z, int bound, Graph graph) {
        LinkedList<Node> Q = new LinkedList<Node>();
        HashSet<Node> V = new HashSet<Node>();
        Q.offer(x);
        V.add(x);
        Node e = null;
        int distance = 0;
        while (!Q.isEmpty() && !Thread.currentThread().isInterrupted()) {
            Node t = (Node)Q.remove();
            if (e == t) {
                e = null;
                if (++distance > (bound == -1 ? 1000 : bound)) {
                    return false;
                }
            }
            for (Node u : graph.getAdjacentNodes(t)) {
                Edge edge = graph.getEdge(t, u);
                Node c = Edges.traverse(t, edge);
                if (c == null) continue;
                if (c == z && distance > 2) {
                    return true;
                }
                if (V.contains(c)) continue;
                V.add(c);
                Q.offer(c);
                if (e != null) continue;
                e = u;
            }
        }
        return false;
    }
}

