/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MimUtils {
    public static Clusters convertToClusters(Graph clusterGraph) {
        ArrayList<Node> measuredVariables = new ArrayList<Node>();
        for (Node node : clusterGraph.getNodes()) {
            if (node.getNodeType() == NodeType.LATENT) continue;
            measuredVariables.add(node);
        }
        return MimUtils.convertToClusters(clusterGraph, measuredVariables);
    }

    public static List<List<Node>> convertToClusters2(Graph clusterGraph) {
        Clusters clusters = MimUtils.convertToClusters(clusterGraph);
        ArrayList<List<Node>> _clusters = new ArrayList<List<Node>>();
        for (int i = 0; i < clusters.getNumClusters(); ++i) {
            ArrayList<Node> cluster = new ArrayList<Node>();
            List<String> cluster1 = clusters.getCluster(i);
            for (String s : cluster1) {
                cluster.add(clusterGraph.getNode(s));
            }
            _clusters.add(cluster);
        }
        return _clusters;
    }

    public static Clusters convertToClusters(Graph clusterGraph, List<Node> measuredVariables) {
        ArrayList<String> latents = new ArrayList<String>();
        Clusters clusters = new Clusters();
        clusterGraph = GraphUtils.replaceNodes(clusterGraph, measuredVariables);
        for (Node node : clusterGraph.getNodes()) {
            if (measuredVariables.contains(node)) continue;
            latents.add(node.getName());
        }
        Collections.sort(latents);
        for (int i = 0; i < latents.size(); ++i) {
            String name = (String)latents.get(i);
            clusters.setClusterName(i, name);
            Node latent = clusterGraph.getNode(name);
            List<Node> measured = clusterGraph.getNodesOutTo(latent, Endpoint.ARROW);
            for (Node _node : measured) {
                if (!measuredVariables.contains(_node)) continue;
                clusters.addToCluster(i, _node.getName());
            }
        }
        return clusters;
    }
}

