/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import java.util.ArrayList;
import java.util.Stack;

public class NRooks {
    public static ArrayList<int[]> nRooks(boolean[][] allowablePositions) {
        for (boolean[] positions : allowablePositions) {
            if (positions.length == allowablePositions[0].length) continue;
            throw new IllegalArgumentException("Expecting a square matrix.");
        }
        int p = allowablePositions.length;
        boolean[][] board = new boolean[p][p];
        ArrayList<int[]> solutions = new ArrayList<int[]>();
        Stack<Integer> rows = new Stack<Integer>();
        Stack<Integer> cols = new Stack<Integer>();
        int row = 0;
        int col = 0;
        while (row < p) {
            if (col == p) {
                if (rows.isEmpty()) break;
                row = (Integer)rows.pop();
                col = (Integer)cols.pop() + 1;
                board[row][col - 1] = false;
                continue;
            }
            if (allowablePositions[row][col] && NRooks.isValid(board, row, col)) {
                board[row][col] = true;
                rows.push(row);
                cols.push(col);
                col = 0;
                if (++row != p) continue;
                int[] solution = new int[p];
                block2: for (int i = 0; i < p; ++i) {
                    for (int j = 0; j < p; ++j) {
                        if (!board[i][j]) continue;
                        solution[i] = j;
                        continue block2;
                    }
                }
                solutions.add(solution);
                row = p - 1;
                col = p;
                continue;
            }
            ++col;
        }
        return solutions;
    }

    private static boolean isValid(boolean[][] board, int row, int col) {
        for (int i = 0; i < row; ++i) {
            if (!board[i][col]) continue;
            return false;
        }
        return true;
    }
}

