/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;

public class PartialCorrelation {
    private final ICovarianceMatrix corr;
    private final Map<Node, Integer> nodesMap = new HashMap<Node, Integer>();

    public PartialCorrelation(List<Node> nodes, Matrix cov, int sampleSize) {
        this.corr = new CorrelationMatrix((ICovarianceMatrix)new CovarianceMatrix(nodes, cov, sampleSize));
        for (int i = 0; i < nodes.size(); ++i) {
            this.nodesMap.put(nodes.get(i), i);
        }
    }

    public PartialCorrelation(ICovarianceMatrix cov) {
        this.corr = new CorrelationMatrix(cov);
        List<Node> nodes = this.corr.getVariables();
        for (int i = 0; i < nodes.size(); ++i) {
            this.nodesMap.put(nodes.get(i), i);
        }
    }

    public double corr(Node x, Node y, List<Node> z) {
        if (z.isEmpty()) {
            return this.corr.getValue(this.nodesMap.get(x), this.nodesMap.get(y));
        }
        Node z0 = z.get(0);
        ArrayList<Node> _z = new ArrayList<Node>(z);
        _z.remove(z0);
        double corr0 = this.corr(x, y, _z);
        double corr1 = this.corr(x, z0, _z);
        double corr2 = this.corr(z0, y, _z);
        return (corr0 - corr1 * corr2) / FastMath.sqrt(1.0 - corr1 * corr1) * FastMath.sqrt(1.0 - corr2 * corr2);
    }
}

