/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.utils.MaxP;
import edu.cmu.tetrad.search.utils.MeekRules;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public final class PcCommon
implements IGraphSearch {
    private final IndependenceTest independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private Graph graph;
    private long elapsedTime;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Set<Triple> ambiguousTriples;
    private boolean meekPreventCycles;
    private boolean verbose = false;
    private int maxPathLength = 3;
    private FasType fasType = FasType.REGULAR;
    private ColliderDiscovery colliderDiscovery = ColliderDiscovery.FAS_SEPSETS;
    private ConflictRule conflictRule = ConflictRule.PRIORITIZE_EXISTING;
    private PcHeuristicType pcHeuristicType = PcHeuristicType.NONE;

    public PcCommon(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
    }

    public static void orientCollider(Node x, Node y, Node z, ConflictRule conflictRule, Graph graph) {
        if (conflictRule == ConflictRule.PRIORITIZE_EXISTING) {
            if (graph.getEndpoint(x, y) != Endpoint.ARROW || graph.getEndpoint(z, y) != Endpoint.ARROW) {
                graph.removeEdge(x, y);
                graph.removeEdge(z, y);
                graph.addDirectedEdge(x, y);
                graph.addDirectedEdge(z, y);
            }
        } else if (conflictRule == ConflictRule.ORIENT_BIDIRECTED) {
            graph.setEndpoint(x, y, Endpoint.ARROW);
            graph.setEndpoint(z, y, Endpoint.ARROW);
            System.out.println("Orienting " + graph.getEdge(x, y) + " " + graph.getEdge(z, y));
        } else if (conflictRule == ConflictRule.OVERWRITE_EXISTING) {
            graph.removeEdge(x, y);
            graph.removeEdge(z, y);
            graph.addDirectedEdge(x, y);
            graph.addDirectedEdge(z, y);
        }
        TetradLogger.getInstance().log("colliderOrientations", LogUtilsSearch.colliderOrientedMsg(x, y, z));
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public void setFasType(FasType fasType) {
        this.fasType = fasType;
    }

    public void setPcHeuristicType(PcHeuristicType pcHeuristic) {
        this.pcHeuristicType = pcHeuristic;
    }

    public boolean isMeekPreventCycles() {
        return this.meekPreventCycles;
    }

    public void setMeekPreventCycles(boolean meekPreventCycles) {
        this.meekPreventCycles = meekPreventCycles;
    }

    @Override
    public Graph search() {
        return this.search(this.getIndependenceTest().getVariables());
    }

    public Graph search(List<Node> nodes) {
        Fas fas;
        nodes = new ArrayList<Node>(nodes);
        this.logger.log("info", "Starting algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        this.ambiguousTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.independenceTest.setVerbose(this.verbose);
        long startTime = MillisecondTimes.timeMillis();
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!new HashSet<Node>(allNodes).containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        if (this.fasType == FasType.REGULAR) {
            fas = new Fas(this.getIndependenceTest());
            fas.setPcHeuristicType(this.pcHeuristicType);
        } else {
            fas = new Fas(this.getIndependenceTest());
            fas.setPcHeuristicType(this.pcHeuristicType);
            fas.setStable(true);
        }
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        fas.setVerbose(this.verbose);
        this.graph = fas.search();
        SepsetMap sepsets = fas.getSepsets();
        if (this.graph.paths().existsDirectedCycle()) {
            throw new IllegalArgumentException("Graph is cyclic after sepsets!");
        }
        GraphSearchUtils.pcOrientbk(this.knowledge, this.graph, nodes);
        if (this.colliderDiscovery == ColliderDiscovery.FAS_SEPSETS) {
            this.orientCollidersUsingSepsets(sepsets, this.knowledge, this.graph, this.verbose, this.conflictRule);
        } else if (this.colliderDiscovery == ColliderDiscovery.MAX_P) {
            if (this.verbose) {
                System.out.println("MaxP orientation...");
            }
            if (this.graph.paths().existsDirectedCycle()) {
                throw new IllegalArgumentException("Graph is cyclic before maxp!");
            }
            MaxP orientCollidersMaxP = new MaxP(this.independenceTest);
            orientCollidersMaxP.setConflictRule(this.conflictRule);
            orientCollidersMaxP.setMaxPathLength(this.maxPathLength);
            orientCollidersMaxP.setDepth(this.depth);
            orientCollidersMaxP.setKnowledge(this.knowledge);
            orientCollidersMaxP.orient(this.graph);
        } else if (this.colliderDiscovery == ColliderDiscovery.CONSERVATIVE) {
            if (this.verbose) {
                System.out.println("CPC orientation...");
            }
            this.orientUnshieldedTriplesConservative(this.knowledge);
        }
        this.graph = GraphUtils.replaceNodes(this.graph, nodes);
        MeekRules meekRules = new MeekRules();
        meekRules.setKnowledge(this.knowledge);
        meekRules.setVerbose(this.verbose);
        meekRules.setMeekPreventCycles(this.meekPreventCycles);
        meekRules.orientImplied(this.graph);
        long endTime = MillisecondTimes.timeMillis();
        this.elapsedTime = endTime - startTime;
        TetradLogger.getInstance().log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logTriples();
        TetradLogger.getInstance().flush();
        return this.graph;
    }

    public void setColliderDiscovery(ColliderDiscovery colliderDiscovery) {
        this.colliderDiscovery = colliderDiscovery;
    }

    public void setConflictRule(ConflictRule conflictRule) {
        this.conflictRule = conflictRule;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0: " + depth);
        }
        if (depth == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Depth must not be Integer.MAX_VALUE, due to a known bug.");
        }
        this.depth = depth;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    public Set<Triple> getColliderTriples() {
        return new HashSet<Triple>(this.colliderTriples);
    }

    public Set<Triple> getNoncolliderTriples() {
        return new HashSet<Triple>(this.noncolliderTriples);
    }

    public Set<Edge> getAdjacencies() {
        return new HashSet<Edge>(this.graph.getEdges());
    }

    private void logTriples() {
        TetradLogger.getInstance().log("info", "\nCollider triples:");
        for (Triple triple : this.colliderTriples) {
            TetradLogger.getInstance().log("info", "Collider: " + triple);
        }
        TetradLogger.getInstance().log("info", "\nNoncollider triples:");
        for (Triple triple : this.noncolliderTriples) {
            TetradLogger.getInstance().log("info", "Noncollider: " + triple);
        }
        TetradLogger.getInstance().log("info", "\nAmbiguous triples (i.e. list of triples for which \nthere is ambiguous data about whether they are colliderDiscovery or not):");
        for (Triple triple : this.getAmbiguousTriples()) {
            TetradLogger.getInstance().log("info", "Ambiguous: " + triple);
        }
    }

    private void orientUnshieldedTriplesConservative(Knowledge knowledge) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        List<Node> nodes = this.graph.getNodes();
        for (Node y : nodes) {
            int[] combination;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(this.graph.getAdjacentNodes(y));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                Node z;
                Node x = (Node)adjacentNodes.get(combination[0]);
                if (this.graph.isAdjacentTo(x, z = (Node)adjacentNodes.get(combination[1]))) continue;
                Set<Set<Node>> sepsetsxz = this.getSepsets(x, z, this.graph);
                if (this.isColliderSepset(y, sepsetsxz)) {
                    if (this.colliderAllowed(x, y, z, knowledge)) {
                        PcCommon.orientCollider(x, y, z, this.conflictRule, this.graph);
                    }
                    this.colliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                if (this.isNoncolliderSepset(y, sepsetsxz)) {
                    this.noncolliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                Triple triple = new Triple(x, y, z);
                this.ambiguousTriples.add(triple);
                this.graph.addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private Set<Set<Node>> getSepsets(Node i, Node k, Graph g) {
        ArrayList<Node> adji = new ArrayList<Node>(g.getAdjacentNodes(i));
        ArrayList<Node> adjk = new ArrayList<Node>(g.getAdjacentNodes(k));
        HashSet<Set<Node>> sepsets = new HashSet<Set<Node>>();
        for (int d = 0; d <= FastMath.max(adji.size(), adjk.size()); ++d) {
            Set<Node> v;
            int[] choice;
            ChoiceGenerator gen;
            if (adji.size() >= 2 && d <= adji.size()) {
                gen = new ChoiceGenerator(adji.size(), d);
                while ((choice = gen.next()) != null && !Thread.currentThread().isInterrupted()) {
                    v = GraphUtils.asSet(choice, adji);
                    if (!this.getIndependenceTest().checkIndependence(i, k, v).isIndependent()) continue;
                    sepsets.add(v);
                }
            }
            if (adjk.size() < 2 || d > adjk.size()) continue;
            gen = new ChoiceGenerator(adjk.size(), d);
            while ((choice = gen.next()) != null && !Thread.currentThread().isInterrupted()) {
                v = GraphUtils.asSet(choice, adjk);
                if (!this.getIndependenceTest().checkIndependence(i, k, v).isIndependent()) continue;
                sepsets.add(v);
            }
        }
        return sepsets;
    }

    private boolean isColliderSepset(Node j, Set<Set<Node>> sepsets) {
        if (sepsets.isEmpty()) {
            return false;
        }
        for (Set<Node> sepset : sepsets) {
            if (!sepset.contains(j)) continue;
            return false;
        }
        return true;
    }

    private boolean isNoncolliderSepset(Node j, Set<Set<Node>> sepsets) {
        if (sepsets.isEmpty()) {
            return false;
        }
        for (Set<Node> sepset : sepsets) {
            if (sepset.contains(j)) continue;
            return false;
        }
        return true;
    }

    private boolean colliderAllowed(Node x, Node y, Node z, Knowledge knowledge) {
        boolean result = true;
        if (knowledge != null) {
            boolean bl = result = !knowledge.isRequired(((Object)y).toString(), ((Object)x).toString()) && !knowledge.isForbidden(((Object)x).toString(), ((Object)y).toString());
        }
        if (!result) {
            return false;
        }
        if (knowledge == null) {
            return true;
        }
        return !knowledge.isRequired(((Object)y).toString(), ((Object)z).toString()) && !knowledge.isForbidden(((Object)z).toString(), ((Object)y).toString());
    }

    private void orientCollidersUsingSepsets(SepsetMap set, Knowledge knowledge, Graph graph, boolean verbose, ConflictRule conflictRule) {
        if (verbose) {
            System.out.println("FAS Sepset orientation...");
        }
        TetradLogger.getInstance().log("details", "Starting Collider Orientation:");
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            int[] combination;
            ArrayList<Node> adjacentNodes = new ArrayList<Node>(graph.getAdjacentNodes(b));
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                Set<Node> sepset;
                Node c;
                Node a = (Node)adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(a, c = (Node)adjacentNodes.get(combination[1])) || (sepset = set.get(a, c)) == null || sepset.contains(b)) continue;
                boolean result1 = true;
                if (knowledge != null) {
                    boolean bl = result1 = !knowledge.isRequired(((Object)b).toString(), ((Object)a).toString()) && !knowledge.isForbidden(((Object)a).toString(), ((Object)b).toString());
                }
                if (!result1) continue;
                boolean result = true;
                if (knowledge != null) {
                    boolean bl = result = !knowledge.isRequired(((Object)b).toString(), ((Object)c).toString()) && !knowledge.isForbidden(((Object)c).toString(), ((Object)b).toString());
                }
                if (!result) continue;
                PcCommon.orientCollider(a, b, c, conflictRule, graph);
                if (verbose) {
                    System.out.println("Collider orientation <" + a + ", " + b + ", " + c + "> sepset = " + sepset);
                }
                TetradLogger.getInstance().log("colliderOrientations", LogUtilsSearch.colliderOrientedMsg(a, b, c, sepset));
            }
        }
    }

    public static enum FasType {
        REGULAR,
        STABLE;

    }

    public static enum ColliderDiscovery {
        FAS_SEPSETS,
        CONSERVATIVE,
        MAX_P;

    }

    public static enum ConflictRule {
        PRIORITIZE_EXISTING,
        ORIENT_BIDIRECTED,
        OVERWRITE_EXISTING;

    }

    public static enum PcHeuristicType {
        NONE,
        HEURISTIC_1,
        HEURISTIC_2,
        HEURISTIC_3;

    }
}

