/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.util.Matrix;
import java.util.Arrays;

public class PermutationMatrixPair {
    private final int[] rowPerm;
    private final int[] colPerm;
    private final Matrix M;

    public PermutationMatrixPair(Matrix M, int[] rowPerm, int[] colPerm) {
        int i;
        if (rowPerm == null) {
            rowPerm = new int[M.getNumRows()];
            for (i = 0; i < M.getNumRows(); ++i) {
                rowPerm[i] = i;
            }
        }
        if (colPerm == null) {
            colPerm = new int[M.getNumColumns()];
            for (i = 0; i < M.getNumColumns(); ++i) {
                colPerm[i] = i;
            }
        }
        this.rowPerm = Arrays.copyOf(rowPerm, rowPerm.length);
        this.colPerm = Arrays.copyOf(colPerm, colPerm.length);
        this.M = M.copy();
    }

    public Matrix getPermutedMatrix() {
        return this.M.getSelection(this.rowPerm, this.colPerm);
    }

    public int[] getRowPerm() {
        return Arrays.copyOf(this.rowPerm, this.rowPerm.length);
    }

    public int[] getColPerm() {
        return Arrays.copyOf(this.colPerm, this.colPerm.length);
    }

    public String toString() {
        return "Row perm " + Arrays.toString(this.rowPerm) + "\nCol perm = " + Arrays.toString(this.colPerm) + "\nPermuted matrix : " + this.getPermutedMatrix();
    }
}

