/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.search.utils.BpcTestType;
import edu.cmu.tetrad.search.utils.IPurify;
import edu.cmu.tetrad.search.utils.MimUtils;
import edu.cmu.tetrad.search.utils.TetradTest;
import edu.cmu.tetrad.search.utils.TetradTestContinuous;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.MatrixUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public class PurifyScoreBased
implements IPurify {
    private final boolean outputMessage = true;
    private final TetradTest tetradTest;
    private final int numVars;
    private final List<Set<String>> forbiddenList;
    double[][] Cyy;
    double[][] Cyz;
    double[][] Czz;
    double[][] bestCyy;
    double[][] bestCyz;
    double[][] bestCzz;
    double[][] covErrors;
    double[][] oldCovErrors;
    double[][] sampleCovErrors;
    double[][] betas;
    double[][] oldBetas;
    double[][] betasLat;
    double[] varErrorLatent;
    double[][] omega;
    double[] omegaI;
    double[][][] parentsResidualsCovar;
    double[] iResidualsCovar;
    double[][][] selectedInverseOmega;
    double[][][] auxInverseOmega;
    int[][] spouses;
    int[] nSpouses;
    int[][] parents;
    int[][] parentsLat;
    double[][][] parentsCov;
    double[][] parentsChildCov;
    double[][][] parentsLatCov;
    double[][] parentsChildLatCov;
    double[][][] pseudoParentsCov;
    double[][] pseudoParentsChildCov;
    boolean[][] parentsL;
    int numObserved;
    int numLatent;
    int[] clusterId;
    HashMap<String, Integer> observableNames;
    HashMap<String, Integer> latentNames;
    SemGraph purePartitionGraph;
    Graph basicGraph;
    ICovarianceMatrix covarianceMatrix;
    boolean[][] correlatedErrors;
    boolean[][] latentParent;
    boolean[][] observedParent;
    List<Node> latentNodes;
    List<Node> measuredNodes;
    boolean modifiedGraph;

    public PurifyScoreBased(TetradTest tetradTest, List<Set<String>> forbiddenList) {
        this.tetradTest = tetradTest;
        this.numVars = tetradTest.getVarNames().length;
        this.forbiddenList = forbiddenList;
    }

    @Override
    public List<List<Node>> purify(List<List<Node>> partition) {
        System.out.println("*** " + partition);
        List<int[]> _partition = this.convertListToInt(partition);
        this.printIntPartition(_partition);
        SemGraph graph = this.scoreBasedPurify(_partition);
        Graph _graph = this.convertSearchGraph(graph);
        Clusters clusters = MimUtils.convertToClusters(_graph);
        ArrayList<int[]> _partition1 = new ArrayList<int[]>();
        List<Node> nodes = this.tetradTest.getVariables();
        for (int i = 0; i < clusters.getNumClusters(); ++i) {
            List<String> cluster = clusters.getCluster(i);
            int[] _cluster = new int[cluster.size()];
            block1: for (int j = 0; j < cluster.size(); ++j) {
                for (int k = 0; k < nodes.size(); ++k) {
                    Node node = nodes.get(k);
                    if (!node.getName().equals(cluster.get(j))) continue;
                    _cluster[j] = k;
                    continue block1;
                }
            }
            _partition1.add(_cluster);
        }
        this.printClustering(_partition1);
        return this.convertIntToList(_partition1);
    }

    @Override
    public void setTrueGraph(Graph mim) {
        throw new UnsupportedOperationException();
    }

    private void printIntPartition(List<int[]> partition) {
        for (int i = 0; i < partition.size(); ++i) {
            int[] cluster = partition.get(i);
            System.out.print(i + ": ");
            for (int k : cluster) {
                System.out.print(k + " ");
            }
            System.out.println();
        }
        System.out.println();
    }

    private List<int[]> convertListToInt(List<List<Node>> partition) {
        List<Node> nodes = this.tetradTest.getVariables();
        ArrayList<int[]> _partition = new ArrayList<int[]>();
        for (List<Node> cluster : partition) {
            int[] _cluster = new int[cluster.size()];
            for (int j = 0; j < cluster.size(); ++j) {
                for (int k = 0; k < nodes.size(); ++k) {
                    if (!nodes.get(k).getName().equals(cluster.get(j).getName())) continue;
                    _cluster[j] = k;
                }
            }
            _partition.add(_cluster);
        }
        return _partition;
    }

    private List<List<Node>> convertIntToList(List<int[]> partition) {
        List<Node> nodes = this.tetradTest.getVariables();
        ArrayList<List<Node>> _partition = new ArrayList<List<Node>>();
        for (int[] cluster : partition) {
            ArrayList<Node> _cluster = new ArrayList<Node>();
            for (int k : cluster) {
                _cluster.add(nodes.get(k));
            }
            _partition.add(_cluster);
        }
        return _partition;
    }

    private Graph convertSearchGraph(SemGraph input) {
        if (input == null) {
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(new GraphNode("No_model."));
            return new EdgeListGraph(nodes);
        }
        ArrayList<Node> inputIndicators = new ArrayList<Node>();
        ArrayList<Node> inputLatents = new ArrayList<Node>();
        for (Node next : input.getNodes()) {
            if (next.getNodeType() == NodeType.MEASURED) {
                inputIndicators.add(next);
                continue;
            }
            if (next.getNodeType() != NodeType.LATENT) continue;
            inputLatents.add(next);
        }
        ArrayList<Node> allNodes = new ArrayList<Node>(inputIndicators);
        allNodes.addAll(inputLatents);
        EdgeListGraph output = new EdgeListGraph(allNodes);
        for (Node node1 : input.getNodes()) {
            for (Node node2 : input.getNodes()) {
                Edge edge = input.getEdge(node1, node2);
                if (edge == null) continue;
                if (node1.getNodeType() == NodeType.ERROR && node2.getNodeType() == NodeType.ERROR) {
                    Iterator<Node> ci = input.getChildren(node1).iterator();
                    Node indicator1 = ci.next();
                    ci = input.getChildren(node2).iterator();
                    Node indicator2 = ci.next();
                    if (indicator1.getNodeType() == NodeType.LATENT) continue;
                    output.setEndpoint(indicator1, indicator2, Endpoint.ARROW);
                    output.setEndpoint(indicator2, indicator1, Endpoint.ARROW);
                    continue;
                }
                if (node1.getNodeType() == NodeType.LATENT && node2.getNodeType() == NodeType.LATENT || node1.getNodeType() == NodeType.ERROR || node2.getNodeType() == NodeType.ERROR) continue;
                output.setEndpoint(edge.getNode1(), edge.getNode2(), Endpoint.ARROW);
                output.setEndpoint(edge.getNode2(), edge.getNode1(), Endpoint.TAIL);
            }
        }
        for (int i = 0; i < inputLatents.size() - 1; ++i) {
            for (int j = i + 1; j < inputLatents.size(); ++j) {
                output.setEndpoint((Node)inputLatents.get(i), (Node)inputLatents.get(j), Endpoint.TAIL);
                output.setEndpoint((Node)inputLatents.get(j), (Node)inputLatents.get(i), Endpoint.TAIL);
            }
        }
        return output;
    }

    private SemGraph scoreBasedPurify(List<int[]> partition) {
        int j;
        int i;
        this.structuralEmInitialization(partition);
        SemGraph bestGraph = this.purePartitionGraph;
        System.out.println(">>>> Structural EM: initial round");
        for (i = 0; i < this.correlatedErrors.length; ++i) {
            for (j = 0; j < this.correlatedErrors.length; ++j) {
                this.correlatedErrors[i][j] = false;
            }
        }
        for (i = 0; i < this.numObserved; ++i) {
            for (j = 0; j < this.numLatent; ++j) {
                Node latentNode = this.purePartitionGraph.getNode(this.latentNodes.get(j).toString());
                Node measuredNode = this.purePartitionGraph.getNode(this.measuredNodes.get(i).toString());
                this.latentParent[i][j] = this.purePartitionGraph.isParentOf(latentNode, measuredNode);
            }
            for (j = i; j < this.numObserved; ++j) {
                this.observedParent[j][i] = false;
                this.observedParent[i][j] = false;
            }
        }
        do {
            this.modifiedGraph = false;
            double score = this.gaussianEM(bestGraph);
            this.printlnMessage("Initial score" + score);
            this.impurityScoreSearch(score);
            if (!this.modifiedGraph) continue;
            this.printlnMessage(">>>> Structural EM: starting a new round");
            bestGraph = this.updatedGraph();
        } while (this.modifiedGraph);
        boolean[][] impurities = new boolean[this.numObserved][this.numObserved];
        for (int i2 = 0; i2 < this.numObserved; ++i2) {
            List<Node> parents = bestGraph.getParents(bestGraph.getNode(this.measuredNodes.get(i2).toString()));
            if (parents.size() > 1) {
                boolean latent_found = false;
                for (Node o : parents) {
                    if (o.getNodeType() != NodeType.LATENT) continue;
                    if (latent_found) {
                        impurities[i2][i2] = true;
                        break;
                    }
                    latent_found = true;
                }
            } else {
                impurities[i2][i2] = false;
            }
            for (int j2 = i2 + 1; j2 < this.numObserved; ++j2) {
                impurities[i2][j2] = this.correlatedErrors[i2][j2] || this.observedParent[i2][j2] || this.observedParent[j2][i2];
                impurities[j2][i2] = impurities[i2][j2];
            }
        }
        if (((TetradTestContinuous)this.tetradTest).getTestType() == BpcTestType.GAUSSIAN_SCORE) {
            bestGraph = this.removeMarkedImpurities(bestGraph, impurities);
        }
        return bestGraph;
    }

    private void structuralEmInitialization(List<int[]> partition) {
        this.observableNames = new HashMap();
        this.latentNames = new HashMap();
        this.numObserved = 0;
        this.numLatent = 0;
        this.latentNodes = new ArrayList<Node>();
        this.measuredNodes = new ArrayList<Node>();
        this.basicGraph = new EdgeListGraph();
        for (int p = 0; p < partition.size(); ++p) {
            int[] next = partition.get(p);
            GraphNode newLatent = new GraphNode("_L" + p);
            newLatent.setNodeType(NodeType.LATENT);
            this.basicGraph.addNode(newLatent);
            this.latentNodes.forEach(previousLatent -> this.basicGraph.addDirectedEdge((Node)previousLatent, newLatent));
            this.latentNodes.add(newLatent);
            this.latentNames.put(newLatent.toString(), this.numLatent);
            ++this.numLatent;
            for (int j : next) {
                GraphNode newNode = new GraphNode(this.tetradTest.getVarNames()[j]);
                this.basicGraph.addNode(newNode);
                this.basicGraph.addDirectedEdge(newLatent, newNode);
                this.observableNames.put(newNode.toString(), this.numObserved);
                this.measuredNodes.add(newNode);
                ++this.numObserved;
            }
        }
        if (this.numLatent + this.numObserved < 1) {
            throw new IllegalArgumentException("Input clusters must contain at least one variable.");
        }
        this.clusterId = new int[this.numObserved];
        int count = 0;
        for (int p = 0; p < partition.size(); ++p) {
            int[] next = partition.get(p);
            for (int i = 0; i < next.length; ++i) {
                this.clusterId[count++] = p;
            }
        }
        this.purePartitionGraph = new SemGraph(this.basicGraph);
        this.purePartitionGraph.setShowErrorTerms(true);
        if (((TetradTestContinuous)this.tetradTest).getTestType() == BpcTestType.NONE) {
            return;
        }
        this.correlatedErrors = new boolean[this.numObserved][this.numObserved];
        this.latentParent = new boolean[this.numObserved][this.numLatent];
        this.observedParent = new boolean[this.numObserved][this.numObserved];
        this.Cyy = new double[this.numObserved][this.numObserved];
        this.bestCyy = new double[this.numObserved][this.numObserved];
        this.bestCyz = new double[this.numObserved][this.numLatent];
        this.bestCzz = new double[this.numLatent][this.numLatent];
        this.covarianceMatrix = this.tetradTest.getCovMatrix();
        String[] varNames = this.covarianceMatrix.getVariableNames().toArray(new String[0]);
        double[][] cov = this.covarianceMatrix.getMatrix().toArray();
        for (int i = 0; i < cov.length; ++i) {
            for (int j = 0; j < cov.length; ++j) {
                if (this.observableNames.get(varNames[i]) == null || this.observableNames.get(varNames[j]) == null) continue;
                this.Cyy[this.observableNames.get((Object)varNames[i]).intValue()][this.observableNames.get((Object)varNames[j]).intValue()] = cov[i][j];
            }
        }
        this.parents = new int[this.numObserved][];
        this.spouses = new int[this.numObserved][];
        this.nSpouses = new int[this.numObserved];
        this.parentsLat = new int[this.numLatent][];
        this.parentsL = new boolean[this.numObserved][];
        this.parentsCov = new double[this.numObserved][][];
        this.parentsChildCov = new double[this.numObserved][];
        this.parentsLatCov = new double[this.numLatent][][];
        this.parentsChildLatCov = new double[this.numLatent][];
        this.pseudoParentsCov = new double[this.numObserved][][];
        this.pseudoParentsChildCov = new double[this.numObserved][];
        this.covErrors = new double[this.numObserved][this.numObserved];
        this.oldCovErrors = new double[this.numObserved][this.numObserved];
        this.sampleCovErrors = new double[this.numObserved][this.numObserved];
        this.varErrorLatent = new double[this.numLatent];
        this.omega = new double[this.numLatent + this.numObserved - 1][this.numLatent + this.numObserved - 1];
        this.omegaI = new double[this.numLatent + this.numObserved - 1];
        this.selectedInverseOmega = new double[this.numObserved][][];
        this.auxInverseOmega = new double[this.numObserved][][];
        this.parentsResidualsCovar = new double[this.numObserved][][];
        this.iResidualsCovar = new double[this.numObserved + this.numLatent - 1];
        this.betas = new double[this.numObserved][this.numObserved + this.numLatent];
        this.oldBetas = new double[this.numObserved][this.numObserved + this.numLatent];
        this.betasLat = new double[this.numLatent][this.numLatent];
    }

    private void printMessage(String message) {
        Objects.requireNonNull(this);
        System.out.print(message);
    }

    private void printlnMessage(String message) {
        Objects.requireNonNull(this);
        System.out.println(message);
    }

    private void printlnMessage() {
        Objects.requireNonNull(this);
        System.out.println();
    }

    private void printClustering(List<int[]> clustering) {
        Iterator<int[]> iterator = clustering.iterator();
        while (iterator.hasNext()) {
            int[] o;
            int[] c = o = iterator.next();
            this.printCluster(c);
        }
    }

    private void printCluster(int[] c) {
        int i;
        String[] sorted = new String[c.length];
        for (i = 0; i < c.length; ++i) {
            sorted[i] = this.tetradTest.getVarNames()[c[i]];
        }
        for (i = 0; i < sorted.length - 1; ++i) {
            String min = sorted[i];
            int min_idx = i;
            for (int j = i + 1; j < sorted.length; ++j) {
                if (sorted[j].compareTo(min) >= 0) continue;
                min = sorted[j];
                min_idx = j;
            }
            String temp = sorted[i];
            sorted[i] = min;
            sorted[min_idx] = temp;
        }
        for (String s : sorted) {
            this.printMessage(s + " ");
        }
        this.printlnMessage();
    }

    private double gaussianEM(SemGraph semdag) {
        int p;
        double newScore = -1.7976931348623157E308;
        double bestScore = -1.7976931348623157E308;
        SemPm semPm = new SemPm(semdag);
        semdag.setShowErrorTerms(true);
        for (p = 0; p < this.numObserved; ++p) {
            System.arraycopy(this.Cyy[p], 0, this.bestCyy[p], 0, this.numObserved);
            if (this.Cyz == null || this.numLatent < 0) continue;
            System.arraycopy(this.Cyz[p], 0, this.bestCyz[p], 0, this.numLatent);
        }
        if (this.Czz != null) {
            for (p = 0; p < this.numLatent; ++p) {
                System.arraycopy(this.Czz[p], 0, this.bestCzz[p], 0, this.numLatent);
            }
        }
        this.initializeGaussianEM(semdag);
        for (int i = 0; i < 3; ++i) {
            int p2;
            double score;
            System.out.println("--Trial " + i);
            SemIm semIm = new SemIm(semPm);
            semIm.setCovMatrix(this.covarianceMatrix);
            do {
                score = newScore;
                this.gaussianExpectation(semIm);
            } while ((newScore = this.gaussianMaximization(semIm)) != -1.7976931348623157E308 && FastMath.abs(score - newScore) > 0.001);
            System.out.println(newScore);
            if (!(newScore > bestScore) || Double.isInfinite(newScore)) continue;
            bestScore = newScore;
            for (p2 = 0; p2 < this.numObserved; ++p2) {
                System.arraycopy(this.Cyy[p2], 0, this.bestCyy[p2], 0, this.numObserved);
                if (this.numLatent < 0) continue;
                System.arraycopy(this.Cyz[p2], 0, this.bestCyz[p2], 0, this.numLatent);
            }
            for (p2 = 0; p2 < this.numLatent; ++p2) {
                System.arraycopy(this.Czz[p2], 0, this.bestCzz[p2], 0, this.numLatent);
            }
        }
        for (p = 0; p < this.numObserved; ++p) {
            System.arraycopy(this.bestCyy[p], 0, this.Cyy[p], 0, this.numObserved);
            if (this.numLatent < 0) continue;
            System.arraycopy(this.bestCyz[p], 0, this.Cyz[p], 0, this.numLatent);
        }
        for (p = 0; p < this.numLatent; ++p) {
            System.arraycopy(this.bestCzz[p], 0, this.Czz[p], 0, this.numLatent);
        }
        if (Double.isInfinite(bestScore)) {
            System.out.println("* * Warning: Heywood case in this step");
            return -1.7976931348623157E308;
        }
        return bestScore;
    }

    private void initializeGaussianEM(SemGraph semMag) {
        for (int i = 0; i < this.numLatent; ++i) {
            Node node = this.latentNodes.get(i);
            if (semMag.getParents(node).size() <= 0) continue;
            this.parentsLat[i] = new int[semMag.getParents(node).size() - 1];
            int count = 0;
            for (Node parent : semMag.getParents(node)) {
                if (parent.getNodeType() != NodeType.LATENT) continue;
                this.parentsLat[i][count++] = this.latentNames.get(parent.getName());
            }
            this.parentsLatCov[i] = new double[this.parentsLat[i].length][this.parentsLat[i].length];
            this.parentsChildLatCov[i] = new double[this.parentsLat[i].length];
        }
        boolean[][] correlatedErrors = new boolean[this.numObserved][this.numObserved];
        for (int i = 0; i < this.numObserved; ++i) {
            for (int j = 0; j < this.numObserved; ++j) {
                correlatedErrors[i][j] = false;
            }
        }
        for (Edge nextEdge : semMag.getEdges()) {
            if (nextEdge.getEndpoint1() != Endpoint.ARROW || nextEdge.getEndpoint2() != Endpoint.ARROW) continue;
            Iterator<Node> it1 = semMag.getChildren(nextEdge.getNode1()).iterator();
            Node measure1 = it1.next();
            Iterator<Node> it2 = semMag.getChildren(nextEdge.getNode2()).iterator();
            Node measure2 = it2.next();
            correlatedErrors[this.observableNames.get((Object)measure1.getName()).intValue()][this.observableNames.get((Object)measure2.getName()).intValue()] = true;
            correlatedErrors[this.observableNames.get((Object)measure2.getName()).intValue()][this.observableNames.get((Object)measure1.getName()).intValue()] = true;
        }
        for (int i = 0; i < this.numObserved; ++i) {
            Node node = this.measuredNodes.get(i);
            this.parents[i] = new int[semMag.getParents(node).size() - 1];
            this.parentsL[i] = new boolean[semMag.getParents(node).size() - 1];
            int count = 0;
            for (Node parent : semMag.getParents(node)) {
                if (parent.getNodeType() == NodeType.LATENT) {
                    this.parents[i][count] = this.latentNames.get(parent.getName());
                    this.parentsL[i][count++] = true;
                    continue;
                }
                if (parent.getNodeType() != NodeType.MEASURED) continue;
                this.parents[i][count] = this.observableNames.get(parent.getName());
                this.parentsL[i][count++] = false;
            }
            int numCovar = 0;
            for (int j = 0; j < correlatedErrors.length; ++j) {
                if (i == j || !correlatedErrors[i][j]) continue;
                ++numCovar;
            }
            if (numCovar > 0) {
                this.spouses[i] = new int[numCovar];
                int countS = 0;
                for (int j = 0; j < this.numObserved; ++j) {
                    if (i == j || !correlatedErrors[i][j]) continue;
                    this.spouses[i][countS++] = j;
                }
                this.nSpouses[i] = countS;
            } else {
                this.spouses[i] = null;
                this.nSpouses[i] = 0;
            }
            this.parentsCov[i] = new double[this.parents[i].length][this.parents[i].length];
            this.parentsChildCov[i] = new double[this.parents[i].length];
            this.pseudoParentsCov[i] = new double[this.parents[i].length + this.nSpouses[i]][this.parents[i].length + this.nSpouses[i]];
            this.pseudoParentsChildCov[i] = new double[this.parents[i].length + this.nSpouses[i]];
            this.parentsResidualsCovar[i] = new double[this.parents[i].length][this.numLatent + this.numObserved - 1];
            this.selectedInverseOmega[i] = new double[this.nSpouses[i]][this.numLatent + this.numObserved - 1];
            this.auxInverseOmega[i] = new double[this.nSpouses[i]][this.numLatent + this.numObserved - 1];
        }
    }

    private void gaussianExpectation(SemIm semIm) {
        int j;
        int i;
        double[][] beta = new double[this.numLatent][this.numLatent];
        double[][] fi = new double[this.numLatent][this.numLatent];
        double[][] lambdaI = new double[this.numObserved][this.numObserved];
        double[][] lambdaL = new double[this.numObserved][this.numLatent];
        double[][] tau = new double[this.numObserved][this.numObserved];
        for (i = 0; i < this.numLatent; ++i) {
            for (j = 0; j < this.numLatent; ++j) {
                beta[i][j] = 0.0;
                fi[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numObserved; ++i) {
            for (j = 0; j < this.numLatent; ++j) {
                lambdaL[i][j] = 0.0;
            }
        }
        for (i = 0; i < this.numObserved; ++i) {
            for (j = 0; j < this.numObserved; ++j) {
                tau[i][j] = 0.0;
                lambdaI[i][j] = 0.0;
            }
        }
        List<Parameter> parameters = semIm.getFreeParameters();
        double[] paramValues = semIm.getFreeParamValues();
        for (int i2 = 0; i2 < parameters.size(); ++i2) {
            Parameter parameter = parameters.get(i2);
            if (parameter.getType() == ParamType.COEF) {
                int position2;
                int position1;
                Node from = parameter.getNodeA();
                Node to = parameter.getNodeB();
                if (to.getNodeType() == NodeType.MEASURED && from.getNodeType() == NodeType.LATENT) {
                    position1 = this.latentNames.get(from.getName());
                    position2 = this.observableNames.get(to.getName());
                    lambdaL[position2][position1] = paramValues[i2];
                    continue;
                }
                if (to.getNodeType() == NodeType.MEASURED && from.getNodeType() == NodeType.MEASURED) {
                    position1 = this.observableNames.get(from.getName());
                    position2 = this.observableNames.get(to.getName());
                    lambdaI[position2][position1] = paramValues[i2];
                    continue;
                }
                if (to.getNodeType() != NodeType.LATENT) continue;
                position1 = this.latentNames.get(from.getName());
                position2 = this.latentNames.get(to.getName());
                beta[position2][position1] = paramValues[i2];
                continue;
            }
            if (parameter.getType() == ParamType.VAR) {
                Node exo = parameter.getNodeA();
                if (exo.getNodeType() == NodeType.ERROR) {
                    Iterator<Node> ci = semIm.getSemPm().getGraph().getChildren(exo).iterator();
                    exo = ci.next();
                }
                if (exo.getNodeType() == NodeType.LATENT) {
                    fi[this.latentNames.get((Object)exo.getName()).intValue()][this.latentNames.get((Object)exo.getName()).intValue()] = paramValues[i2];
                    continue;
                }
                tau[this.observableNames.get((Object)exo.getName()).intValue()][this.observableNames.get((Object)exo.getName()).intValue()] = paramValues[i2];
                continue;
            }
            if (parameter.getType() != ParamType.COVAR) continue;
            Node exo1 = parameter.getNodeA();
            Node exo2 = parameter.getNodeB();
            exo1 = semIm.getSemPm().getGraph().getVarNode(exo1);
            exo2 = semIm.getSemPm().getGraph().getVarNode(exo2);
            double d = paramValues[i2];
            tau[this.observableNames.get((Object)exo2.getName()).intValue()][this.observableNames.get((Object)exo1.getName()).intValue()] = d;
            tau[this.observableNames.get((Object)exo1.getName()).intValue()][this.observableNames.get((Object)exo2.getName()).intValue()] = d;
        }
        double[][] identity = new double[this.numLatent][this.numLatent];
        for (int i3 = 0; i3 < this.numLatent; ++i3) {
            for (int j2 = 0; j2 < this.numLatent; ++j2) {
                identity[i3][j2] = i3 == j2 ? 1.0 : 0.0;
            }
        }
        double[][] identityI = new double[this.numObserved][this.numObserved];
        for (int i4 = 0; i4 < this.numObserved; ++i4) {
            for (int j3 = 0; j3 < this.numObserved; ++j3) {
                identityI[i4][j3] = i4 == j3 ? 1.0 : 0.0;
            }
        }
        double[][] iMinusB = MatrixUtils.inverse(MatrixUtils.subtract(identity, beta));
        double[][] latentImpliedCovar = MatrixUtils.product(iMinusB, MatrixUtils.product(fi, MatrixUtils.transpose(iMinusB)));
        double[][] iMinusI = MatrixUtils.inverse(MatrixUtils.subtract(identityI, lambdaI));
        double[][] indImpliedCovar = MatrixUtils.product(MatrixUtils.product(iMinusI, MatrixUtils.sum(MatrixUtils.product(MatrixUtils.product(lambdaL, latentImpliedCovar), MatrixUtils.transpose(lambdaL)), tau)), MatrixUtils.transpose(iMinusI));
        double[][] loadingLatentCovar = MatrixUtils.product(iMinusI, MatrixUtils.product(lambdaL, latentImpliedCovar));
        double[][] smallDelta = MatrixUtils.product(MatrixUtils.inverse(indImpliedCovar), loadingLatentCovar);
        double[][] bigDelta = MatrixUtils.subtract(latentImpliedCovar, MatrixUtils.product(MatrixUtils.transpose(loadingLatentCovar), smallDelta));
        this.Cyz = MatrixUtils.product(this.Cyy, smallDelta);
        this.Czz = MatrixUtils.sum(MatrixUtils.product(MatrixUtils.transpose(smallDelta), this.Cyz), bigDelta);
    }

    private double gaussianMaximization(SemIm semIm) {
        int i;
        double change;
        int i2;
        int j;
        int i3;
        semIm.getSemPm().getGraph().setShowErrorTerms(true);
        for (i3 = 0; i3 < this.numObserved; ++i3) {
            for (j = 0; j < this.numObserved + this.numLatent; ++j) {
                this.betas[i3][j] = 0.0;
            }
        }
        for (i3 = 0; i3 < this.numLatent; ++i3) {
            for (j = 0; j < this.numLatent; ++j) {
                this.betasLat[i3][j] = 0.0;
            }
        }
        for (i3 = 0; i3 < this.numObserved; ++i3) {
            for (j = 0; j < this.numObserved; ++j) {
                this.covErrors[i3][j] = 0.0;
            }
        }
        for (Parameter nextP : semIm.getFreeParameters()) {
            Node exo;
            if (nextP.getType() == ParamType.COEF) {
                int index2;
                int index1;
                Node node1 = nextP.getNodeA();
                Node node2 = nextP.getNodeB();
                if (node1.getNodeType() == NodeType.LATENT && node2.getNodeType() == NodeType.LATENT) continue;
                Node latent = null;
                Node observed = null;
                if (node1.getNodeType() == NodeType.LATENT) {
                    latent = node1;
                    observed = node2;
                } else if (node2.getNodeType() == NodeType.LATENT) {
                    latent = node2;
                    observed = node1;
                }
                if (latent != null) {
                    index1 = this.latentNames.get(latent.getName());
                    index2 = this.observableNames.get(observed.getName());
                    this.betas[index2][index1] = semIm.getParamValue(nextP);
                    continue;
                }
                index1 = this.observableNames.get(node1.getName());
                index2 = this.observableNames.get(node2.getName());
                if (semIm.getSemPm().getGraph().isParentOf(node1, node2)) {
                    this.betas[index2][this.numLatent + index1] = semIm.getParamValue(nextP);
                    continue;
                }
                this.betas[index1][this.numLatent + index2] = semIm.getParamValue(nextP);
                continue;
            }
            if (nextP.getType() == ParamType.COVAR) {
                Node exo1 = nextP.getNodeA();
                Node exo2 = nextP.getNodeB();
                exo1 = semIm.getSemPm().getGraph().getVarNode(exo1);
                exo2 = semIm.getSemPm().getGraph().getVarNode(exo2);
                int index1 = this.observableNames.get(exo1.getName());
                int index2 = this.observableNames.get(exo2.getName());
                double d = semIm.getParamValue(nextP);
                this.covErrors[index2][index1] = d;
                this.covErrors[index1][index2] = d;
                continue;
            }
            if (nextP.getType() != ParamType.VAR || (exo = nextP.getNodeA()).getNodeType() == NodeType.LATENT || (exo = semIm.getSemPm().getGraph().getVarNode(exo)).getNodeType() != NodeType.MEASURED) continue;
            int index = this.observableNames.get(exo.getName());
            this.covErrors[index][index] = semIm.getParamValue(nextP);
        }
        this.varErrorLatent[0] = this.Czz[0][0];
        for (i2 = 1; i2 < this.numLatent; ++i2) {
            for (int j2 = 0; j2 < this.parentsLat[i2].length; ++j2) {
                this.parentsChildLatCov[i2][j2] = this.Czz[i2][this.parentsLat[i2][j2]];
                for (int k = j2; k < this.parentsLat[i2].length; ++k) {
                    this.parentsLatCov[i2][j2][k] = this.Czz[this.parentsLat[i2][j2]][this.parentsLat[i2][k]];
                    this.parentsLatCov[i2][k][j2] = this.parentsLatCov[i2][j2][k];
                }
            }
            double[] betaL = MatrixUtils.product(MatrixUtils.inverse(this.parentsLatCov[i2]), this.parentsChildLatCov[i2]);
            this.varErrorLatent[i2] = this.Czz[i2][i2] - MatrixUtils.innerProduct(this.parentsChildLatCov[i2], betaL);
            for (int j3 = 0; j3 < this.parentsLat[i2].length; ++j3) {
                this.betasLat[i2][this.parentsLat[i2][j3]] = betaL[j3];
            }
        }
        for (i2 = 0; i2 < this.numObserved; ++i2) {
            for (int j4 = 0; j4 < this.parents[i2].length; ++j4) {
                this.parentsChildCov[i2][j4] = this.parentsL[i2][j4] ? this.Cyz[i2][this.parents[i2][j4]] : this.Cyy[i2][this.parents[i2][j4]];
                for (int k = j4; k < this.parents[i2].length; ++k) {
                    this.parentsCov[i2][j4][k] = this.parentsL[i2][j4] && this.parentsL[i2][k] ? this.Czz[this.parents[i2][j4]][this.parents[i2][k]] : (!this.parentsL[i2][j4] && this.parentsL[i2][k] ? this.Cyz[this.parents[i2][j4]][this.parents[i2][k]] : (this.parentsL[i2][j4] && !this.parentsL[i2][k] ? this.Cyz[this.parents[i2][k]][this.parents[i2][j4]] : this.Cyy[this.parents[i2][j4]][this.parents[i2][k]]));
                    this.parentsCov[i2][k][j4] = this.parentsCov[i2][j4][k];
                }
            }
        }
        int iter = 0;
        do {
            for (i = 0; i < this.covErrors.length; ++i) {
                if (this.covErrors.length < 0) continue;
                System.arraycopy(this.covErrors[i], 0, this.oldCovErrors[i], 0, this.covErrors.length);
            }
            for (i = 0; i < this.numObserved; ++i) {
                if (this.betas[i].length < 0) continue;
                System.arraycopy(this.betas[i], 0, this.oldBetas[i], 0, this.betas[i].length);
            }
            for (i = 0; i < this.numObserved; ++i) {
                int j5;
                int k;
                int ii;
                int j6;
                int ii2;
                for (ii2 = 0; ii2 < this.omega.length; ++ii2) {
                    for (int j7 = 0; j7 < this.omega.length; ++j7) {
                        this.omega[ii2][j7] = 0.0;
                    }
                }
                for (ii2 = 0; ii2 < this.numLatent; ++ii2) {
                    this.omegaI[ii2] = 0.0;
                    this.omega[ii2][ii2] = this.varErrorLatent[ii2];
                }
                for (ii2 = 0; ii2 < this.numObserved; ++ii2) {
                    if (ii2 > i) {
                        this.omegaI[this.numLatent + ii2 - 1] = this.covErrors[i][ii2];
                        this.omega[this.numLatent + ii2 - 1][this.numLatent + ii2 - 1] = this.covErrors[ii2][ii2];
                        continue;
                    }
                    if (ii2 >= i) continue;
                    this.omegaI[this.numLatent + ii2] = this.covErrors[i][ii2];
                    this.omega[this.numLatent + ii2][this.numLatent + ii2] = this.covErrors[ii2][ii2];
                }
                for (ii2 = 0; ii2 < this.numObserved; ++ii2) {
                    int index_ii;
                    if (ii2 > i) {
                        index_ii = this.numLatent + ii2 - 1;
                    } else {
                        if (ii2 >= i) continue;
                        index_ii = this.numLatent + ii2;
                    }
                    for (int j8 = 0; j8 < this.nSpouses[ii2]; ++j8) {
                        if (this.spouses[ii2][j8] > i) {
                            this.omega[index_ii][this.numLatent + this.spouses[ii2][j8] - 1] = this.covErrors[ii2][this.spouses[ii2][j8]];
                            continue;
                        }
                        if (this.spouses[ii2][j8] >= i) continue;
                        this.omega[index_ii][this.numLatent + this.spouses[ii2][j8]] = this.covErrors[ii2][this.spouses[ii2][j8]];
                    }
                }
                for (ii2 = 0; ii2 < this.numObserved; ++ii2) {
                    if (ii2 == i) continue;
                    for (int j9 = ii2; j9 < this.numObserved; ++j9) {
                        int p;
                        if (j9 == i) continue;
                        this.sampleCovErrors[ii2][j9] = this.Cyy[ii2][j9];
                        for (p = 0; p < this.parents[ii2].length; ++p) {
                            if (this.parentsL[ii2][p]) {
                                double[] dArray = this.sampleCovErrors[ii2];
                                int n = j9;
                                dArray[n] = dArray[n] - this.betas[ii2][this.parents[ii2][p]] * this.Cyz[j9][this.parents[ii2][p]];
                                continue;
                            }
                            double[] dArray = this.sampleCovErrors[ii2];
                            int n = j9;
                            dArray[n] = dArray[n] - this.betas[ii2][this.numLatent + this.parents[ii2][p]] * this.Cyy[j9][this.parents[ii2][p]];
                        }
                        for (p = 0; p < this.parents[j9].length; ++p) {
                            if (this.parentsL[j9][p]) {
                                double[] dArray = this.sampleCovErrors[ii2];
                                int n = j9;
                                dArray[n] = dArray[n] - this.betas[j9][this.parents[j9][p]] * this.Cyz[ii2][this.parents[j9][p]];
                                continue;
                            }
                            double[] dArray = this.sampleCovErrors[ii2];
                            int n = j9;
                            dArray[n] = dArray[n] - this.betas[j9][this.numLatent + this.parents[j9][p]] * this.Cyy[ii2][this.parents[j9][p]];
                        }
                        for (int p1 = 0; p1 < this.parents[ii2].length; ++p1) {
                            for (int p2 = 0; p2 < this.parents[j9].length; ++p2) {
                                if (this.parentsL[ii2][p1] && this.parentsL[j9][p2]) {
                                    double[] dArray = this.sampleCovErrors[ii2];
                                    int n = j9;
                                    dArray[n] = dArray[n] + this.betas[ii2][this.parents[ii2][p1]] * this.betas[j9][this.parents[j9][p2]] * this.Czz[this.parents[ii2][p1]][this.parents[j9][p2]];
                                    continue;
                                }
                                if (this.parentsL[ii2][p1] && !this.parentsL[j9][p2]) {
                                    double[] dArray = this.sampleCovErrors[ii2];
                                    int n = j9;
                                    dArray[n] = dArray[n] + this.betas[ii2][this.parents[ii2][p1]] * this.betas[j9][this.numLatent + this.parents[j9][p2]] * this.Cyz[this.parents[j9][p2]][this.parents[ii2][p1]];
                                    continue;
                                }
                                if (!this.parentsL[ii2][p1] && this.parentsL[j9][p2]) {
                                    double[] dArray = this.sampleCovErrors[ii2];
                                    int n = j9;
                                    dArray[n] = dArray[n] + this.betas[ii2][this.numLatent + this.parents[ii2][p1]] * this.betas[j9][this.parents[j9][p2]] * this.Cyz[this.parents[ii2][p1]][this.parents[j9][p2]];
                                    continue;
                                }
                                double[] dArray = this.sampleCovErrors[ii2];
                                int n = j9;
                                dArray[n] = dArray[n] + this.betas[ii2][this.numLatent + this.parents[ii2][p1]] * this.betas[j9][this.numLatent + this.parents[j9][p2]] * this.Cyy[this.parents[ii2][p1]][this.parents[j9][p2]];
                            }
                        }
                        this.sampleCovErrors[j9][ii2] = this.sampleCovErrors[ii2][j9];
                    }
                }
                for (ii2 = 0; ii2 < this.parents[i].length; ++ii2) {
                    int j10;
                    this.parentsResidualsCovar[i][ii2][0] = this.parentsL[i][ii2] ? this.Czz[this.parents[i][ii2]][0] : this.Cyz[this.parents[i][ii2]][0];
                    for (j10 = 1; j10 < this.numLatent; ++j10) {
                        int p;
                        if (this.parentsL[i][ii2]) {
                            this.parentsResidualsCovar[i][ii2][j10] = this.Czz[this.parents[i][ii2]][j10];
                            for (p = 0; p < this.parentsLat[j10].length; ++p) {
                                double[] dArray = this.parentsResidualsCovar[i][ii2];
                                int n = j10;
                                dArray[n] = dArray[n] - this.betasLat[j10][this.parentsLat[j10][p]] * this.Czz[this.parents[i][ii2]][this.parentsLat[j10][p]];
                            }
                            continue;
                        }
                        this.parentsResidualsCovar[i][ii2][j10] = this.Cyz[this.parents[i][ii2]][j10];
                        for (p = 0; p < this.parentsLat[j10].length; ++p) {
                            double[] dArray = this.parentsResidualsCovar[i][ii2];
                            int n = j10;
                            dArray[n] = dArray[n] - this.betasLat[j10][this.parentsLat[j10][p]] * this.Cyz[this.parents[i][ii2]][this.parentsLat[j10][p]];
                        }
                    }
                    for (j10 = 0; j10 < this.numObserved; ++j10) {
                        int p;
                        int index_j;
                        if (j10 < i) {
                            index_j = this.numLatent + j10;
                        } else {
                            if (j10 <= i) continue;
                            index_j = this.numLatent + j10 - 1;
                        }
                        if (this.parentsL[i][ii2]) {
                            this.parentsResidualsCovar[i][ii2][index_j] = this.Cyz[j10][this.parents[i][ii2]];
                            for (p = 0; p < this.parents[j10].length; ++p) {
                                if (this.parentsL[j10][p]) {
                                    double[] dArray = this.parentsResidualsCovar[i][ii2];
                                    int n = index_j;
                                    dArray[n] = dArray[n] - this.betas[j10][this.parents[j10][p]] * this.Czz[this.parents[i][ii2]][this.parents[j10][p]];
                                    continue;
                                }
                                double[] dArray = this.parentsResidualsCovar[i][ii2];
                                int n = index_j;
                                dArray[n] = dArray[n] - this.betas[j10][this.numLatent + this.parents[j10][p]] * this.Cyz[this.parents[j10][p]][this.parents[i][ii2]];
                            }
                            continue;
                        }
                        this.parentsResidualsCovar[i][ii2][index_j] = this.Cyy[j10][this.parents[i][ii2]];
                        for (p = 0; p < this.parents[j10].length; ++p) {
                            if (this.parentsL[j10][p]) {
                                double[] dArray = this.parentsResidualsCovar[i][ii2];
                                int n = index_j;
                                dArray[n] = dArray[n] - this.betas[j10][this.parents[j10][p]] * this.Cyz[this.parents[i][ii2]][this.parents[j10][p]];
                                continue;
                            }
                            double[] dArray = this.parentsResidualsCovar[i][ii2];
                            int n = index_j;
                            dArray[n] = dArray[n] - this.betas[j10][this.numLatent + this.parents[j10][p]] * this.Cyy[this.parents[j10][p]][this.parents[i][ii2]];
                        }
                    }
                }
                this.iResidualsCovar[0] = this.Cyz[i][0];
                for (j6 = 1; j6 < this.numLatent; ++j6) {
                    this.iResidualsCovar[j6] = this.Cyz[i][j6];
                    for (int p = 0; p < this.parentsLat[j6].length; ++p) {
                        int n = j6;
                        this.iResidualsCovar[n] = this.iResidualsCovar[n] - this.betasLat[j6][this.parentsLat[j6][p]] * this.Cyz[i][this.parentsLat[j6][p]];
                    }
                }
                for (j6 = 0; j6 < this.numObserved; ++j6) {
                    int index_j;
                    if (j6 < i) {
                        index_j = this.numLatent + j6;
                    } else {
                        if (j6 <= i) continue;
                        index_j = this.numLatent + j6 - 1;
                    }
                    this.iResidualsCovar[index_j] = this.Cyy[i][j6];
                    for (int p = 0; p < this.parents[j6].length; ++p) {
                        if (this.parentsL[j6][p]) {
                            int n = index_j;
                            this.iResidualsCovar[n] = this.iResidualsCovar[n] - this.betas[j6][this.parents[j6][p]] * this.Cyz[i][this.parents[j6][p]];
                            continue;
                        }
                        int n = index_j;
                        this.iResidualsCovar[n] = this.iResidualsCovar[n] - this.betas[j6][this.numLatent + this.parents[j6][p]] * this.Cyy[i][this.parents[j6][p]];
                    }
                }
                double[][] inverseOmega = MatrixUtils.inverse(this.omega);
                for (ii = 0; ii < this.nSpouses[i]; ++ii) {
                    int sp_index = this.spouses[i][ii] > i ? this.numLatent + this.spouses[i][ii] - 1 : this.numLatent + this.spouses[i][ii];
                    if (this.numLatent + this.numObserved - 1 < 0) continue;
                    System.arraycopy(inverseOmega[sp_index], 0, this.selectedInverseOmega[i][ii], 0, this.numLatent + this.numObserved - 1);
                }
                for (ii = 0; ii < this.nSpouses[i]; ++ii) {
                    int j11;
                    for (j11 = 0; j11 < this.numLatent; ++j11) {
                        this.auxInverseOmega[i][ii][j11] = this.selectedInverseOmega[i][ii][j11] * this.varErrorLatent[j11];
                    }
                    for (j11 = 0; j11 < this.numObserved; ++j11) {
                        int index_j;
                        if (j11 > i) {
                            index_j = this.numLatent + j11 - 1;
                        } else {
                            if (j11 >= i) continue;
                            index_j = this.numLatent + j11;
                        }
                        this.auxInverseOmega[i][ii][index_j] = 0.0;
                        for (int k2 = 0; k2 < this.numObserved; ++k2) {
                            int index_k;
                            if (k2 > i) {
                                index_k = this.numLatent + k2 - 1;
                            } else {
                                if (k2 >= i) continue;
                                index_k = this.numLatent + k2;
                            }
                            double[] dArray = this.auxInverseOmega[i][ii];
                            int n = index_j;
                            dArray[n] = dArray[n] + this.selectedInverseOmega[i][ii][index_k] * this.sampleCovErrors[k2][j11];
                        }
                    }
                }
                for (ii = 0; ii < this.parents[i].length; ++ii) {
                    for (int j12 = ii; j12 < this.parents[i].length; ++j12) {
                        double d = this.parentsCov[i][ii][j12];
                        this.pseudoParentsCov[i][j12][ii] = d;
                        this.pseudoParentsCov[i][ii][j12] = d;
                    }
                }
                for (ii = 0; ii < this.parents[i].length; ++ii) {
                    for (int j13 = 0; j13 < this.nSpouses[i]; ++j13) {
                        this.pseudoParentsCov[i][ii][this.parents[i].length + j13] = 0.0;
                        for (k = 0; k < this.numLatent + this.numObserved - 1; ++k) {
                            double[] dArray = this.pseudoParentsCov[i][ii];
                            int n = this.parents[i].length + j13;
                            dArray[n] = dArray[n] + this.parentsResidualsCovar[i][ii][k] * this.selectedInverseOmega[i][j13][k];
                        }
                        this.pseudoParentsCov[i][this.parents[i].length + j13][ii] = this.pseudoParentsCov[i][ii][this.parents[i].length + j13];
                    }
                }
                block53: for (ii = 0; ii < this.nSpouses[i]; ++ii) {
                    for (int j14 = ii; j14 < this.nSpouses[i]; ++j14) {
                        this.pseudoParentsCov[i][this.parents[i].length + ii][this.parents[i].length + j14] = 0.0;
                        for (k = 0; k < this.numLatent + this.numObserved - 1; ++k) {
                            double[] dArray = this.pseudoParentsCov[i][this.parents[i].length + ii];
                            int n = this.parents[i].length + j14;
                            dArray[n] = dArray[n] + this.auxInverseOmega[i][ii][k] * this.selectedInverseOmega[i][j14][k];
                        }
                        this.pseudoParentsCov[i][this.parents[i].length + j14][this.parents[i].length + ii] = this.pseudoParentsCov[i][this.parents[i].length + ii][this.parents[i].length + j14];
                        if (this.pseudoParentsCov[i][this.parents[i].length + j14][this.parents[i].length + ii] != 0.0) continue;
                        System.out.println("Zero here... Iter = " + iter);
                        iter = 1000;
                        continue block53;
                    }
                }
                if (this.parents[i].length >= 0) {
                    System.arraycopy(this.parentsChildCov[i], 0, this.pseudoParentsChildCov[i], 0, this.parents[i].length);
                }
                for (int j15 = 0; j15 < this.nSpouses[i]; ++j15) {
                    this.pseudoParentsChildCov[i][this.parents[i].length + j15] = 0.0;
                    for (int k3 = 0; k3 < this.numLatent + this.numObserved - 1; ++k3) {
                        double[] dArray = this.pseudoParentsChildCov[i];
                        int n = this.parents[i].length + j15;
                        dArray[n] = dArray[n] + this.selectedInverseOmega[i][j15][k3] * this.iResidualsCovar[k3];
                    }
                }
                double[] params = MatrixUtils.product(MatrixUtils.inverse(this.pseudoParentsCov[i]), this.pseudoParentsChildCov[i]);
                for (j5 = 0; j5 < this.parents[i].length; ++j5) {
                    if (this.parentsL[i][j5]) {
                        this.betas[i][this.parents[i][j5]] = params[j5];
                        continue;
                    }
                    this.betas[i][this.numLatent + this.parents[i][j5]] = params[j5];
                }
                for (j5 = 0; j5 < this.nSpouses[i]; ++j5) {
                    double d = params[this.parents[i].length + j5];
                    this.covErrors[this.spouses[i][j5]][i] = d;
                    this.covErrors[i][this.spouses[i][j5]] = d;
                    if (this.spouses[i][j5] > i) {
                        this.omegaI[this.numLatent + this.spouses[i][j5] - 1] = params[this.parents[i].length + j5];
                        continue;
                    }
                    this.omegaI[this.numLatent + this.spouses[i][j5]] = params[this.parents[i].length + j5];
                }
                double conditionalVar = this.Cyy[i][i] - MatrixUtils.innerProduct(this.pseudoParentsChildCov[i], params);
                this.covErrors[i][i] = conditionalVar + MatrixUtils.innerProduct(MatrixUtils.product(this.omegaI, inverseOmega), this.omegaI);
            }
            change = 0.0;
            for (i = 0; i < this.covErrors.length; ++i) {
                for (int j16 = i; j16 < this.covErrors.length; ++j16) {
                    change += FastMath.abs(this.oldCovErrors[i][j16] - this.covErrors[i][j16]);
                }
            }
            for (i = 0; i < this.numObserved; ++i) {
                for (int j17 = 0; j17 < this.betas[i].length; ++j17) {
                    change += FastMath.abs(this.oldBetas[i][j17] - this.betas[i][j17]);
                }
            }
        } while (++iter < 200 && change > 0.01);
        try {
            for (i = 0; i < this.numObserved; ++i) {
                int j18;
                Node node = semIm.getSemPm().getGraph().getNode(this.measuredNodes.get(i).toString());
                Node nodeErrorTerm = semIm.getSemPm().getGraph().getExogenous(node);
                for (j18 = 0; j18 < this.parents[i].length; ++j18) {
                    Node parent = this.parentsL[i][j18] ? semIm.getSemPm().getGraph().getNode(this.latentNodes.get(this.parents[i][j18]).toString()) : semIm.getSemPm().getGraph().getNode(this.measuredNodes.get(this.parents[i][j18]).toString());
                    if (this.parentsL[i][j18]) {
                        semIm.setParamValue(parent, node, this.betas[i][this.parents[i][j18]]);
                        continue;
                    }
                    semIm.setParamValue(parent, node, this.betas[i][this.numLatent + this.parents[i][j18]]);
                }
                for (j18 = 0; j18 < this.nSpouses[i]; ++j18) {
                    if (this.spouses[i][j18] <= i) continue;
                    Node spouse = semIm.getSemPm().getGraph().getNode(this.measuredNodes.get(this.spouses[i][j18]).toString());
                    Node spouseErrorTerm = semIm.getSemPm().getGraph().getExogenous(spouse);
                    semIm.setParamValue(nodeErrorTerm, spouseErrorTerm, this.covErrors[i][this.spouses[i][j18]]);
                }
            }
            for (i = 0; i < this.numLatent; ++i) {
                Node node = semIm.getSemPm().getGraph().getNode(this.latentNodes.get(i).toString());
                if (semIm.getSemPm().getGraph().getParents(node).size() == 0) {
                    semIm.setParamValue(node, node, this.varErrorLatent[i]);
                    continue;
                }
                for (Node nextParent : semIm.getSemPm().getGraph().getParents(node)) {
                    if (nextParent.getNodeType() != NodeType.ERROR) continue;
                    semIm.setParamValue(nextParent, nextParent, this.varErrorLatent[i]);
                    break;
                }
                for (int j19 = 0; j19 < this.parentsLat[i].length; ++j19) {
                    Node parent = semIm.getSemPm().getGraph().getNode(this.latentNodes.get(this.parentsLat[i][j19]).toString());
                    semIm.setParamValue(parent, node, this.betasLat[i][this.parentsLat[i][j19]]);
                }
            }
            return -semIm.getTruncLL() - 0.5 * (double)semIm.getNumFreeParams() * FastMath.log(this.covarianceMatrix.getSampleSize());
        }
        catch (IllegalArgumentException e) {
            System.out.println("** Warning: " + e.toString());
            return -1.7976931348623157E308;
        }
    }

    private SemGraph removeMarkedImpurities(SemGraph graph, boolean[][] impurities) {
        int i;
        this.printlnMessage();
        this.printlnMessage("** PURIFY: using marked impure pairs");
        ArrayList<Node> latents = new ArrayList<Node>();
        ArrayList<int[]> partition = new ArrayList<int[]>();
        for (i = 0; i < graph.getNodes().size(); ++i) {
            Node nextLatent = graph.getNodes().get(i);
            if (nextLatent.getNodeType() != NodeType.LATENT) continue;
            latents.add(graph.getNodes().get(i));
            Iterator<Node> cit = graph.getChildren(nextLatent).iterator();
            ArrayList<Node> children = new ArrayList<Node>();
            while (cit.hasNext()) {
                Node cnext = cit.next();
                if (cnext.getNodeType() != NodeType.MEASURED) continue;
                children.add(cnext);
            }
            int[] newCluster = new int[children.size()];
            for (int j = 0; j < children.size(); ++j) {
                newCluster[j] = this.observableNames.get(((Node)children.get(j)).toString());
            }
            partition.add(newCluster);
        }
        for (i = 0; i < impurities.length - 1; ++i) {
            for (int j = i + 1; j < impurities.length; ++j) {
                if (!impurities[i][j]) continue;
                System.out.println(this.measuredNodes.get(i).toString() + " x " + this.measuredNodes.get(j).toString());
            }
        }
        ArrayList<int[]> latentCliques = new ArrayList<int[]>();
        int[] firstClique = new int[latents.size()];
        for (int i2 = 0; i2 < firstClique.length; ++i2) {
            firstClique[i2] = i2;
        }
        latentCliques.add(firstClique);
        Iterator iterator = latentCliques.iterator();
        if (iterator.hasNext()) {
            Object latentClique = iterator.next();
            int[] nextLatentList = (int[])latentClique;
            ArrayList<int[]> nextPartition = new ArrayList<int[]>();
            for (int j : nextLatentList) {
                nextPartition.add((int[])partition.get(j));
            }
            List<int[]> solution = this.findInducedPureGraph(nextPartition, impurities);
            if (solution != null) {
                int p;
                System.out.println("--Solution");
                Iterator<int[]> iterator2 = solution.iterator();
                while (iterator2.hasNext()) {
                    int[] o;
                    int[] c;
                    for (int i3 : c = (o = iterator2.next())) {
                        System.out.print(this.measuredNodes.get(i3).toString() + " ");
                    }
                    System.out.println();
                }
                this.printlnMessage(">> SIZE: " + this.sizeCluster(solution));
                this.printlnMessage(">> New solution found!");
                SemGraph graph2 = new SemGraph();
                graph2.setShowErrorTerms(true);
                Node[] latentsArray = new Node[solution.size()];
                for (p = 0; p < solution.size(); ++p) {
                    int[] cluster = solution.get(p);
                    latentsArray[p] = new GraphNode("_L" + (p + 1));
                    latentsArray[p].setNodeType(NodeType.LATENT);
                    graph2.addNode(latentsArray[p]);
                    for (int i4 : cluster) {
                        GraphNode newIndicator = new GraphNode(this.measuredNodes.get(i4).toString());
                        graph2.addNode(newIndicator);
                        graph2.addDirectedEdge(latentsArray[p], newIndicator);
                    }
                }
                for (p = 0; p < latentsArray.length - 1; ++p) {
                    for (int q = p + 1; q < latentsArray.length; ++q) {
                        graph2.addDirectedEdge(latentsArray[p], latentsArray[q]);
                    }
                }
                return graph2;
            }
            return null;
        }
        return null;
    }

    private List<int[]> findInducedPureGraph(List<int[]> partition, boolean[][] impurities) {
        int[][] elements = new int[this.sizeCluster(partition)][3];
        int countElements = 0;
        for (int p = 0; p < partition.size(); ++p) {
            int[] next;
            int[] nArray = next = partition.get(p);
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int j;
                elements[countElements][0] = j = nArray[i];
                elements[countElements][1] = p;
                ++countElements;
            }
        }
        for (int i = 0; i < elements.length; ++i) {
            elements[i][2] = 0;
            for (int j = 0; j < elements.length; ++j) {
                if (!impurities[elements[i][0]][elements[j][0]]) continue;
                int[] nArray = elements[i];
                nArray[2] = nArray[2] + 1;
            }
        }
        boolean[] eliminated = new boolean[this.numVars];
        for (int[] element : elements) {
            eliminated[element[0]] = impurities[element[0]][element[0]];
        }
        return this.buildSolution2(elements, eliminated, partition);
    }

    private int sizeCluster(List<int[]> cluster) {
        int total = 0;
        Iterator<int[]> iterator = cluster.iterator();
        while (iterator.hasNext()) {
            int[] o;
            int[] next = o = iterator.next();
            total += next.length;
        }
        return total;
    }

    private List<int[]> buildSolution2(int[][] elements, boolean[] eliminated, List<int[]> partition) {
        ArrayList<int[]> solution = new ArrayList<int[]>();
        Iterator<int[]> iterator = partition.iterator();
        while (iterator.hasNext()) {
            int[] o;
            int[] next = o = iterator.next();
            int[] draftArea = new int[next.length];
            int draftCount = 0;
            for (int j : next) {
                for (int[] element : elements) {
                    if (element[0] != j || eliminated[element[0]]) continue;
                    draftArea[draftCount++] = j;
                }
            }
            if (draftCount <= 0) continue;
            int[] realCluster = new int[draftCount];
            System.arraycopy(draftArea, 0, realCluster, 0, draftCount);
            solution.add(realCluster);
        }
        if (solution.size() > 0) {
            return solution;
        }
        return null;
    }

    private void impurityScoreSearch(double initialScore) {
        double nextScore = initialScore;
        boolean[] changed = new boolean[]{false};
        do {
            double score = nextScore;
            nextScore = this.addImpuritySearch(score, changed);
            if (!changed[0]) continue;
            changed[0] = false;
            nextScore = this.deleteImpuritySearch(nextScore, changed);
        } while (changed[0]);
    }

    private double addImpuritySearch(double initialScore, boolean[] changed) {
        double score;
        double nextScore = initialScore;
        int choiceType = -1;
        do {
            score = nextScore;
            int bestChoice1 = -1;
            int bestChoice2 = -1;
            for (int i = 0; i < this.numObserved; ++i) {
                for (int j = i + 1; j < this.numObserved; ++j) {
                    if (this.forbiddenImpurity(this.measuredNodes.get(i).toString(), this.measuredNodes.get(j).toString()) || this.correlatedErrors[i][j] || this.observedParent[i][j] || this.observedParent[j][i]) continue;
                    this.correlatedErrors[j][i] = true;
                    this.correlatedErrors[i][j] = true;
                    double newScore = this.scoreCandidate();
                    System.out.println("Trying impurity " + i + " &lt;-&gt; " + j + " (Score = " + newScore + ")");
                    if (newScore > nextScore) {
                        nextScore = newScore;
                        bestChoice1 = i;
                        bestChoice2 = j;
                        choiceType = 2;
                    }
                    this.correlatedErrors[j][i] = false;
                    this.correlatedErrors[i][j] = false;
                }
            }
            if (bestChoice1 == -1) continue;
            this.modifiedGraph = true;
            switch (choiceType) {
                case 0: {
                    this.latentParent[bestChoice1][bestChoice2] = true;
                    System.out.println("****************************Added impurity: " + this.latentNodes.get(bestChoice2).toString() + " --> " + this.measuredNodes.get(bestChoice1).toString() + " " + nextScore);
                    break;
                }
                case 1: {
                    this.observedParent[bestChoice1][bestChoice2] = true;
                    System.out.println("****************************Added impurity: " + this.measuredNodes.get(bestChoice2).toString() + " --> " + this.measuredNodes.get(bestChoice1).toString() + " " + nextScore);
                    break;
                }
                case 2: {
                    System.out.println("****************************Added impurity: " + this.measuredNodes.get(bestChoice1).toString() + " &lt;-&gt; " + this.measuredNodes.get(bestChoice2).toString() + " " + nextScore);
                    this.correlatedErrors[bestChoice2][bestChoice1] = true;
                    this.correlatedErrors[bestChoice1][bestChoice2] = true;
                }
            }
            changed[0] = true;
        } while (score < nextScore);
        this.printlnMessage("End of addition round");
        return score;
    }

    private boolean forbiddenImpurity(String name1, String name2) {
        if (this.forbiddenList == null) {
            return false;
        }
        for (Set<String> nextPair : this.forbiddenList) {
            if (!nextPair.contains(name1) || !nextPair.contains(name2)) continue;
            return true;
        }
        return false;
    }

    private double scoreCandidate() {
        SemGraph graph = this.updatedGraph();
        this.initializeGaussianEM(graph);
        SemPm semPm = new SemPm(graph);
        SemIm semIm = new SemIm(semPm, this.covarianceMatrix);
        this.gaussianMaximization(semIm);
        try {
            System.out.println("trunk ll = " + semIm.getTruncLL());
            return -semIm.getTruncLL() - 0.5 * (double)semIm.getNumFreeParams() * FastMath.log(this.covarianceMatrix.getSampleSize());
        }
        catch (IllegalArgumentException e) {
            return -1.7976931348623157E308;
        }
    }

    private SemGraph updatedGraph() {
        SemGraph output = new SemGraph(this.basicGraph);
        output.setShowErrorTerms(true);
        for (int i = 0; i < output.getNodes().size() - 1; ++i) {
            Node node2;
            int j;
            Node node1 = output.getNodes().get(i);
            if (node1.getNodeType() != NodeType.MEASURED) continue;
            for (j = 0; j < output.getNodes().size(); ++j) {
                int pos2;
                int pos1;
                node2 = output.getNodes().get(j);
                if (node2.getNodeType() != NodeType.LATENT || !this.latentParent[pos1 = this.observableNames.get(output.getNodes().get(i).toString()).intValue()][pos2 = this.latentNames.get(output.getNodes().get(j).toString()).intValue()] || output.getEdge(node1, node2) != null) continue;
                output.addDirectedEdge(node2, node1);
            }
            for (j = i + 1; j < output.getNodes().size(); ++j) {
                int pos2;
                node2 = output.getNodes().get(j);
                if (node2.getNodeType() != NodeType.MEASURED) continue;
                Node errnode1 = output.getErrorNode(output.getNodes().get(i));
                Node errnode2 = output.getErrorNode(output.getNodes().get(j));
                int pos1 = this.observableNames.get(output.getNodes().get(i).toString());
                if (this.correlatedErrors[pos1][pos2 = this.observableNames.get(output.getNodes().get(j).toString()).intValue()] && output.getEdge(errnode1, errnode2) == null) {
                    output.addBidirectedEdge(errnode1, errnode2);
                }
                if (this.observedParent[pos1][pos2] && output.getEdge(node1, node2) == null) {
                    output.addDirectedEdge(node2, node1);
                    continue;
                }
                if (!this.observedParent[pos2][pos1] || output.getEdge(node1, node2) != null) continue;
                output.addDirectedEdge(node1, node2);
            }
        }
        return output;
    }

    private double deleteImpuritySearch(double initialScore, boolean[] changed) {
        double score;
        double nextScore = initialScore;
        int choiceType = -1;
        do {
            score = nextScore;
            int bestChoice1 = -1;
            int bestChoice2 = -1;
            for (int i = 0; i < this.numObserved - 1; ++i) {
                for (int j = i + 1; j < this.numObserved; ++j) {
                    if (this.observedParent[i][j] || this.observedParent[j][i]) {
                        boolean directionIJ = this.observedParent[i][j];
                        this.observedParent[j][i] = false;
                        this.observedParent[i][j] = false;
                        double newScore = this.scoreCandidate();
                        if (newScore > nextScore) {
                            nextScore = newScore;
                            bestChoice1 = i;
                            bestChoice2 = j;
                            choiceType = 0;
                        }
                        if (directionIJ) {
                            this.observedParent[i][j] = true;
                        } else {
                            this.observedParent[j][i] = true;
                        }
                    }
                    if (!this.correlatedErrors[i][j]) continue;
                    this.correlatedErrors[j][i] = false;
                    this.correlatedErrors[i][j] = false;
                    double newScore = this.scoreCandidate();
                    if (newScore > nextScore) {
                        nextScore = newScore;
                        bestChoice1 = i;
                        bestChoice2 = j;
                        choiceType = 1;
                    }
                    this.correlatedErrors[j][i] = true;
                    this.correlatedErrors[i][j] = true;
                }
            }
            if (bestChoice1 == -1) continue;
            this.modifiedGraph = true;
            switch (choiceType) {
                case 0: {
                    if (this.observedParent[bestChoice1][bestChoice2]) {
                        System.out.println("****************************Removed impurity: " + this.measuredNodes.get(bestChoice2).toString() + " --> " + this.measuredNodes.get(bestChoice1).toString() + " " + nextScore);
                    } else {
                        System.out.println("****************************Removed impurity: " + this.measuredNodes.get(bestChoice1).toString() + " --> " + this.measuredNodes.get(bestChoice2).toString() + " " + nextScore);
                    }
                    this.observedParent[bestChoice2][bestChoice1] = false;
                    this.observedParent[bestChoice1][bestChoice2] = false;
                    break;
                }
                case 1: {
                    System.out.println("****************************Removed impurity: " + this.measuredNodes.get(bestChoice1).toString() + " &lt;-&gt; " + this.measuredNodes.get(bestChoice2).toString() + " " + nextScore);
                    this.correlatedErrors[bestChoice2][bestChoice1] = false;
                    this.correlatedErrors[bestChoice1][bestChoice2] = false;
                }
            }
            changed[0] = true;
        } while (score < nextScore);
        this.printlnMessage("End of deletion round");
        return score;
    }
}

