/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.search.utils.SepsetProducer;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public class SepsetsConservative
implements SepsetProducer {
    private final Graph graph;
    private final IndependenceTest independenceTest;
    private final SepsetMap extraSepsets;
    private final int depth;
    private IndependenceResult lastResult;

    public SepsetsConservative(Graph graph, IndependenceTest independenceTest, SepsetMap extraSepsets, int depth) {
        this.graph = graph;
        this.independenceTest = independenceTest;
        this.extraSepsets = extraSepsets;
        this.depth = depth;
    }

    @Override
    public Set<Node> getSepset(Node i, Node k) {
        Set<Node> possibleMsep;
        double _p = 0.0;
        Set<Node> _v = null;
        if (this.extraSepsets != null && (possibleMsep = this.extraSepsets.get(i, k)) != null) {
            IndependenceResult result = this.independenceTest.checkIndependence(i, k, possibleMsep);
            _p = result.getPValue();
            _v = possibleMsep;
        }
        ArrayList<Node> adji = new ArrayList<Node>(this.graph.getAdjacentNodes(i));
        ArrayList<Node> adjk = new ArrayList<Node>(this.graph.getAdjacentNodes(k));
        adji.remove(k);
        adjk.remove(i);
        for (int d = 0; d <= FastMath.min(this.depth == -1 ? 1000 : this.depth, FastMath.max(adji.size(), adjk.size())); ++d) {
            double pValue;
            IndependenceResult result;
            Set<Node> v;
            int[] choice;
            ChoiceGenerator gen;
            if (d <= adji.size()) {
                gen = new ChoiceGenerator(adji.size(), d);
                while ((choice = gen.next()) != null) {
                    v = GraphUtils.asSet(choice, adji);
                    result = this.getIndependenceTest().checkIndependence(i, k, v);
                    if (!result.isIndependent() || !((pValue = result.getPValue()) > _p)) continue;
                    _p = pValue;
                    _v = v;
                }
            }
            if (d > adjk.size()) continue;
            gen = new ChoiceGenerator(adjk.size(), d);
            while ((choice = gen.next()) != null) {
                v = GraphUtils.asSet(choice, adjk);
                result = this.getIndependenceTest().checkIndependence(i, k, v);
                if (!result.isIndependent() || !((pValue = result.getPValue()) > _p)) continue;
                _p = pValue;
                _v = v;
            }
        }
        return _v;
    }

    @Override
    public boolean isUnshieldedCollider(Node i, Node j, Node k) {
        List<List<Set<Node>>> ret = this.getSepsetsLists(i, j, k, this.independenceTest, this.depth, true);
        return ret.get(0).isEmpty();
    }

    public List<List<Set<Node>>> getSepsetsLists(Node x, Node y, Node z, IndependenceTest test, int depth, boolean verbose) {
        Set<Node> cond;
        int[] choice;
        ChoiceGenerator cg;
        int d;
        ArrayList<Set<Node>> sepsetsContainingY = new ArrayList<Set<Node>>();
        ArrayList<Set<Node>> sepsetsNotContainingY = new ArrayList<Set<Node>>();
        ArrayList<Node> _nodes = new ArrayList<Node>(this.graph.getAdjacentNodes(x));
        _nodes.remove(z);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                cond = GraphUtils.asSet(choice, _nodes);
                if (!test.checkIndependence(x, z, cond).isIndependent()) continue;
                if (verbose) {
                    System.out.println("Indep: " + x + " _||_ " + z + " | " + cond);
                }
                if (cond.contains(y)) {
                    sepsetsContainingY.add(cond);
                    continue;
                }
                sepsetsNotContainingY.add(cond);
            }
        }
        _nodes = new ArrayList<Node>(this.graph.getAdjacentNodes(z));
        _nodes.remove(x);
        _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = FastMath.min(_depth, _nodes.size());
        for (d = 0; d <= _depth; ++d) {
            cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                cond = GraphUtils.asSet(choice, _nodes);
                if (!test.checkIndependence(x, z, cond).isIndependent()) continue;
                if (cond.contains(y)) {
                    sepsetsContainingY.add(cond);
                    continue;
                }
                sepsetsNotContainingY.add(cond);
            }
        }
        ArrayList<List<Set<Node>>> ret = new ArrayList<List<Set<Node>>>();
        ret.add(sepsetsContainingY);
        ret.add(sepsetsNotContainingY);
        return ret;
    }

    @Override
    public boolean isIndependent(Node a, Node b, Set<Node> c) {
        IndependenceResult result;
        this.lastResult = result = this.independenceTest.checkIndependence(a, b, c);
        return result.isIndependent();
    }

    @Override
    public double getScore() {
        return -(this.lastResult.getPValue() - this.independenceTest.getAlpha());
    }

    @Override
    public List<Node> getVariables() {
        return this.independenceTest.getVariables();
    }

    @Override
    public void setVerbose(boolean verbose) {
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }
}

