/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.test.MsepTest;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.search.utils.SepsetProducer;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.FastMath;

public class SepsetsGreedy
implements SepsetProducer {
    private final Graph graph;
    private final IndependenceTest independenceTest;
    private final SepsetMap extraSepsets;
    private int depth;
    private boolean verbose;
    private IndependenceResult result;
    private Knowledge knowledge = new Knowledge();

    public SepsetsGreedy(Graph graph, IndependenceTest independenceTest, SepsetMap extraSepsets, int depth, Knowledge knowledge) {
        this.graph = graph;
        this.independenceTest = independenceTest;
        this.extraSepsets = extraSepsets;
        this.depth = depth;
        if (knowledge != null) {
            this.knowledge = knowledge;
        }
    }

    @Override
    public Set<Node> getSepset(Node i, Node k) {
        return this.getSepsetGreedy(i, k);
    }

    @Override
    public boolean isUnshieldedCollider(Node i, Node j, Node k) {
        Set<Node> set = this.getSepsetGreedy(i, k);
        return set != null && !set.contains(j);
    }

    @Override
    public boolean isIndependent(Node a, Node b, Set<Node> c) {
        IndependenceResult result;
        this.result = result = this.independenceTest.checkIndependence(a, b, c);
        return result.isIndependent();
    }

    @Override
    public double getScore() {
        return -(this.result.getPValue() - this.independenceTest.getAlpha());
    }

    @Override
    public List<Node> getVariables() {
        return this.independenceTest.getVariables();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Graph getDag() {
        if (this.independenceTest instanceof MsepTest) {
            return ((MsepTest)this.independenceTest).getGraph();
        }
        return null;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    private Set<Node> getSepsetGreedy(Node i, Node k) {
        Set<Node> v;
        if (this.extraSepsets != null && (v = this.extraSepsets.get(i, k)) != null) {
            return v;
        }
        ArrayList<Node> adji = new ArrayList<Node>(this.graph.getAdjacentNodes(i));
        ArrayList<Node> adjk = new ArrayList<Node>(this.graph.getAdjacentNodes(k));
        adji.remove(k);
        adjk.remove(i);
        for (int d = 0; d <= FastMath.min(this.depth == -1 ? 1000 : this.depth, FastMath.max(adji.size(), adjk.size())); ++d) {
            Set<Node> v2;
            int[] choice;
            ChoiceGenerator gen;
            if (d <= adji.size()) {
                gen = new ChoiceGenerator(adji.size(), d);
                while ((choice = gen.next()) != null) {
                    v2 = GraphUtils.asSet(choice, adji);
                    if (!this.independenceTest.checkIndependence(i, k, v2 = this.possibleParents(i, v2, this.knowledge, k)).isIndependent()) continue;
                    return v2;
                }
            }
            if (d > adjk.size()) continue;
            gen = new ChoiceGenerator(adjk.size(), d);
            while ((choice = gen.next()) != null) {
                v2 = GraphUtils.asSet(choice, adjk);
                if (!this.independenceTest.checkIndependence(i, k, v2 = this.possibleParents(k, v2, this.knowledge, i)).isIndependent()) continue;
                return v2;
            }
        }
        return null;
    }

    private Set<Node> possibleParents(Node x, Set<Node> adjx, Knowledge knowledge, Node y) {
        HashSet<Node> possibleParents = new HashSet<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z;
            if (z == x || z == y || !this.possibleParentOf(_z = z.getName(), _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.isForbidden(z, x) && !knowledge.isRequired(x, z);
    }
}

