/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.search.utils.SepsetProducer;
import java.util.List;
import java.util.Set;

public class SepsetsSet
implements SepsetProducer {
    private final SepsetMap sepsets;
    private final IndependenceTest test;
    private boolean verbose;
    private IndependenceResult result;

    public SepsetsSet(SepsetMap sepsets, IndependenceTest test) {
        this.sepsets = sepsets;
        this.test = test;
    }

    @Override
    public Set<Node> getSepset(Node a, Node b) {
        return this.sepsets.get(a, b);
    }

    @Override
    public boolean isUnshieldedCollider(Node i, Node j, Node k) {
        Set<Node> sepset = this.sepsets.get(i, k);
        if (sepset == null) {
            throw new IllegalArgumentException("That triple was covered: " + i + " " + j + " " + k);
        }
        return !sepset.contains(j);
    }

    @Override
    public boolean isIndependent(Node a, Node b, Set<Node> c) {
        IndependenceResult result;
        this.result = result = this.test.checkIndependence(a, b, c);
        return result.isIndependent();
    }

    @Override
    public double getScore() {
        return -(this.result.getPValue() - this.test.getAlpha());
    }

    @Override
    public List<Node> getVariables() {
        return this.test.getVariables();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

