/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.graph.Node;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;

public class Tetrad {
    private final Node i;
    private final Node j;
    private final Node k;
    private final Node l;
    private final double pValue;

    public Tetrad(Node i, Node j, Node k, Node l) {
        this.i = i;
        this.j = j;
        this.k = k;
        this.l = l;
        this.pValue = Double.NaN;
    }

    public Tetrad(Node i, Node j, Node k, Node l, double pValue) {
        this.i = i;
        this.j = j;
        this.k = k;
        this.l = l;
        this.pValue = pValue;
    }

    public Node getI() {
        return this.i;
    }

    public Node getJ() {
        return this.j;
    }

    public Node getK() {
        return this.k;
    }

    public Node getL() {
        return this.l;
    }

    public int hashCode() {
        int hash = 17 * this.i.hashCode() * this.j.hashCode();
        return hash += 29 * this.k.hashCode() * this.l.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Tetrad)) {
            return false;
        }
        Tetrad tetrad = (Tetrad)o;
        return this.i == tetrad.i && this.j == tetrad.j && this.k == tetrad.k && this.l == tetrad.l || this.i == tetrad.j && this.j == tetrad.i && this.k == tetrad.k && this.l == tetrad.l || this.i == tetrad.i && this.j == tetrad.j && this.k == tetrad.l && this.l == tetrad.k || this.i == tetrad.j && this.j == tetrad.i && this.k == tetrad.l && this.l == tetrad.k || this.i == tetrad.k && this.j == tetrad.l && this.k == tetrad.i && this.l == tetrad.j || this.i == tetrad.k && this.j == tetrad.l && this.k == tetrad.j && this.l == tetrad.i || this.i == tetrad.l && this.j == tetrad.k && this.k == tetrad.i && this.l == tetrad.j || this.i == tetrad.l && this.j == tetrad.k && this.k == tetrad.j && this.l == tetrad.i;
    }

    public String toString() {
        DecimalFormat nf = new DecimalFormat("0.0000");
        if (Double.isNaN(this.pValue)) {
            return "s(" + this.i + "," + this.j + ")*s(" + this.k + "," + this.l + ")-s(" + this.i + "," + this.k + ")*s(" + this.j + "," + this.l + ")";
        }
        return "<" + this.i + ", " + this.j + ", " + this.k + ", " + this.l + ", " + nf.format(this.pValue) + ">";
    }

    public double getPValue() {
        return this.pValue;
    }

    public Set<Node> getNodes() {
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(this.i);
        nodes.add(this.j);
        nodes.add(this.k);
        nodes.add(this.l);
        return nodes;
    }
}

