/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.utils.TetradTest;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public final class TetradTestDiscrete
implements TetradTest {
    private static final int MAX_VALUES = 50;
    private static final int RHO_GRID_SIZE = 1000;
    private static final double[] GHY = new double[]{5.555035187326467, 4.773992343411219, 4.12199554749184, 3.5319728771376777, 2.979991207704598, 2.453552124512838, 1.944962949186254, 1.448934250650732, 0.961499634418369, 0.4794507070791076, 0.0, -5.555035187326467, -4.773992343411219, -4.12199554749184, -3.5319728771376777, -2.979991207704598, -2.453552124512838, -1.944962949186254, -1.448934250650732, -0.961499634418369, -0.4794507070791076};
    public boolean verbose;
    DataSet dataSet;
    int[][][][] counts;
    int[][] values;
    int[] valueIndices;
    double[][] thresholds;
    int[] indices;
    int[][][][] currentCounts;
    int currentVar1;
    int currentVar2;
    double[][] currentFiBuffer;
    double[][] currentPi;
    double currentRho;
    double[] rhoGrid;
    double[][] polyCorr;
    int[][][][] oneFactor4Tests;
    int[][][][] twoFactor4Tests;
    private double[] prob;
    private double tempProb;
    private double sig1;
    private double sig2;
    private double sig3;
    private double sig;
    private boolean[] bvalues;

    public TetradTestDiscrete(DataSet dataSet, double sig) {
        this.dataSet = dataSet;
        this.sig = sig;
        this.initialization();
    }

    @Override
    public String[] getVarNames() {
        return this.dataSet.getVariableNames().toArray(new String[0]);
    }

    @Override
    public List<Node> getVariables() {
        return this.dataSet.getVariables();
    }

    @Override
    public DataSet getDataSet() {
        return this.dataSet;
    }

    private void initialization() {
        int i;
        int i2 = 0;
        while (i2 < GHY.length) {
            int n = i2++;
            GHY[n] = GHY[n] * FastMath.sqrt(2.0);
        }
        int numRows = this.dataSet.getNumRows();
        int numColumns = this.dataSet.getNumColumns();
        this.prob = new double[3];
        this.bvalues = new boolean[3];
        this.sig1 = this.sig / 3.0;
        this.sig2 = 2.0 * this.sig / 3.0;
        this.sig3 = this.sig;
        this.rhoGrid = new double[1000];
        for (int i3 = 1; i3 < 1000; ++i3) {
            this.rhoGrid[i3 - 1] = -1.0 + 0.002 * (double)i3;
        }
        this.values = new int[numColumns][];
        this.valueIndices = new int[numColumns];
        int[] tempValues = new int[50];
        boolean[] marked = new boolean[50];
        for (i = 0; i < numColumns; ++i) {
            int j;
            int vSize = 0;
            block3: for (j = 0; j < numRows; ++j) {
                int value = this.dataSet.getInt(j, i);
                for (int k = 0; k < vSize; ++k) {
                    if (tempValues[k] == value) continue block3;
                }
                if (vSize < 49) {
                    tempValues[vSize++] = value;
                    continue;
                }
                throw new RuntimeException("Maximum number of distinct values for a discrete variable exceeded!");
            }
            this.values[i] = new int[vSize];
            if (i == 0) {
                this.valueIndices[0] = 0;
            } else {
                this.valueIndices[i] = this.valueIndices[i - 1] + vSize - 1;
            }
            for (j = 0; j < vSize; ++j) {
                marked[j] = false;
            }
            for (j = 0; j < vSize; ++j) {
                int minValue = Integer.MAX_VALUE;
                int minIndexValue = -1;
                for (int k = 0; k < vSize; ++k) {
                    if (marked[k] || tempValues[k] >= minValue) continue;
                    minValue = tempValues[k];
                    minIndexValue = k;
                }
                this.values[i][j] = minValue;
                marked[minIndexValue] = true;
            }
        }
        this.thresholds = new double[numColumns][];
        for (i = 0; i < numColumns; ++i) {
            this.thresholds[i] = new double[this.values[i].length - 1];
        }
        this.counts = new int[numColumns][numColumns][][];
        this.computeCounts(this.counts, this.dataSet);
        this.currentCounts = this.counts;
        this.polyCorr = this.getUnderlyingCorr(this.counts);
        this.oneFactor4Tests = new int[this.values.length][this.values.length][this.values.length][this.values.length];
        this.twoFactor4Tests = new int[this.values.length][this.values.length][this.values.length][this.values.length];
        this.resetCache();
    }

    public void resetCache() {
        int v4;
        int v3;
        int v2;
        int v1;
        for (v1 = 0; v1 < this.values.length; ++v1) {
            for (v2 = v1 + 1; v2 < this.values.length; ++v2) {
                for (v3 = v2 + 1; v3 < this.values.length; ++v3) {
                    for (v4 = v3 + 1; v4 < this.values.length; ++v4) {
                        this.oneFactor4Tests[v1][v2][v3][v4] = 0;
                    }
                }
            }
        }
        for (v1 = 0; v1 < this.values.length - 1; ++v1) {
            for (v2 = v1 + 1; v2 < this.values.length; ++v2) {
                for (v3 = 0; v3 < this.values.length - 1; ++v3) {
                    for (v4 = v3 + 1; v4 < this.values.length; ++v4) {
                        this.twoFactor4Tests[v1][v2][v3][v4] = 0;
                    }
                }
            }
        }
    }

    @Override
    public double getSignificance() {
        return this.sig;
    }

    @Override
    public void setSignificance(double sig) {
        this.sig = sig;
    }

    @Override
    public int tetradScore(int i, int j, int k, int l) {
        if (!this.oneFactorTest(i, j, k, l)) {
            this.twoFactorTest(i, l, j, k);
            this.prob[0] = this.tempProb;
            this.twoFactorTest(i, k, j, l);
            this.prob[1] = this.tempProb;
            this.twoFactorTest(i, j, k, l);
            this.prob[2] = this.tempProb;
            for (int c = 0; c < 3; ++c) {
                this.bvalues[c] = this.prob[c] >= this.sig;
            }
            if (this.prob[1] < this.prob[0] && this.prob[1] < this.prob[2]) {
                this.tempProb = this.prob[0];
                this.prob[0] = this.prob[1];
                this.prob[1] = this.tempProb;
            } else if (this.prob[2] < this.prob[0] && this.prob[2] < this.prob[0]) {
                this.tempProb = this.prob[0];
                this.prob[0] = this.prob[2];
                this.prob[2] = this.tempProb;
            }
            if (this.prob[2] < this.prob[1]) {
                this.tempProb = this.prob[1];
                this.prob[1] = this.prob[2];
                this.prob[2] = this.tempProb;
            }
            if (this.prob[2] <= this.sig3) {
                return 0;
            }
            if (this.prob[1] <= this.sig2) {
                return 1;
            }
            if (this.prob[0] <= this.sig1) {
                return 3;
            }
        }
        return 3;
    }

    @Override
    public boolean tetradScore1(int v1, int v2, int v3, int v4) {
        if (this.oneFactorTest(v1, v2, v3, v4)) {
            return false;
        }
        return this.twoFactorTest(v1, v2, v3, v4);
    }

    @Override
    public boolean tetradScore3(int v1, int v2, int v3, int v4) {
        return this.oneFactorTest(v1, v2, v3, v4);
    }

    @Override
    public double tetradPValue(int v1, int v2, int v3, int v4) {
        this.twoFactorTest(v1, v2, v3, v4);
        return this.tempProb;
    }

    @Override
    public boolean tetradHolds(int i, int j, int k, int l) {
        this.twoFactorTest(i, l, j, k);
        this.prob[0] = this.tempProb;
        this.bvalues[0] = this.prob[0] >= this.sig;
        return this.bvalues[0];
    }

    private void computeCounts(int[][][][] counts, DataSet data) {
        int q;
        int k;
        int j;
        int i;
        int numRows = this.dataSet.getNumRows();
        int numColumns = this.dataSet.getNumColumns();
        for (i = 0; i < numColumns; ++i) {
            for (j = i; j < numColumns; ++j) {
                counts[i][j] = new int[this.values[i].length][this.values[j].length];
                counts[j][i] = new int[this.values[j].length][this.values[i].length];
                for (k = 0; k < this.values[i].length; ++k) {
                    for (q = 0; q < this.values[j].length; ++q) {
                        counts[j][i][q][k] = 0;
                        counts[i][j][k][q] = 0;
                    }
                }
            }
        }
        for (int r = 0; r < numRows; ++r) {
            for (int i2 = 0; i2 < numColumns; ++i2) {
                for (int j2 = i2; j2 < numColumns; ++j2) {
                    int[] nArray = counts[i2][j2][this.getValuePosition(data.getInt(r, i2), i2)];
                    int n = this.getValuePosition(data.getInt(r, j2), j2);
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        for (i = 0; i < numColumns - 1; ++i) {
            for (j = i + 1; j < numColumns; ++j) {
                for (k = 0; k < this.values[i].length; ++k) {
                    for (q = 0; q < this.values[j].length; ++q) {
                        counts[j][i][q][k] = counts[i][j][k][q];
                    }
                }
            }
        }
    }

    private int getValuePosition(int value, int varNumber) {
        for (int i = 0; i < this.values[varNumber].length; ++i) {
            if (this.values[varNumber][i] != value) continue;
            return i;
        }
        assert (false);
        return -1;
    }

    private double[][] getUnderlyingCorr(int[][][][] nextCounts) {
        int i;
        int j;
        double[][] outputCorr = new double[this.dataSet.getNumColumns()][this.dataSet.getNumColumns()];
        this.currentCounts = nextCounts;
        for (int i2 = 0; i2 < this.dataSet.getNumColumns(); ++i2) {
            int c = 0;
            for (j = 0; j < this.values[i2].length - 1; ++j) {
                this.thresholds[i2][j] = ProbUtils.normalQuantile((double)(c += this.currentCounts[i2][i2][j][j]) / (double)this.dataSet.getNumRows());
            }
        }
        int[] indices = new int[2];
        for (i = 0; i < this.dataSet.getNumColumns(); ++i) {
            outputCorr[i][i] = 1.0;
            for (j = i + 1; j < this.dataSet.getNumColumns(); ++j) {
                indices[0] = i;
                indices[1] = j;
                double d = this.estimatePolychoric(indices);
                outputCorr[j][i] = d;
                outputCorr[i][j] = d;
            }
        }
        for (i = 0; i < outputCorr.length; ++i) {
            for (j = 0; j <= i; ++j) {
                System.out.print((double)((int)(100.0 * outputCorr[i][j])) / 100.0 + "\t");
            }
            System.out.println();
        }
        return outputCorr;
    }

    private double estimatePolychoric(int[] indices) {
        this.indices = indices;
        RandomUtil r = RandomUtil.getInstance();
        this.currentVar1 = indices[0];
        this.currentVar2 = indices[1];
        this.currentFiBuffer = new double[this.values[this.currentVar1].length + 1][this.values[this.currentVar2].length + 1];
        this.currentPi = new double[this.values[this.currentVar1].length][this.values[this.currentVar2].length];
        this.currentRho = r.nextDouble() / 2.0 + 0.2;
        this.currentRho = this.gridOptimizer();
        return this.currentRho;
    }

    private void computeFiBuffer() {
        for (int i = 0; i < this.values[this.currentVar1].length + 1; ++i) {
            int j;
            this.currentFiBuffer[i][0] = 0.0;
            if (i == 0) {
                for (j = 1; j < this.values[this.currentVar2].length + 1; ++j) {
                    this.currentFiBuffer[0][j] = 0.0;
                }
                continue;
            }
            if (i < this.values[this.currentVar1].length) {
                for (j = 1; j < this.values[this.currentVar2].length + 1; ++j) {
                    this.currentFiBuffer[i][j] = j < this.values[this.currentVar2].length ? ProbUtils.biNormalCdf(this.thresholds[this.currentVar1][i - 1], this.thresholds[this.currentVar2][j - 1], this.currentRho) : ProbUtils.normalCdf(this.thresholds[this.currentVar1][i - 1]);
                }
                continue;
            }
            for (j = 1; j < this.values[this.currentVar2].length + 1; ++j) {
                this.currentFiBuffer[i][j] = j < this.values[this.currentVar2].length ? ProbUtils.normalCdf(this.thresholds[this.currentVar2][j - 1]) : 1.0;
            }
        }
    }

    double currentScoreFunction() {
        double score = 0.0;
        for (int i = 0; i < this.values[this.currentVar1].length; ++i) {
            for (int j = 0; j < this.values[this.currentVar2].length; ++j) {
                score -= (double)this.currentCounts[this.currentVar1][this.currentVar2][i][j] * FastMath.log(this.currentPi[i][j]);
            }
        }
        return score;
    }

    private void computeCurrentPi() {
        for (int i = 0; i < this.values[this.currentVar1].length; ++i) {
            for (int j = 0; j < this.values[this.currentVar2].length; ++j) {
                this.currentPi[i][j] = this.currentFiBuffer[i + 1][j + 1] - this.currentFiBuffer[i][j + 1] - this.currentFiBuffer[i + 1][j] + this.currentFiBuffer[i][j];
            }
        }
    }

    private double gridOptimizer() {
        double minValue = Double.MAX_VALUE;
        double bestRho = -1.0;
        double[] dArray = this.rhoGrid;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double v;
            this.currentRho = v = dArray[i];
            this.computeFiBuffer();
            this.computeCurrentPi();
            double score = this.currentScoreFunction();
            if (!(score < minValue)) continue;
            minValue = score;
            bestRho = this.currentRho;
        }
        return bestRho;
    }

    @Override
    public boolean oneFactorTest(int i, int j, int k, int l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean oneFactorTest(int i, int j, int k, int l, int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean twoFactorTest(int i, int j, int k, int l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean twoFactorTest(int i, int j, int k, int l, int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean twoFactorTest(int i, int j, int k, int l, int x, int y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICovarianceMatrix getCovMatrix() {
        return null;
    }
}

