/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.utils;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.utils.DagSepsets;
import edu.cmu.tetrad.search.utils.FciOrient;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class TsDagToPag {
    private final Graph dag;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Knowledge knowledge = new Knowledge();
    private boolean completeRuleSetUsed = true;
    private boolean verbose;
    private int maxPathLength = -1;
    private Graph truePag;
    private boolean doDiscriminatingPathRule = false;

    public TsDagToPag(Graph dag) {
        String tmp;
        int lag;
        String varName;
        this.dag = dag;
        int numLags = 1;
        List<Node> variables = dag.getNodes();
        ArrayList<Integer> laglist = new ArrayList<Integer>();
        Knowledge knowledge = new Knowledge();
        for (Node node : variables) {
            varName = node.getName();
            if (varName.indexOf(58) == -1) {
                lag = 0;
            } else {
                tmp = varName.substring(varName.indexOf(58) + 1);
                lag = Integer.parseInt(tmp);
            }
            laglist.add(lag);
        }
        numLags = (Integer)Collections.max(laglist);
        for (Node node : variables) {
            varName = node.getName();
            if (varName.indexOf(58) == -1) {
                lag = 0;
            } else {
                tmp = varName.substring(varName.indexOf(58) + 1);
                lag = Integer.parseInt(tmp);
            }
            laglist.add(lag);
            knowledge.addToTier(numLags - lag, node.getName());
        }
        this.setKnowledge(knowledge);
    }

    public static boolean existsInducingPathInto(Node x, Node y, Graph graph, Knowledge knowledge) {
        if (x.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        if (y.getNodeType() != NodeType.MEASURED) {
            throw new IllegalArgumentException();
        }
        LinkedList<Node> path = new LinkedList<Node>();
        path.add(x);
        for (Node b : graph.getAdjacentNodes(x)) {
            Edge edge = graph.getEdge(x, b);
            if (!edge.pointsTowards(x) || !TsDagToPag.existsInducingPathVisitts(graph, x, b, x, y, path, knowledge)) continue;
            return true;
        }
        return false;
    }

    public static boolean existsInducingPathVisitts(Graph graph, Node a, Node b, Node x, Node y, LinkedList<Node> path, Knowledge knowledge) {
        if (path.contains(b)) {
            return false;
        }
        path.addLast(b);
        if (b == y) {
            return true;
        }
        for (Node c : graph.getAdjacentNodes(b)) {
            if (c == a || b.getNodeType() == NodeType.MEASURED && !graph.isDefCollider(a, b, c) || graph.isDefCollider(a, b, c) && (!graph.paths().isAncestorOf(b, x) || knowledge.isForbidden(b.getName(), x.getName())) && (!graph.paths().isAncestorOf(b, y) || knowledge.isForbidden(b.getName(), x.getName())) || !TsDagToPag.existsInducingPathVisitts(graph, b, c, x, y, path, knowledge)) continue;
            return true;
        }
        path.removeLast();
        return false;
    }

    public Graph convert() {
        this.logger.log("info", "Starting DAG to PAG_of_the_true_DAG.");
        if (this.verbose) {
            System.out.println("DAG to PAG_of_the_true_DAG: Starting adjacency search");
        }
        Graph graph = this.calcAdjacencyGraph();
        if (this.verbose) {
            System.out.println("DAG to PAG_of_the_true_DAG: Starting collider orientation");
        }
        this.orientUnshieldedColliders(graph, this.dag);
        if (this.verbose) {
            System.out.println("DAG to PAG_of_the_true_DAG: Starting final orientation");
        }
        FciOrient fciOrient = new FciOrient(new DagSepsets(this.dag));
        System.out.println("Complete rule set is used? " + this.completeRuleSetUsed);
        fciOrient.setCompleteRuleSetUsed(this.completeRuleSetUsed);
        fciOrient.setDoDiscriminatingPathColliderRule(this.doDiscriminatingPathRule);
        fciOrient.setDoDiscriminatingPathTailRule(this.doDiscriminatingPathRule);
        fciOrient.setChangeFlag(false);
        fciOrient.setMaxPathLength(this.maxPathLength);
        fciOrient.setKnowledge(this.knowledge);
        fciOrient.ruleR0(graph);
        fciOrient.doFinalOrientation(graph);
        if (this.verbose) {
            System.out.println("Finishing final orientation");
        }
        return graph;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int maxPathLength) {
        this.maxPathLength = maxPathLength;
    }

    public Graph getTruePag() {
        return this.truePag;
    }

    public void setTruePag(Graph truePag) {
        this.truePag = truePag;
    }

    public void setDoDiscriminatingPathRule(boolean doDiscriminatingPathRule) {
        this.doDiscriminatingPathRule = doDiscriminatingPathRule;
    }

    private Graph calcAdjacencyGraph() {
        List<Node> allNodes = this.dag.getNodes();
        ArrayList<Node> measured = new ArrayList<Node>();
        for (Node node : allNodes) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            measured.add(node);
        }
        EdgeListGraph graph = new EdgeListGraph(measured);
        for (int i = 0; i < measured.size(); ++i) {
            for (int j = i + 1; j < measured.size(); ++j) {
                boolean exists;
                Node n1 = (Node)measured.get(i);
                Node n2 = (Node)measured.get(j);
                List<Node> inducingPath = this.dag.paths().getInducingPath(n1, n2);
                boolean bl = exists = inducingPath != null;
                if (!exists) continue;
                graph.addEdge(Edges.nondirectedEdge(n1, n2));
            }
        }
        return graph;
    }

    private void orientUnshieldedColliders(Graph graph, Graph dag) {
        graph.reorientAllWith(Endpoint.CIRCLE);
        List<Node> allNodes = dag.getNodes();
        ArrayList<Node> measured = new ArrayList<Node>();
        for (Node node : allNodes) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            measured.add(node);
        }
        for (Node b : measured) {
            ArrayList<Node> adjb = new ArrayList<Node>(graph.getAdjacentNodes(b));
            if (adjb.size() < 2) continue;
            for (int i = 0; i < adjb.size(); ++i) {
                for (int j = i + 1; j < adjb.size(); ++j) {
                    boolean found;
                    Node c;
                    Node a = (Node)adjb.get(i);
                    if (graph.isDefCollider(a, b, c = (Node)adjb.get(j)) || graph.isAdjacentTo(a, c) || !(found = this.foundCollider(dag, a, b, c))) continue;
                    if (this.verbose) {
                        System.out.println("Orienting collider " + a + "*->" + b + "<-*" + c);
                    }
                    graph.setEndpoint(a, b, Endpoint.ARROW);
                    graph.setEndpoint(c, b, Endpoint.ARROW);
                }
            }
        }
    }

    private boolean foundCollider(Graph dag, Node a, Node b, Node c) {
        boolean ipba = TsDagToPag.existsInducingPathInto(b, a, dag, this.knowledge);
        boolean ipbc = TsDagToPag.existsInducingPathInto(b, c, dag, this.knowledge);
        if (!ipba || !ipbc) {
            this.printTrueDefCollider(a, b, c, false);
            return false;
        }
        this.printTrueDefCollider(a, b, c, true);
        return true;
    }

    private void printTrueDefCollider(Node a, Node b, Node c, boolean found) {
        if (this.truePag != null) {
            boolean defCollider = this.truePag.isDefCollider(a, b, c);
            if (this.verbose) {
                if (!found && defCollider) {
                    System.out.println("FOUND COLLIDER FCI");
                } else if (found && !defCollider) {
                    System.out.println("DIDN'T FIND COLLIDER FCI");
                }
            }
        }
    }
}

