/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.utils.BpcTestType;
import edu.cmu.tetrad.search.utils.PurifyTetradBased;
import edu.cmu.tetrad.search.utils.TetradTest;
import edu.cmu.tetrad.search.utils.TetradTestContinuous;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BpcTetradPurifyWashdown {
    private final List<Node> variables;
    private final TetradTest test;

    public BpcTetradPurifyWashdown(ICovarianceMatrix cov, BpcTestType testType, double alpha) {
        this.variables = cov.getVariables();
        this.test = new TetradTestContinuous(cov, testType, alpha);
    }

    public BpcTetradPurifyWashdown(DataSet dataSet, BpcTestType testType, double alpha) {
        this.variables = dataSet.getVariables();
        this.test = new TetradTestContinuous(dataSet, testType, alpha);
    }

    public Graph search() {
        List<Node> _disgards;
        List<Node> disgards;
        PurifyTetradBased purify = new PurifyTetradBased(this.test);
        ArrayList<Node> variables = new ArrayList<Node>(this.variables);
        List<List<Node>> clustering = new ArrayList<List<Node>>();
        do {
            _disgards = this.calculateDisgards(clustering, variables);
            clustering.add(_disgards);
        } while (!new HashSet<Node>(disgards = this.calculateDisgards(clustering = purify.purify(clustering), variables)).equals(new HashSet<Node>(_disgards)));
        EdgeListGraph graph = new EdgeListGraph();
        clustering.removeIf(cluster -> cluster.size() < 3);
        for (int i = 0; i < clustering.size(); ++i) {
            List<Node> cluster2 = clustering.get(i);
            GraphNode latent = new GraphNode("_L" + (i + 1));
            latent.setNodeType(NodeType.LATENT);
            graph.addNode(latent);
            for (Node node : cluster2) {
                graph.addNode(node);
                graph.addDirectedEdge(latent, node);
            }
        }
        return graph;
    }

    private List<Node> calculateDisgards(List<List<Node>> clustering, List<Node> variables) {
        ArrayList<Node> disgards = new ArrayList<Node>();
        block0: for (Node node : variables) {
            for (List<Node> cluster : clustering) {
                if (!cluster.contains(node)) continue;
                continue block0;
            }
            disgards.add(node);
        }
        return disgards;
    }
}

