/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.utils.ResolveSepsets;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.search.work_in_progress.FasDci;
import edu.cmu.tetrad.search.work_in_progress.IndTestSepsetDci;
import edu.cmu.tetrad.search.work_in_progress.SepsetMapDci;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.math3.util.FastMath;

public class Dci {
    private final Set<Graph> output = new HashSet<Graph>();
    private final List<IndependenceTest> independenceTests = new ArrayList<IndependenceTest>();
    private final List<Node> variables = new ArrayList<Node>();
    private final List<Set<Node>> marginalVars = new ArrayList<Set<Node>>();
    private final Set<Triple> definiteNoncolliders = new HashSet<Triple>();
    private final Set<Triple> definiteColliders = new HashSet<Triple>();
    private final List<Graph> discrimGraphs = new ArrayList<Graph>();
    private final List<Graph> currentDiscrimGraphs = new ArrayList<Graph>();
    private final List<Graph> finalGraphs = new ArrayList<Graph>();
    private final List<Map<Set<Edge>, Map<Triple, List<Set<Edge>>>>> currentNecessaryTreks = new ArrayList<Map<Set<Edge>, Map<Triple, List<Set<Edge>>>>>();
    private final Set<Triple> currentPossibleColliders = new HashSet<Triple>();
    private final Lock lock = new ReentrantLock();
    private List<SepsetMapDci> sepsetMaps = new ArrayList<SepsetMapDci>();
    private List<SepsetMapDci> minimalSepsetMaps;
    private int depth = 3;
    private Set<Triple> allTriples;
    private boolean changeFlag = true;
    private Map<List<Node>, Map<Set<Edge>, Map<Triple, List<Set<Edge>>>>> necessaryTreks;
    private Graph currentGraph;
    private Graph oldGraph;
    private List<NodePair> currentNodePairs;
    private Set<Node> currentMarginalSet;
    private ResolveSepsets.Method method;
    private int totalThreads;
    private int currentThread;
    private Map<Integer, Map<List<Node>, Set<Node>>> allPaths;
    private long elapsedTime;
    private double maxMemory;

    public Dci(List<IndependenceTest> tests) {
        HashSet<Node> variables = new HashSet<Node>();
        for (IndependenceTest test : tests) {
            if (test == null) {
                throw new NullPointerException();
            }
            this.independenceTests.add(test);
            this.marginalVars.add(new HashSet<Node>(test.getVariables()));
            variables.addAll(test.getVariables());
        }
        this.variables.addAll(variables);
    }

    public Dci(List<IndependenceTest> tests, ResolveSepsets.Method method) {
        HashSet<Node> variables = new HashSet<Node>();
        for (IndependenceTest test : tests) {
            if (test == null) {
                throw new NullPointerException();
            }
            this.independenceTests.add(test);
            this.marginalVars.add(new HashSet<Node>(test.getVariables()));
            variables.addAll(test.getVariables());
        }
        this.variables.addAll(variables);
        System.out.println("Variables: " + variables);
        this.method = method;
    }

    private static Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> pathsEnsuringTrek(Graph graph, List<Node> ensureTrek, Set<Node> conditioning) {
        HashMap<Set<Edge>, Map<Triple, List<Set<Edge>>>> paths = new HashMap<Set<Edge>, Map<Triple, List<Set<Edge>>>>();
        Dci.pathsEnsuringTrek(graph, ensureTrek, 1, new LinkedList<Node>(Collections.singletonList(ensureTrek.get(0))), conditioning, new HashMap<Triple, NodePair>(), paths, new HashSet<Node>(Collections.singletonList(ensureTrek.get(0))));
        return paths;
    }

    private static void pathsEnsuringTrek(Graph graph, List<Node> ensureTrek, int index, LinkedList<Node> path, Set<Node> conditioning, Map<Triple, NodePair> colliders, Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> paths, Set<Node> visited) {
        if (index == ensureTrek.size()) {
            HashMap newColliders = new HashMap();
            for (Triple triple : colliders.keySet()) {
                ArrayList edgeSet = new ArrayList();
                ArrayList<List<Node>> treks = new ArrayList<List<Node>>();
                treks.addAll(graph.paths().treks(triple.getY(), colliders.get(triple).getFirst(), -1));
                treks.addAll(graph.paths().treks(triple.getY(), colliders.get(triple).getSecond(), -1));
                for (List list : treks) {
                    HashSet<Edge> edges = new HashSet<Edge>();
                    boolean okay = true;
                    for (int k = 0; k < list.size() - 1; ++k) {
                        if (graph.getEndpoint((Node)list.get(k + 1), (Node)list.get(k)).equals(Endpoint.ARROW)) {
                            okay = false;
                            break;
                        }
                        edges.add(graph.getEdge((Node)list.get(k + 1), (Node)list.get(k)));
                    }
                    if (!okay) continue;
                    edgeSet.add(edges);
                }
                if (edgeSet.isEmpty()) {
                    return;
                }
                newColliders.put(triple, edgeSet);
            }
            HashSet<Edge> edges = new HashSet<Edge>();
            for (int k = 0; k < path.size() - 1; ++k) {
                edges.add(graph.getEdge(path.get(k), path.get(k + 1)));
            }
            paths.put(edges, newColliders);
            return;
        }
        Node node1 = path.getLast();
        Node node2 = ensureTrek.get(index);
        for (Edge edge : graph.getEdges(node1)) {
            Set<Node> currentVisited;
            Node node0;
            Node next = Edges.traverse(node1, edge);
            if (next == null || path.size() > 1 && !next.equals(node0 = path.get(path.size() - 2)) && graph.isDefCollider(node0, node1, next) && !conditioning.contains(node1) || visited.contains(next)) continue;
            path.add(next);
            visited.add(next);
            if (conditioning.contains(node1)) {
                node0 = path.get(path.size() - 3);
                if (graph.getEndpoint(node0, node1).equals(Endpoint.TAIL) || graph.getEndpoint(next, node1).equals(Endpoint.TAIL)) {
                    path.removeLast();
                    visited.remove(next);
                    continue;
                }
                if (!graph.paths().possibleAncestor(next, node2)) {
                    path.removeLast();
                    visited.remove(next);
                    continue;
                }
                colliders.put(new Triple(node0, node1, next), new NodePair(node2, ensureTrek.get(index - 1)));
            }
            if (next.equals(node2)) {
                ++index;
                currentVisited = new HashSet<Node>();
                currentVisited.add(node2);
            } else {
                currentVisited = visited;
            }
            Dci.pathsEnsuringTrek(graph, ensureTrek, index, path, conditioning, colliders, paths, currentVisited);
            path.removeLast();
            if (next == node2) {
                --index;
            }
            visited.remove(next);
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            for (Triple triple : colliders.keySet()) {
                if (!triple.getY().equals(node1)) continue;
                arrayList.add(triple);
            }
            for (Triple triple : arrayList) {
                colliders.remove(triple);
            }
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public List<SepsetMapDci> getSepset() {
        return this.sepsetMaps;
    }

    public List<Graph> search() {
        this.elapsedTime = MillisecondTimes.timeMillis();
        EdgeListGraph graph = new EdgeListGraph(this.variables);
        graph.fullyConnect(Endpoint.CIRCLE);
        System.out.println("Finding sepsets...");
        this.findSepsets(this.independenceTests);
        double currentUsage = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (currentUsage > this.maxMemory) {
            this.maxMemory = currentUsage;
        }
        if (this.method != null) {
            System.out.println("Resolving conflicting independence/dependence constraints");
            this.resolveResultingIndependenciesC();
        }
        this.removeNonadjacencies(graph, this.sepsetMaps);
        System.out.println("Removed edges");
        this.orientColliders(graph);
        System.out.println("Oriented ColliderDiscovery");
        this.propagateInitialOrientations(graph);
        System.out.println("Propagated initial orientations");
        System.out.println(graph);
        this.getTriplesDefiniteColliders(graph);
        this.ensureMinimalSpanningTreks(graph);
        System.out.println("Found ways of ensuring minimal spanning treks");
        System.out.println("Paths ensuring Treks: \n" + this.necessaryTreks);
        Map<Set<Edge>, Set<Map<Triple, List<Set<Edge>>>>> possibleSkeletons = this.findPossibleSkeletons(graph);
        currentUsage = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (currentUsage > this.maxMemory) {
            this.maxMemory = currentUsage;
        }
        Iterator<Set<Edge>> itr = possibleSkeletons.keySet().iterator();
        while (itr.hasNext()) {
            Set<Edge> edgesToRemove = itr.next();
            Set<Map<Triple, List<Set<Edge>>>> colliderSets = possibleSkeletons.get(edgesToRemove);
            EdgeListGraph newGraph = new EdgeListGraph((Graph)graph);
            newGraph.removeEdges(new ArrayList<Edge>(edgesToRemove));
            this.oldGraph = newGraph;
            if (colliderSets.isEmpty()) {
                this.allColliderCombinations(newGraph, edgesToRemove, new HashSet<Triple>(), possibleSkeletons.size());
            } else {
                for (Map<Triple, List<Set<Edge>>> colliderSet : colliderSets) {
                    for (Graph newNewGraph : this.generateSkeletons(newGraph, colliderSet)) {
                        this.allColliderCombinations(newNewGraph, edgesToRemove, colliderSet.keySet(), possibleSkeletons.size());
                    }
                }
            }
            System.out.println("Current Size: " + this.output.size());
            currentUsage = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            if (currentUsage > this.maxMemory) {
                this.maxMemory = currentUsage;
            }
            itr.remove();
        }
        this.elapsedTime = MillisecondTimes.timeMillis() - this.elapsedTime;
        System.out.println(this.output.size());
        return new ArrayList<Graph>(this.output);
    }

    private void findSepsets(List<IndependenceTest> independenceTests) {
        for (int k = 0; k < this.marginalVars.size(); ++k) {
            IndependenceTest independenceTest = independenceTests.get(k);
            EdgeListGraph marginalGraph = new EdgeListGraph(new ArrayList<Node>((Collection)this.marginalVars.get(k)));
            marginalGraph.fullyConnect(Endpoint.CIRCLE);
            FasDci adj = this.method != null ? new FasDci(marginalGraph, independenceTest, this.method, this.marginalVars, independenceTests, null, null) : new FasDci(marginalGraph, independenceTest);
            adj.setDepth(this.depth);
            this.sepsetMaps.add(adj.search());
        }
        this.minimalSepsetMaps = this.method == null ? this.sepsetMaps : new ArrayList<SepsetMapDci>();
    }

    private void removeNonadjacencies(Graph graph, List<SepsetMapDci> sepsetMaps) {
        int[] combination;
        List<Node> nodes = graph.getNodes();
        ChoiceGenerator cg = new ChoiceGenerator(nodes.size(), 2);
        block0: while ((combination = cg.next()) != null) {
            Node x = graph.getNode(nodes.get(combination[0]).getName());
            Node y = graph.getNode(nodes.get(combination[1]).getName());
            for (SepsetMapDci sepset : sepsetMaps) {
                if (sepset.get(x, y) == null || !graph.isAdjacentTo(x, y)) continue;
                graph.removeEdge(x, y);
                continue block0;
            }
        }
    }

    private void orientColliders(Graph graph) {
        for (int k = 0; k < this.marginalVars.size(); ++k) {
            Set<Node> marginalSet = this.marginalVars.get(k);
            SepsetMapDci sepset = this.sepsetMaps.get(k);
            for (Node b : marginalSet) {
                int[] combination;
                ArrayList<Node> adjacentNodes = new ArrayList<Node>();
                for (Node node : graph.getAdjacentNodes(graph.getNode(b.getName()))) {
                    if (!marginalSet.contains(node)) continue;
                    adjacentNodes.add(node);
                }
                if (adjacentNodes.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node c;
                    Node a = (Node)adjacentNodes.get(combination[0]);
                    if (sepset.get(a, c = (Node)adjacentNodes.get(combination[1])) == null) continue;
                    if (!sepset.get(a, c).contains(b)) {
                        if (!this.isArrowheadAllowed(graph, a, b) || !this.isArrowheadAllowed(graph, c, b)) continue;
                        System.out.println("Check here " + k + "\n " + sepset.get(a, c) + "\n" + graph + "\n" + b);
                        graph.setEndpoint(a, graph.getNode(b.getName()), Endpoint.ARROW);
                        graph.setEndpoint(c, graph.getNode(b.getName()), Endpoint.ARROW);
                        continue;
                    }
                    this.definiteNoncolliders.add(new Triple(a, b, c));
                }
            }
        }
    }

    private void propagateInitialOrientations(Graph graph) {
        while (this.changeFlag) {
            this.changeFlag = false;
            this.initialDoubleTriangle(graph);
            this.initialAwayFromColliderAncestorCycle(graph);
            this.initialDiscrimPaths(graph);
        }
        this.changeFlag = true;
    }

    private void initialDoubleTriangle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = graph.getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = graph.getNodesInTo(B, Endpoint.CIRCLE);
            LinkedList<Node> possA = new LinkedList<Node>(intoBArrows);
            LinkedList<Node> possC = new LinkedList<Node>(intoBArrows);
            for (Node D : intoBCircles) {
                for (Node A : possA) {
                    for (Node C : possC) {
                        if (C == A || !graph.isAdjacentTo(A, D) || !graph.isAdjacentTo(C, D) || graph.isDefCollider(A, D, C)) continue;
                        boolean checkABC = false;
                        boolean checkADC = false;
                        for (Set<Node> marginalSet : this.marginalVars) {
                            if (marginalSet.contains(A) && marginalSet.contains(B) && marginalSet.contains(C)) {
                                checkABC = true;
                            }
                            if (!marginalSet.contains(A) || !marginalSet.contains(D) || !marginalSet.contains(C)) continue;
                            checkABC = true;
                        }
                    }
                }
            }
        }
    }

    private boolean isArrowheadAllowed(Graph graph, Node x, Node y) {
        if (graph.getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (graph.getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (graph.getEndpoint(y, x) == Endpoint.ARROW) {
            graph.getEndpoint(x, y);
        }
        return true;
    }

    private void initialAwayFromColliderAncestorCycle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(B));
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = (Node)adj.get(combination[0]);
                Node C = (Node)adj.get(combination[1]);
                boolean checkABC = false;
                for (Set<Node> marginalSet : this.marginalVars) {
                    if (!marginalSet.contains(A) || !marginalSet.contains(B) || !marginalSet.contains(C)) continue;
                    checkABC = true;
                    break;
                }
                if (checkABC) {
                    this.awayFromCollider(graph, A, B, C);
                    this.awayFromCollider(graph, C, B, A);
                }
                this.awayFromAncestor(graph, A, B, C);
                this.awayFromAncestor(graph, C, B, A);
                this.awayFromCycle(graph, A, B, C);
                this.awayFromCycle(graph, C, B, A);
            }
        }
    }

    private void awayFromCollider(Graph graph, Node a, Node b, Node c) {
        Endpoint BC = graph.getEndpoint(b, c);
        Endpoint CB = graph.getEndpoint(c, b);
        if (!graph.isAdjacentTo(a, c) && graph.getEndpoint(a, b) == Endpoint.ARROW) {
            if ((CB == Endpoint.CIRCLE || CB == Endpoint.TAIL) && BC == Endpoint.CIRCLE) {
                if (!this.isArrowheadAllowed(graph, b, c)) {
                    return;
                }
                graph.setEndpoint(b, c, Endpoint.ARROW);
                this.changeFlag = true;
            }
            if ((BC == Endpoint.CIRCLE || BC == Endpoint.ARROW) && CB == Endpoint.CIRCLE) {
                graph.setEndpoint(c, b, Endpoint.TAIL);
                this.changeFlag = true;
            }
        }
    }

    private void awayFromAncestor(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.CIRCLE && graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(b, c) == Endpoint.ARROW && (graph.getEndpoint(b, a) == Endpoint.TAIL || graph.getEndpoint(c, b) == Endpoint.TAIL)) {
            if (!this.isArrowheadAllowed(graph, a, c)) {
                return;
            }
            graph.setEndpoint(a, c, Endpoint.ARROW);
            this.changeFlag = true;
        }
    }

    private void awayFromCycle(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.ARROW && graph.getEndpoint(c, a) == Endpoint.CIRCLE && graph.paths().isDirectedFromTo(a, b) && graph.paths().isDirectedFromTo(b, c)) {
            graph.setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
        }
    }

    private void initialDiscrimPaths(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possAandC = graph.getNodesOutTo(b, Endpoint.ARROW);
            LinkedList<Node> possA = new LinkedList<Node>(possAandC);
            possA.removeAll(graph.getNodesInTo(b, Endpoint.TAIL));
            LinkedList<Node> possC = new LinkedList<Node>(possAandC);
            possC.retainAll(graph.getNodesInTo(b, Endpoint.CIRCLE));
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isParentOf(a, c)) continue;
                    boolean checkABC = false;
                    for (Set<Node> marginalSet : this.marginalVars) {
                        if (!marginalSet.contains(a) || !marginalSet.contains(b) || !marginalSet.contains(c)) continue;
                        checkABC = true;
                        break;
                    }
                    if (!checkABC) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    this.reachablePathFind(graph, a, b, c, reachable);
                }
            }
        }
    }

    private void reachablePathFind(Graph graph, Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node l : pathExtensions) {
                boolean checkABCL = false;
                for (Set<Node> marginalSet : this.marginalVars) {
                    if (!marginalSet.contains(a) || !marginalSet.contains(b) || !marginalSet.contains(c) || !marginalSet.contains(l)) continue;
                    checkABCL = true;
                    break;
                }
                if (!checkABCL) continue;
                if (!graph.isAdjacentTo(l, c)) {
                    this.doDdpOrientation(graph, l, a, b, c);
                    return;
                }
                if (!cParents.contains(l) || graph.getEndpoint(x, l) != Endpoint.ARROW) continue;
                reachable.add(l);
            }
        }
    }

    private void doDdpOrientation(Graph graph, Node l, Node a, Node b, Node c) {
        HashSet<Node> sepset = new HashSet<Node>();
        for (SepsetMapDci msepset : this.sepsetMaps) {
            Set<Node> condSet = msepset.get(l, c);
            if (condSet == null) continue;
            sepset.addAll(condSet);
        }
        if (sepset.contains(b)) {
            graph.setEndpoint(c, b, Endpoint.TAIL);
        } else {
            if (!this.isArrowheadAllowed(graph, a, b)) {
                return;
            }
            if (!this.isArrowheadAllowed(graph, c, b)) {
                return;
            }
            graph.setEndpoint(a, b, Endpoint.ARROW);
            graph.setEndpoint(c, b, Endpoint.ARROW);
        }
        this.changeFlag = true;
    }

    private Map<List<Node>, Set<Node>> minimalSpanningTreks(Graph graph, Set<Node> marginalNodes) {
        System.out.println("minspan\n" + graph + "\n" + marginalNodes);
        int size = marginalNodes.size();
        System.out.println("Graph now\n" + graph);
        this.currentGraph = graph;
        this.currentMarginalSet = marginalNodes;
        this.allPaths = Collections.synchronizedMap(new HashMap());
        for (int k = 2; k <= size; ++k) {
            this.allPaths.put(k, new HashMap());
        }
        this.currentNodePairs = this.allNodePairs(new ArrayList<Node>(marginalNodes));
        this.totalThreads = this.currentNodePairs.size();
        ArrayList<FindMinimalSpanningTrek> threads = new ArrayList<FindMinimalSpanningTrek>();
        int maxThreads = 1;
        for (int k = 0; k < maxThreads; ++k) {
            threads.add(new FindMinimalSpanningTrek());
        }
        for (FindMinimalSpanningTrek thread : threads) {
            if (!thread.thisThread.isAlive()) continue;
            try {
                thread.thisThread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.currentThread = 0;
        System.out.println("allpaths \n" + this.allPaths);
        HashMap<List<Node>, Set<Node>> minimalSpanningTreks = new HashMap<List<Node>, Set<Node>>();
        for (int k = 2; k < size; ++k) {
            Map<List<Node>, Set<Node>> smaller = this.allPaths.get(k);
            Map<List<Node>, Set<Node>> larger = this.allPaths.get(k + 1);
            for (List<Node> subpath : smaller.keySet()) {
                boolean isSubpath = false;
                for (List<Node> path : larger.keySet()) {
                    if (!this.isSubpath(path, subpath)) continue;
                    isSubpath = true;
                    break;
                }
                if (isSubpath) continue;
                minimalSpanningTreks.put(subpath, smaller.get(subpath));
            }
            if (larger.isEmpty()) break;
            if (k != size - 1) continue;
            minimalSpanningTreks.putAll(larger);
        }
        if (size == 2) {
            minimalSpanningTreks.putAll(this.allPaths.get(2));
        }
        System.out.println("Found minimal spanning treks");
        System.out.println(minimalSpanningTreks);
        return minimalSpanningTreks;
    }

    private int nextThread() {
        this.lock.lock();
        ++this.currentThread;
        this.lock.unlock();
        return this.currentThread;
    }

    public boolean isSubtrek(List<Node> trek, List<Node> subtrek) {
        int l = 0;
        for (Node node : subtrek) {
            while (!node.equals(trek.get(l))) {
                if (++l < trek.size()) continue;
                return false;
            }
            if (l >= trek.size()) {
                return false;
            }
            ++l;
        }
        return true;
    }

    private boolean isSubpath(List<Node> path, List<Node> subpath) {
        boolean isSubpath = false;
        int subpathLast = subpath.size() - 1;
        for (int k = 0; k < path.size() - subpathLast; ++k) {
            int m;
            if (path.get(k).equals(subpath.get(0))) {
                isSubpath = true;
                for (m = 1; m < subpath.size(); ++m) {
                    if (path.get(k + m).equals(subpath.get(m))) continue;
                    isSubpath = false;
                    break;
                }
                if (isSubpath) break;
            }
            if (!path.get(k).equals(subpath.get(subpathLast))) continue;
            isSubpath = true;
            for (m = subpathLast - 1; m >= 0; --m) {
                if (path.get(k + subpathLast - m).equals(subpath.get(m))) continue;
                isSubpath = false;
                break;
            }
            if (isSubpath) break;
        }
        return isSubpath;
    }

    private Set<Triple> getAllTriples(Graph graph) {
        HashSet<Triple> triples = new HashSet<Triple>();
        for (Node node : graph.getNodes()) {
            ArrayList<Node> adjNodes = new ArrayList<Node>(graph.getAdjacentNodes(node));
            for (int i = 0; i < adjNodes.size() - 1; ++i) {
                for (int j = i + 1; j < adjNodes.size(); ++j) {
                    triples.add(new Triple((Node)adjNodes.get(i), node, (Node)adjNodes.get(j)));
                }
            }
        }
        return triples;
    }

    private void getTriplesDefiniteColliders(Graph graph) {
        this.allTriples = this.getAllTriples(graph);
        for (Triple triple : this.allTriples) {
            if (!graph.isDefCollider(triple.getX(), triple.getY(), triple.getZ())) continue;
            this.definiteColliders.add(triple);
        }
    }

    private void ensureMinimalSpanningTreks(Graph graph) {
        this.necessaryTreks = new HashMap<List<Node>, Map<Set<Edge>, Map<Triple, List<Set<Edge>>>>>();
        for (Set<Node> marginalSet : this.marginalVars) {
            Map<List<Node>, Set<Node>> minimalSpanningTreks = this.minimalSpanningTreks(graph, marginalSet);
            Set<List<Node>> treks = minimalSpanningTreks.keySet();
            System.out.println(treks);
            int t = 1;
            for (List<Node> trek : treks) {
                System.out.println("Finding ways to ensure minimal spanning treks... " + t + " of " + treks.size());
                this.necessaryTreks.put(trek, Dci.pathsEnsuringTrek(graph, trek, minimalSpanningTreks.get(trek)));
                ++t;
            }
        }
    }

    private List<Graph> generateSkeletons(Graph graph, Map<Triple, List<Set<Edge>>> colliderSet) {
        EdgeListGraph newGraph = new EdgeListGraph(graph);
        for (Triple triple : colliderSet.keySet()) {
            newGraph.setEndpoint(triple.getX(), triple.getY(), Endpoint.ARROW);
            newGraph.setEndpoint(triple.getZ(), triple.getY(), Endpoint.ARROW);
        }
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        graphs.add(newGraph);
        for (Triple triple : colliderSet.keySet()) {
            this.generateSkeletons(graphs, triple, colliderSet.get(triple));
        }
        return graphs;
    }

    private void generateSkeletons(List<Graph> graphs, Triple collider, List<Set<Edge>> paths) {
        ArrayList<Graph> newGraphs = new ArrayList<Graph>();
        for (Graph graph : graphs) {
            for (Set<Edge> edges : paths) {
                List<Node> path = this.getPathFromEdges(edges, collider.getY());
                EdgeListGraph newGraph = new EdgeListGraph(graph);
                for (int k = 0; k < path.size() - 1; ++k) {
                    Node node1 = path.get(k);
                    Node node2 = path.get(k + 1);
                    newGraph.setEndpoint(node1, node2, Endpoint.ARROW);
                    newGraph.setEndpoint(node2, node1, Endpoint.TAIL);
                }
                newGraphs.add(newGraph);
            }
        }
        graphs = newGraphs;
    }

    private List<Node> getPathFromEdges(Set<Edge> edges, Node start) {
        EdgeListGraph newGraph = new EdgeListGraph();
        for (Edge edge : edges) {
            newGraph.addNode(edge.getNode1());
            newGraph.addNode(edge.getNode2());
            newGraph.addEdge(edge);
        }
        ArrayList<Node> path = new ArrayList<Node>();
        path.add(start);
        Node next = start;
        Node last = start;
        Node current = start;
        for (int k = 1; k < newGraph.getNumNodes(); ++k) {
            ArrayList<Edge> adjEdges = new ArrayList<Edge>(newGraph.getEdges(current));
            next = ((Edge)adjEdges.get(0)).getDistalNode(current);
            assert (next != null);
            if (next.equals(last)) {
                next = ((Edge)adjEdges.get(1)).getDistalNode(current);
            }
            path.add(next);
            last = current;
            current = next;
        }
        return path;
    }

    private Map<Set<Edge>, Set<Map<Triple, List<Set<Edge>>>>> findPossibleSkeletons(Graph graph) {
        HashSet<Edge> allEdges = new HashSet<Edge>(graph.getEdges());
        HashSet<Edge> remove = new HashSet<Edge>();
        block0: for (Edge edge : allEdges) {
            boolean necessary = false;
            for (List<Node> necessaryTrek : this.necessaryTreks.keySet()) {
                necessary = true;
                Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> possiblePaths = this.necessaryTreks.get(necessaryTrek);
                for (Set<Edge> set : possiblePaths.keySet()) {
                    if (set.contains(edge)) continue;
                    Map<Triple, List<Set<Edge>>> tripleMap = possiblePaths.get(set);
                    if (tripleMap.isEmpty()) {
                        necessary = false;
                    }
                    for (Triple triple : tripleMap.keySet()) {
                        necessary = true;
                        for (Set<Edge> ancpath : tripleMap.get(triple)) {
                            if (ancpath.contains(edge)) continue;
                            necessary = false;
                            break;
                        }
                        if (!necessary) continue;
                        break;
                    }
                    if (necessary) continue;
                    break;
                }
                if (!necessary) continue;
                remove.add(edge);
                continue block0;
            }
        }
        allEdges.removeAll(remove);
        HashMap<Set<Edge>, Set<Map<Triple, List<Set<Edge>>>>> possibleEdges = new HashMap<Set<Edge>, Set<Map<Triple, List<Set<Edge>>>>>();
        PowerSet<Edge> pset = new PowerSet<Edge>(allEdges);
        for (Set<Edge> set : pset) {
            boolean possible = true;
            HashSet colliderSets = new HashSet();
            for (List list : this.necessaryTreks.keySet()) {
                Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> possiblePaths = this.necessaryTreks.get(list);
                boolean okay = false;
                HashSet necessaryColliders = new HashSet();
                for (Set<Edge> path : possiblePaths.keySet()) {
                    boolean pathOkay = true;
                    for (Edge edge : set) {
                        if (!path.contains(edge)) continue;
                        pathOkay = false;
                        break;
                    }
                    if (!pathOkay) continue;
                    Map<Triple, List<Set<Edge>>> colliders = possiblePaths.get(path);
                    if (colliders.isEmpty()) {
                        okay = true;
                        necessaryColliders.clear();
                        break;
                    }
                    HashMap newColliders = new HashMap();
                    for (Triple triple : colliders.keySet()) {
                        ArrayList<Set<Edge>> newEdges = new ArrayList<Set<Edge>>();
                        for (Set<Edge> edges : colliders.get(triple)) {
                            pathOkay = true;
                            for (Edge edge : set) {
                                if (!path.contains(edge)) continue;
                                pathOkay = false;
                                break;
                            }
                            if (!pathOkay) continue;
                            newEdges.add(edges);
                        }
                        if (newEdges.isEmpty()) break;
                        newColliders.put(triple, newEdges);
                    }
                    if (colliders.size() != newColliders.size()) continue;
                    okay = true;
                    necessaryColliders.add(newColliders);
                }
                if (!okay) {
                    possible = false;
                    break;
                }
                if (necessaryColliders.isEmpty()) continue;
                colliderSets.addAll(necessaryColliders);
            }
            if (!possible) continue;
            possibleEdges.put(set, colliderSets);
        }
        return possibleEdges;
    }

    private void allColliderCombinations(Graph graph, Set<Edge> removedEdges, Set<Triple> newColliders, int skeletonsLeft) {
        this.currentGraph = graph;
        for (List<Node> necessaryTrek : this.necessaryTreks.keySet()) {
            Map<Set<Edge>, Map<Triple, List<Set<Edge>>>> possiblePaths = this.necessaryTreks.get(necessaryTrek);
            HashMap newPossiblePaths = new HashMap();
            for (Set<Edge> set : possiblePaths.keySet()) {
                boolean add = true;
                for (Edge edgeRemoved : removedEdges) {
                    if (!set.contains(edgeRemoved)) continue;
                    add = false;
                    break;
                }
                if (add) {
                    for (Triple triple : newColliders) {
                        if (!set.contains(this.oldGraph.getEdge(triple.getX(), triple.getY())) || !set.contains(this.oldGraph.getEdge(triple.getZ(), triple.getY())) || possiblePaths.get(set).containsKey(triple)) continue;
                        add = false;
                        break;
                    }
                }
                if (!add) continue;
                Map<Triple, List<Set<Edge>>> colliderMap = possiblePaths.get(set);
                HashMap newColliderMap = new HashMap();
                for (Triple collider : colliderMap.keySet()) {
                    ArrayList<Set<Edge>> pathSet = new ArrayList<Set<Edge>>();
                    for (Set<Edge> edges : colliderMap.get(collider)) {
                        add = true;
                        for (Edge edgeRemoved : removedEdges) {
                            if (!set.contains(edgeRemoved)) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue;
                        pathSet.add(edges);
                    }
                    if (pathSet.isEmpty()) {
                        add = false;
                        break;
                    }
                    newColliderMap.put(collider, pathSet);
                }
                if (!add) continue;
                newPossiblePaths.put(set, newColliderMap);
            }
            this.currentNecessaryTreks.add(newPossiblePaths);
        }
        for (Triple triple : this.allTriples) {
            if (graph.isAdjacentTo(triple.getX(), triple.getZ()) || this.definiteNoncolliders.contains(triple) || graph.isDefCollider(triple.getX(), triple.getY(), triple.getZ()) || !graph.isAdjacentTo(triple.getX(), triple.getY()) || !graph.isAdjacentTo(triple.getY(), triple.getZ()) || graph.isUnderlineTriple(triple.getX(), triple.getY(), triple.getZ())) continue;
            this.currentPossibleColliders.add(triple);
        }
        HashSet<Triple> remove = new HashSet<Triple>();
        block8: for (Triple triple : this.currentPossibleColliders) {
            boolean necessary = false;
            for (Map map : this.currentNecessaryTreks) {
                necessary = true;
                boolean size1 = map.size() == 1;
                for (Set path : map.keySet()) {
                    if (path.contains(this.oldGraph.getEdge(triple.getX(), triple.getY())) && path.contains(this.oldGraph.getEdge(triple.getZ(), triple.getY())) && !((Map)map.get(path)).containsKey(triple)) continue;
                    necessary = false;
                    break;
                }
                if (!necessary && size1) {
                    for (Map tripleMap : map.values()) {
                        for (List path : tripleMap.values()) {
                            if (path.size() != 1 || !((Set)path.get(0)).contains(this.oldGraph.getEdge(triple.getX(), triple.getY())) || !((Set)path.get(0)).contains(this.oldGraph.getEdge(triple.getZ(), triple.getY()))) continue;
                            necessary = true;
                            break;
                        }
                        if (!necessary) continue;
                        break;
                    }
                }
                if (!necessary) continue;
                remove.add(triple);
                continue block8;
            }
        }
        this.currentPossibleColliders.removeAll(remove);
        this.simpleColliderIterator(skeletonsLeft);
        this.currentPossibleColliders.clear();
        this.currentNecessaryTreks.clear();
    }

    private void simpleColliderIterator(int skeletonsLeft) {
        HashSet<Set<Triple>> necessaryEdges = new HashSet<Set<Triple>>();
        PowerSet<Triple> pset = new PowerSet<Triple>(this.currentPossibleColliders);
        int psetsize = (int)FastMath.pow(2.0, this.currentPossibleColliders.size());
        for (Set<Triple> set : pset) {
            System.out.println("Searching Possible PAGs: " + psetsize + " (" + skeletonsLeft + " Skeletons Remaining)");
            --psetsize;
            boolean stop = false;
            for (Set set2 : necessaryEdges) {
                if (!set.containsAll(set2)) continue;
                stop = true;
                break;
            }
            if (stop) continue;
            if (this.checkCollider(set, necessaryEdges)) {
                EdgeListGraph newGraph = new EdgeListGraph(this.currentGraph);
                for (Triple triple : set) {
                    newGraph.setEndpoint(triple.getX(), triple.getY(), Endpoint.ARROW);
                    newGraph.setEndpoint(triple.getZ(), triple.getY(), Endpoint.ARROW);
                }
                this.doFinalOrientation(newGraph);
                for (Graph graph : this.finalGraphs) {
                    if (this.predictsFalseDependence(graph)) continue;
                    HashSet<Triple> newColliders = new HashSet<Triple>(this.allTriples);
                    newColliders.removeAll(this.definiteColliders);
                    newColliders.removeAll(set);
                    HashSet<Triple> remove = new HashSet<Triple>();
                    for (Triple triple : newColliders) {
                        if (graph.isDefCollider(triple.getX(), triple.getY(), triple.getZ())) continue;
                        remove.add(triple);
                    }
                    newColliders.removeAll(remove);
                    if (!newColliders.isEmpty()) {
                        newColliders.addAll(set);
                        if (!this.checkCollider(newColliders, necessaryEdges)) continue;
                    }
                    if (graph.paths().existsDirectedCycle()) continue;
                    graph.setUnderLineTriples(new HashSet<Triple>());
                    this.output.add(graph);
                }
                continue;
            }
            necessaryEdges.add(set);
        }
    }

    private boolean checkCollider(Set<Triple> newSet, Set<Set<Triple>> necessaryEdges) {
        boolean possible = true;
        for (Set<Triple> set : necessaryEdges) {
            if (!newSet.containsAll(set)) continue;
            possible = false;
            break;
        }
        if (possible) {
            for (Map map : this.currentNecessaryTreks) {
                boolean okay = false;
                for (Set path : map.keySet()) {
                    boolean pathOkay = true;
                    for (Triple triple : newSet) {
                        if (path.contains(this.currentGraph.getEdge(triple.getX(), triple.getY())) && path.contains(this.currentGraph.getEdge(triple.getY(), triple.getZ())) && !((Map)map.get(path)).containsKey(triple)) {
                            pathOkay = false;
                            break;
                        }
                        for (Triple collider : ((Map)map.get(path)).keySet()) {
                            if (!this.currentGraph.isDefCollider(collider.getX(), collider.getY(), collider.getZ()) && !newSet.contains(collider)) {
                                pathOkay = false;
                                break;
                            }
                            pathOkay = false;
                            for (Set adjPath : (List)((Map)map.get(path)).get(collider)) {
                                int k;
                                boolean adjPathOkay;
                                List<Node> findPath;
                                if (adjPath.contains(this.oldGraph.getEdge(triple.getX(), triple.getY())) && adjPath.contains(this.oldGraph.getEdge(triple.getZ(), triple.getY()))) continue;
                                if (adjPath.contains(this.oldGraph.getEdge(triple.getX(), triple.getY()))) {
                                    findPath = this.getPathFromEdges(adjPath, collider.getY());
                                    adjPathOkay = true;
                                    for (k = 0; k < findPath.size() - 1; ++k) {
                                        if (!findPath.get(k).equals(triple.getY()) || !findPath.get(k + 1).equals(triple.getX())) continue;
                                        adjPathOkay = false;
                                        break;
                                    }
                                    if (!adjPathOkay) continue;
                                    pathOkay = true;
                                    continue;
                                }
                                if (adjPath.contains(this.oldGraph.getEdge(triple.getZ(), triple.getY()))) {
                                    findPath = this.getPathFromEdges(adjPath, collider.getY());
                                    adjPathOkay = true;
                                    for (k = 0; k < findPath.size() - 1; ++k) {
                                        if (!findPath.get(k).equals(triple.getY()) || !findPath.get(k + 1).equals(triple.getZ())) continue;
                                        adjPathOkay = false;
                                        break;
                                    }
                                    if (!adjPathOkay) continue;
                                    pathOkay = true;
                                    continue;
                                }
                                pathOkay = true;
                            }
                            if (pathOkay) continue;
                            break;
                        }
                        if (pathOkay) continue;
                        break;
                    }
                    if (!pathOkay) continue;
                    okay = true;
                    break;
                }
                if (okay) continue;
                possible = false;
                break;
            }
        }
        return possible;
    }

    private void doFinalOrientation(Graph graph) {
        this.discrimGraphs.clear();
        this.finalGraphs.clear();
        this.currentDiscrimGraphs.add(graph);
        while (this.changeFlag) {
            this.changeFlag = false;
            this.currentDiscrimGraphs.addAll(this.discrimGraphs);
            this.discrimGraphs.clear();
            for (Graph newGraph : this.currentDiscrimGraphs) {
                this.doubleTriangle(newGraph);
                this.awayFromColliderAncestorCycle(newGraph);
                if (this.discrimPaths(newGraph)) continue;
                if (this.changeFlag) {
                    this.discrimGraphs.add(newGraph);
                    continue;
                }
                this.finalGraphs.add(newGraph);
            }
            this.currentDiscrimGraphs.clear();
        }
        this.changeFlag = true;
    }

    private void doubleTriangle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = graph.getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = graph.getNodesInTo(B, Endpoint.CIRCLE);
            LinkedList<Node> possA = new LinkedList<Node>(intoBArrows);
            LinkedList<Node> possC = new LinkedList<Node>(intoBArrows);
            for (Node D : intoBCircles) {
                for (Node A : possA) {
                    for (Node C : possC) {
                        if (C == A || !graph.isAdjacentTo(A, D) || !graph.isAdjacentTo(C, D) || graph.isDefCollider(A, D, C) || !this.isArrowheadAllowed(graph, D, B)) continue;
                        graph.setEndpoint(D, B, Endpoint.ARROW);
                        this.changeFlag = true;
                    }
                }
            }
        }
    }

    private void awayFromAncestorCycle(Graph graph) {
        while (this.changeFlag) {
            this.changeFlag = false;
            List<Node> nodes = graph.getNodes();
            for (Node B : nodes) {
                int[] combination;
                ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(B));
                if (adj.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node A = (Node)adj.get(combination[0]);
                    Node C = (Node)adj.get(combination[1]);
                    this.awayFromAncestor(graph, A, B, C);
                    this.awayFromAncestor(graph, C, B, A);
                    this.awayFromCycle(graph, A, B, C);
                    this.awayFromCycle(graph, C, B, A);
                }
            }
        }
        this.changeFlag = true;
    }

    private void awayFromColliderAncestorCycle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            ArrayList<Node> adj = new ArrayList<Node>(graph.getAdjacentNodes(B));
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = (Node)adj.get(combination[0]);
                Node C = (Node)adj.get(combination[1]);
                this.awayFromCollider(graph, A, B, C);
                this.awayFromCollider(graph, C, B, A);
                this.awayFromAncestor(graph, A, B, C);
                this.awayFromAncestor(graph, C, B, A);
                this.awayFromCycle(graph, A, B, C);
                this.awayFromCycle(graph, C, B, A);
            }
        }
    }

    private boolean discrimPaths(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possAandC = graph.getNodesOutTo(b, Endpoint.ARROW);
            LinkedList<Node> possA = new LinkedList<Node>(possAandC);
            possA.removeAll(graph.getNodesInTo(b, Endpoint.TAIL));
            LinkedList<Node> possC = new LinkedList<Node>(possAandC);
            possC.retainAll(graph.getNodesInTo(b, Endpoint.CIRCLE));
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isParentOf(a, c)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    if (!this.reachablePathFindOrient(graph, a, b, c, reachable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean reachablePathFindOrient(Graph graph, Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node l : pathExtensions) {
                if (!graph.isAdjacentTo(l, c)) {
                    this.doDdpOrientationFinal(graph, l, a, b, c);
                    return true;
                }
                if (!cParents.contains(l) || graph.getEndpoint(x, l) != Endpoint.ARROW) continue;
                reachable.add(l);
            }
        }
        return false;
    }

    private void doDdpOrientationFinal(Graph graph, Node l, Node a, Node b, Node c) {
        this.changeFlag = true;
        ArrayList<Node> sepset = new ArrayList<Node>();
        for (SepsetMapDci msepset : this.sepsetMaps) {
            Set<Node> condSet = msepset.get(l, c);
            if (condSet == null) continue;
            sepset.addAll(condSet);
        }
        EdgeListGraph newGraph1 = new EdgeListGraph(graph);
        newGraph1.setEndpoint(c, b, Endpoint.TAIL);
        this.discrimGraphs.add(newGraph1);
        if (sepset.contains(b)) {
            return;
        }
        EdgeListGraph newGraph2 = new EdgeListGraph(graph);
        if (!this.isArrowheadAllowed(graph, a, b)) {
            return;
        }
        if (!this.isArrowheadAllowed(graph, c, b)) {
            return;
        }
        newGraph2.setEndpoint(a, b, Endpoint.ARROW);
        newGraph2.setEndpoint(c, b, Endpoint.ARROW);
        this.discrimGraphs.add(newGraph2);
    }

    private boolean predictsFalseDependence(Graph graph) {
        for (int k = 0; k < this.variables.size() - 1; ++k) {
            Node x = this.variables.get(k);
            for (int m = k + 1; m < this.variables.size(); ++m) {
                Node y = this.variables.get(m);
                for (SepsetMapDci sepset : this.minimalSepsetMaps) {
                    if (sepset.get(x, y) == null) continue;
                    for (Set<Node> condSet : sepset.getSet(x, y)) {
                        if (graph.paths().isMSeparatedFrom(x, y, condSet)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void resolveResultingIndependencies() {
        int k;
        ArrayList<SepsetMapDci> allSepsets = new ArrayList<SepsetMapDci>();
        Pc fci = new Pc(new IndTestSepsetDci(this.combineSepsets(this.sepsetMaps), this.variables));
        System.out.println("Starting pc...");
        SepsetMapDci consSepset = new SepsetMapDci();
        this.doSepsetClosure(consSepset, fci.search());
        for (k = 0; k < this.marginalVars.size(); ++k) {
            SepsetMapDci newSepset = new SepsetMapDci();
            List<NodePair> pairs = this.allNodePairs(new ArrayList<Node>((Collection)this.marginalVars.get(k)));
            int p = 1;
            for (NodePair pair : pairs) {
                Node y;
                Node x = pair.getFirst();
                if (consSepset.getSet(x, y = pair.getSecond()) == null) continue;
                int c = 1;
                Set<Set<Node>> conds = consSepset.getSet(x, y);
                for (Set<Node> z : conds) {
                    System.out.println("Resolving inconsistencies... " + c + " of " + conds.size() + " (" + p + " of " + pairs.size() + " pairs and )" + (k + 1) + " of " + this.marginalVars.size() + " datasets)");
                    if (this.marginalVars.get(k).containsAll(z)) {
                        newSepset.set(x, y, z);
                    }
                    ++c;
                }
                ++p;
            }
            allSepsets.add(newSepset);
        }
        for (k = 0; k < this.marginalVars.size(); ++k) {
            ArrayList<Node> variables = new ArrayList<Node>((Collection)this.marginalVars.get(k));
            EdgeListGraph newGraph = new EdgeListGraph(variables);
            newGraph.fullyConnect(Endpoint.CIRCLE);
            FasDci fas = new FasDci(newGraph, new IndTestSepsetDci((SepsetMapDci)allSepsets.get(k), new ArrayList<Node>((Collection)this.marginalVars.get(k))));
            this.minimalSepsetMaps.add(fas.search());
        }
        this.sepsetMaps = allSepsets;
        System.out.println(this.sepsetMaps);
    }

    private void resolveResultingIndependenciesB() {
        SepsetMapDci combinedSepset = this.combineSepsets(this.sepsetMaps);
        Pc pc = new Pc(new IndTestSepsetDci(combinedSepset, this.variables));
        Graph allInd = pc.search();
        System.out.println("PC finished...");
        ArrayList overlap = new ArrayList(this.marginalVars.get(0));
        System.out.println(this.marginalVars.get(0).size());
        for (int k = 1; k < this.marginalVars.size(); ++k) {
            System.out.println("Size: " + this.marginalVars.get(k).size());
            Set<Node> marginal = this.marginalVars.get(k);
            ArrayList<Node> remove = new ArrayList<Node>();
            for (Node node : overlap) {
                if (marginal.contains(node)) continue;
                remove.add(node);
            }
            overlap.removeAll(remove);
        }
        System.out.println("Overlap: " + overlap);
        System.out.println((double)overlap.size() / (double)this.variables.size());
        ArrayList<Graph> marginals = new ArrayList<Graph>();
        for (int k = 0; k < this.marginalVars.size(); ++k) {
            Pc mpc = new Pc(this.independenceTests.get(k));
            marginals.add(mpc.search());
            System.out.println("PC finished " + (k + 1) + " of " + this.marginalVars.size());
        }
        List<NodePair> pairs = this.allNodePairs(this.variables);
        int p = 1;
        for (NodePair nodePair : pairs) {
            HashSet<Node> condSet = new HashSet<Node>();
            condSet.addAll(allInd.getAdjacentNodes(nodePair.getFirst()));
            condSet.addAll(allInd.getAdjacentNodes(nodePair.getSecond()));
            for (Graph graph : marginals) {
                Node newNode;
                try {
                    for (Node node : graph.getAdjacentNodes(graph.getNode(nodePair.getFirst().getName()))) {
                        newNode = allInd.getNode(node.getName());
                        condSet.add(newNode);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    for (Node node : graph.getAdjacentNodes(graph.getNode(nodePair.getSecond().getName()))) {
                        newNode = allInd.getNode(node.getName());
                        condSet.add(newNode);
                    }
                }
                catch (Exception exception) {
                }
            }
            int c = 1;
            int cs = (int)FastMath.pow(2.0, condSet.size());
            for (Set set : new PowerSet(condSet)) {
                System.out.println("Resolving inconsistencies... " + c + " of " + cs + " (" + p + " of " + pairs.size() + " pairs)");
                ++c;
                HashSet<Node> z = new HashSet<Node>(set);
                if (allInd.paths().isMConnectedTo(nodePair.getFirst(), nodePair.getSecond(), z)) continue;
                combinedSepset.set(nodePair.getFirst(), nodePair.getSecond(), new HashSet<Node>(set));
            }
            ++p;
        }
        this.sepsetMaps.clear();
        for (Set set : this.marginalVars) {
            SepsetMapDci newSepset = new SepsetMapDci();
            List<NodePair> pairs2 = this.allNodePairs(new ArrayList<Node>(set));
            for (NodePair pair : pairs2) {
                Node y;
                Node node = pair.getFirst();
                if (combinedSepset.getSet(node, y = pair.getSecond()) == null) continue;
                Set<Set<Node>> conds = combinedSepset.getSet(node, y);
                for (Set<Node> z : conds) {
                    if (!set.containsAll(z)) continue;
                    newSepset.set(node, y, z);
                }
            }
            this.sepsetMaps.add(newSepset);
            ArrayList<Node> variables = new ArrayList<Node>(set);
            EdgeListGraph newGraph = new EdgeListGraph(variables);
            newGraph.fullyConnect(Endpoint.CIRCLE);
            FasDci fasDci = new FasDci(newGraph, new IndTestSepsetDci(newSepset, variables));
            this.minimalSepsetMaps.add(fasDci.search());
        }
    }

    private void resolveResultingIndependenciesC() {
        ArrayList<SepsetMapDci> allSepsets = new ArrayList<SepsetMapDci>();
        Pc fci = new Pc(new IndTestSepsetDci(this.combineSepsets(this.sepsetMaps), this.variables));
        System.out.println("Starting pc...");
        SepsetMapDci consSepset = new SepsetMapDci();
        Graph fciResult = fci.search();
        SepsetMap fciSepset = fci.getSepsets();
        for (int k = 0; k < this.marginalVars.size(); ++k) {
            SepsetMapDci newSepset = new SepsetMapDci(this.sepsetMaps.get(k));
            List<NodePair> pairs = this.allNodePairs(new ArrayList<Node>((Collection)this.marginalVars.get(k)));
            boolean p = true;
            for (NodePair pair : pairs) {
                Node y;
                Node x = pair.getFirst();
                if (fciSepset.get(x, y = pair.getSecond()) == null) continue;
                Set<Node> set = fciSepset.get(x, y);
                ArrayList<Node> currentset = new ArrayList<Node>();
                if (newSepset.get(x, y) != null) {
                    currentset.addAll(newSepset.get(x, y));
                }
                boolean c = true;
                for (Node node : set) {
                    System.out.println("Resolving inconsistencies... 1 of " + set.size() + " (" + 1 + " of " + pairs.size() + " pairs and )" + (k + 1) + " of " + this.marginalVars.size() + " datasets)");
                    if (currentset.contains(node)) continue;
                    ArrayList<Node> possibleCond = new ArrayList<Node>(set);
                    possibleCond.remove(node);
                    PowerSet<Node> pset = new PowerSet<Node>(possibleCond);
                    for (Set<Node> set2 : pset) {
                        HashSet<Node> cond = new HashSet<Node>(set2);
                        cond.add(node);
                        if (!fciResult.paths().isMSeparatedFrom(x, y, cond)) continue;
                        newSepset.set(x, y, cond);
                    }
                }
            }
            allSepsets.add(newSepset);
        }
        this.sepsetMaps = allSepsets;
        System.out.println(this.sepsetMaps);
    }

    private void doSepsetClosure(SepsetMapDci sepset, Graph graph) {
        List<Node> nodes = graph.getNodes();
        List<NodePair> pairs = this.allNodePairs(nodes);
        int p = 1;
        for (NodePair pair : pairs) {
            ArrayList<Node> possibleNodes = new ArrayList<Node>(nodes);
            Node x = pair.getFirst();
            Node y = pair.getSecond();
            possibleNodes.remove(x);
            possibleNodes.remove(y);
            possibleNodes.addAll(graph.getAdjacentNodes(x));
            possibleNodes.addAll(graph.getAdjacentNodes(y));
            int c = 1;
            int ps = (int)FastMath.pow(2.0, possibleNodes.size());
            for (Set<Node> set : new PowerSet<Node>(possibleNodes)) {
                System.out.println("Getting closure set... " + c + " of " + ps + "(" + p + " of " + pairs.size() + " remaining)");
                if (graph.paths().isMSeparatedFrom(x, y, new HashSet<Node>(set))) {
                    sepset.set(x, y, new HashSet<Node>(set));
                }
                ++c;
            }
            ++p;
        }
    }

    private SepsetMapDci combineSepsets(List<SepsetMapDci> sepsets) {
        SepsetMapDci allSepsets = new SepsetMapDci();
        for (SepsetMapDci sepset : sepsets) {
            for (Set<Node> pair : sepset.getSeparatedPairs()) {
                Object[] pairArray = pair.toArray();
                Node x = (Node)pairArray[0];
                Node y = (Node)pairArray[1];
                for (Set<Node> condSet : sepset.getSet(x, y)) {
                    allSepsets.set(x, y, condSet);
                }
            }
        }
        return allSepsets;
    }

    private List<NodePair> allNodePairs(List<Node> nodes) {
        ArrayList<NodePair> nodePairs = new ArrayList<NodePair>();
        for (int j = 0; j < nodes.size() - 1; ++j) {
            for (int k = j + 1; k < nodes.size(); ++k) {
                nodePairs.add(new NodePair(nodes.get(j), nodes.get(k)));
            }
        }
        return nodePairs;
    }

    private class FindMinimalSpanningTrek
    implements Runnable {
        Thread thisThread = new Thread(this);

        FindMinimalSpanningTrek() {
            this.thisThread.start();
        }

        @Override
        public void run() {
            int threadNum;
            while (Dci.this.currentThread < Dci.this.totalThreads && (threadNum = Dci.this.nextThread()) < Dci.this.totalThreads) {
                int k;
                int size = Dci.this.currentMarginalSet.size();
                NodePair nodePair = (NodePair)Dci.this.currentNodePairs.get(threadNum);
                System.out.println("Finding minmal spanning treks... " + threadNum + " of " + Dci.this.totalThreads);
                if (Dci.this.currentGraph.isAdjacentTo(Dci.this.currentGraph.getNode(nodePair.getFirst().getName()), Dci.this.currentGraph.getNode(nodePair.getSecond().getName()))) {
                    HashSet otherNodes = new HashSet(Dci.this.currentMarginalSet);
                    ArrayList<Node> adjacency = new ArrayList<Node>();
                    adjacency.add(nodePair.getFirst());
                    adjacency.add(nodePair.getSecond());
                    otherNodes.removeAll(adjacency);
                    ((Map)Dci.this.allPaths.get(2)).put(adjacency, otherNodes);
                    continue;
                }
                HashMap newPaths = new HashMap();
                for (int k2 = 2; k2 <= size; ++k2) {
                    newPaths.put(k2, new HashMap());
                }
                for (List<Node> trek : Dci.this.currentGraph.paths().treks(Dci.this.currentGraph.getNode(nodePair.getFirst().getName()), Dci.this.currentGraph.getNode(nodePair.getSecond().getName()), -1)) {
                    boolean inMarginal = true;
                    for (Node node : trek) {
                        if (Dci.this.currentMarginalSet.contains(node)) continue;
                        inMarginal = false;
                        break;
                    }
                    if (!inMarginal) continue;
                    HashSet otherNodes = new HashSet(Dci.this.currentMarginalSet);
                    trek.forEach(otherNodes::remove);
                    ((Map)newPaths.get(trek.size())).put(trek, otherNodes);
                }
                ArrayList<List> remove = new ArrayList<List>();
                for (k = 2; k < size; ++k) {
                    Map trekMap = (Map)newPaths.get(k);
                    for (int l = k + 1; l <= size; ++l) {
                        Map trekMapNext = (Map)newPaths.get(l);
                        for (List trek : trekMap.keySet()) {
                            for (List trekNext : trekMapNext.keySet()) {
                                if (!((Set)trekMap.get(trek)).containsAll((Collection)trekMapNext.get(trekNext)) || !Dci.this.isSubtrek(trekNext, trek)) continue;
                                remove.add(trekNext);
                            }
                        }
                        for (List nodes : remove) {
                            trekMapNext.remove(nodes);
                        }
                        remove.clear();
                    }
                }
                for (k = 2; k <= size; ++k) {
                    ((Map)Dci.this.allPaths.get(k)).putAll((Map)newPaths.get(k));
                }
            }
        }
    }

    private static class PowerSet<E>
    implements Iterable<Set<E>> {
        Collection<E> all;

        public PowerSet(Collection<E> all) {
            this.all = all;
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new PowerSetIterator(this);
        }

        static class PowerSetIterator<InE>
        implements Iterator<Set<InE>> {
            PowerSet<InE> powerSet;
            List<InE> canonicalOrder = new ArrayList<InE>();
            List<InE> mask = new ArrayList<InE>();
            boolean hasNext = true;

            PowerSetIterator(PowerSet<InE> powerSet) {
                this.powerSet = powerSet;
                this.canonicalOrder.addAll(powerSet.all);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean allOnes() {
                for (InE bit : this.mask) {
                    if (bit != null) continue;
                    return false;
                }
                return true;
            }

            private void increment() {
                int i;
                for (i = 0; i < this.mask.size(); ++i) {
                    InE bit = this.mask.get(i);
                    if (bit == null) {
                        this.mask.set(i, this.canonicalOrder.get(i));
                        return;
                    }
                    this.mask.set(i, null);
                }
                this.mask.add(this.canonicalOrder.get(i));
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Set<InE> next() {
                HashSet<InE> result = new HashSet<InE>(this.mask);
                result.remove(null);
                boolean bl = this.hasNext = this.mask.size() < this.powerSet.all.size() || !this.allOnes();
                if (this.hasNext) {
                    this.increment();
                }
                return result;
            }
        }
    }
}

