/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IFas;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.utils.PcCommon;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Fas2
implements IFas {
    private final List<Node> nodes;
    private final IndependenceTest test;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Knowledge knowledge = new Knowledge();
    private int depth = 1000;
    private int numIndependenceTests;
    private SepsetMap sepset = new SepsetMap();
    private Graph initialGraph;
    private boolean verbose = false;
    private PrintStream out = System.out;
    private PcCommon.PcHeuristicType pcHeuristicType;

    public Fas2(Graph initialGraph, IndependenceTest test) {
        if (initialGraph != null) {
            this.initialGraph = new EdgeListGraph(initialGraph);
        }
        this.test = test;
        this.nodes = test.getVariables();
    }

    public Fas2(IndependenceTest test) {
        this.test = test;
        this.nodes = test.getVariables();
    }

    public Graph search(List<Node> nodes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Graph search() {
        boolean more;
        this.logger.log("info", "Starting Fast Adjacency Search.");
        this.sepset = new SepsetMap();
        int _depth = this.depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        HashMap<Node, Set<Node>> adjacencies = new HashMap<Node, Set<Node>>();
        for (Node node : this.nodes) {
            adjacencies.put(node, new TreeSet());
        }
        for (int d = 0; d <= _depth && (more = d == 0 ? this.searchAtDepth0(this.nodes, this.test, adjacencies) : this.searchAtDepth(this.nodes, this.test, adjacencies, d)); ++d) {
        }
        EdgeListGraph graph = new EdgeListGraph(this.nodes);
        for (int i = 0; i < this.nodes.size(); ++i) {
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                Node x = this.nodes.get(i);
                Node y = this.nodes.get(j);
                if (!((Set)adjacencies.get(x)).contains(y)) continue;
                graph.addUndirectedEdge(x, y);
            }
        }
        this.logger.log("info", "Finishing Fast Adjacency Search.");
        return graph;
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0.");
        }
        this.depth = depth;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException("Cannot set knowledge to null");
        }
        this.knowledge = knowledge;
    }

    private boolean searchAtDepth0(List<Node> nodes, IndependenceTest test, Map<Node, Set<Node>> adjacencies) {
        Set<Node> empty = Collections.emptySet();
        for (int i = 0; i < nodes.size(); ++i) {
            if (this.verbose && (i + 1) % 100 == 0) {
                this.out.println("Node # " + (i + 1));
            }
            if (Thread.currentThread().isInterrupted()) break;
            Node x = nodes.get(i);
            for (int j = i + 1; j < nodes.size(); ++j) {
                boolean independent;
                Node y2;
                Node x2;
                Node y = nodes.get(j);
                if (this.initialGraph != null && !this.initialGraph.isAdjacentTo(x2 = this.initialGraph.getNode(x.getName()), y2 = this.initialGraph.getNode(y.getName()))) continue;
                try {
                    ++this.numIndependenceTests;
                    independent = test.checkIndependence(x, y, empty).isIndependent();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    independent = false;
                }
                boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                if (independent && noEdgeRequired) {
                    this.getSepsets().set(x, y, empty);
                    continue;
                }
                if (this.forbiddenEdge(x, y)) continue;
                adjacencies.get(x).add(y);
                adjacencies.get(y).add(x);
            }
        }
        return this.freeDegree(nodes, adjacencies) > 0;
    }

    private int freeDegree(List<Node> nodes, Map<Node, Set<Node>> adjacencies) {
        int max = 0;
        for (Node x : nodes) {
            Set<Node> opposites = adjacencies.get(x);
            for (Node y : opposites) {
                HashSet<Node> adjx = new HashSet<Node>(opposites);
                adjx.remove(y);
                if (adjx.size() <= max) continue;
                max = adjx.size();
            }
        }
        return max;
    }

    private boolean forbiddenEdge(Node x, Node y) {
        String name2;
        String name1 = x.getName();
        if (this.knowledge.isForbidden(name1, name2 = y.getName()) && this.knowledge.isForbidden(name2, name1)) {
            System.out.println(Edges.undirectedEdge(x, y) + " because it was forbidden by background knowledge.");
            return true;
        }
        return false;
    }

    private boolean searchAtDepth(List<Node> nodes, IndependenceTest test, Map<Node, Set<Node>> adjacencies, int depth) {
        int count = 0;
        for (Node x : nodes) {
            if (this.verbose && ++count % 100 == 0) {
                this.out.println("count " + count + " of " + nodes.size());
            }
            if (Thread.currentThread().isInterrupted()) break;
            ArrayList adjx = new ArrayList(adjacencies.get(x));
            block3: for (Node y : adjx) {
                int[] choice;
                ArrayList<Node> _adjx = new ArrayList<Node>((Collection)adjacencies.get(x));
                _adjx.remove(y);
                List<Node> ppx = this.possibleParents(x, _adjx, this.knowledge);
                if (ppx.size() < depth) continue;
                ChoiceGenerator cg = new ChoiceGenerator(ppx.size(), depth);
                while ((choice = cg.next()) != null && !Thread.currentThread().isInterrupted()) {
                    boolean independent;
                    Set<Node> condSet = GraphUtils.asSet(choice, ppx);
                    try {
                        ++this.numIndependenceTests;
                        independent = test.checkIndependence(x, y, condSet).isIndependent();
                    }
                    catch (Exception e) {
                        independent = false;
                    }
                    boolean noEdgeRequired = this.knowledge.noEdgeRequired(x.getName(), y.getName());
                    if (!independent || !noEdgeRequired) continue;
                    adjacencies.get(x).remove(y);
                    adjacencies.get(y).remove(x);
                    this.getSepsets().set(x, y, condSet);
                    continue block3;
                }
            }
        }
        return this.freeDegree(nodes, adjacencies) > depth;
    }

    private List<Node> possibleParents(Node x, List<Node> adjx, Knowledge knowledge) {
        LinkedList<Node> possibleParents = new LinkedList<Node>();
        String _x = x.getName();
        for (Node z : adjx) {
            String _z = z.getName();
            if (!this.possibleParentOf(_z, _x, knowledge)) continue;
            possibleParents.add(z);
        }
        return possibleParents;
    }

    private boolean possibleParentOf(String z, String x, Knowledge knowledge) {
        return !knowledge.isForbidden(z, x) && !knowledge.isRequired(x, z);
    }

    @Override
    public int getNumIndependenceTests() {
        return this.numIndependenceTests;
    }

    @Override
    public SepsetMap getSepsets() {
        return this.sepset;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    @Override
    public List<Node> getNodes() {
        return this.test.getVariables();
    }

    @Override
    public List<Triple> getAmbiguousTriples(Node node) {
        return null;
    }

    @Override
    public void setOut(PrintStream out) {
        this.out = out;
    }

    public void setPcHeuristicType(PcCommon.PcHeuristicType pcHeuristicType) {
        this.pcHeuristicType = pcHeuristicType;
    }

    public void setStable(boolean b) {
        boolean stable = b;
    }
}

