/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.Lofs;
import edu.cmu.tetrad.search.score.SemBicScore;
import edu.cmu.tetrad.search.test.ScoreIndTest;
import edu.cmu.tetrad.util.MillisecondTimes;
import java.util.Collections;

public final class FasLofs
implements IGraphSearch {
    private final Lofs.Rule rule;
    private final DataSet dataSet;
    private long elapsed;
    private int depth = -1;
    private double penaltyDiscount = 1.0;
    private Knowledge knowledge = new Knowledge();

    public FasLofs(DataSet dataSet, Lofs.Rule rule) {
        this.dataSet = dataSet;
        this.rule = rule;
    }

    @Override
    public Graph search() {
        long start = MillisecondTimes.timeMillis();
        SemBicScore score = new SemBicScore(new CovarianceMatrix(this.dataSet));
        score.setPenaltyDiscount(this.penaltyDiscount);
        ScoreIndTest test = new ScoreIndTest(score, this.dataSet);
        System.out.println("FAS");
        Fas fas = new Fas(test);
        fas.setStable(true);
        fas.setDepth(this.getDepth());
        fas.setVerbose(false);
        fas.setKnowledge(this.knowledge);
        Graph G0 = fas.search();
        System.out.println("LOFS orientation, rule " + (Object)((Object)this.rule));
        Lofs lofs2 = new Lofs(G0, Collections.singletonList(this.dataSet));
        lofs2.setRule(this.rule);
        lofs2.setKnowledge(this.knowledge);
        Graph graph = lofs2.orient();
        System.out.println("Done");
        long stop = MillisecondTimes.timeMillis();
        this.elapsed = stop - start;
        return graph;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsed;
    }

    public double getPenaltyDiscount() {
        return this.penaltyDiscount;
    }

    public void setPenaltyDiscount(double penaltyDiscount) {
        this.penaltyDiscount = penaltyDiscount;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = new Knowledge(knowledge);
    }
}

