/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphChange {
    private final List<Edge> removes;
    private final List<Triple> colliders;
    private final List<Triple> nonColliders;
    private final List<NodePair> orients;

    public GraphChange() {
        this.removes = new ArrayList<Edge>();
        this.colliders = new ArrayList<Triple>();
        this.nonColliders = new ArrayList<Triple>();
        this.orients = new ArrayList<NodePair>();
    }

    public GraphChange(GraphChange source) {
        this.removes = new ArrayList<Edge>(source.removes);
        this.colliders = new ArrayList<Triple>(source.colliders);
        this.nonColliders = new ArrayList<Triple>(source.nonColliders);
        this.orients = new ArrayList<NodePair>(source.orients);
    }

    public void union(GraphChange other) {
        this.removes.addAll(other.removes);
        this.colliders.addAll(other.colliders);
        this.nonColliders.addAll(other.nonColliders);
        this.orients.addAll(other.orients);
    }

    public boolean isConsistent(GraphChange other) {
        for (Triple colide : this.colliders) {
            if (!other.nonColliders.contains(colide)) continue;
            return false;
        }
        for (Triple nonColide : this.nonColliders) {
            if (!other.colliders.contains(nonColide)) continue;
            return false;
        }
        Collection<OrderedNodePair> colidePairsOther = this.makePairs(other.colliders);
        Collection<OrderedNodePair> nonColidePairsOther = this.makePairs(other.nonColliders);
        for (Edge e : this.removes) {
            NodePair rem = new NodePair(e.getNode1(), e.getNode2());
            if (!colidePairsOther.contains(rem) && !nonColidePairsOther.contains(rem) && !other.orients.contains(rem)) continue;
            return false;
        }
        Collection<OrderedNodePair> colidePairsThis = this.makePairs(this.colliders);
        Collection<OrderedNodePair> nonColidePairsThis = this.makePairs(this.nonColliders);
        for (Edge e : other.removes) {
            NodePair rem = new NodePair(e.getNode1(), e.getNode2());
            if (!colidePairsThis.contains(rem) && !nonColidePairsThis.contains(rem) && !this.orients.contains(rem)) continue;
            return false;
        }
        return true;
    }

    public Graph applyTo(Graph graph) {
        EdgeListGraph output = new EdgeListGraph(graph);
        this.makeNewEdges(output);
        for (Triple t : this.nonColliders) {
            output.addUnderlineTriple(t.getX(), t.getY(), t.getZ());
        }
        for (Edge e : this.removes) {
            if (output.removeEdge(e)) continue;
            return null;
        }
        Collection<OrderedNodePair> allOrients = this.makePairs(this.colliders);
        allOrients.addAll(this.pairToOrdered(this.orients));
        for (OrderedNodePair or : allOrients) {
            Node to = or.getSecond();
            Node from = or.getFirst();
            if (output.setEndpoint(from, to, Endpoint.ARROW)) continue;
            return null;
        }
        return output;
    }

    public void addRemove(Edge removalEdge) {
        this.removes.add(removalEdge);
    }

    public void addCollider(Triple colliderTrip) {
        this.colliders.add(colliderTrip);
    }

    public void addNonCollider(Triple nonColliderTrip) {
        this.nonColliders.add(nonColliderTrip);
    }

    public void addOrient(Node from, Node to) {
        this.orients.add(new NodePair(from, to));
    }

    public boolean contains(GraphChange gc) {
        if (!this.removes.containsAll(gc.removes)) {
            return false;
        }
        if (!this.colliders.containsAll(gc.colliders)) {
            return false;
        }
        if (!this.nonColliders.containsAll(gc.nonColliders)) {
            return false;
        }
        return this.orients.containsAll(gc.orients);
    }

    public String toString() {
        String ret = "[ ";
        if (!this.removes.isEmpty()) {
            ret = ret + "\n removes: " + this.removes;
        }
        if (!this.colliders.isEmpty()) {
            ret = ret + "\n colliders: " + this.colliders;
        }
        if (!this.nonColliders.isEmpty()) {
            ret = ret + "\n nonColliders: " + this.nonColliders;
        }
        if (!this.orients.isEmpty()) {
            ret = ret + "\n orient: " + this.orients;
        }
        ret = ret + " ]";
        return ret;
    }

    public List<Triple> getColliders() {
        return this.colliders;
    }

    public List<Triple> getNoncolliders() {
        return this.nonColliders;
    }

    public List<Edge> getRemoves() {
        return this.removes;
    }

    public List<NodePair> getOrients() {
        return this.orients;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GraphChange)) {
            return false;
        }
        GraphChange otherGC = (GraphChange)other;
        return otherGC.removes.equals(this.removes) && otherGC.colliders.equals(this.colliders) && otherGC.nonColliders.equals(this.nonColliders) && otherGC.orients.equals(this.orients);
    }

    public int hashCode() {
        int hash = 1;
        hash *= 17 * this.removes.hashCode();
        hash *= 19 * this.colliders.hashCode();
        hash *= 7 * this.nonColliders.hashCode();
        return hash *= 23 * this.orients.hashCode();
    }

    private Collection<OrderedNodePair> makePairs(List<Triple> input) {
        HashSet<OrderedNodePair> outputPairs = new HashSet<OrderedNodePair>();
        for (Triple trip : input) {
            Node y = trip.getY();
            outputPairs.add(new OrderedNodePair(trip.getX(), y));
            outputPairs.add(new OrderedNodePair(trip.getZ(), y));
        }
        return outputPairs;
    }

    private Collection<OrderedNodePair> pairToOrdered(List<NodePair> orig) {
        ArrayList<OrderedNodePair> ordered = new ArrayList<OrderedNodePair>(orig.size());
        for (NodePair p : orig) {
            ordered.add(new OrderedNodePair(p.getFirst(), p.getSecond()));
        }
        return ordered;
    }

    private void makeNewEdges(Graph graph) {
        Set<Edge> origEdges = graph.getEdges();
        for (Edge e : origEdges) {
            Edge newEdge = new Edge(e.getNode1(), e.getNode2(), e.getEndpoint1(), e.getEndpoint2());
            graph.removeEdge(e);
            graph.addEdge(newEdge);
        }
    }

    private static class OrderedNodePair
    extends NodePair {
        public OrderedNodePair(Node first, Node second) {
            super(first, second);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodePair)) {
                return false;
            }
            NodePair thatPair = (NodePair)o;
            return this.getFirst().equals(thatPair.getFirst()) && this.getSecond().equals(thatPair.getSecond());
        }
    }
}

