/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IMbSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.MbUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IambnPc
implements IMbSearch {
    private final IndependenceTest independenceTest;
    private final List<Node> variables;

    public IambnPc(IndependenceTest test) {
        if (test == null) {
            throw new NullPointerException();
        }
        this.independenceTest = test;
        this.variables = test.getVariables();
    }

    @Override
    public Set<Node> findMb(Node target) {
        HashSet<Node> cmb = new HashSet<Node>();
        Pc pc = new Pc(this.independenceTest);
        boolean cont = true;
        while (cont) {
            cont = false;
            LinkedList<Node> remaining = new LinkedList<Node>(this.variables);
            remaining.removeAll(cmb);
            remaining.remove(target);
            double strength = Double.NEGATIVE_INFINITY;
            Node f = null;
            for (Node v : remaining) {
                double _strength;
                if (v == target || !((_strength = this.associationStrength(v, target, cmb)) > strength)) continue;
                strength = _strength;
                f = v;
            }
            if (f == null) break;
            if (this.independenceTest.checkIndependence(f, target, cmb).isIndependent()) continue;
            cmb.add(f);
            cont = true;
        }
        cmb.add(target);
        Graph graph = pc.search(cmb);
        MbUtils.trimToMbNodes(graph, target, false);
        cmb = new HashSet<Node>(graph.getNodes());
        cmb.remove(target);
        return cmb;
    }

    private double associationStrength(Node v, Node target, Set<Node> cmb) {
        IndependenceResult result = this.independenceTest.checkIndependence(v, target, cmb);
        return 1.0 - result.getPValue();
    }

    @Override
    public String getAlgorithmName() {
        return "IAMBnPC";
    }

    @Override
    public int getNumIndependenceTests() {
        return 0;
    }

    private Node getVariableForName(String targetName) {
        Node target = null;
        for (Node V : this.variables) {
            if (!V.getName().equals(targetName)) continue;
            target = V;
            break;
        }
        if (target == null) {
            throw new IllegalArgumentException("Target variable not in dataset: " + targetName);
        }
        return target;
    }
}

