/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;

public final class IndTestFisherZPercentIndependent
implements IndependenceTest {
    private final List<Node> variables;
    private final List<DataSet> dataSets;
    private final int[] rows;
    private final List<Matrix> data;
    private final List<Matrix> ncov;
    private final Map<Node, Integer> variablesMap;
    private double alpha;
    private double percent = 0.75;
    private boolean fdr = true;
    private boolean verbose;

    public IndTestFisherZPercentIndependent(List<DataSet> dataSets, double alpha) {
        int i;
        this.dataSets = dataSets;
        this.variables = dataSets.get(0).getVariables();
        if (!(alpha >= 0.0) || !(alpha <= 1.0)) {
            throw new IllegalArgumentException("Alpha mut be in [0, 1]");
        }
        this.data = new ArrayList<Matrix>();
        for (DataSet dataSet : dataSets) {
            dataSet = DataTransforms.center(dataSet);
            Matrix _data = dataSet.getDoubleData();
            this.data.add(_data);
        }
        this.ncov = new ArrayList<Matrix>();
        for (Matrix d : this.data) {
            this.ncov.add(d.transpose().times(d).scalarMult(1.0 / (double)d.getNumRows()));
        }
        this.setAlpha(alpha);
        this.rows = new int[dataSets.get(0).getNumRows()];
        for (i = 0; i < this.getRows().length; ++i) {
            this.getRows()[i] = i;
        }
        this.variablesMap = new HashMap<Node, Integer>();
        for (i = 0; i < this.variables.size(); ++i) {
            this.variablesMap.put(this.variables.get(i), i);
        }
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> _z) {
        try {
            boolean independent;
            ArrayList<Node> z = new ArrayList<Node>(_z);
            Collections.sort(z);
            int[] all = new int[z.size() + 2];
            all[0] = this.variablesMap.get(x);
            all[1] = this.variablesMap.get(y);
            for (int i = 0; i < z.size(); ++i) {
                all[i + 2] = this.variablesMap.get(z.get(i));
            }
            int sampleSize = this.data.get(0).getNumRows();
            ArrayList<Double> pValues = new ArrayList<Double>();
            for (Matrix matrix : this.ncov) {
                Matrix _ncov = matrix.getSelection(all, all);
                Matrix inv = _ncov.inverse();
                double r = -inv.get(0, 1) / FastMath.sqrt(inv.get(0, 0) * inv.get(1, 1));
                double fisherZ = FastMath.sqrt((double)(sampleSize - z.size()) - 3.0) * 0.5 * (FastMath.log(1.0 + r) - FastMath.log(1.0 - r));
                double pValue = Double.isInfinite(fisherZ) ? 0.0 : 2.0 * (1.0 - RandomUtil.getInstance().normalCdf(0.0, 1.0, FastMath.abs(fisherZ)));
                pValues.add(pValue);
            }
            double _cutoff = this.alpha;
            if (this.fdr) {
                _cutoff = StatUtils.fdrCutoff(this.alpha, pValues, false);
            }
            Collections.sort(pValues);
            int index = (int)FastMath.round((1.0 - this.percent) * (double)pValues.size());
            double pValue = (Double)pValues.get(index);
            if (Double.isNaN(pValue)) {
                throw new RuntimeException("NaN p-value encountered when testing " + LogUtilsSearch.independenceFact(x, y, _z));
            }
            boolean bl = independent = pValue > _cutoff;
            if (this.verbose && independent) {
                TetradLogger.getInstance().forceLogMessage(LogUtilsSearch.independenceFactMsg(x, y, _z, pValue));
            }
            return new IndependenceResult(new IndependenceFact(x, y, _z), independent, pValue, this.getAlpha() - pValue);
        }
        catch (SingularMatrixException e) {
            throw new RuntimeException("Singularity encountered when testing " + LogUtilsSearch.independenceFact(x, y, _z));
        }
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    public boolean determines(List z, Node x) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSet getData() {
        return DataTransforms.concatenate(this.dataSets);
    }

    @Override
    public ICovarianceMatrix getCov() {
        ArrayList<DataSet> _dataSets = new ArrayList<DataSet>();
        for (DataSet d : this.dataSets) {
            _dataSets.add(DataTransforms.standardizeData(d));
        }
        return new CovarianceMatrix(DataTransforms.concatenate(this.dataSets));
    }

    @Override
    public List<DataSet> getDataSets() {
        return this.dataSets;
    }

    @Override
    public int getSampleSize() {
        return this.dataSets.get(0).getNumRows();
    }

    @Override
    public String toString() {
        return "Fisher Z, Percent Independent";
    }

    public int[] getRows() {
        return this.rows;
    }

    public double getPercent() {
        return this.percent;
    }

    public void setPercent(double percent) {
        if (percent < 0.0 || percent > 1.0) {
            throw new IllegalArgumentException();
        }
        this.percent = percent;
    }

    public void setFdr(boolean fdr) {
        this.fdr = fdr;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

