/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.work_in_progress.MnlrLikelihood;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.HashedMap;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.util.FastMath;

public class IndTestMnlrLr
implements IndependenceTest {
    private final DataSet data;
    private final Map<Node, Integer> nodesHash;
    private final MnlrLikelihood likelihood;
    private double alpha;
    private boolean verbose;

    public IndTestMnlrLr(DataSet data, double alpha) {
        this.data = data;
        this.likelihood = new MnlrLikelihood(data, -1.0, 1);
        this.nodesHash = new HashedMap<Node, Integer>();
        List<Node> variables = data.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            this.nodesHash.put(variables.get(i), i);
        }
        this.alpha = alpha;
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> _z) {
        boolean independent;
        ArrayList<Node> z = new ArrayList<Node>(_z);
        int _x = this.nodesHash.get(x);
        int _y = this.nodesHash.get(y);
        int[] list0 = new int[z.size() + 1];
        int[] list1 = new int[z.size() + 1];
        int[] list2 = new int[z.size()];
        list0[0] = _x;
        list1[0] = _y;
        for (int i = 0; i < z.size(); ++i) {
            int __z;
            list0[i + 1] = __z = this.nodesHash.get(z.get(i)).intValue();
            list1[i + 1] = __z;
            list2[i] = __z;
        }
        double lik_0 = this.likelihood.getLik(_y, list0) - this.likelihood.getLik(_y, list2);
        double dof_0 = this.likelihood.getLik(_y, list0) - this.likelihood.getLik(_y, list2);
        double lik_1 = this.likelihood.getLik(_x, list1) - this.likelihood.getLik(_x, list2);
        double dof_1 = this.likelihood.getLik(_x, list1) - this.likelihood.getLik(_x, list2);
        if (dof_0 <= 0.0) {
            dof_0 = 1.0;
        }
        if (dof_1 <= 0.0) {
            dof_1 = 1.0;
        }
        double p_0 = 0.0;
        double p_1 = 0.0;
        try {
            p_0 = 1.0 - new ChiSquaredDistribution(dof_0).cumulativeProbability(2.0 * lik_0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            p_1 = 1.0 - new ChiSquaredDistribution(dof_1).cumulativeProbability(2.0 * lik_1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double pValue = FastMath.min(p_0, p_1);
        if (Double.isNaN(pValue)) {
            throw new RuntimeException("Undefined p-value encountered when testing " + LogUtilsSearch.independenceFact(x, y, _z));
        }
        boolean bl = independent = pValue > this.alpha;
        if (this.verbose && independent) {
            TetradLogger.getInstance().forceLogMessage(LogUtilsSearch.independenceFactMsg(x, y, _z, pValue));
        }
        return new IndependenceResult(new IndependenceFact(x, y, _z), independent, pValue, this.alpha - pValue);
    }

    @Override
    public List<Node> getVariables() {
        return this.data.getVariables();
    }

    public boolean determines(List<Node> z, Node y) {
        return false;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public DataSet getData() {
        return this.data;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public String toString() {
        return "IndTestMnlrLr";
    }
}

