/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.StatUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.FastMath;

public final class IndTestPositiveCorr
implements IndependenceTest {
    private final ICovarianceMatrix covMatrix;
    private final double[][] data;
    private final DataSet dataSet;
    private final Map<String, Node> nameMap;
    private final double fisherZ = Double.NaN;
    private final NormalDistribution normal = new NormalDistribution(0.0, 1.0);
    private List<Node> variables;
    private double alpha;
    private boolean verbose = true;
    private double cutoff = Double.NaN;

    public IndTestPositiveCorr(DataSet dataSet, double alpha) {
        if (!dataSet.isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        if (!(alpha >= 0.0) || !(alpha <= 1.0)) {
            throw new IllegalArgumentException("Alpha mut be in [0, 1]");
        }
        this.covMatrix = new CovarianceMatrix(dataSet);
        List<Node> nodes = this.covMatrix.getVariables();
        this.variables = Collections.unmodifiableList(nodes);
        this.nameMap = this.nameMap(this.variables);
        this.setAlpha(alpha);
        this.dataSet = dataSet;
        this.data = dataSet.getDoubleData().transpose().toArray();
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndependenceResult checkIndependence(Node x0, Node y0, Set<Node> _z0) {
        System.out.println(LogUtilsSearch.independenceFact(x0, y0, _z0));
        double[] x = this.data[this.dataSet.getColumn(x0)];
        double[] y = this.data[this.dataSet.getColumn(y0)];
        ArrayList<Node> z0 = new ArrayList<Node>(_z0);
        Collections.sort(z0);
        double[][] _Z = new double[z0.size()][];
        for (int f = 0; f < z0.size(); ++f) {
            Node _z = (Node)z0.get(f);
            int column = this.dataSet.getColumn(_z);
            _Z[f] = this.data[column];
        }
        double pc = this.partialCorrelation(x, y, _Z, x, Double.NEGATIVE_INFINITY);
        double pc1 = this.partialCorrelation(x, y, _Z, x, 0.0);
        double pc2 = this.partialCorrelation(x, y, _Z, y, 0.0);
        int nc = StatUtils.getRows(x, Double.NEGATIVE_INFINITY, 1.0).size();
        int nc1 = StatUtils.getRows(x, 0.0, 1.0).size();
        int nc2 = StatUtils.getRows(y, 0.0, 1.0).size();
        double z = 0.5 * (FastMath.log(1.0 + pc) - FastMath.log(1.0 - pc));
        double z1 = 0.5 * (FastMath.log(1.0 + pc1) - FastMath.log(1.0 - pc1));
        double z2 = 0.5 * (FastMath.log(1.0 + pc2) - FastMath.log(1.0 - pc2));
        double zv1 = (z - z1) / FastMath.sqrt(1.0 / ((double)nc - 3.0) + 1.0 / ((double)nc1 - 3.0));
        double zv2 = (z - z2) / FastMath.sqrt(1.0 / ((double)nc - 3.0) + 1.0 / ((double)nc2 - 3.0));
        double p1 = 1.0 - new NormalDistribution(0.0, 1.0).cumulativeProbability(FastMath.abs(zv1));
        double p2 = 1.0 - new NormalDistribution(0.0, 1.0).cumulativeProbability(FastMath.abs(zv2));
        boolean rejected1 = p1 < this.alpha;
        boolean rejected2 = p2 < this.alpha;
        boolean possibleEdge = false;
        if (zv1 < 0.0 && zv2 > 0.0 && rejected1) {
            possibleEdge = true;
        } else if (zv1 > 0.0 && zv2 < 0.0 && rejected2) {
            possibleEdge = true;
        } else if (rejected1 && rejected2) {
            possibleEdge = true;
        } else if (rejected1 || rejected2) {
            possibleEdge = true;
        }
        System.out.println(possibleEdge);
        double pValue = this.getPValue();
        if (Double.isNaN(pValue)) {
            throw new RuntimeException("Undefined p-value encountered when testing " + LogUtilsSearch.independenceFact(x0, y0, _z0));
        }
        return new IndependenceResult(new IndependenceFact(x0, y0, _z0), !possibleEdge, pValue, this.alpha - pValue);
    }

    public double getPValue() {
        return 2.0 * (1.0 - this.normal.cumulativeProbability(FastMath.abs(this.fisherZ)));
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range: " + alpha);
        }
        this.alpha = alpha;
        this.cutoff = StatUtils.getZForAlpha(alpha);
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Node> variables) {
        if (variables.size() != this.variables.size()) {
            throw new IllegalArgumentException("Wrong # of variables.");
        }
        this.variables = new ArrayList<Node>(variables);
        this.covMatrix.setVariables(variables);
    }

    @Override
    public Node getVariable(String name) {
        return this.nameMap.get(name);
    }

    public boolean determines(List<Node> z, Node x) throws UnsupportedOperationException {
        int[] parents = new int[z.size()];
        for (int j = 0; j < parents.length; ++j) {
            parents[j] = this.covMatrix.getVariables().indexOf(z.get(j));
        }
        if (parents.length > 0) {
            Matrix Czz = this.covMatrix.getSelection(parents, parents);
            try {
                Czz.inverse();
            }
            catch (SingularMatrixException e) {
                return true;
            }
        }
        return false;
    }

    @Override
    public DataSet getData() {
        return this.dataSet;
    }

    @Override
    public String toString() {
        return "Fisher Z, alpha = " + new DecimalFormat("0.0E0").format(this.getAlpha());
    }

    private Map<String, Node> nameMap(List<Node> variables) {
        ConcurrentHashMap<String, Node> nameMap = new ConcurrentHashMap<String, Node>();
        for (Node node : variables) {
            nameMap.put(node.getName(), node);
        }
        return nameMap;
    }

    @Override
    public ICovarianceMatrix getCov() {
        return this.covMatrix;
    }

    @Override
    public List<DataSet> getDataSets() {
        ArrayList<DataSet> dataSets = new ArrayList<DataSet>();
        dataSets.add(this.dataSet);
        return dataSets;
    }

    @Override
    public int getSampleSize() {
        return this.covMatrix.getSampleSize();
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private double partialCorrelation(double[] x, double[] y, double[][] z, double[] condition, double threshold) throws SingularMatrixException {
        double[][] cv = StatUtils.covMatrix(x, y, z, condition, threshold, 1.0);
        Matrix m = new Matrix(cv).transpose();
        return StatUtils.partialCorrelation(m);
    }
}

