/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndependenceResult;
import edu.cmu.tetrad.search.utils.LogUtilsSearch;
import edu.cmu.tetrad.search.work_in_progress.SepsetMapDci;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.TetradLogger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IndTestSepsetDci
implements IndependenceTest {
    private final SepsetMapDci sepset;
    private final Map<Node, Node> nodesToVariables;
    private final Map<Node, Node> variablesToNodes;
    private final List<Node> observedVars;
    private boolean verbose;

    public IndTestSepsetDci(SepsetMapDci sepset, List<Node> nodes) {
        if (sepset == null) {
            throw new NullPointerException();
        }
        this.sepset = sepset;
        this.nodesToVariables = new HashMap<Node, Node>();
        this.variablesToNodes = new HashMap<Node, Node>();
        for (Node node : nodes) {
            this.nodesToVariables.put(node, node);
            this.variablesToNodes.put(node, node);
        }
        this.observedVars = this.calcObservedVars(nodes);
    }

    @Override
    public IndependenceTest indTestSubset(List<Node> vars) {
        if (vars.isEmpty()) {
            throw new IllegalArgumentException("Subset may not be empty.");
        }
        for (Node var : vars) {
            if (this.getVariables().contains(var)) continue;
            throw new IllegalArgumentException("All vars must be original vars");
        }
        return this;
    }

    @Override
    public IndependenceResult checkIndependence(Node x, Node y, Set<Node> z) {
        if (z == null) {
            throw new NullPointerException();
        }
        for (Node node : z) {
            if (node != null) continue;
            throw new NullPointerException();
        }
        boolean independent = false;
        if (this.sepset.get(x, y) != null) {
            Set<Set<Node>> condSets = this.sepset.getSet(x, y);
            for (Set<Node> condSet : condSets) {
                if (condSet.size() != z.size() || !condSet.containsAll(z)) continue;
                double pValue = 1.0;
                if (this.verbose) {
                    TetradLogger.getInstance().log("independencies", LogUtilsSearch.independenceFactMsg(x, y, z, 1.0));
                }
                independent = true;
                break;
            }
        }
        if (this.verbose && independent) {
            NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
            TetradLogger.getInstance().forceLogMessage(LogUtilsSearch.independenceFact(x, y, z) + " score = " + LogUtilsSearch.independenceFactMsg(x, y, z, this.getPValue()));
        }
        if (Double.isNaN(this.getPValue())) {
            throw new RuntimeException("Undefined p-value encountered when testing " + LogUtilsSearch.independenceFact(x, y, z));
        }
        return new IndependenceResult(new IndependenceFact(x, y, z), independent, this.getPValue(), this.getAlpha() - this.getPValue());
    }

    public double getPValue() {
        return Double.NaN;
    }

    @Override
    public List<Node> getVariables() {
        return Collections.unmodifiableList(this.observedVars);
    }

    public boolean determines(List<Node> z, Node x1) {
        return z.contains(x1);
    }

    @Override
    public double getAlpha() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAlpha(double alpha) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node getVariable(String name) {
        for (int i = 0; i < this.getVariables().size(); ++i) {
            Node variable = this.getVariables().get(i);
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public Node getVariable(Node node) {
        return this.nodesToVariables.get(node);
    }

    public Node getNode(Node variable) {
        return this.variablesToNodes.get(variable);
    }

    @Override
    public String toString() {
        return "D-separation";
    }

    @Override
    public DataSet getData() {
        return null;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private List<Node> calcObservedVars(List<Node> nodes) {
        ArrayList<Node> observedVars = new ArrayList<Node>();
        for (Node node : nodes) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            observedVars.add(this.getVariable(node));
        }
        return observedVars;
    }
}

