/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.IGraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.test.IndTestHsic;
import edu.cmu.tetrad.search.utils.GraphSearchUtils;
import edu.cmu.tetrad.search.utils.MeekRules;
import edu.cmu.tetrad.search.utils.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Kpc
implements IGraphSearch {
    private final IndTestHsic independenceTest;
    private final TetradLogger logger = TetradLogger.getInstance();
    private Knowledge knowledge = new Knowledge();
    private SepsetMap sepset;
    private int depth = 1000;
    private Graph graph;
    private long elapsedTime;
    private boolean meekPreventCycles;
    private Set<Triple> unshieldedColliders;
    private Set<Triple> unshieldedNoncolliders;
    private double alpha;
    private int perms = 100;
    private boolean verbose;

    public Kpc(DataSet dataset, double alpha) {
        if (dataset == null) {
            throw new NullPointerException();
        }
        this.alpha = alpha;
        this.independenceTest = new IndTestHsic(dataset, alpha);
    }

    public boolean isMeekPreventCycles() {
        return this.meekPreventCycles;
    }

    public void setMeekPreventCycles(boolean meekPreventCycles) {
        this.meekPreventCycles = meekPreventCycles;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public SepsetMap getSepset() {
        return this.sepset;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 or >= 0.");
        }
        if (depth > 1000) {
            throw new IllegalArgumentException("Depth must be <= 1000.");
        }
        this.depth = depth;
    }

    @Override
    public Graph search() {
        return this.search(this.independenceTest.getVariables());
    }

    public Graph search(List<Node> nodes) {
        nodes = new ArrayList<Node>(nodes);
        this.logger.log("info", "Starting kPC algorithm");
        this.logger.log("info", "Independence test = " + this.getIndependenceTest() + ".");
        long startTime = MillisecondTimes.timeMillis();
        if (this.getIndependenceTest() == null) {
            throw new NullPointerException();
        }
        List<Node> allNodes = this.getIndependenceTest().getVariables();
        if (!new HashSet<Node>(allNodes).containsAll(nodes)) {
            throw new IllegalArgumentException("All of the given nodes must be in the domain of the independence test provided.");
        }
        this.graph = new EdgeListGraph(nodes);
        this.graph.fullyConnect(Endpoint.TAIL);
        Fas fas = new Fas(this.getIndependenceTest());
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        this.graph = fas.search();
        this.sepset = fas.getSepsets();
        this.enumerateTriples();
        GraphSearchUtils.pcOrientbk(this.knowledge, this.graph, nodes);
        GraphSearchUtils.orientCollidersUsingSepsets(this.sepset, this.knowledge, this.graph, this.verbose, true);
        MeekRules rules = new MeekRules();
        rules.setMeekPreventCycles(this.meekPreventCycles);
        rules.setKnowledge(this.knowledge);
        rules.orientImplied(this.graph);
        this.elapsedTime = MillisecondTimes.timeMillis() - startTime;
        this.logger.log("info", "Elapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        this.logger.log("info", "Finishing PC Algorithm.");
        this.logger.flush();
        return this.graph;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Set<Triple> getUnshieldedColliders() {
        return this.unshieldedColliders;
    }

    public Set<Triple> getUnshieldedNoncolliders() {
        return this.unshieldedNoncolliders;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("Significance out of range.");
        }
        this.alpha = alpha;
        this.independenceTest.setAlpha(alpha);
    }

    public double getPrecision() {
        return 1.0E-18;
    }

    public int getPerms() {
        return this.perms;
    }

    public void setPerms(int perms) {
        this.perms = perms;
        this.independenceTest.setPerms(perms);
    }

    private void enumerateTriples() {
        this.unshieldedColliders = new HashSet<Triple>();
        this.unshieldedNoncolliders = new HashSet<Triple>();
        for (Node y : this.graph.getNodes()) {
            int[] choice;
            ArrayList<Node> adj = new ArrayList<Node>(this.graph.getAdjacentNodes(y));
            if (adj.size() < 2) continue;
            ChoiceGenerator gen = new ChoiceGenerator(adj.size(), 2);
            while ((choice = gen.next()) != null) {
                Node z;
                Node x = (Node)adj.get(choice[0]);
                Set<Node> nodes = this.sepset.get(x, z = (Node)adj.get(choice[1]));
                if (nodes == null) continue;
                if (nodes.contains(y)) {
                    this.getUnshieldedNoncolliders().add(new Triple(x, y, z));
                    continue;
                }
                this.getUnshieldedColliders().add(new Triple(x, y, z));
            }
        }
    }
}

