/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.score.Score;
import edu.cmu.tetrad.search.work_in_progress.MnlrLikelihood;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class MnlrScore
implements Score {
    private final DataSet dataSet;
    private final List<Node> variables;
    private final MnlrLikelihood likelihood;
    private final double logn;

    public MnlrScore(DataSet dataSet, double structurePrior, int fDegree) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        this.variables = dataSet.getVariables();
        this.likelihood = new MnlrLikelihood(dataSet, structurePrior, fDegree);
        this.logn = FastMath.log(dataSet.getNumRows());
    }

    @Override
    public double localScore(int i, int ... parents) {
        double sp;
        double dof;
        double lik = this.likelihood.getLik(i, parents);
        double score = 2.0 * lik - (dof = this.likelihood.getDoF(i, parents)) * this.logn + (sp = this.likelihood.getStructurePrior(parents.length));
        if (Double.isNaN(score) || Double.isInfinite(score)) {
            return Double.NaN;
        }
        return score;
    }

    @Override
    public double localScoreDiff(int x, int y, int[] z) {
        return this.localScore(y, this.append(z, x)) - this.localScore(y, z);
    }

    @Override
    public int getSampleSize() {
        return this.dataSet.getNumRows();
    }

    @Override
    public boolean isEffectEdge(double bump) {
        return bump > 0.0;
    }

    @Override
    public List<Node> getVariables() {
        return this.variables;
    }

    @Override
    public int getMaxDegree() {
        return (int)FastMath.ceil(FastMath.log(this.dataSet.getNumRows()));
    }
}

