/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.work_in_progress;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.utils.SepsetMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class SepsetMapDci {
    private static final long serialVersionUID = 23L;
    private final Map<Node, LinkedHashSet<Node>> parents = new HashMap<Node, LinkedHashSet<Node>>();
    private Map<Set<Node>, Set<Node>> sepsets = new HashMap<Set<Node>, Set<Node>>();
    private Map<Set<Node>, Set<Set<Node>>> sepsetSets = new HashMap<Set<Node>, Set<Set<Node>>>();

    public SepsetMapDci() {
    }

    public SepsetMapDci(SepsetMapDci map) {
        this.sepsets = new HashMap<Set<Node>, Set<Node>>(map.sepsets);
        this.sepsetSets = new HashMap<Set<Node>, Set<Set<Node>>>(map.sepsetSets);
    }

    public static SepsetMap serializableInstance() {
        return new SepsetMap();
    }

    public void set(Node x, Node y, Set<Node> z) {
        HashSet<Node> pair = new HashSet<Node>(2);
        pair.add(x);
        pair.add(y);
        if (this.sepsets.get(pair) == null) {
            this.sepsets.put(pair, z);
        } else {
            HashSet<Node> newSet = new HashSet<Node>((Collection)this.sepsets.get(pair));
            newSet.addAll(z);
            this.sepsets.put(pair, newSet);
        }
        if (this.sepsetSets.containsKey(pair)) {
            this.sepsetSets.get(pair).add(new HashSet<Node>(z));
        } else {
            HashSet<HashSet<Node>> condSets = new HashSet<HashSet<Node>>();
            condSets.add(new HashSet<Node>(z));
            this.sepsetSets.put(pair, condSets);
        }
    }

    public Set<Node> get(Node x, Node y) {
        HashSet<Node> pair = new HashSet<Node>(2);
        pair.add(x);
        pair.add(y);
        return this.sepsets.get(pair);
    }

    public Set<Set<Node>> getSet(Node x, Node y) {
        HashSet<Node> pair = new HashSet<Node>(2);
        pair.add(x);
        pair.add(y);
        return this.sepsetSets.get(pair);
    }

    public void set(Node x, LinkedHashSet<Node> z) {
        if (this.parents.get(x) != null) {
            this.parents.get(x).addAll(z);
        } else {
            this.parents.put(x, z);
        }
    }

    public LinkedHashSet<Node> get(Node x) {
        return this.parents.get(x) == null ? new LinkedHashSet<Node>() : this.parents.get(x);
    }

    public Set<Set<Node>> getSeparatedPairs() {
        return this.sepsets.keySet();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SepsetMapDci)) {
            return false;
        }
        SepsetMapDci _sepset = (SepsetMapDci)o;
        return this.sepsets.equals(_sepset.sepsets) && this.sepsetSets.equals(_sepset.sepsetSets);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.sepsets == null) {
            throw new NullPointerException();
        }
    }

    public int size() {
        return this.sepsets.keySet().size();
    }

    public String toString() {
        return this.sepsets.toString() + "\n" + this.sepsetSets.toString();
    }
}

