/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.calculator.expression.Expression;
import edu.cmu.tetrad.calculator.parser.ExpressionParser;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.TemplateExpander;
import edu.cmu.tetrad.util.Pm;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GeneralizedSemPm
implements Pm,
TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final SemGraph graph;
    private final List<Node> nodes;
    private final List<Node> variableNodes;
    private final List<Node> measuredNodes;
    private final List<Node> errorNodes;
    private final Map<String, Set<Node>> referencedParameters;
    private final Map<Node, Set<Node>> referencedNodes;
    private final Map<Node, Expression> nodeExpressions;
    private final Map<Node, String> nodeExpressionStrings;
    private final Map<String, Expression> parameterExpressions;
    private final Map<String, String> parameterExpressionStrings;
    private final Map<String, String> parameterEstimationInitializationExpressionStrings;
    private final Map<String, String> startsWithParametersTemplates;
    private final Map<String, String> startsWithParametersEstimationInitializationTemplates;
    private final Map<String, Node> namesToNodes = new HashMap<String, Node>();
    private final Map<String, Integer> parameterSubscript = new HashMap<String, Integer>();
    private Map<String, Expression> parameterEstimationInitializationExpressions;
    private String variablesTemplate = "TSUM(NEW(B)*$)";
    private String errorsTemplate = "Normal(0, NEW(s))";
    private String parametersTemplate = "Split(-1.0,-.5,.5,1.0)";
    private String parametersEstimationInitializationTemplate = "Split(-1.0,-.5,.5,1.0)";
    private List<String> variableNames;

    public GeneralizedSemPm(Graph graph) {
        this(new SemGraph(graph));
    }

    public GeneralizedSemPm(SemGraph graph) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.graph = new SemGraph(graph);
        this.graph.setShowErrorTerms(true);
        for (Edge edge : this.graph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            throw new IllegalArgumentException("The generalized SEM PM cannot currently deal with bidirected edges. Sorry.");
        }
        this.nodes = Collections.unmodifiableList(this.graph.getNodes());
        for (Node node : this.nodes) {
            this.namesToNodes.put(node.getName(), node);
        }
        this.variableNodes = new ArrayList<Node>();
        this.measuredNodes = new ArrayList<Node>();
        for (Node variable : this.nodes) {
            if (variable.getNodeType() == NodeType.MEASURED || variable.getNodeType() == NodeType.LATENT) {
                this.variableNodes.add(variable);
            }
            if (variable.getNodeType() != NodeType.MEASURED) continue;
            this.measuredNodes.add(variable);
        }
        this.errorNodes = new ArrayList<Node>();
        for (Node variable : this.variableNodes) {
            List<Node> parents = this.graph.getParents(variable);
            boolean added = false;
            for (Node _node : parents) {
                if (_node.getNodeType() != NodeType.ERROR) continue;
                this.errorNodes.add(_node);
                added = true;
                break;
            }
            if (added) continue;
            this.errorNodes.add(null);
        }
        this.referencedParameters = new HashMap<String, Set<Node>>();
        this.referencedNodes = new HashMap<Node, Set<Node>>();
        this.nodeExpressions = new HashMap<Node, Expression>();
        this.nodeExpressionStrings = new HashMap<Node, String>();
        this.parameterExpressions = new HashMap<String, Expression>();
        this.parameterExpressionStrings = new HashMap<String, String>();
        this.parameterEstimationInitializationExpressions = new HashMap<String, Expression>();
        this.parameterEstimationInitializationExpressionStrings = new HashMap<String, String>();
        this.startsWithParametersTemplates = new HashMap<String, String>();
        this.startsWithParametersEstimationInitializationTemplates = new HashMap<String, String>();
        this.variableNames = new ArrayList<String>();
        for (Node _node : this.variableNodes) {
            this.variableNames.add(_node.getName());
        }
        for (Node _node : this.errorNodes) {
            if (_node == null) continue;
            this.variableNames.add(_node.getName());
        }
        try {
            Set<String> parameters;
            String formula;
            List<Node> variableNodes = this.getVariableNodes();
            for (Node node : variableNodes) {
                String expressionString;
                if (!this.graph.isParameterizable(node) || this.nodeExpressions.get(node) != null) continue;
                String variablestemplate = this.getVariablesTemplate();
                formula = TemplateExpander.getInstance().expandTemplate(variablestemplate, this, node);
                this.setNodeExpression(node, formula);
                parameters = this.getReferencedParameters(node);
                String parametersTemplate = this.getParametersTemplate();
                for (String parameter : parameters) {
                    if (this.parameterExpressions.get(parameter) == null) continue;
                    if (parametersTemplate != null) {
                        this.setParameterExpression(parameter, parametersTemplate);
                        continue;
                    }
                    if (this.graph.isTimeLagModel()) {
                        expressionString = "Split(-0.9, -.1, .1, 0.9)";
                        this.setParameterExpression(parameter, "Split(-0.9, -.1, .1, 0.9)");
                        this.setParametersTemplate("Split(-0.9, -.1, .1, 0.9)");
                        continue;
                    }
                    expressionString = "Split(-1.0, -.5, .5, 1.0)";
                    this.setParameterExpression(parameter, "Split(-1.0, -.5, .5, 1.0)");
                    this.setParametersTemplate("Split(-1.0, -.5, .5, 1.0)");
                }
                for (String parameter : parameters) {
                    if (this.parameterEstimationInitializationExpressions.get(parameter) == null) {
                        if (parametersTemplate != null) {
                            this.setParameterEstimationInitializationExpression(parameter, parametersTemplate);
                        } else if (this.graph.isTimeLagModel()) {
                            expressionString = "Split(-0.9, -.1, .1, 0.9)";
                            this.setParameterEstimationInitializationExpression(parameter, "Split(-0.9, -.1, .1, 0.9)");
                        } else {
                            expressionString = "Split(-1.0, -.5, .5, 1.0)";
                            this.setParameterEstimationInitializationExpression(parameter, "Split(-1.0, -.5, .5, 1.0)");
                        }
                    }
                    this.setStartsWithParametersTemplate("s", "Split(-1, -.5, .5, 1.0)");
                    this.setStartsWithParametersEstimationInitializaationTemplate("s", "Split(-1.5, -.5, .5, 1.5)");
                }
            }
            for (Node node : this.errorNodes) {
                if (node == null) continue;
                String template = this.getErrorsTemplate();
                formula = TemplateExpander.getInstance().expandTemplate(template, this, node);
                this.setNodeExpression(node, formula);
                parameters = this.getReferencedParameters(node);
                this.setStartsWithParametersTemplate("s", "U(1, 3)");
                this.setStartsWithParametersEstimationInitializaationTemplate("s", "U(1, 3)");
                for (String parameter : parameters) {
                    this.setParameterExpression(parameter, "U(1, 3)");
                }
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException("Parse error in constructing initial model.", e);
        }
    }

    public GeneralizedSemPm(SemPm semPm) {
        this(semPm.getGraph());
        try {
            List<Node> variableNodes = this.getVariableNodes();
            for (int i = 0; i < variableNodes.size(); ++i) {
                Node node = variableNodes.get(i);
                ArrayList<Node> parents = new ArrayList<Node>(this.getVariableParents(node));
                StringBuilder buf = new StringBuilder();
                for (int j = 0; j < parents.size(); ++j) {
                    if (!variableNodes.contains(parents.get(j))) continue;
                    Node parent = (Node)parents.get(j);
                    Parameter _parameter = semPm.getParameter(parent, node);
                    String parameter = _parameter.getName();
                    HashSet<Node> nodes = new HashSet<Node>();
                    nodes.add(node);
                    this.referencedParameters.put(parameter, nodes);
                    buf.append(parameter);
                    buf.append("*");
                    buf.append(((Node)parents.get(j)).getName());
                    this.setParameterExpression(parameter, "Split(-1.0, -.0, .0, 1.0)");
                    this.setStartsWithParametersTemplate(parameter.substring(0, 1), "Split(-1.0, -.0, .0, 1.0)");
                    this.setStartsWithParametersEstimationInitializaationTemplate(parameter.substring(0, 1), "Split(-1.5, -.5, .5, 1.5)");
                    if (j >= parents.size() - 1) continue;
                    buf.append(" + ");
                }
                if (buf.toString().trim().length() != 0) {
                    buf.append(" + ");
                }
                buf.append(this.errorNodes.get(i));
                this.setNodeExpression(node, buf.toString());
            }
            for (Node node : variableNodes) {
                Parameter _parameter = semPm.getParameter(node, node);
                String parameter = _parameter.getName();
                String distributionFormula = "N(0," + parameter + ")";
                this.setNodeExpression(this.getErrorNode(node), distributionFormula);
                this.setParameterExpression(parameter, "U(0, 1)");
                this.setStartsWithParametersTemplate(parameter.substring(0, 1), "U(0, 1)");
                this.setStartsWithParametersEstimationInitializaationTemplate(parameter.substring(0, 1), "U(0, 1)");
            }
            this.variableNames = new ArrayList<String>();
            for (Node _node : variableNodes) {
                this.variableNames.add(_node.getName());
            }
            for (Node _node : this.errorNodes) {
                this.variableNames.add(_node.getName());
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException("Parse error in constructing initial model.", e);
        }
    }

    public GeneralizedSemPm(GeneralizedSemPm semPm) {
        this.graph = new SemGraph(semPm.graph);
        this.nodes = new ArrayList<Node>(semPm.nodes);
        this.variableNodes = new ArrayList<Node>(semPm.variableNodes);
        this.measuredNodes = new ArrayList<Node>(semPm.measuredNodes);
        this.errorNodes = new ArrayList<Node>(semPm.errorNodes);
        this.referencedParameters = new HashMap<String, Set<Node>>();
        this.referencedNodes = new HashMap<Node, Set<Node>>();
        this.parameterEstimationInitializationExpressions = new HashMap<String, Expression>(semPm.parameterEstimationInitializationExpressions);
        this.parametersEstimationInitializationTemplate = semPm.parametersEstimationInitializationTemplate;
        for (String parameter : semPm.referencedParameters.keySet()) {
            this.referencedParameters.put(parameter, new HashSet(semPm.referencedParameters.get(parameter)));
        }
        for (Node node : semPm.referencedNodes.keySet()) {
            this.referencedNodes.put(node, new HashSet(semPm.referencedNodes.get(node)));
        }
        this.nodeExpressions = new HashMap<Node, Expression>(semPm.nodeExpressions);
        this.nodeExpressionStrings = new HashMap<Node, String>(semPm.nodeExpressionStrings);
        this.parameterExpressions = new HashMap<String, Expression>(semPm.parameterExpressions);
        this.parameterExpressionStrings = new HashMap<String, String>(semPm.parameterExpressionStrings);
        this.parameterEstimationInitializationExpressions = new HashMap<String, Expression>(semPm.parameterEstimationInitializationExpressions);
        this.parameterEstimationInitializationExpressionStrings = new HashMap<String, String>(semPm.parameterEstimationInitializationExpressionStrings);
        this.variablesTemplate = semPm.variablesTemplate;
        this.errorsTemplate = semPm.errorsTemplate;
        this.parametersTemplate = semPm.parametersTemplate;
        this.variableNames = semPm.variableNames == null ? new ArrayList<String>() : new ArrayList<String>(semPm.variableNames);
        this.startsWithParametersTemplates = new HashMap<String, String>(semPm.startsWithParametersTemplates);
        this.startsWithParametersEstimationInitializationTemplates = new HashMap<String, String>(semPm.startsWithParametersEstimationInitializationTemplates);
    }

    public static GeneralizedSemPm serializableInstance() {
        Dag dag = new Dag();
        GraphNode node1 = new GraphNode("X");
        dag.addNode(node1);
        return new GeneralizedSemPm(Dag.serializableInstance());
    }

    public static List<String> getParameterNames() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("generalSemFunctionTemplateMeasured");
        parameters.add("generalSemFunctionTemplateLatent");
        parameters.add("generalSemErrorTemplate");
        parameters.add("generalSemParameterTemplate");
        return parameters;
    }

    public Expression getNodeExpression(Node node) {
        return this.nodeExpressions.get(node);
    }

    public String getNodeExpressionString(Node node) {
        return this.nodeExpressionStrings.get(node);
    }

    public void setNodeExpression(Node node, String expressionString) throws ParseException {
        Set<Node> nodes;
        if (node == null) {
            throw new NullPointerException("Node was null.");
        }
        if (expressionString == null) {
            throw new NullPointerException("Expression string was null.");
        }
        ExpressionParser parser = new ExpressionParser();
        Expression expression = parser.parseExpression(expressionString);
        List<String> parameterNames = parser.getParameters();
        List<Node> parents = this.graph.getParents(node);
        LinkedList<String> parentNames = new LinkedList<String>();
        for (Node node2 : parents) {
            parentNames.add(node2.getName());
        }
        parameterNames.removeAll(this.variableNames);
        for (Node node3 : this.nodes) {
            parameterNames.remove(node3.getName());
        }
        LinkedList<String> parametersToRemove = new LinkedList<String>();
        for (String parameter : this.referencedParameters.keySet()) {
            nodes = this.referencedParameters.get(parameter);
            nodes.remove(node);
            if (!nodes.isEmpty()) continue;
            parametersToRemove.add(parameter);
        }
        for (String parameter : parametersToRemove) {
            this.referencedParameters.remove(parameter);
            this.parameterExpressions.remove(parameter);
            this.parameterExpressionStrings.remove(parameter);
            this.parameterEstimationInitializationExpressions.remove(parameter);
            this.parameterEstimationInitializationExpressionStrings.remove(parameter);
        }
        for (String parameter : parameterNames) {
            this.referencedParameters.computeIfAbsent(parameter, k -> new HashSet());
            nodes = this.referencedParameters.get(parameter);
            nodes.add(node);
            this.setSuitableParameterDistribution(parameter);
        }
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (Node _node : this.referencedNodes.keySet()) {
            Set<Node> nodes2 = this.referencedNodes.get(_node);
            nodes2.remove(node);
            if (!nodes2.isEmpty()) continue;
            linkedList.add(_node);
        }
        for (Node _node : linkedList) {
            this.referencedNodes.remove(_node);
        }
        for (String variableString : this.variableNames) {
            Node _node = this.getNode(variableString);
            this.referencedNodes.computeIfAbsent(_node, k -> new HashSet());
            for (String s : parentNames) {
                if (!s.equals(variableString)) continue;
                Set<Node> nodes3 = this.referencedNodes.get(_node);
                nodes3.add(node);
            }
        }
        this.nodeExpressions.put(node, expression);
        this.nodeExpressionStrings.put(node, expressionString);
    }

    private void setSuitableParameterDistribution(String parameter) throws ParseException {
        boolean found = false;
        for (String prefix : this.startsWithParametersTemplates.keySet()) {
            if (!parameter.startsWith(prefix)) continue;
            if (this.parameterExpressions.get(parameter) == null) {
                this.setParameterExpression(parameter, this.startsWithParametersTemplates.get(prefix));
            }
            if (this.parameterEstimationInitializationExpressions.get(parameter) == null) {
                this.setParameterEstimationInitializationExpression(parameter, this.startsWithParametersTemplates.get(prefix));
            }
            found = true;
        }
        if (!found) {
            if (this.parameterExpressions.get(parameter) == null) {
                this.setParameterExpression(parameter, this.getParametersTemplate());
            }
            if (this.parameterEstimationInitializationExpressions.get(parameter) == null) {
                this.setParameterEstimationInitializationExpression(parameter, this.getParametersTemplate());
            }
        }
    }

    public void setParameterExpression(String parameter, String expressionString) throws ParseException {
        if (parameter == null) {
            throw new NullPointerException("Parameter was null.");
        }
        if (expressionString == null) {
            throw new NullPointerException("Expression string was null.");
        }
        ExpressionParser parser = new ExpressionParser();
        Expression expression = parser.parseExpression(expressionString);
        List<String> parameterNames = parser.getParameters();
        if (parameterNames.size() > 0) {
            throw new IllegalArgumentException("Initial distribution for a parameter may not contain parameters: " + expressionString);
        }
        this.parameterExpressions.put(parameter, expression);
        this.parameterExpressionStrings.put(parameter, expressionString);
    }

    public void setParameterEstimationInitializationExpression(String parameter, String expressionString) throws ParseException {
        if (parameter == null) {
            throw new NullPointerException("Parameter was null.");
        }
        if (expressionString == null) {
            throw new NullPointerException("Expression string was null.");
        }
        ExpressionParser parser = new ExpressionParser();
        Expression expression = parser.parseExpression(expressionString);
        List<String> parameterNames = parser.getParameters();
        if (parameterNames.size() > 0) {
            throw new IllegalArgumentException("Initial distribution may not contain parameters: " + expressionString);
        }
        this.parameterEstimationInitializationExpressions.put(parameter, expression);
        this.parameterEstimationInitializationExpressionStrings.put(parameter, expressionString);
    }

    public void setParameterExpression(String startsWith, String parameter, String expressionString) throws ParseException {
        if (parameter == null) {
            throw new NullPointerException("Parameter was null.");
        }
        if (startsWith == null) {
            throw new NullPointerException("StartsWith expression was null.");
        }
        if (startsWith.contains(" ")) {
            throw new IllegalArgumentException("StartsWith expression contains spaces.");
        }
        if (expressionString == null) {
            throw new NullPointerException("Expression string was null.");
        }
        ExpressionParser parser = new ExpressionParser();
        Expression expression = parser.parseExpression(expressionString);
        List<String> parameterNames = parser.getParameters();
        if (parameterNames.size() > 0) {
            throw new IllegalArgumentException("Initial distribution may not contain parameters: " + expressionString);
        }
        this.parameterExpressions.put(parameter, expression);
        this.parameterExpressionStrings.put(parameter, expressionString);
        this.startsWithParametersTemplates.put(startsWith, expressionString);
    }

    public void setParameterEstimationInitializationExpression(String startsWith, String parameter, String expressionString) throws ParseException {
        if (parameter == null) {
            throw new NullPointerException("Parameter was null.");
        }
        if (startsWith == null) {
            throw new NullPointerException("StartsWith expression was null.");
        }
        if (startsWith.contains(" ")) {
            throw new IllegalArgumentException("StartsWith expression contains spaces.");
        }
        if (expressionString == null) {
            throw new NullPointerException("Expression string was null.");
        }
        ExpressionParser parser = new ExpressionParser();
        Expression expression = parser.parseExpression(expressionString);
        List<String> parameterNames = parser.getParameters();
        if (parameterNames.size() > 0) {
            throw new IllegalArgumentException("Initial distribution may not contain parameters: " + expressionString);
        }
        this.parameterEstimationInitializationExpressions.put(parameter, expression);
        this.parameterEstimationInitializationExpressionStrings.put(parameter, expressionString);
        this.startsWithParametersTemplates.put(startsWith, expressionString);
    }

    public Set<String> getParameters() {
        return new HashSet<String>(this.parameterExpressions.keySet());
    }

    public Expression getParameterExpression(String parameter) {
        return this.parameterExpressions.get(parameter);
    }

    public Expression getParameterEstimationInitializationExpression(String parameter) {
        return this.parameterEstimationInitializationExpressions.get(parameter);
    }

    public String getParameterExpressionString(String parameter) {
        return this.parameterExpressionStrings.get(parameter);
    }

    public String getParameterEstimationInitializationExpressionString(String parameter) {
        return this.parameterEstimationInitializationExpressionStrings.get(parameter);
    }

    public SemGraph getGraph() {
        return new SemGraph(this.graph);
    }

    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes);
    }

    public List<Node> getVariableNodes() {
        return new ArrayList<Node>(this.variableNodes);
    }

    public List<Node> getMeasuredNodes() {
        return new ArrayList<Node>(this.measuredNodes);
    }

    public List<Node> getErrorNodes() {
        return new ArrayList<Node>(this.errorNodes);
    }

    public Node getErrorNode(Node node) {
        if (this.errorNodes.contains(node)) {
            return node;
        }
        int index = this.variableNodes.indexOf(node);
        if (index == -1) {
            return null;
        }
        return this.errorNodes.get(index);
    }

    public Node getNode(String name) {
        return this.namesToNodes.get(name);
    }

    public Set<Node> getReferencingNodes(String parameter) {
        Set<Node> set = this.referencedParameters.get(parameter);
        return set == null ? new HashSet<Node>() : new HashSet<Node>(set);
    }

    public Set<String> getReferencedParameters(Node node) {
        HashSet<String> parameters = new HashSet<String>();
        for (String parameter : this.referencedParameters.keySet()) {
            if (!this.referencedParameters.get(parameter).contains(node)) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    public Set<Node> getReferencingNodes(Node node) {
        Set<Node> set = this.referencedNodes.get(node);
        return set == null ? new HashSet<Node>() : new HashSet<Node>(set);
    }

    public Set<Node> getReferencedNodes(Node node) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (Node _node : this.referencedNodes.keySet()) {
            if (!this.referencedNodes.get(_node).contains(node)) continue;
            nodes.add(_node);
        }
        return nodes;
    }

    public String nextParameterName(String base) {
        if (this.graph.getNode(base) != null) {
            throw new IllegalArgumentException(base + " is a variable name.");
        }
        int subscript = 0;
        if (this.parameterSubscript.containsKey(base)) {
            subscript = this.parameterSubscript.get(base);
        }
        this.parameterSubscript.put(base, ++subscript);
        return base + subscript;
    }

    public List<Node> getParents(Node node) {
        List<Node> parents = this.graph.getParents(node);
        parents = this.putErrorNodesLast(parents);
        return new ArrayList<Node>(parents);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nEquations:\n");
        for (Node node : this.variableNodes) {
            buf.append("\n").append(node).append(" = ").append(this.nodeExpressionStrings.get(node));
        }
        buf.append("\n\nErrors:\n");
        for (Node node : this.errorNodes) {
            buf.append("\n").append(node).append(" ~ ").append(this.nodeExpressionStrings.get(node));
        }
        buf.append("\n\nParameters:\n");
        for (String param : this.getParameters()) {
            buf.append("\n").append(param).append(" ~ ").append(this.getParameterExpressionString(param));
        }
        return buf.toString();
    }

    private Set<Node> getVariableParents(Node node) {
        List<Node> allParents = this.graph.getParents(node);
        HashSet<Node> parents = new HashSet<Node>();
        for (Node _parent : allParents) {
            if (_parent.getNodeType() == NodeType.ERROR) continue;
            parents.add(_parent);
        }
        return parents;
    }

    private List<Node> putErrorNodesLast(List<Node> parents) {
        ArrayList<Node> sortedNodes = new ArrayList<Node>();
        for (Node node : parents) {
            if (node.getNodeType() == NodeType.ERROR) continue;
            sortedNodes.add(node);
        }
        for (Node node : parents) {
            if (node.getNodeType() != NodeType.ERROR) continue;
            sortedNodes.add(node);
        }
        return sortedNodes;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public String getVariablesTemplate() {
        return this.variablesTemplate;
    }

    public void setVariablesTemplate(String variablesTemplate) throws ParseException {
        if (variablesTemplate == null) {
            throw new NullPointerException();
        }
        ExpressionParser parser = new ExpressionParser();
        parser.parseExpression(variablesTemplate);
        this.variablesTemplate = variablesTemplate;
    }

    public String getErrorsTemplate() {
        return this.errorsTemplate;
    }

    public void setErrorsTemplate(String errorsTemplate) throws ParseException {
        if (errorsTemplate == null) {
            throw new NullPointerException();
        }
        ExpressionParser parser = new ExpressionParser();
        parser.parseExpression(errorsTemplate);
        this.errorsTemplate = errorsTemplate;
    }

    public String getParametersTemplate() {
        return this.parametersTemplate;
    }

    public void setParametersTemplate(String parametersTemplate) throws ParseException {
        if (parametersTemplate == null) {
            throw new NullPointerException();
        }
        ExpressionParser parser = new ExpressionParser();
        Expression expression = parser.parseExpression(parametersTemplate);
        List<String> parameterNames = parser.getParameters();
        if (!parameterNames.isEmpty()) {
            throw new IllegalArgumentException("Initial distribution for a parameter may not contain parameters: " + expression.toString());
        }
        this.parametersTemplate = parametersTemplate;
    }

    public String getParametersEstimationInitializationTemplate() {
        return this.parametersEstimationInitializationTemplate;
    }

    public void setParametersEstimationInitializationTemplate(String parametersTemplate) throws ParseException {
        if (parametersTemplate == null) {
            throw new NullPointerException();
        }
        ExpressionParser parser = new ExpressionParser();
        parser.parseExpression(parametersTemplate);
        this.parametersEstimationInitializationTemplate = parametersTemplate;
    }

    public void setStartsWithParametersTemplate(String startsWith, String parametersTemplate) throws ParseException {
        if (startsWith == null || startsWith.isEmpty()) {
            return;
        }
        if (parametersTemplate == null) {
            throw new NullPointerException();
        }
        ExpressionParser parser = new ExpressionParser();
        parser.parseExpression(parametersTemplate);
        if (startsWith.contains(" ")) {
            throw new IllegalArgumentException("Starts with string contains spaces.");
        }
        this.startsWithParametersTemplates.put(startsWith, parametersTemplate);
    }

    public void setStartsWithParametersEstimationInitializaationTemplate(String startsWith, String parametersEstimationInitializationTemplate) throws ParseException {
        if (startsWith == null || startsWith.isEmpty()) {
            return;
        }
        if (this.parametersTemplate == null) {
            throw new NullPointerException();
        }
        ExpressionParser parser = new ExpressionParser();
        parser.parseExpression(parametersEstimationInitializationTemplate);
        if (startsWith.contains(" ")) {
            throw new IllegalArgumentException("Starts with string contains spaces.");
        }
        this.startsWithParametersEstimationInitializationTemplates.put(startsWith, parametersEstimationInitializationTemplate);
    }

    public String getStartsWithParameterTemplate(String startsWith) {
        return this.startsWithParametersTemplates.get(startsWith);
    }

    public String getStartsWithParameterEstimationInitializatonTemplate(String startsWith) {
        return this.startsWithParametersEstimationInitializationTemplates.get(startsWith);
    }

    public Set<String> startsWithPrefixes() {
        return this.startsWithParametersTemplates.keySet();
    }
}

