/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.dist.Distribution;
import edu.cmu.tetrad.util.dist.Normal;
import java.io.IOException;
import java.io.ObjectInputStream;

public final class Parameter
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private static final Distribution DEFAULT_DISTRIBUTION = new Normal(0.0, 1.0);
    private final Node nodeA;
    private final Node nodeB;
    private final ParamType type;
    private String name;
    private boolean fixed;
    private boolean initializedRandomly = true;
    private Distribution distribution = DEFAULT_DISTRIBUTION;
    private double startingValue = 1.0;

    public Parameter(String name, ParamType type, Node nodeA, Node nodeB) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        if (type == null) {
            throw new NullPointerException("ParamType must not be null.");
        }
        if (nodeA == null) {
            throw new NullPointerException("Node A must not be null.");
        }
        if (nodeB == null) {
            throw new NullPointerException("Node B must not be null.");
        }
        if (type == ParamType.VAR && nodeA != nodeB) {
            throw new IllegalArgumentException("Variance parameters must have nodeA and nodeB the same.");
        }
        if (type == ParamType.COVAR && nodeA == nodeB) {
            throw new IllegalArgumentException("Covariance parameters must have nodeA and nodeB different.");
        }
        this.name = name;
        this.type = type;
        this.nodeA = nodeA;
        this.nodeB = nodeB;
    }

    public static Parameter serializableInstance() {
        return new Parameter("X", ParamType.COEF, new GraphNode("X"), new GraphNode("Y"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!NamingProtocol.isLegalName(name)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        this.name = name;
    }

    public String toString() {
        return "<" + this.name + ", " + this.type + ", " + this.nodeA + ", " + this.nodeB + ", " + (this.fixed ? "fixed" : "free") + ">";
    }

    public Node getNodeA() {
        return this.nodeA;
    }

    public Node getNodeB() {
        return this.nodeB;
    }

    public ParamType getType() {
        return this.type;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public void setDistribution(Distribution distribution) {
        if (distribution == null) {
            throw new NullPointerException("Distribution must not be null.");
        }
        this.distribution = distribution;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public double getStartingValue() {
        return this.startingValue;
    }

    public void setStartingValue(double startingValue) {
        this.startingValue = startingValue;
    }

    public boolean isInitializedRandomly() {
        return this.initializedRandomly;
    }

    public void setInitializedRandomly(boolean initializedRandomly) {
        this.initializedRandomly = initializedRandomly;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.name == null) {
            throw new NullPointerException();
        }
        if (this.distribution == null) {
            throw new NullPointerException();
        }
        if (this.type == ParamType.VAR && this.nodeA != this.nodeB) {
            throw new IllegalStateException();
        }
        if (this.type == ParamType.COVAR && this.nodeA == this.nodeB) {
            throw new IllegalStateException();
        }
    }
}

