/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.ScoreType;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerPowell;
import edu.cmu.tetrad.sem.SemPm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;

public class ReidentifyVariables {
    public static List<String> reidentifyVariables1(List<List<Node>> partition, Graph trueGraph) {
        ArrayList<String> names = new ArrayList<String>();
        for (List<Node> _partition : partition) {
            boolean added = false;
            for (Node _latent : trueGraph.getNodes()) {
                List<Node> trueChildren = trueGraph.getChildren(_latent);
                trueChildren.removeIf(node2 -> node2.getNodeType() == NodeType.LATENT);
                boolean containsAll = true;
                Node latent = _latent;
                for (Node child : _partition) {
                    boolean contains = false;
                    for (Node _child : trueChildren) {
                        if (!child.getName().equals(_child.getName())) continue;
                        contains = true;
                        break;
                    }
                    if (contains) continue;
                    containsAll = false;
                    break;
                }
                if (!containsAll) continue;
                String name = latent.getName();
                while (names.contains(name)) {
                    name = name + "*";
                }
                names.add(name);
                for (Node child : _partition) {
                    if (_partition.contains(child)) continue;
                    _partition.add(child);
                }
                added = true;
                break;
            }
            if (added) continue;
            String name = "M*";
            while (names.contains(name)) {
                name = name + "*";
            }
            names.add(name);
            for (Node child : _partition) {
                if (_partition.contains(child)) continue;
                _partition.add(child);
            }
        }
        return names;
    }

    public static List<String> reidentifyVariables2(List<List<Node>> clusters, Graph trueGraph, DataSet data) {
        trueGraph = GraphUtils.replaceNodes(trueGraph, data.getVariables());
        HashMap<Node, SemIm> ims = new HashMap<Node, SemIm>();
        ArrayList<String> latentNames = new ArrayList<String>();
        for (Node node : trueGraph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            List<Node> list = trueGraph.getChildren(node);
            ReidentifyVariables.getLatents(trueGraph).forEach(list::remove);
            ArrayList<Node> all = new ArrayList<Node>();
            all.add(node);
            all.addAll(list);
            Graph subgraph = trueGraph.subgraph(all);
            SemPm pm = new SemPm(subgraph);
            pm.fixOneLoadingPerLatent();
            SemOptimizerPowell semOptimizer = new SemOptimizerPowell();
            SemEstimator est = new SemEstimator(data, pm, (SemOptimizer)semOptimizer);
            est.setScoreType(ScoreType.Fgls);
            SemIm im = est.estimate();
            ims.put(node, im);
        }
        HashMap<List, String> clustersToNames = new HashMap<List, String>();
        for (List<Node> list : clusters) {
            double maxSum = Double.NEGATIVE_INFINITY;
            Node maxLatent = null;
            for (Node _latent : trueGraph.getNodes()) {
                double sum;
                if (_latent.getNodeType() != NodeType.LATENT || !((sum = ReidentifyVariables.sumOfAbsLoadings(list, _latent, trueGraph, ims)) > maxSum)) continue;
                maxSum = sum;
                maxLatent = _latent;
            }
            if (maxLatent == null) {
                throw new NullPointerException("No such latent");
            }
            String name = maxLatent.getName();
            latentNames.add(name);
            clustersToNames.put(list, name);
        }
        HashSet hashSet = new HashSet(clustersToNames.values());
        for (String key : hashSet) {
            double maxSum = Double.NEGATIVE_INFINITY;
            List maxCluster = null;
            for (List _cluster : clustersToNames.keySet()) {
                double sum;
                if (!((String)clustersToNames.get(_cluster)).equals(key) || !((sum = ReidentifyVariables.sumOfAbsLoadings(_cluster, trueGraph.getNode(key), trueGraph, ims)) > Double.NEGATIVE_INFINITY)) continue;
                maxCluster = _cluster;
            }
            for (List _cluster : clustersToNames.keySet()) {
                if (!((String)clustersToNames.get(_cluster)).equals(key) || _cluster.equals(maxCluster)) continue;
                String name = key;
                while (latentNames.contains(name)) {
                    name = name + "*";
                }
                clustersToNames.put(_cluster, name);
                latentNames.set(clusters.indexOf(_cluster), name);
            }
        }
        return latentNames;
    }

    private static double sumOfAbsLoadings(List<Node> searchChildren, Node latent, Graph mim, Map<Node, SemIm> ims) {
        double sum = 0.0;
        for (Node child : searchChildren) {
            if (!mim.isParentOf(latent, child)) continue;
            SemIm im = ims.get(latent);
            double coef = im.getEdgeCoef(latent, child);
            sum += FastMath.abs(coef);
        }
        return sum;
    }

    public static List<Node> getLatents(Graph graph) {
        ArrayList<Node> latents = new ArrayList<Node>();
        for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            latents.add(node);
        }
        return latents;
    }
}

