/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemManipulation;
import edu.cmu.tetrad.sem.SemProposition;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public final class SemEvidence
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final SemIm semIm;
    private final SemProposition proposition;
    private final SemManipulation manipulation;

    public SemEvidence(SemIm semIm) {
        if (semIm == null) {
            throw new NullPointerException();
        }
        this.semIm = semIm;
        this.proposition = SemProposition.tautology(semIm);
        this.manipulation = new SemManipulation(semIm);
    }

    public SemEvidence(SemEvidence evidence) {
        this.semIm = evidence.semIm;
        this.proposition = new SemProposition(evidence.proposition);
        this.manipulation = new SemManipulation(evidence.manipulation);
    }

    public static SemEvidence serializableInstance() {
        return new SemEvidence(SemIm.serializableInstance());
    }

    public SemIm getSemIm() {
        return this.semIm;
    }

    public int getNodeIndex(String nodeName) {
        List<Node> nodes = this.semIm.getSemPm().getVariableNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!node.getName().equals(nodeName)) continue;
            return i;
        }
        return -1;
    }

    public int getNodeIndex(Node node) {
        List<Node> nodes = this.semIm.getSemPm().getVariableNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Node _node = nodes.get(i);
            if (node != _node) continue;
            return i;
        }
        return -1;
    }

    public int getNumNodes() {
        return this.semIm.getVariableNodes().size();
    }

    public Node getNode(int nodeIndex) {
        return this.semIm.getVariableNodes().get(nodeIndex);
    }

    public SemProposition getProposition() {
        return this.proposition;
    }

    public boolean isManipulated(int nodeIndex) {
        return this.manipulation.isManipulated(nodeIndex);
    }

    public void setManipulated(int nodeIndex, boolean manipulated) {
        this.manipulation.setManipulated(nodeIndex, manipulated);
    }

    public String toString() {
        List<Node> nodes = this.semIm.getVariableNodes();
        StringBuilder buf = new StringBuilder();
        buf.append("\nEvidence: ");
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            buf.append("\n").append(node).append(" = ").append(this.proposition.getValue(i));
            if (!this.isManipulated(i)) continue;
            buf.append("\tManipulated");
        }
        return buf.toString();
    }

    public List<Node> getNodesInEvidence() {
        List<Node> nodes = this.semIm.getVariableNodes();
        ArrayList<Node> nodesInEvidence = new ArrayList<Node>();
        for (int i = 0; i < nodes.size(); ++i) {
            if (Double.isNaN(this.proposition.getValue(i))) continue;
            nodesInEvidence.add(nodes.get(i));
        }
        return nodesInEvidence;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SemEvidence)) {
            throw new IllegalArgumentException();
        }
        SemEvidence evidence = (SemEvidence)o;
        return this.semIm == evidence.semIm && this.proposition.equals(evidence.proposition) && this.manipulation.equals(evidence.manipulation);
    }

    public int hashCode() {
        int hashCode = 37;
        hashCode = 19 * hashCode + this.semIm.hashCode();
        hashCode = 19 * hashCode + this.proposition.hashCode();
        hashCode = 19 * hashCode + this.manipulation.hashCode();
        return hashCode;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.proposition == null) {
            throw new NullPointerException();
        }
    }
}

