/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataTransforms;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Paths;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.graph.TimeLagGraph;
import edu.cmu.tetrad.regression.RegressionCovariance;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.sem.ConnectionFunction;
import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.sem.Mapping;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.ScoreType;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.SemStdErrorEstimator;
import edu.cmu.tetrad.util.Im;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.Vector;
import edu.cmu.tetrad.util.dist.Distribution;
import edu.cmu.tetrad.util.dist.Split;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.util.FastMath;

public final class SemIm
implements Im,
ISemIm {
    private static final long serialVersionUID = 23L;
    private final SemPm semPm;
    private final List<Node> variableNodes;
    private final List<Node> measuredNodes;
    private final Matrix edgeCoef;
    private final double[] variableMeansStdDev;
    private List<Parameter> freeParameters;
    private List<Parameter> fixedParameters;
    private List<Parameter> meanParameters;
    private Matrix errCovar;
    private double[] variableMeans;
    private Matrix sampleCovarC;
    private int sampleSize;
    private Matrix implCovar;
    private List<Mapping> freeMappings;
    private List<Mapping> fixedMappings;
    private double[] standardErrors;
    private boolean parameterBoundsEnforced = true;
    private boolean estimated;
    private boolean cyclic;
    private boolean cyclicChecked;
    private Parameters params = new Parameters();
    private Map<Node, Distribution> distributions;
    private Map<Node, ConnectionFunction> functions;
    private Map<Node, Integer> variablesHash;
    private Matrix sampleCovInv;
    private ScoreType scoreType = ScoreType.Fml;
    private double errorParam1;
    private double errorParam2 = 1.0;
    private int numRandomCalls = 0;

    public SemIm(SemPm semPm) {
        this(semPm, null, new Parameters());
    }

    public SemIm(SemPm semPm, Parameters params) {
        this(semPm, null, params);
    }

    public SemIm(SemPm semPm, SemIm oldSemIm, Parameters parameters) {
        if (semPm == null) {
            throw new NullPointerException("Sem PM must not be null.");
        }
        this.params = parameters;
        this.sampleSize = parameters.getInt("sampleSize");
        this.semPm = new SemPm(semPm);
        this.variableNodes = Collections.unmodifiableList(semPm.getVariableNodes());
        this.measuredNodes = Collections.unmodifiableList(semPm.getMeasuredNodes());
        int numVars = this.variableNodes.size();
        this.edgeCoef = new Matrix(numVars, numVars);
        this.errCovar = new Matrix(numVars, numVars);
        this.variableMeans = new double[numVars];
        this.variableMeansStdDev = new double[numVars];
        this.freeParameters = this.initFreeParameters();
        this.freeMappings = this.createMappings(this.getFreeParameters());
        this.fixedParameters = this.initFixedParameters();
        this.fixedMappings = this.createMappings(this.getFixedParameters());
        this.meanParameters = this.initMeanParameters();
        for (int i = 0; i < numVars; ++i) {
            this.variableMeans[i] = 0.0;
            this.variableMeansStdDev[i] = Double.NaN;
        }
        this.initializeValues();
        if (oldSemIm != null && this.getParams().getBoolean("retainPreviousValues", false)) {
            this.retainPreviousValues(oldSemIm);
        }
        this.distributions = new HashMap<Node, Distribution>();
        this.errorParam1 = parameters.getDouble("simulationParam1");
        this.errorParam2 = parameters.getDouble("simulationParam2");
        this.functions = new HashMap<Node, ConnectionFunction>();
    }

    public SemIm(SemPm semPm, ICovarianceMatrix covMatrix) {
        this(semPm);
        this.setCovMatrix(covMatrix);
    }

    private SemIm(SemIm semIm, Matrix covariances, Vector means) {
        this(semIm);
        if (covariances.getNumRows() != covariances.getNumColumns()) {
            throw new IllegalArgumentException("Expecting covariances to be square.");
        }
        if (!MatrixUtils.isPositiveDefinite(covariances)) {
            throw new IllegalArgumentException("Covariances must be symmetric positive definite.");
        }
        if (means.size() != this.semPm.getVariableNodes().size()) {
            throw new IllegalArgumentException("Number of means does not equal number of variables.");
        }
        if (covariances.getNumRows() != this.semPm.getVariableNodes().size()) {
            throw new IllegalArgumentException("Dimension of covariance matrix does not equal number of variables.");
        }
        this.errCovar = covariances;
        this.variableMeans = means.toArray();
        this.freeParameters = this.initFreeParameters();
        this.freeMappings = this.createMappings(this.getFreeParameters());
        this.fixedParameters = this.initFixedParameters();
        this.fixedMappings = this.createMappings(this.getFixedParameters());
    }

    public SemIm(SemIm semIm) {
        try {
            SemIm _semIm = new MarshalledObject<SemIm>(semIm).get();
            this.semPm = _semIm.semPm;
            this.variableNodes = _semIm.variableNodes;
            this.measuredNodes = _semIm.measuredNodes;
            this.freeParameters = _semIm.freeParameters;
            this.fixedParameters = _semIm.fixedParameters;
            this.meanParameters = _semIm.meanParameters;
            this.edgeCoef = _semIm.edgeCoef;
            this.errCovar = _semIm.errCovar;
            this.variableMeans = _semIm.variableMeans;
            this.variableMeansStdDev = _semIm.variableMeansStdDev;
            this.sampleCovarC = _semIm.sampleCovarC;
            this.sampleSize = _semIm.sampleSize;
            this.implCovar = _semIm.implCovar;
            this.freeMappings = _semIm.freeMappings;
            this.fixedMappings = _semIm.fixedMappings;
            this.standardErrors = _semIm.standardErrors;
            this.parameterBoundsEnforced = _semIm.parameterBoundsEnforced;
            this.estimated = _semIm.estimated;
            this.cyclic = _semIm.cyclic;
            this.distributions = new HashMap<Node, Distribution>(_semIm.distributions);
            this.scoreType = _semIm.scoreType;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("SemIm could not be deep cloned.", e);
        }
    }

    public SemIm(SemPm semPm, List<Node> variableNodes, List<Node> measuredNodes, Matrix edgeCoef, double[] variableMeansStdDev) {
        this.semPm = semPm;
        this.variableNodes = new ArrayList<Node>(variableNodes);
        this.measuredNodes = new ArrayList<Node>(measuredNodes);
        this.edgeCoef = new Matrix(edgeCoef);
        this.variableMeansStdDev = Arrays.copyOf(variableMeansStdDev, variableMeansStdDev.length);
    }

    public static List<String> getParameterNames() {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("coefLow");
        parameters.add("coefHigh");
        parameters.add("covLow");
        parameters.add("covHigh");
        parameters.add("varLow");
        parameters.add("varHigh");
        parameters.add("coefSymmetric");
        parameters.add("covSymmetric");
        return parameters;
    }

    public static SemIm retainValues(SemIm semIm, SemGraph graph) {
        SemPm newSemPm = new SemPm(graph);
        SemIm newSemIm = new SemIm(newSemPm);
        for (Parameter p1 : newSemIm.getSemPm().getParameters()) {
            Node nodeA = semIm.getSemPm().getGraph().getNode(p1.getNodeA().getName());
            Node nodeB = semIm.getSemPm().getGraph().getNode(p1.getNodeB().getName());
            for (Parameter p2 : semIm.getSemPm().getParameters()) {
                if (p2.getNodeA() != nodeA || p2.getNodeB() != nodeB || p2.getType() != p1.getType()) continue;
                newSemIm.setParamValue(p1, semIm.getParamValue(p2));
            }
        }
        newSemIm.sampleSize = semIm.sampleSize;
        return newSemIm;
    }

    public static SemIm serializableInstance() {
        return new SemIm(SemPm.serializableInstance());
    }

    public SemIm updatedIm(Matrix covariances, Vector means) {
        return new SemIm(this, covariances, means);
    }

    public void setCovMatrix(ICovarianceMatrix covMatrix) {
        if (covMatrix == null) {
            throw new NullPointerException("Covariance matrix must not be null.");
        }
        ICovarianceMatrix covMatrix2 = this.fixVarOrder(covMatrix);
        this.sampleCovarC = covMatrix2.getMatrix().copy();
        covMatrix2.getVariables();
        this.sampleSize = covMatrix2.getSampleSize();
        this.sampleCovInv = null;
        if (this.sampleSize < 0) {
            throw new IllegalArgumentException("Sample size out of range: " + this.sampleSize);
        }
    }

    public void setDataSet(DataSet dataSet) {
        this.setCovMatrix(new CovarianceMatrix(dataSet));
    }

    @Override
    public SemPm getSemPm() {
        return this.semPm;
    }

    @Override
    public double[] getFreeParamValues() {
        double[] paramValues = new double[this.freeMappings().size()];
        for (int i = 0; i < this.freeMappings().size(); ++i) {
            Mapping mapping = this.freeMappings().get(i);
            paramValues[i] = mapping.getValue();
        }
        return paramValues;
    }

    @Override
    public void setFreeParamValues(double[] params) {
        if (params.length != this.getNumFreeParams()) {
            throw new IllegalArgumentException("The array provided must be of the same length as the number of free parameters.");
        }
        for (int i = 0; i < this.freeMappings().size(); ++i) {
            Mapping mapping = this.freeMappings().get(i);
            mapping.setValue(params[i]);
        }
    }

    @Override
    public double getParamValue(Parameter parameter) {
        if (parameter == null) {
            throw new NullPointerException();
        }
        if (this.getFreeParameters().contains(parameter)) {
            int index = this.getFreeParameters().indexOf(parameter);
            Mapping mapping = this.freeMappings.get(index);
            return mapping.getValue();
        }
        if (this.getFixedParameters().contains(parameter)) {
            int index = this.getFixedParameters().indexOf(parameter);
            Mapping mapping = this.fixedMappings.get(index);
            return mapping.getValue();
        }
        if (this.getMeanParameters().contains(parameter)) {
            int index = this.getMeanParameters().indexOf(parameter);
            return this.variableMeans[index];
        }
        throw new IllegalArgumentException("Not a parameter in this model: " + parameter);
    }

    @Override
    public void setParamValue(Parameter parameter, double value) {
        if (this.getFreeParameters().contains(parameter)) {
            int index = this.getFreeParameters().indexOf(parameter);
            Mapping mapping = this.freeMappings.get(index);
            mapping.setValue(value);
        } else if (this.getMeanParameters().contains(parameter)) {
            int index = this.getMeanParameters().indexOf(parameter);
            this.variableMeans[index] = value;
        } else {
            throw new IllegalArgumentException("That parameter cannot be set in this model: " + parameter);
        }
    }

    @Override
    public void setFixedParamValue(Parameter parameter, double value) {
        if (!this.getFixedParameters().contains(parameter)) {
            throw new IllegalArgumentException("Not a fixed parameter in this model: " + parameter);
        }
        int index = this.getFixedParameters().indexOf(parameter);
        Mapping mapping = this.fixedMappings.get(index);
        mapping.setValue(value);
    }

    public double getErrVar(Node x) {
        Parameter param = this.semPm.getVarianceParameter(x);
        return this.getParamValue(param);
    }

    public double getErrCovar(Node x, Node y) {
        Parameter param = this.semPm.getCovarianceParameter(x, y);
        return this.getParamValue(param);
    }

    public double getEdgeCoef(Node x, Node y) {
        Parameter param = this.semPm.getCoefficientParameter(x, y);
        return this.getParamValue(param);
    }

    public double getEdgeCoef(Edge edge) {
        if (!Edges.isDirectedEdge(edge)) {
            throw new IllegalArgumentException("Only directed edges have 'edge coefficients'");
        }
        return this.getEdgeCoef(edge.getNode1(), edge.getNode2());
    }

    @Override
    public void setErrVar(Node x, double value) {
        Parameter param = this.semPm.getVarianceParameter(x);
        this.setParamValue(param, value);
    }

    @Override
    public void setEdgeCoef(Node x, Node y, double value) {
        Parameter param = this.semPm.getCoefficientParameter(x, y);
        this.setParamValue(param, value);
    }

    public boolean existsEdgeCoef(Node x, Node y) {
        return x != y && this.semPm.getCoefficientParameter(x, y) != null;
    }

    public void setErrCovar(Node x, double value) {
        SemGraph graph = this.getSemPm().getGraph();
        Node exogenousX = graph.getExogenous(x);
        this.setParamValue(exogenousX, exogenousX, value);
    }

    public void setErrCovar(Node x, Node y, double value) {
        Parameter param = this.semPm.getCovarianceParameter(x, y);
        this.setParamValue(param, value);
    }

    @Override
    public void setMean(Node node, double mean) {
        int index = this.variableNodes.indexOf(node);
        this.variableMeans[index] = mean;
    }

    public void setMeanStandardDeviation(Node node, double mean) {
        int index = this.variableNodes.indexOf(node);
        this.variableMeansStdDev[index] = mean;
    }

    @Override
    public void setIntercept(Node node, double intercept) {
        Node _node;
        int i;
        if (this.isCyclic()) {
            throw new UnsupportedOperationException("Setting and getting of intercepts is supported for acyclic SEMs only. The internal parameterizations uses variable means; the relationship between variable means and intercepts has not been fully worked out for the cyclic case.");
        }
        SemGraph semGraph = this.getSemPm().getGraph();
        System.out.println(semGraph);
        semGraph.setShowErrorTerms(false);
        Paths paths = new Paths(semGraph);
        List<Node> initialOrder = semGraph.getNodes();
        List<Node> tierOrdering = paths.getValidOrder(initialOrder, true);
        double[] intercepts = new double[tierOrdering.size()];
        for (i = 0; i < tierOrdering.size(); ++i) {
            _node = tierOrdering.get(i);
            intercepts[i] = this.getIntercept(_node);
        }
        intercepts[tierOrdering.indexOf((Object)node)] = intercept;
        for (i = 0; i < tierOrdering.size(); ++i) {
            _node = tierOrdering.get(i);
            List<Node> parents = semGraph.getParents(_node);
            double weightedSumOfParentMeans = 0.0;
            for (Node parent : parents) {
                if (parent.getNodeType() == NodeType.ERROR) continue;
                double coef = this.getEdgeCoef(parent, _node);
                double mean = this.getMean(parent);
                weightedSumOfParentMeans += coef * mean;
            }
            double mean = weightedSumOfParentMeans + intercepts[i];
            this.setMean(_node, mean);
        }
    }

    @Override
    public double getIntercept(Node node) {
        node = this.semPm.getGraph().getNode(node.getName());
        if (this.isCyclic()) {
            return Double.NaN;
        }
        SemGraph semGraph = this.getSemPm().getGraph();
        List<Node> parents = semGraph.getParents(node);
        double weightedSumOfParentMeans = 0.0;
        for (Node parent : parents) {
            if (parent.getNodeType() == NodeType.ERROR) continue;
            double coef = this.getEdgeCoef(parent, node);
            double mean = this.getMean(parent);
            weightedSumOfParentMeans += coef * mean;
        }
        double mean = this.getMean(node);
        return mean - weightedSumOfParentMeans;
    }

    @Override
    public double getMean(Node node) {
        int index = this.variableNodes.indexOf(node);
        if (index == -1) {
            System.out.println("Expecting this node: " + node);
            System.out.println("Node list = " + this.variableNodes);
        }
        return this.variableMeans[index];
    }

    public double[] getMeans() {
        double[] means = new double[this.variableMeans.length];
        System.arraycopy(this.variableMeans, 0, means, 0, this.variableMeans.length);
        return means;
    }

    @Override
    public double getMeanStdDev(Node node) {
        int index = this.variableNodes.indexOf(node);
        return this.variableMeansStdDev[index];
    }

    @Override
    public double getVariance(Node node, Matrix implCovar) {
        if (this.getSemPm().getGraph().isExogenous(node)) {
            Parameter parameter = this.getSemPm().getVarianceParameter(node);
            if (parameter == null) {
                return Double.NaN;
            }
            return this.getParamValue(parameter);
        }
        int index = this.variableNodes.indexOf(node);
        return implCovar.get(index, index);
    }

    @Override
    public double getStdDev(Node node, Matrix implCovar) {
        return FastMath.sqrt(this.getVariance(node, implCovar));
    }

    @Override
    public double getParamValue(Node nodeA, Node nodeB) {
        Parameter parameter = null;
        if (nodeA == nodeB) {
            parameter = this.getSemPm().getVarianceParameter(nodeA);
        }
        if (parameter == null) {
            parameter = this.getSemPm().getCovarianceParameter(nodeA, nodeB);
        }
        if (parameter == null) {
            parameter = this.getSemPm().getCoefficientParameter(nodeA, nodeB);
        }
        if (parameter == null) {
            return Double.NaN;
        }
        if (!this.getFreeParameters().contains(parameter)) {
            return Double.NaN;
        }
        return this.getParamValue(parameter);
    }

    @Override
    public void setParamValue(Node nodeA, Node nodeB, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Please remove or impute missing data.");
        }
        if (nodeA == null || nodeB == null) {
            throw new NullPointerException("Nodes must not be null: nodeA = " + nodeA + ", nodeB = " + nodeB);
        }
        Parameter parameter = null;
        if (nodeA == nodeB) {
            parameter = this.getSemPm().getVarianceParameter(nodeA);
        }
        if (parameter == null) {
            parameter = this.getSemPm().getCoefficientParameter(nodeA, nodeB);
        }
        if (parameter == null) {
            parameter = this.getSemPm().getCovarianceParameter(nodeA, nodeB);
        }
        if (parameter == null) {
            throw new IllegalArgumentException("There is no parameter in model for an edge from " + nodeA + " to " + nodeB + ".");
        }
        if (!this.getFreeParameters().contains(parameter)) {
            throw new IllegalArgumentException("Not a free parameter in this model: " + parameter);
        }
        this.setParamValue(parameter, value);
    }

    @Override
    public List<Parameter> getFreeParameters() {
        return this.freeParameters;
    }

    @Override
    public int getNumFreeParams() {
        return this.getFreeParameters().size();
    }

    @Override
    public List<Parameter> getFixedParameters() {
        return this.fixedParameters;
    }

    private List<Parameter> getMeanParameters() {
        return this.meanParameters;
    }

    public int getNumFixedParams() {
        return this.getFixedParameters().size();
    }

    @Override
    public List<Node> getVariableNodes() {
        return this.variableNodes;
    }

    @Override
    public List<Node> getMeasuredNodes() {
        return this.measuredNodes;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    public Matrix getEdgeCoef() {
        return this.edgeCoef.copy();
    }

    public Matrix getErrCovar() {
        return this.errCovar().copy();
    }

    @Override
    public Matrix getImplCovar(boolean recalculate) {
        if (!recalculate && this.implCovar != null) {
            return this.implCovar;
        }
        return this.implCovar();
    }

    @Override
    public Matrix getImplCovarMeas() {
        return this.implCovarMeas().copy();
    }

    public Matrix getSampleCovar() {
        return this.sampleCovarC == null ? null : this.sampleCovarC.copy();
    }

    @Override
    public double getScore() {
        if (this.scoreType == ScoreType.Fml) {
            return this.getFml2();
        }
        if (this.scoreType == ScoreType.Fgls) {
            return this.getFgls();
        }
        throw new IllegalStateException("Unrecognized score type; " + (Object)((Object)this.scoreType));
    }

    private double getFml2() {
        double fml;
        Matrix sigma;
        try {
            sigma = this.implCovarMeas();
        }
        catch (Exception e) {
            return Double.NaN;
        }
        Matrix s = this.sampleCovarC;
        try {
            fml = FastMath.log(sigma.det()) + s.times(sigma.inverse()).trace() - FastMath.log(s.det()) - (double)this.getMeasuredNodes().size();
        }
        catch (Exception e) {
            return Double.NaN;
        }
        return fml;
    }

    private double getFgls() {
        Matrix implCovarMeas;
        try {
            implCovarMeas = this.implCovarMeas();
        }
        catch (Exception e) {
            return Double.NaN;
        }
        if (this.sampleCovInv == null) {
            Matrix sampleCovar = this.sampleCovarC;
            this.sampleCovInv = sampleCovar.inverse();
        }
        Matrix I = Matrix.identity(implCovarMeas.getNumRows());
        Matrix diff = I.minus(implCovarMeas.times(this.sampleCovInv));
        return 0.5 * diff.times(diff).trace();
    }

    public double getTruncLL() {
        Matrix Sigma2 = this.implCovarMeas();
        Matrix S = this.sampleCovarC;
        int n = this.getSampleSize();
        return (double)(-(n - 1)) / 2.0 * (this.logDet(Sigma2) + this.traceAInvB(Sigma2, S));
    }

    @Override
    public double getBicScore() {
        int dof = this.getSemPm().getDof();
        return this.getChiSquare() - (double)dof * FastMath.log(this.sampleSize);
    }

    @Override
    public double getRmsea() {
        double v = this.getChiSquare() - (double)this.semPm.getDof();
        double v1 = this.semPm.getDof() * (this.getSampleSize() - 1);
        return FastMath.sqrt(v) / FastMath.sqrt(v1);
    }

    @Override
    public double getCfi() {
        if (this.getSampleCovar() == null) {
            return Double.NaN;
        }
        SemIm nullIm = this.independenceModel();
        double nullChiSq = nullIm.getChiSquare();
        double dNull = nullChiSq - (double)nullIm.getSemPm().getDof();
        double dProposed = this.getChiSquare() - (double)this.getSemPm().getDof();
        return (dNull - dProposed) / dNull;
    }

    private SemIm independenceModel() {
        SemGraph nullModel = new SemGraph(this.getSemPm().getGraph());
        nullModel.removeEdges(nullModel.getEdges());
        SemPm nullPm = new SemPm((Graph)nullModel);
        CovarianceMatrix sampleCovar = new CovarianceMatrix(this.getMeasuredNodes(), this.getSampleCovar(), this.getSampleSize());
        return new SemEstimator(sampleCovar, nullPm).estimate();
    }

    @Override
    public double getChiSquare() {
        return (double)(this.getSampleSize() - 1) * this.getScore();
    }

    @Override
    public double getPValue() {
        double chiSquare = this.getChiSquare();
        int dof = this.semPm.getDof();
        if (dof <= 0) {
            return Double.NaN;
        }
        if (chiSquare < 0.0) {
            return Double.NaN;
        }
        return 1.0 - new ChiSquaredDistribution(dof).cumulativeProbability(chiSquare);
    }

    @Override
    public DataSet simulateData(int sampleSize, boolean latentDataSaved) {
        if (this.semPm.getGraph().isTimeLagModel()) {
            return this.simulateTimeSeries(sampleSize, latentDataSaved);
        }
        return this.simulateDataReducedForm(sampleSize, latentDataSaved);
    }

    public void setScoreType(ScoreType scoreType) {
        if (scoreType == null) {
            scoreType = ScoreType.Fgls;
        }
        this.scoreType = scoreType;
    }

    private DataSet simulateTimeSeries(int sampleSize, boolean latentDataSaved) {
        SemGraph semGraph = new SemGraph(this.semPm.getGraph());
        semGraph.setShowErrorTerms(true);
        TimeLagGraph timeSeriesGraph = this.semPm.getGraph().getTimeLagGraph();
        ArrayList<Node> variables = new ArrayList<Node>();
        List<Node> lag0Nodes = timeSeriesGraph.getLag0Nodes();
        for (Node node : lag0Nodes) {
            ContinuousVariable _node = new ContinuousVariable(timeSeriesGraph.getNodeId(node).getName());
            _node.setNodeType(node.getNodeType());
            variables.add(_node);
        }
        BoxDataSet fullData = new BoxDataSet(new VerticalDoubleDataBox(sampleSize, variables.size()), variables);
        HashMap<Node, Integer> nodeIndices = new HashMap<Node, Integer>();
        for (int i = 0; i < lag0Nodes.size(); ++i) {
            nodeIndices.put(lag0Nodes.get(i), i);
        }
        Graph contemporaneousDag = timeSeriesGraph.subgraph(timeSeriesGraph.getLag0Nodes());
        Paths paths = contemporaneousDag.paths();
        List<Node> initialOrder = contemporaneousDag.getNodes();
        List<Node> tierOrdering = paths.getValidOrder(initialOrder, true);
        for (int currentStep = 0; currentStep < sampleSize; ++currentStep) {
            for (Node to : tierOrdering) {
                List<Node> parents = semGraph.getNodesInTo(to, Endpoint.ARROW);
                double sum = 0.0;
                for (Node parent : parents) {
                    if (parent.getNodeType() == NodeType.ERROR) {
                        if (semGraph.getChildren(parent).size() != 1) continue;
                        Node child = semGraph.getChildren(parent).iterator().next();
                        double paramValue = this.getParamValue(child, child);
                        sum += this.getNextNormal(0.0, paramValue);
                        continue;
                    }
                    TimeLagGraph.NodeId id = timeSeriesGraph.getNodeId(parent);
                    int fromIndex = (Integer)nodeIndices.get(timeSeriesGraph.getNode(id.getName(), 0));
                    int lag = id.getLag();
                    if (currentStep > lag) {
                        double coef = this.getParamValue(parent, to);
                        double fromValue = fullData.getDouble(currentStep - lag, fromIndex);
                        sum += coef * fromValue;
                        continue;
                    }
                    sum += this.getNextNormal(0.0, 0.5);
                }
                if (to.getNodeType() == NodeType.ERROR) continue;
                int toIndex = (Integer)nodeIndices.get(to);
                fullData.setDouble(currentStep, toIndex, sum);
            }
        }
        return latentDataSaved ? fullData : DataTransforms.restrictToMeasured(fullData);
    }

    private double getNextNormal(double mean, double stdDev) {
        ++this.numRandomCalls;
        return RandomUtil.getInstance().nextNormal(mean, stdDev);
    }

    public DataSet simulateDataCholesky(int sampleSize, boolean latentDataSaved) {
        LinkedList<Node> variables = new LinkedList<Node>();
        if (latentDataSaved) {
            variables.addAll(this.getVariableNodes());
        } else {
            variables.addAll(this.getMeasuredNodes());
        }
        ArrayList<Node> newVariables = new ArrayList<Node>();
        for (Node node : variables) {
            ContinuousVariable continuousVariable = new ContinuousVariable(node.getName());
            continuousVariable.setNodeType(node.getNodeType());
            newVariables.add(continuousVariable);
        }
        Matrix impliedCovar = this.implCovar();
        BoxDataSet fullDataSet = new BoxDataSet(new VerticalDoubleDataBox(sampleSize, newVariables.size()), newVariables);
        Matrix cholesky = MatrixUtils.cholesky(impliedCovar);
        block1: for (int row = 0; row < sampleSize; ++row) {
            double[] exoData = new double[cholesky.getNumRows()];
            for (int i = 0; i < exoData.length; ++i) {
                exoData[i] = RandomUtil.getInstance().nextNormal(0.0, 1.0);
            }
            double[] point = new double[exoData.length];
            for (int i = 0; i < exoData.length; ++i) {
                double sum = 0.0;
                for (int j = 0; j <= i; ++j) {
                    sum += cholesky.get(i, j) * exoData[j];
                }
                point[i] = sum;
            }
            for (int col = 0; col < variables.size(); ++col) {
                int index = this.getVariableNodes().indexOf(variables.get(col));
                double value = point[index] + this.variableMeans[col];
                if (Double.isNaN(value) || Double.isInfinite(value)) {
                    throw new IllegalArgumentException("Value out of range: " + value);
                }
                if (this.isSimulatedPositiveDataOnly() && value < 0.0) {
                    --row;
                    continue block1;
                }
                fullDataSet.setDouble(row, col, value);
            }
        }
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataTransforms.restrictToMeasured(fullDataSet);
    }

    public DataSet simulateDataRecursive(int sampleSize, boolean latentDataSaved) {
        return this.simulateDataRecursive(sampleSize, null, latentDataSaved);
    }

    private DataSet simulateDataRecursive(int sampleSize, DataSet initialValues, boolean latentDataSaved) {
        int errorType = this.params.getInt("simulationErrorType");
        LinkedList<Node> variables = new LinkedList<Node>();
        List<Node> variableNodes = this.getVariableNodes();
        for (Node node : variableNodes) {
            ContinuousVariable var = new ContinuousVariable(node.getName());
            var.setNodeType(node.getNodeType());
            variables.add(var);
        }
        BoxDataSet fullDataSet = new BoxDataSet(new VerticalDoubleDataBox(sampleSize, variables.size()), variables);
        EdgeListGraph graph = new EdgeListGraph(this.getSemPm().getGraph());
        Paths paths = graph.paths();
        List<Node> initialOrder = graph.getNodes();
        List<Node> tierOrdering = paths.getValidOrder(initialOrder, true);
        int[] tierIndices = new int[variableNodes.size()];
        for (int i = 0; i < tierIndices.length; ++i) {
            tierIndices[i] = variableNodes.indexOf(tierOrdering.get(i));
        }
        int[][] _parents = new int[variableNodes.size()][];
        for (int i = 0; i < variableNodes.size(); ++i) {
            Node node = variableNodes.get(i);
            ArrayList<Node> parents = new ArrayList<Node>(graph.getParents(node));
            parents.removeIf(_node -> _node.getNodeType() == NodeType.ERROR);
            _parents[i] = new int[parents.size()];
            for (int j = 0; j < parents.size(); ++j) {
                Node _parent = (Node)parents.get(j);
                _parents[i][j] = variableNodes.indexOf(_parent);
            }
        }
        Matrix cholesky = MatrixUtils.cholesky(this.errCovar());
        block4: for (int row = 0; row < sampleSize; ++row) {
            double[] exoData = new double[cholesky.getNumRows()];
            for (int i = 0; i < exoData.length; ++i) {
                if (errorType == 1) {
                    exoData[i] = this.getNextNormal(0.0, FastMath.sqrt(this.errCovar.get(i, i)));
                    continue;
                }
                if (errorType == 2) {
                    exoData[i] = this.getNextUniform();
                    continue;
                }
                if (errorType == 3) {
                    exoData[i] = this.getNextExponential();
                    continue;
                }
                if (errorType == 4) {
                    exoData[i] = this.getNextGumbel();
                    continue;
                }
                if (errorType != 5) continue;
                exoData[i] = this.getNextGamma();
            }
            double[] point = new double[exoData.length];
            for (int i = 0; i < exoData.length; ++i) {
                double sum = 0.0;
                for (int j1 = 0; j1 < exoData.length; ++j1) {
                    sum += cholesky.get(i, j1) * exoData[j1];
                }
                point[i] = sum;
            }
            Vector e = new Vector(point);
            for (int tier = 0; tier < tierOrdering.size(); ++tier) {
                double value;
                Node node = tierOrdering.get(tier);
                ConnectionFunction function = this.functions.get(node);
                int col = tierIndices[tier];
                Distribution distribution = this.distributions.get(node);
                Node node1 = tierOrdering.get(tier);
                Node initNode = null;
                int initCol = -1;
                if (initialValues != null) {
                    initNode = initialValues.getVariable(node1.getName());
                    initCol = initialValues.getColumn(initNode);
                }
                if (_parents[col].length == 0 && initialValues != null && initCol != -1) {
                    int column = initialValues.getColumn(initNode);
                    value = initialValues.getDouble(row, column);
                } else {
                    value = distribution == null ? e.get(col) : distribution.nextRandom();
                }
                if (function != null) {
                    Node[] parents = function.getInputNodes();
                    double[] parentValues = new double[parents.length];
                    for (int j = 0; j < parents.length; ++j) {
                        Node parent = parents[j];
                        int index = variableNodes.indexOf(parent);
                        parentValues[j] = fullDataSet.getDouble(row, index);
                    }
                    value += function.valueAt(parentValues);
                    if (initialValues == null && this.isSimulatedPositiveDataOnly() && value < 0.0) {
                        --row;
                        continue block4;
                    }
                } else {
                    for (int j = 0; j < _parents[col].length; ++j) {
                        int parent = _parents[col][j];
                        double parentValue = fullDataSet.getDouble(row, parent);
                        double parentCoef = this.edgeCoef.get(parent, col);
                        value += parentValue * parentCoef;
                    }
                    if (this.isSimulatedPositiveDataOnly() && value < 0.0) {
                        --row;
                        continue block4;
                    }
                }
                fullDataSet.setDouble(row, col, value);
            }
        }
        for (int i = 0; i < fullDataSet.getNumRows(); ++i) {
            for (int j = 0; j < fullDataSet.getNumColumns(); ++j) {
                fullDataSet.setDouble(i, j, fullDataSet.getDouble(i, j) + this.variableMeans[j]);
            }
        }
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataTransforms.restrictToMeasured(fullDataSet);
    }

    private double getNextGamma() {
        ++this.numRandomCalls;
        return RandomUtil.getInstance().nextGamma(this.errorParam1, this.errorParam2);
    }

    private double getNextGumbel() {
        ++this.numRandomCalls;
        return RandomUtil.getInstance().nextGumbel(this.errorParam1, this.errorParam2);
    }

    private double getNextExponential() {
        ++this.numRandomCalls;
        return RandomUtil.getInstance().nextExponential(this.errorParam1);
    }

    private double getNextUniform() {
        ++this.numRandomCalls;
        return RandomUtil.getInstance().nextUniform(this.errorParam1, this.errorParam2);
    }

    public DataSet simulateDataReducedForm(int sampleSize, boolean latentDataSaved) {
        int errorType = this.params.getInt("simulationErrorType");
        double errorParam1 = this.params.getDouble("simulationParam1");
        double errorParam2 = this.params.getDouble("simulationParam2");
        int numVars = this.getVariableNodes().size();
        Matrix B = this.edgeCoef().transpose();
        Matrix iMinusBInv = Matrix.identity(B.getNumRows()).minus(B).inverse();
        Matrix sim = new Matrix(sampleSize, numVars);
        block0: for (int row = 0; row < sampleSize; ++row) {
            Vector e = new Vector(this.edgeCoef.getNumColumns());
            for (int i = 0; i < e.size(); ++i) {
                if (errorType == 1) {
                    double errCovar = this.errCovar.get(i, i);
                    if (errCovar == 0.0) {
                        e.set(i, 0.0);
                        continue;
                    }
                    e.set(i, RandomUtil.getInstance().nextNormal(0.0, FastMath.sqrt(errCovar)));
                    continue;
                }
                if (errorType == 2) {
                    e.set(i, RandomUtil.getInstance().nextUniform(errorParam1, errorParam2));
                    continue;
                }
                if (errorType == 3) {
                    e.set(i, RandomUtil.getInstance().nextExponential(errorParam1));
                    continue;
                }
                if (errorType == 4) {
                    e.set(i, RandomUtil.getInstance().nextGumbel(errorParam1, errorParam2));
                    continue;
                }
                if (errorType != 5) continue;
                e.set(i, RandomUtil.getInstance().nextGamma(errorParam1, errorParam2));
            }
            Vector sample = iMinusBInv.times(e);
            sim.assignRow(row, sample);
            for (int col = 0; col < sample.size(); ++col) {
                double value = sim.get(row, col) + this.variableMeans[col];
                if (this.isSimulatedPositiveDataOnly() && value < 0.0) {
                    --row;
                    continue block0;
                }
                sim.set(row, col, value);
            }
        }
        ArrayList<Node> continuousVars = new ArrayList<Node>();
        for (Node node : this.getVariableNodes()) {
            ContinuousVariable var = new ContinuousVariable(node.getName());
            var.setNodeType(node.getNodeType());
            continuousVars.add(var);
        }
        BoxDataSet fullDataSet = new BoxDataSet(new DoubleDataBox(sim.toArray()), continuousVars);
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataTransforms.restrictToMeasured(fullDataSet);
    }

    public Vector simulateOneRecord(Vector e) {
        Matrix edgeCoef = this.edgeCoef().copy().transpose();
        Matrix iMinusB = Matrix.identity(edgeCoef.getNumRows()).minus(edgeCoef);
        Matrix inv = iMinusB.inverse();
        return inv.times(e);
    }

    public void initializeValues() {
        Parameter parameter;
        for (Mapping fixedMapping : this.fixedMappings) {
            parameter = fixedMapping.getParameter();
            fixedMapping.setValue(this.initialValue(parameter));
        }
        for (Mapping freeMapping : this.freeMappings) {
            parameter = freeMapping.getParameter();
            freeMapping.setValue(this.initialValue(parameter));
        }
    }

    @Override
    public double getStandardError(Parameter parameter, int maxFreeParams) {
        Matrix sampleCovar = this.getSampleCovar();
        if (sampleCovar == null) {
            return Double.NaN;
        }
        if (this.getFreeParameters().contains(parameter)) {
            if (this.getNumFreeParams() <= maxFreeParams) {
                if (parameter.getNodeA() != parameter.getNodeB()) {
                    Node child;
                    Node parent;
                    Node nodeA = parameter.getNodeA();
                    Node nodeB = parameter.getNodeB();
                    SemGraph graph = this.getSemPm().getGraph();
                    if (graph.isParentOf(nodeA, nodeB)) {
                        parent = nodeA;
                        child = nodeB;
                    } else {
                        parent = nodeB;
                        child = nodeA;
                    }
                    if (child.getName().startsWith("E_")) {
                        return Double.NaN;
                    }
                    CovarianceMatrix cov = new CovarianceMatrix(this.measuredNodes, sampleCovar, this.sampleSize);
                    RegressionCovariance regression = new RegressionCovariance(cov);
                    List<Node> parents = graph.getParents(child);
                    parents.removeIf(node -> node.getName().startsWith("E_"));
                    if (child.getNodeType() != NodeType.LATENT && !this.containsLatent(parents)) {
                        RegressionResult result = regression.regress(child, parents);
                        double[] se = result.getSe();
                        return se[parents.indexOf(parent) + 1];
                    }
                }
                if (this.sampleCovarC == null) {
                    this.standardErrors = null;
                    return Double.NaN;
                }
                int index = this.getFreeParameters().indexOf(parameter);
                double[] doubles = this.standardErrors();
                if (doubles == null) {
                    return Double.NaN;
                }
                return doubles[index];
            }
            return Double.NaN;
        }
        if (this.getFixedParameters().contains(parameter)) {
            return 0.0;
        }
        throw new IllegalArgumentException("That is not a parameter of this model: " + parameter);
    }

    private boolean containsLatent(List<Node> parents) {
        for (Node node : parents) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Node> listUnmeasuredLatents() {
        return this.unmeasuredLatents(this.getSemPm());
    }

    @Override
    public double getTValue(Parameter parameter, int maxFreeParams) {
        return this.getParamValue(parameter) / this.getStandardError(parameter, maxFreeParams);
    }

    @Override
    public double getPValue(Parameter parameter, int maxFreeParams) {
        double tValue = this.getTValue(parameter, maxFreeParams);
        int df = this.getSampleSize() - 1;
        return 2.0 * (1.0 - ProbUtils.tCdf(FastMath.abs(tValue), df));
    }

    @Override
    public boolean isParameterBoundsEnforced() {
        return this.parameterBoundsEnforced;
    }

    @Override
    public void setParameterBoundsEnforced(boolean parameterBoundsEnforced) {
        this.parameterBoundsEnforced = parameterBoundsEnforced;
    }

    @Override
    public boolean isEstimated() {
        return this.estimated;
    }

    public void setEstimated(boolean estimated) {
        this.estimated = estimated;
    }

    @Override
    public boolean isCyclic() {
        if (!this.cyclicChecked) {
            this.cyclic = this.semPm.getGraph().paths().existsDirectedCycle();
            this.cyclicChecked = true;
        }
        return this.cyclic;
    }

    public Node getVariableNode(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        List<Node> variables = this.getVariableNodes();
        for (Node variable : variables) {
            if (!name.equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }

    public String toString() {
        Mapping iMapping;
        int i;
        ArrayList<String> varNames = new ArrayList<String>();
        for (Node node : this.variableNodes) {
            varNames.add(node.getName());
        }
        StringBuilder buf = new StringBuilder();
        buf.append("\nVariable nodes:\n\n");
        buf.append(this.getVariableNodes());
        buf.append("\n\nMeasured nodes:\n\n");
        buf.append(this.getMeasuredNodes());
        buf.append("\n\nEdge coefficient matrix:\n");
        buf.append(MatrixUtils.toStringSquare(this.edgeCoef().toArray(), varNames));
        buf.append("\n\nError covariance matrix:\n");
        buf.append(MatrixUtils.toStringSquare(this.getErrCovar().toArray(), varNames));
        buf.append("\n\nVariable means:\n");
        for (int i2 = 0; i2 < this.getVariableNodes().size(); ++i2) {
            buf.append("\nMean(");
            buf.append(this.getVariableNodes().get(i2));
            buf.append(") = ");
            buf.append(this.variableMeans[i2]);
        }
        buf.append("\n\nSample size = ");
        buf.append(this.sampleSize);
        if (this.sampleCovarC == null) {
            buf.append("\n\nSample covaraince matrix not specified**");
        } else {
            buf.append("\n\nsample cov:\n");
            buf.append(MatrixUtils.toString(this.sampleCovarC.toArray()));
        }
        buf.append("\n\nimplCovar:\n");
        try {
            buf.append(MatrixUtils.toString(this.implCovar().toArray()));
        }
        catch (IllegalFormatException e) {
            e.printStackTrace();
        }
        buf.append("\n\nimplCovarMeas:\n");
        buf.append(MatrixUtils.toString(this.implCovarMeas().toArray()));
        if (this.sampleCovarC != null) {
            buf.append("\n\nmodel chi square = ");
            buf.append(this.getChiSquare());
            buf.append("\nmodel dof = ");
            buf.append(this.semPm.getDof());
            buf.append("\nmodel p-value = ");
            buf.append(this.getPValue());
        }
        buf.append("\n\nfree mappings:\n");
        for (i = 0; i < this.freeMappings.size(); ++i) {
            iMapping = this.freeMappings.get(i);
            buf.append("\n");
            buf.append(i);
            buf.append(". ");
            buf.append(iMapping);
        }
        buf.append("\n\nfixed mappings:\n");
        for (i = 0; i < this.fixedMappings.size(); ++i) {
            iMapping = this.fixedMappings.get(i);
            buf.append("\n");
            buf.append(i);
            buf.append(". ");
            buf.append(iMapping);
        }
        return buf.toString();
    }

    private void retainPreviousValues(SemIm oldSemIm) {
        if (oldSemIm == null) {
            System.out.println("old sem im null");
            return;
        }
        List<Node> nodes = this.semPm.getGraph().getNodes();
        SemGraph oldGraph = oldSemIm.getSemPm().getGraph();
        for (Node nodeA : nodes) {
            for (Node nodeB : nodes) {
                double _value;
                Node _nodeA = oldGraph.getNode(nodeA.getName());
                Node _nodeB = oldGraph.getNode(nodeB.getName());
                if (_nodeA == null || _nodeB == null || Double.isNaN(_value = oldSemIm.getParamValue(_nodeA, _nodeB))) continue;
                try {
                    Parameter _parameter = oldSemIm.getSemPm().getParameter(_nodeA, _nodeB);
                    Parameter parameter = this.getSemPm().getParameter(nodeA, nodeB);
                    if (parameter.getType() != _parameter.getType() || parameter.isFixed()) continue;
                    this.setParamValue(nodeA, nodeB, _value);
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Couldn't set " + nodeA + ", " + nodeB);
                }
            }
        }
    }

    private List<Node> unmeasuredLatents(SemPm semPm) {
        SemGraph graph = semPm.getGraph();
        LinkedList<Node> unmeasuredLatents = new LinkedList<Node>();
        block0: for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            for (Node child : graph.getChildren(node)) {
                if (child.getNodeType() != NodeType.MEASURED) continue;
                continue block0;
            }
            unmeasuredLatents.add(node);
        }
        return unmeasuredLatents;
    }

    private Matrix errCovar() {
        return this.errCovar;
    }

    private Matrix implCovar() {
        this.computeImpliedCovar();
        return this.implCovar;
    }

    private Matrix implCovarMeas() {
        this.computeImpliedCovar();
        int size = this.getMeasuredNodes().size();
        Matrix implCovarMeas = new Matrix(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                Node iNode = this.getMeasuredNodes().get(i);
                Node jNode = this.getMeasuredNodes().get(j);
                if (this.variablesHash == null) {
                    this.variablesHash = new HashMap<Node, Integer>();
                    for (int k = 0; k < this.variableNodes.size(); ++k) {
                        this.variablesHash.put(this.variableNodes.get(k), k);
                    }
                }
                int _i = this.variablesHash.get(iNode);
                int _j = this.variablesHash.get(jNode);
                implCovarMeas.set(i, j, this.implCovar.get(_i, _j));
            }
        }
        return implCovarMeas;
    }

    private List<Parameter> initFreeParameters() {
        return Collections.unmodifiableList(this.semPm.getFreeParameters());
    }

    private double initialValue(Parameter parameter) {
        if (!this.getSemPm().getParameters().contains(parameter)) {
            throw new IllegalArgumentException("Not a parameter for this SEM: " + parameter);
        }
        if (parameter.isInitializedRandomly()) {
            if (parameter.getType() == ParamType.COEF) {
                double coefLow = this.getParams().getDouble("coefLow", 0.0);
                double coefHigh = this.getParams().getDouble("coefHigh", 1.0);
                double value = new Split(coefLow, coefHigh).nextRandom();
                if (this.getParams().getBoolean("coefSymmetric", true)) {
                    return value;
                }
                return FastMath.abs(value);
            }
            if (parameter.getType() == ParamType.COVAR) {
                double covLow = this.getParams().getDouble("covLow", 0.1);
                double covHigh = this.getParams().getDouble("covHigh", 0.2);
                double value = new Split(covLow, covHigh).nextRandom();
                if (this.getParams().getBoolean("covSymmetric", true)) {
                    return value;
                }
                return FastMath.abs(value);
            }
            return RandomUtil.getInstance().nextUniform(this.getParams().getDouble("varLow", 1.0), this.getParams().getDouble("varHigh", 3.0));
        }
        return parameter.getStartingValue();
    }

    private List<Mapping> freeMappings() {
        return this.freeMappings;
    }

    private ICovarianceMatrix fixVarOrder(ICovarianceMatrix covMatrix) {
        ArrayList<String> varNamesList = new ArrayList<String>();
        for (int i = 0; i < this.getMeasuredNodes().size(); ++i) {
            Node node = this.getMeasuredNodes().get(i);
            varNamesList.add(node.getName());
        }
        String[] measuredVarNames = varNamesList.toArray(new String[0]);
        return covMatrix.getSubmatrix(measuredVarNames);
    }

    private List<Mapping> createMappings(List<Parameter> parameters) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        SemGraph graph = this.getSemPm().getGraph();
        for (Parameter parameter : parameters) {
            Mapping mapping;
            Node nodeA = graph.getVarNode(parameter.getNodeA());
            Node nodeB = graph.getVarNode(parameter.getNodeB());
            if (nodeA == null || nodeB == null) {
                throw new IllegalArgumentException("Missing variable--either " + nodeA + " or " + nodeB + " parameter = " + parameter + ".");
            }
            int i = this.getVariableNodes().indexOf(nodeA);
            int j = this.getVariableNodes().indexOf(nodeB);
            if (parameter.getType() == ParamType.COEF) {
                mapping = new Mapping(this, parameter, this.edgeCoef(), i, j);
                mappings.add(mapping);
                continue;
            }
            if (parameter.getType() == ParamType.VAR) {
                mapping = new Mapping(this, parameter, this.errCovar(), i, i);
                mappings.add(mapping);
                continue;
            }
            if (parameter.getType() != ParamType.COVAR) continue;
            mapping = new Mapping(this, parameter, this.errCovar(), i, j);
            mappings.add(mapping);
        }
        return Collections.unmodifiableList(mappings);
    }

    private List<Parameter> initFixedParameters() {
        ArrayList<Parameter> fixedParameters = new ArrayList<Parameter>();
        for (Parameter _parameter : this.getSemPm().getParameters()) {
            ParamType type = _parameter.getType();
            if (type != ParamType.VAR && type != ParamType.COVAR && type != ParamType.COEF || !_parameter.isFixed()) continue;
            fixedParameters.add(_parameter);
        }
        return Collections.unmodifiableList(fixedParameters);
    }

    private List<Parameter> initMeanParameters() {
        ArrayList<Parameter> meanParameters = new ArrayList<Parameter>();
        for (Parameter param : this.getSemPm().getParameters()) {
            if (param.getType() != ParamType.MEAN) continue;
            meanParameters.add(param);
        }
        return Collections.unmodifiableList(meanParameters);
    }

    private void computeImpliedCovar() {
        Matrix edgeCoefT = this.edgeCoef().transpose();
        this.implCovar = MatrixUtils.impliedCovar(edgeCoefT, this.errCovar());
    }

    private double logDet(Matrix matrix2D) {
        double det = matrix2D.det();
        return FastMath.log(FastMath.abs(det));
    }

    private double traceAInvB(Matrix A, Matrix B) {
        Matrix inverse = A.inverse();
        Matrix product = inverse.times(B);
        double trace = product.trace();
        if (trace < -1.0E-8) {
            return 0.0;
        }
        return trace;
    }

    private Matrix edgeCoef() {
        return this.edgeCoef;
    }

    private double[] standardErrors() {
        if (this.standardErrors == null) {
            SemStdErrorEstimator estimator = new SemStdErrorEstimator();
            try {
                estimator.computeStdErrors(this);
            }
            catch (Exception e) {
                return null;
            }
            this.standardErrors = estimator.getStdErrors();
        }
        return this.standardErrors;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semPm == null) {
            throw new NullPointerException();
        }
        if (this.variableNodes == null) {
            throw new NullPointerException();
        }
        if (this.measuredNodes == null) {
            throw new NullPointerException();
        }
        if (this.variableMeans == null) {
            throw new NullPointerException();
        }
        if (this.freeParameters == null) {
            throw new NullPointerException();
        }
        if (this.freeMappings == null) {
            throw new NullPointerException();
        }
        if (this.fixedParameters == null) {
            throw new NullPointerException();
        }
        if (this.fixedMappings == null) {
            throw new NullPointerException();
        }
        if (this.meanParameters == null) {
            this.meanParameters = this.initMeanParameters();
        }
        if (this.sampleSize < 0) {
            throw new IllegalArgumentException("Sample size out of range: " + this.sampleSize);
        }
        if (this.getParams() == null) {
            this.setParams(new Parameters());
        }
        if (this.distributions == null) {
            this.distributions = new HashMap<Node, Distribution>();
        }
    }

    public Parameters getParams() {
        return this.params;
    }

    public void setParams(Parameters params) {
        this.params = params;
    }

    public double[] getVariableMeans() {
        return this.variableMeans;
    }

    @Override
    public boolean isSimulatedPositiveDataOnly() {
        return false;
    }

    public Matrix getImplCovar(List<Node> nodes) {
        this.computeImpliedCovar();
        int size = nodes.size();
        Matrix implCovarMeas = new Matrix(size, size);
        HashMap<Node, Integer> variablesHash = new HashMap<Node, Integer>();
        for (int k = 0; k < this.variableNodes.size(); ++k) {
            variablesHash.put(this.variableNodes.get(k), k);
        }
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                Node iNode = nodes.get(i);
                Node jNode = nodes.get(j);
                int _i = (Integer)variablesHash.get(iNode);
                int _j = (Integer)variablesHash.get(jNode);
                implCovarMeas.set(i, j, this.implCovar.get(_i, _j));
            }
        }
        return implCovarMeas;
    }

    public int getNumRandomCalls() {
        return this.numRandomCalls;
    }
}

