/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;

public final class SemManipulation
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final SemIm semIm;
    private final boolean[] manipulated;

    public SemManipulation(SemIm semIm) {
        if (semIm == null) {
            throw new NullPointerException();
        }
        this.semIm = semIm;
        this.manipulated = new boolean[semIm.getVariableNodes().size()];
    }

    public SemManipulation(SemManipulation manipulation) {
        this.semIm = manipulation.semIm;
        this.manipulated = Arrays.copyOf(manipulation.manipulated, manipulation.manipulated.length);
    }

    public static SemManipulation serializableInstance() {
        return new SemManipulation(SemIm.serializableInstance());
    }

    public int getNodeIndex(String nodeName) {
        List<Node> nodes = this.semIm.getSemPm().getVariableNodes();
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!node.getName().equals(nodeName)) continue;
            return i;
        }
        return -1;
    }

    private int getNumNodes() {
        return this.semIm.getVariableNodes().size();
    }

    public Node getNode(int nodeIndex) {
        return this.semIm.getVariableNodes().get(nodeIndex);
    }

    public boolean isManipulated(int nodeIndex) {
        return this.manipulated[nodeIndex];
    }

    public void setManipulated(int nodeIndex, boolean manipulated) {
        this.manipulated[nodeIndex] = manipulated;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nManipulation:");
        buf.append("\n");
        for (int i = 0; i < this.getNumNodes(); ++i) {
            buf.append(this.isManipulated(i) ? "(Man)" : "     ");
            buf.append("\t");
        }
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SemManipulation)) {
            throw new IllegalArgumentException();
        }
        SemManipulation evidence = (SemManipulation)o;
        if (this.semIm != evidence.semIm) {
            return false;
        }
        for (int i = 0; i < this.manipulated.length; ++i) {
            if (this.manipulated[i] == evidence.manipulated[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 37;
        hashCode = 19 * hashCode + this.semIm.hashCode();
        hashCode = 19 * hashCode + Arrays.hashCode(this.manipulated);
        return hashCode;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

