/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.List;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.PowellOptimizer;

public class SemOptimizerPowell
implements SemOptimizer {
    private static final long serialVersionUID = 23L;
    private int numRestarts;

    public static SemOptimizerPowell serializableInstance() {
        return new SemOptimizerPowell();
    }

    @Override
    public void optimize(SemIm semIm) {
        double min = Double.POSITIVE_INFINITY;
        double[] point = null;
        for (int count = 0; count < this.numRestarts + 1; ++count) {
            SemIm _sem2 = new SemIm(semIm);
            List<Parameter> freeParameters = _sem2.getFreeParameters();
            double[] p = new double[freeParameters.size()];
            for (int i = 0; i < freeParameters.size(); ++i) {
                p[i] = freeParameters.get(i).getType() == ParamType.VAR ? RandomUtil.getInstance().nextUniform(0.0, 1.0) : RandomUtil.getInstance().nextUniform(-1.0, 1.0);
            }
            _sem2.setFreeParamValues(p);
            PowellOptimizer search = new PowellOptimizer(1.0E-7, 1.0E-7);
            PointValuePair pair = search.optimize(new InitialGuess(_sem2.getFreeParamValues()), new ObjectiveFunction(this.fittingFunction(semIm)), GoalType.MINIMIZE, new MaxEval(100000));
            double chisq = _sem2.getChiSquare();
            if (!(chisq < min)) continue;
            min = chisq;
            point = pair.getPoint();
        }
        if (point == null) {
            throw new NullPointerException("Point could not be found.");
        }
        System.arraycopy(point, 0, semIm.getFreeParamValues(), 0, point.length);
    }

    public String toString() {
        return "Sem Optimizer PAL Powell";
    }

    private FittingFunction fittingFunction(SemIm sem) {
        return new FittingFunction(sem);
    }

    @Override
    public int getNumRestarts() {
        return this.numRestarts;
    }

    @Override
    public void setNumRestarts(int numRestarts) {
        this.numRestarts = numRestarts;
    }

    static class FittingFunction
    implements MultivariateFunction {
        private final SemIm sem;
        private final List<Parameter> freeParameters;

        public FittingFunction(SemIm sem) {
            this.sem = sem;
            this.freeParameters = sem.getFreeParameters();
        }

        @Override
        public double value(double[] parameters) {
            for (double parameter : parameters) {
                if (!Double.isNaN(parameter) && !Double.isInfinite(parameter)) continue;
                return 100000.0;
            }
            for (int i = 0; i < parameters.length; ++i) {
                if (this.freeParameters.get(i).getType() != ParamType.VAR || !(parameters[i] <= 0.0)) continue;
                return 100000.0;
            }
            this.sem.setFreeParamValues(parameters);
            double fml = this.sem.getScore();
            if (Double.isNaN(fml) || Double.isInfinite(fml)) {
                return 100000.0;
            }
            if (fml < 0.0) {
                return 100000.0;
            }
            return fml;
        }
    }
}

