/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.Ricf;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.TetradLogger;

public class SemOptimizerRicf
implements SemOptimizer {
    private static final long serialVersionUID = 23L;
    private int numRestarts = 1;

    public static SemOptimizerRicf serializableInstance() {
        return new SemOptimizerRicf();
    }

    @Override
    public void optimize(SemIm semIm) {
        if (this.numRestarts < 1) {
            this.numRestarts = 1;
        }
        if (this.numRestarts != 1) {
            throw new IllegalArgumentException("Number of restarts must be 1 for this method.");
        }
        Matrix sampleCovar = semIm.getSampleCovar();
        if (sampleCovar == null) {
            throw new NullPointerException("Sample covar has not been set.");
        }
        if (DataUtils.containsMissingValue(sampleCovar)) {
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        if (DataUtils.containsMissingValue(sampleCovar)) {
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        TetradLogger.getInstance().log("info", "Trying EM...");
        CovarianceMatrix cov = new CovarianceMatrix(semIm.getMeasuredNodes(), sampleCovar, semIm.getSampleSize());
        SemGraph graph = semIm.getSemPm().getGraph();
        Ricf.RicfResult result = new Ricf().ricf(graph, cov, 0.001);
        Matrix bHat = new Matrix(result.getBhat().toArray());
        Matrix lHat = new Matrix(result.getLhat().toArray());
        Matrix oHat = new Matrix(result.getOhat().toArray());
        for (Parameter param : semIm.getFreeParameters()) {
            int j;
            int i;
            if (param.getType() == ParamType.COEF) {
                i = semIm.getSemPm().getVariableNodes().indexOf(param.getNodeA());
                j = semIm.getSemPm().getVariableNodes().indexOf(param.getNodeB());
                semIm.setEdgeCoef(param.getNodeA(), param.getNodeB(), -bHat.get(j, i));
            }
            if (param.getType() == ParamType.VAR) {
                i = semIm.getSemPm().getVariableNodes().indexOf(param.getNodeA());
                if (lHat.get(i, i) != 0.0) {
                    semIm.setErrVar(param.getNodeA(), lHat.get(i, i));
                } else if (oHat.get(i, i) != 0.0) {
                    semIm.setErrVar(param.getNodeA(), oHat.get(i, i));
                }
            }
            if (param.getType() != ParamType.COVAR) continue;
            i = semIm.getSemPm().getVariableNodes().indexOf(param.getNodeA());
            j = semIm.getSemPm().getVariableNodes().indexOf(param.getNodeB());
            if (lHat.get(i, i) != 0.0) {
                semIm.setErrCovar(param.getNodeA(), param.getNodeB(), lHat.get(j, i));
                continue;
            }
            if (oHat.get(i, i) == 0.0) continue;
            semIm.setErrCovar(param.getNodeA(), param.getNodeB(), oHat.get(j, i));
        }
        System.out.println(result);
        System.out.println(semIm);
    }

    @Override
    public int getNumRestarts() {
        return this.numRestarts;
    }

    @Override
    public void setNumRestarts(int numRestarts) {
        this.numRestarts = numRestarts;
    }

    public String toString() {
        return "Sem Optimizer RICF";
    }
}

