/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.util.Matrix;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class SemStdErrorEstimator {
    private double[] stdErrs;

    public void computeStdErrors(ISemIm estSem) {
        int i;
        estSem.setParameterBoundsEnforced(false);
        double[] paramsOriginal = estSem.getFreeParamValues();
        SemFittingFunction fcn = new SemFittingFunction(estSem);
        int n = fcn.getNumParameters();
        double[] params = new double[n];
        System.arraycopy(paramsOriginal, 0, params, 0, n);
        double delta = 0.005;
        Matrix hess = new Matrix(n, n);
        List<Parameter> freeParameters = estSem.getFreeParameters();
        boolean containsCovararianceParameter = false;
        for (Parameter p : freeParameters) {
            if (p.getType() != ParamType.COVAR) continue;
            containsCovararianceParameter = true;
            break;
        }
        for (i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                Parameter pi = freeParameters.get(i);
                Parameter pj = freeParameters.get(j);
                if (!containsCovararianceParameter && (i != j && (pi.getType() != ParamType.COEF || pj.getType() != ParamType.COEF) || pi.getNodeB() != pj.getNodeB())) continue;
                double v = this.secondPartialDerivative(fcn, i, j, params, delta);
                if (FastMath.abs(v) < 1.0E-7) {
                    v = 0.0;
                }
                hess.set(i, j, v);
                hess.set(j, i, v);
            }
        }
        for (i = 0; i < hess.getNumRows(); ++i) {
            for (int j = 0; j < hess.getNumColumns() && hess.get(i, j) == 0.0; ++j) {
            }
        }
        try {
            Matrix hessInv = hess.ginverse();
            this.stdErrs = new double[n];
            for (int i2 = 0; i2 < n; ++i2) {
                double v = FastMath.sqrt(2.0 / (double)(estSem.getSampleSize() - 1) * hessInv.get(i2, i2));
                if (v == 0.0) {
                    System.out.println("v = 0 hessInv(i, i) = " + hessInv.get(i2, i2));
                }
                this.stdErrs[i2] = v == 0.0 ? Double.NaN : v;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stdErrs = new double[n];
            for (int i3 = 0; i3 < n; ++i3) {
                this.stdErrs[i3] = Double.NaN;
            }
        }
        estSem.setFreeParamValues(paramsOriginal);
        estSem.setParameterBoundsEnforced(true);
    }

    public double[] getStdErrors() {
        return this.stdErrs;
    }

    private double secondPartialDerivative(FittingFunction f, int i, int j, double[] p, double delt) {
        double[] arg = new double[p.length];
        System.arraycopy(p, 0, arg, 0, p.length);
        double center = f.evaluate(arg);
        int n = i;
        arg[n] = arg[n] + delt;
        int n2 = j;
        arg[n2] = arg[n2] + delt;
        double ff1 = f.evaluate(arg);
        int n3 = j;
        arg[n3] = arg[n3] - 2.0 * delt;
        double ff2 = f.evaluate(arg);
        int n4 = i;
        arg[n4] = arg[n4] - 2.0 * delt;
        int n5 = j;
        arg[n5] = arg[n5] + 2.0 * delt;
        double ff3 = f.evaluate(arg);
        int n6 = j;
        arg[n6] = arg[n6] - 2.0 * delt;
        double ff4 = f.evaluate(arg);
        if (Double.isNaN(ff1)) {
            ff1 = center;
        }
        if (Double.isNaN(ff2)) {
            ff2 = center;
        }
        if (Double.isNaN(ff3)) {
            ff3 = center;
        }
        if (Double.isNaN(ff4)) {
            ff4 = center;
        }
        double fsSum = ff1 - ff2 - ff3 + ff4;
        return fsSum / (4.0 * delt * delt);
    }

    static class SemFittingFunction
    implements FittingFunction {
        private final ISemIm sem;

        public SemFittingFunction(ISemIm sem) {
            this.sem = sem;
        }

        @Override
        public double evaluate(double[] parameters) {
            List<Parameter> _parameters = this.sem.getSemPm().getFreeParameters();
            for (int i = 0; i < _parameters.size(); ++i) {
                Parameter parameter = _parameters.get(i);
                if (parameter.getType() != ParamType.VAR || !(parameters[i] < 0.0)) continue;
                parameters[i] = 0.0;
            }
            this.sem.setFreeParamValues(parameters);
            return this.sem.getScore();
        }

        @Override
        public int getNumParameters() {
            return this.sem.getNumFreeParams();
        }
    }

    static interface FittingFunction {
        public double evaluate(double[] var1);

        public int getNumParameters();
    }
}

