/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import nu.xom.Element;
import nu.xom.Elements;

public class SemXmlParser {
    public static SemIm getSemIm(Element semImElement) {
        if (!"sem".equals(semImElement.getQualifiedName())) {
            throw new IllegalArgumentException("Expecting 'sem' element");
        }
        Element variablesElement = semImElement.getFirstChildElement("semVariables");
        Element edgesElement = semImElement.getFirstChildElement("edges");
        Element marginalDistributionElement = semImElement.getFirstChildElement("marginalErrorDistribution");
        Element jointDistributionElement = semImElement.getFirstChildElement("jointErrorDistribution");
        Dag graph = SemXmlParser.makeVariables(variablesElement);
        SemIm im = SemXmlParser.makeEdges(edgesElement, graph);
        SemXmlParser.setNodeMeans(variablesElement, im);
        SemXmlParser.addMarginalErrorDistribution(marginalDistributionElement, im);
        SemXmlParser.addJointErrorDistribution(jointDistributionElement, im);
        return im;
    }

    private static Dag makeVariables(Element variablesElement) {
        if (!"semVariables".equals(variablesElement.getQualifiedName())) {
            throw new IllegalArgumentException("Expecting 'semVariables' element");
        }
        Dag semGraph = new Dag();
        Elements vars = variablesElement.getChildElements("continuousVariable");
        for (int i = 0; i < vars.size(); ++i) {
            Element var = vars.get(i);
            GraphNode node = new GraphNode(var.getAttributeValue("name"));
            if (var.getAttributeValue("latent").equals("yes")) {
                node.setNodeType(NodeType.LATENT);
            } else {
                node.setNodeType(NodeType.MEASURED);
            }
            int x = Integer.parseInt(var.getAttributeValue("x"));
            int y = Integer.parseInt(var.getAttributeValue("y"));
            node.setCenterX(x);
            node.setCenterY(y);
            semGraph.addNode(node);
        }
        return semGraph;
    }

    private static SemIm makeEdges(Element edgesElement, Dag semGraph) {
        Node effectNode;
        Node causeNode;
        Element edge;
        if (!"edges".equals(edgesElement.getQualifiedName())) {
            throw new IllegalArgumentException("Expecting 'edges' element");
        }
        Elements edges = edgesElement.getChildElements("edge");
        for (int i = 0; i < edges.size(); ++i) {
            edge = edges.get(i);
            causeNode = semGraph.getNode(edge.getAttributeValue("causeNode"));
            effectNode = semGraph.getNode(edge.getAttributeValue("effectNode"));
            semGraph.addDirectedEdge(causeNode, effectNode);
        }
        SemIm semIm = new SemIm(new SemPm(semGraph));
        for (int i = 0; i < edges.size(); ++i) {
            edge = edges.get(i);
            causeNode = semGraph.getNode(edge.getAttributeValue("causeNode"));
            effectNode = semGraph.getNode(edge.getAttributeValue("effectNode"));
            semIm.setParamValue(causeNode, effectNode, new Double(edge.getAttributeValue("coef")));
            Parameter covarianceParameter = semIm.getSemPm().getCovarianceParameter(causeNode, effectNode);
            if (covarianceParameter == null) continue;
            Boolean aBoolean = Boolean.valueOf(edge.getAttributeValue("fixed"));
            covarianceParameter.setFixed(aBoolean);
        }
        return semIm;
    }

    private static void setNodeMeans(Element variablesElement, SemIm im) {
        Elements vars = variablesElement.getChildElements("continuousVariable");
        for (int i = 0; i < vars.size(); ++i) {
            Element var = vars.get(i);
            Node node = im.getSemPm().getGraph().getNode(var.getAttributeValue("name"));
            if (var.getAttributeValue("intercept") == null) {
                return;
            }
            im.setMean(node, Double.parseDouble(var.getAttributeValue("intercept")));
        }
    }

    private static void addMarginalErrorDistribution(Element marginalDistributionElement, SemIm semIm) {
        if (!"marginalErrorDistribution".equals(marginalDistributionElement.getQualifiedName())) {
            throw new IllegalArgumentException("Expecting 'marginalErrorDistribution' element");
        }
        Elements normals = marginalDistributionElement.getChildElements("normal");
        for (int i = 0; i < normals.size(); ++i) {
            Element normal = normals.get(i);
            SemGraph graph = semIm.getSemPm().getGraph();
            graph.setShowErrorTerms(true);
            Node node = graph.getExogenous(graph.getNode(normal.getAttributeValue("variable")));
            semIm.setParamValue(node, node, new Double(normal.getAttributeValue("variance")));
        }
    }

    private static void addJointErrorDistribution(Element jointDistributionElement, SemIm semIm) {
        if (!"jointErrorDistribution".equals(jointDistributionElement.getQualifiedName())) {
            throw new IllegalArgumentException("Expecting 'jointErrorDistribution' element");
        }
        Elements normals = jointDistributionElement.getChildElements("normal");
        for (int i = 0; i < normals.size(); ++i) {
            Element normal = normals.get(i);
            Node node1 = semIm.getSemPm().getGraph().getExogenous(semIm.getSemPm().getGraph().getNode(normal.getAttributeValue("node1")));
            Node node2 = semIm.getSemPm().getGraph().getExogenous(semIm.getSemPm().getGraph().getNode(normal.getAttributeValue("node2")));
            semIm.setParamValue(node1, node2, new Double(normal.getAttributeValue("covariance")));
        }
    }
}

