/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.DelegatesEditing;
import edu.cmu.tetrad.session.SessionNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public final class ModificationRegistery {
    private static final Set<Object> EDITED_MODELS = new HashSet<Object>();
    private static final Map<JComponent, SessionNode> EDITORS_TO_SESSION_NODES = new HashMap<JComponent, SessionNode>();
    private static final Map<JComponent, PropertyChangeListener> EDITORS_TO_LISTENERS = new HashMap<JComponent, PropertyChangeListener>();

    public static void registerEditor(SessionNode sessionNode, JComponent editor) {
        if (editor == null) {
            throw new NullPointerException();
        }
        if (sessionNode == null) {
            throw new NullPointerException();
        }
        if (editor instanceof DelegatesEditing) {
            editor = ((DelegatesEditing)((Object)editor)).getEditDelegate();
        }
        EDITORS_TO_SESSION_NODES.put(editor, sessionNode);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("modelChanged".equals(evt.getPropertyName())) {
                    JComponent editor = (JComponent)evt.getSource();
                    Object sessionNode = EDITORS_TO_SESSION_NODES.get(editor);
                    if (sessionNode != null) {
                        EDITED_MODELS.add(sessionNode);
                    }
                }
            }
        };
        editor.addPropertyChangeListener(listener);
        EDITORS_TO_LISTENERS.put(editor, listener);
    }

    public static boolean modelHasChanged(SessionNode sessionNode) {
        return EDITED_MODELS.contains(sessionNode);
    }

    public static void unregisterEditor(JComponent editor) {
        if (editor instanceof DelegatesEditing) {
            editor = ((DelegatesEditing)((Object)editor)).getEditDelegate();
        }
        EDITORS_TO_SESSION_NODES.remove(editor);
        PropertyChangeListener listener = EDITORS_TO_LISTENERS.get(editor);
        editor.removePropertyChangeListener(listener);
        EDITORS_TO_LISTENERS.remove(editor);
    }

    public static void unregisterSessionNode(SessionNode sessionNode) {
        EDITED_MODELS.remove(sessionNode);
    }
}

