/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionListener;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.SessionSupport;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Session
implements TetradSerializable {
    private static final long serialVersionUID = 23L;
    private final List<SessionNode> nodes = new LinkedList<SessionNode>();
    private String name;
    private transient boolean sessionChanged = true;
    private transient boolean newSession = true;
    private transient SessionSupport sessionSupport;
    private transient SessionHandler sessionHandler;

    public Session(String name) {
        this.setName(name);
    }

    public static Session serializableInstance() {
        return new Session("X");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        this.name = name;
    }

    public void addNode(SessionNode node) {
        if (node == null) {
            throw new NullPointerException("Node cannot be null.");
        }
        if (!node.isFreshlyCreated()) {
            throw new IllegalArgumentException("Node must be freshly created in order to be added to a session: " + node);
        }
        this.nodes.add(node);
        node.addSessionListener(this.getSessionHandler());
        this.getSessionSupport().fireNodeAdded(node);
    }

    public void addNodeList(List<SessionNode> nodes) {
        if (nodes == null) {
            throw new NullPointerException("The list of nodes must not be null.");
        }
        for (int i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i) != null) continue;
            throw new IllegalArgumentException("The object at index " + i + " is null.");
        }
        for (SessionNode node : nodes) {
            if (!this.existsNodeByName(node.getDisplayName())) continue;
            throw new IllegalArgumentException("Attempt to add node to the session with duplicate name: " + node.getDisplayName());
        }
        for (int i = 0; i < nodes.size(); ++i) {
            SessionNode node;
            node = nodes.get(i);
            node.restrictConnectionsToList(nodes);
            node.restrictListenersToSessionNodes();
            this.nodes.add(node);
            node.addSessionListener(this.getSessionHandler());
            this.getSessionSupport().fireNodeAdded(node);
        }
    }

    public void removeNode(SessionNode node) {
        if (!this.nodes.contains(node)) {
            throw new IllegalArgumentException("Node doesn't exist ingraph: " + node);
        }
        node.resetToFreshlyCreated();
        this.nodes.remove(node);
        node.removeSessionListener(this.getSessionHandler());
        this.getSessionSupport().fireNodeRemoved(node);
    }

    public Set<SessionNode> getNodes() {
        return new HashSet<SessionNode>(this.nodes);
    }

    public void clearNodes() {
        HashSet<SessionNode> _nodes = new HashSet<SessionNode>(this.nodes);
        for (SessionNode node : _nodes) {
            this.removeNode(node);
        }
    }

    public boolean contains(SessionNode node) {
        return this.nodes.contains(node);
    }

    public void addSessionListener(SessionListener l) {
        this.getSessionSupport().addSessionListener(l);
    }

    public void removeSessionListener(SessionListener l) {
        this.getSessionSupport().removeSessionListener(l);
    }

    SessionSupport getSessionSupport() {
        if (this.sessionSupport == null) {
            this.sessionSupport = new SessionSupport(this);
            for (SessionNode node : this.nodes) {
                node.addSessionListener(this.getSessionHandler());
            }
        }
        return this.sessionSupport;
    }

    SessionHandler getSessionHandler() {
        if (this.sessionHandler == null) {
            this.sessionHandler = new SessionHandler();
        }
        return this.sessionHandler;
    }

    private boolean existsNodeByName(String name) {
        if (name == null) {
            return false;
        }
        for (SessionNode node : this.getNodes()) {
            if (!name.equals(node.getDisplayName())) continue;
            return true;
        }
        return false;
    }

    public boolean isSessionChanged() {
        return this.sessionChanged;
    }

    public void setSessionChanged(boolean sessionChanged) {
        this.sessionChanged = sessionChanged;
    }

    public boolean isNewSession() {
        return this.newSession;
    }

    public void setNewSession(boolean newSession) {
        this.newSession = newSession;
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.name == null) {
            throw new NullPointerException();
        }
        if (this.nodes == null) {
            throw new NullPointerException();
        }
        this.sessionChanged = false;
        this.newSession = false;
    }

    private class SessionHandler
    extends SessionAdapter {
        private SessionHandler() {
        }

        @Override
        public void nodeAdded(SessionEvent event) {
            Session.this.getSessionSupport().fireSessionEvent(event);
            Session.this.setSessionChanged(true);
        }

        @Override
        public void nodeRemoved(SessionEvent event) {
            Session.this.getSessionSupport().fireSessionEvent(event);
            Session.this.setSessionChanged(true);
        }

        @Override
        public void parentAdded(SessionEvent event) {
            Session.this.getSessionSupport().fireSessionEvent(event);
            Session.this.setSessionChanged(true);
        }

        @Override
        public void parentRemoved(SessionEvent event) {
            Session.this.getSessionSupport().fireSessionEvent(event);
            Session.this.setSessionChanged(true);
        }

        @Override
        public void modelCreated(SessionEvent event) {
            Session.this.getSessionSupport().fireSessionEvent(event);
            Session.this.setSessionChanged(true);
        }

        @Override
        public void modelDestroyed(SessionEvent event) {
            Session.this.getSessionSupport().fireSessionEvent(event);
            Session.this.setSessionChanged(true);
        }

        @Override
        public void addingEdge(SessionEvent event) {
            Session.this.getSessionSupport().fireSessionEvent(event, false);
        }
    }
}

