/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.NodeVariableType;
import edu.cmu.tetrad.session.CouldNotCreateModelException;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.session.Executable;
import edu.cmu.tetrad.session.ExecutionRestarter;
import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionListener;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.session.SessionSupport;
import edu.cmu.tetrad.session.Type1;
import edu.cmu.tetrad.util.CombinationIterator;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.PermutationGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.TetradLoggerConfig;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public class SessionNode
implements Node {
    private static final long serialVersionUID = 23L;
    private final Map<Class, Parameters> paramMap = new HashMap<Class, Parameters>();
    private final Parameters parameters = new Parameters();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String boxType;
    private String displayName;
    private Class[] modelClasses;
    private Class lastModelClass;
    private Class[] modelParamTypes;
    private SessionModel model;
    private SessionModel oldModel;
    private transient SessionModel savedModel;
    private Set<SessionNode> parents = new HashSet<SessionNode>();
    private Set<SessionNode> children = new HashSet<SessionNode>();
    private boolean nextEdgeAddAllowed = true;
    private int repetition = 1;
    private transient SessionSupport sessionSupport;
    private transient SessionHandler sessionHandler;
    private TetradLoggerConfig loggerConfig;
    private NodeVariableType nodeVariableType = NodeVariableType.DOMAIN;

    public SessionNode(Class modelClass) {
        this("???", modelClass.getName(), new Class[]{modelClass});
    }

    public SessionNode(String boxType, String displayName, Class modelClass) {
        this(boxType, displayName, new Class[]{modelClass});
    }

    public SessionNode(Class[] modelClasses) {
        this("???", "???", modelClasses);
    }

    public SessionNode(String boxType, String displayName, Class[] modelClasses) {
        this.setBoxType(boxType);
        this.setDisplayName(displayName);
        if (modelClasses == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < modelClasses.length; ++i) {
            if (modelClasses[i] == null) {
                throw new NullPointerException("Model class null: index + " + i);
            }
            if (SessionModel.class.isAssignableFrom(modelClasses[i])) continue;
            throw new ClassCastException("Model class must implement SessionModel: " + modelClasses[i]);
        }
        this.boxType = boxType;
        this.displayName = displayName;
        this.modelClasses = modelClasses;
    }

    public static SessionNode serializableInstance() {
        return new SessionNode(Type1.class);
    }

    public boolean addParent(SessionNode parent) {
        if (this.parents.contains(parent)) {
            return false;
        }
        if (parent == this) {
            return false;
        }
        ArrayList<SessionNode> newParents = new ArrayList<SessionNode>(this.parents);
        newParents.add(parent);
        for (Class modelClass : this.modelClasses) {
            Class[][] parentClasses = new Class[newParents.size()][];
            int[] numModels = new int[newParents.size()];
            for (int j = 0; j < newParents.size(); ++j) {
                SessionNode node = (SessionNode)newParents.get(j);
                parentClasses[j] = node.getModelClasses();
                numModels[j] = parentClasses[j].length;
            }
            if (!this.isConsistentModelClass(modelClass, parentClasses, false, null)) continue;
            this.parents.add(parent);
            parent.addChild(this);
            parent.addSessionListener(this.getSessionHandler());
            this.getSessionSupport().fireParentAdded(parent, this);
            return true;
        }
        return false;
    }

    public boolean isConsistentParent(SessionNode parent) {
        return this.isConsistentParent(parent, null);
    }

    public boolean isConsistentParent(SessionNode parent, List<SessionNode> existingNodes) {
        if (this.parents.contains(parent)) {
            return false;
        }
        if (parent == this) {
            return false;
        }
        ArrayList<SessionNode> newParents = new ArrayList<SessionNode>(this.parents);
        newParents.add(parent);
        Class[] thisClass = new Class[1];
        if (this.getModel() != null) {
            thisClass[0] = this.getModel().getClass();
        }
        for (Class modelClass : this.getModel() != null ? thisClass : this.modelClasses) {
            Class[][] parentClasses = new Class[newParents.size()][];
            for (int j = 0; j < newParents.size(); ++j) {
                SessionNode node = (SessionNode)newParents.get(j);
                parentClasses[j] = node.getModelClasses();
            }
            if (!this.isConsistentModelClass(modelClass, parentClasses, false, existingNodes)) continue;
            return true;
        }
        return false;
    }

    public boolean addParent2(SessionNode parent) {
        if (this.parents.contains(parent)) {
            return false;
        }
        if (parent == this) {
            return false;
        }
        ArrayList<SessionNode> newParents = new ArrayList<SessionNode>(this.parents);
        newParents.add(parent);
        for (Class modelClass : this.modelClasses) {
            Class[][] parentClasses = new Class[newParents.size()][];
            int[] numModels = new int[newParents.size()];
            for (int j = 0; j < newParents.size(); ++j) {
                SessionNode node = (SessionNode)newParents.get(j);
                parentClasses[j] = node.getModelClasses();
                numModels[j] = parentClasses[j].length;
            }
            if (!this.isConsistentModelClass(modelClass, parentClasses, false, null)) continue;
            if (this.getModel() == null) {
                this.parents.add(parent);
                parent.addChild(this);
                parent.addSessionListener(this.getSessionHandler());
                this.getSessionSupport().fireParentAdded(parent, this);
                return true;
            }
            this.sessionSupport.fireAddingEdge();
            if (this.isNextEdgeAddAllowed()) {
                this.setNextEdgeAddAllowed(true);
                this.parents.add(parent);
                parent.addChild(this);
                parent.addSessionListener(this.getSessionHandler());
                this.getSessionSupport().fireParentAdded(parent, this);
                this.destroyModel();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean removeParent(SessionNode parent) {
        if (this.parents.contains(parent)) {
            this.parents.remove(parent);
            parent.removeChild(this);
            parent.removeSessionListener(this.getSessionHandler());
            this.getSessionSupport().fireParentRemoved(parent, this);
            return true;
        }
        return false;
    }

    public Set<SessionNode> getParents() {
        return new HashSet<SessionNode>(this.parents);
    }

    public int getNumParents() {
        return this.parents.size();
    }

    public boolean addChild(SessionNode child) {
        if (!this.children.contains(child)) {
            child.addParent(this);
            if (child.containsParent(this)) {
                this.children.add(child);
                return true;
            }
        }
        return false;
    }

    public boolean containsChild(SessionNode child) {
        return this.children.contains(child);
    }

    public boolean removeChild(SessionNode child) {
        if (this.children.contains(child)) {
            child.removeParent(this);
            if (!child.containsParent(this)) {
                this.children.remove(child);
                return true;
            }
        }
        return false;
    }

    public Set<SessionNode> getChildren() {
        return new HashSet<SessionNode>(this.children);
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public boolean createModel(boolean simulation) {
        if (this.getModel() == null) {
            if (this.lastModelClass != null) {
                try {
                    this.createModel(this.lastModelClass, simulation);
                }
                catch (Exception e) {
                    this.getSessionSupport().fireModelUnclear(this);
                }
            } else {
                this.getSessionSupport().fireModelUnclear(this);
            }
        }
        return this.getModel() != null;
    }

    public void createModel(Class modelClass, boolean simulation) throws Exception {
        if (!Arrays.asList(this.modelClasses).contains(modelClass)) {
            throw new IllegalArgumentException("Class not among possible model classes: " + modelClass);
        }
        this.loggerConfig = this.getLoggerConfig(modelClass);
        TetradLogger.getInstance().setTetradLoggerConfig(this.loggerConfig);
        TetradLogger.getInstance().log("info", "\n========LOGGING " + this.getDisplayName() + "\n");
        List<Object> parentModels = this.listParentModels();
        Parameters param = this.getParam(modelClass);
        this.model = null;
        ArrayList<Object> expandedModels = new ArrayList<Object>(parentModels);
        if (this.oldModel != null && !DoNotAddOldModel.class.isAssignableFrom(modelClass)) {
            expandedModels.add(this.oldModel);
        }
        if (param != null) {
            expandedModels.add(param);
        }
        this.createModelUsingArguments(modelClass, expandedModels);
        if (this.model == null) {
            expandedModels = new ArrayList<Object>(parentModels);
            if (param != null) {
                expandedModels.add(param);
            }
            this.createModelUsingArguments(modelClass, expandedModels);
        }
        if (this.model == null) {
            this.createModelUsingArguments(modelClass, parentModels);
        }
        if (this.model == null) {
            TetradLogger.getInstance().log("info", this.getDisplayName() + " was not created.");
            throw new CouldNotCreateModelException(modelClass);
        }
        if (this.model instanceof Executable) {
            Executable executable = (Executable)((Object)this.model);
            try {
                if (simulation) {
                    executable.execute();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), e.getMessage());
            }
        }
    }

    public TetradLoggerConfig getLoggerConfig() {
        return this.loggerConfig;
    }

    public TetradLoggerConfig getLoggerConfig(Class modelClass) {
        TetradLoggerConfig oldConfig = this.loggerConfig;
        TetradLoggerConfig newConfig = TetradLogger.getInstance().getLoggerForClass(modelClass);
        if (oldConfig != null && newConfig == null) {
            return oldConfig;
        }
        if (oldConfig != null && newConfig != null) {
            for (TetradLoggerConfig.Event event : newConfig.getSupportedEvents()) {
                for (TetradLoggerConfig.Event _event : oldConfig.getSupportedEvents()) {
                    if (!event.getId().equals(_event.getId())) continue;
                    newConfig.setEventActive(_event.getId(), oldConfig.isEventActive(_event.getId()));
                }
            }
        }
        this.loggerConfig = newConfig;
        return newConfig;
    }

    public void destroyModel() {
        if (this.model != null) {
            this.oldModel = this.model;
            this.model = null;
        }
        this.modelParamTypes = null;
        this.getSessionSupport().fireModelDestroyed(this);
    }

    public void forgetOldModel() {
        this.oldModel = null;
    }

    public Class[] getModelClasses() {
        return this.modelClasses;
    }

    public final void setModelClasses(Class[] modelClasses) {
        for (int i = 0; i < modelClasses.length; ++i) {
            if (modelClasses[i] != null) continue;
            throw new NullPointerException("Model class null: index + " + i);
        }
        this.modelClasses = modelClasses;
    }

    public Class[] getConsistentModelClasses(boolean exact) {
        ArrayList<Class> classes = new ArrayList<Class>();
        ArrayList<SessionNode> parents = new ArrayList<SessionNode>(this.parents);
        Class[][] parentModelClasses = new Class[parents.size()][1];
        for (int i = 0; i < parents.size(); ++i) {
            SessionNode sessionNode = (SessionNode)parents.get(i);
            SessionModel model = sessionNode.getModel();
            if (model == null) {
                return null;
            }
            parentModelClasses[i][0] = model.getClass();
        }
        for (Class modelClass : this.modelClasses) {
            if (!this.isConsistentModelClass(modelClass, parentModelClasses, exact, null)) continue;
            classes.add(modelClass);
        }
        return classes.toArray(new Class[0]);
    }

    public SessionModel getModel() {
        return this.model;
    }

    public Class getLastModelClass() {
        return this.lastModelClass;
    }

    public void addSessionListener(SessionListener l) {
        this.getSessionSupport().addSessionListener(l);
    }

    public void removeSessionListener(SessionListener l) {
        this.getSessionSupport().removeSessionListener(l);
    }

    public boolean isFreshlyCreated() {
        return this.model == null && this.modelParamTypes == null && this.parents.size() == 0 && this.children.size() == 0 && this.sessionHandler == null && this.sessionSupport == null;
    }

    public void resetToFreshlyCreated() {
        if (!this.isFreshlyCreated()) {
            HashSet<SessionNode> _parents = new HashSet<SessionNode>(this.parents);
            HashSet<SessionNode> _children = new HashSet<SessionNode>(this.children);
            for (SessionNode _parent : _parents) {
                this.removeParent(_parent);
            }
            for (SessionNode a_children : _children) {
                this.removeChild(a_children);
            }
            this.destroyModel();
            this.parents = new HashSet<SessionNode>();
            this.children = new HashSet<SessionNode>();
            this.sessionSupport = null;
            this.sessionHandler = null;
        }
    }

    public void restrictConnectionsToList(List sessionNodes) {
        for (SessionNode sessionNode : this.getParents()) {
            if (sessionNodes.contains(sessionNode)) continue;
            this.removeParent(sessionNode);
        }
        for (SessionNode sessionNode1 : this.getChildren()) {
            if (sessionNodes.contains(sessionNode1)) continue;
            this.removeChild(sessionNode1);
        }
    }

    public void restrictListenersToSessionNodes() {
        this.sessionSupport = null;
        this.sessionHandler = null;
    }

    public boolean isStructurallyIdentical(SessionNode node) {
        SessionModel model;
        HashSet<Class> set2;
        if (node == null) {
            return false;
        }
        HashSet<Class> set1 = new HashSet<Class>(Arrays.asList(this.getModelClasses()));
        if (!set1.equals(set2 = new HashSet<Class>(Arrays.asList(node.getModelClasses())))) {
            return false;
        }
        Class[] arr1 = this.getModelParamTypes();
        Class[] arr2 = node.getModelParamTypes();
        if (arr1 != null && arr2 != null) {
            if (arr1.length != arr2.length) {
                return false;
            }
            for (int i = 0; i < arr1.length; ++i) {
                if (arr1[i].equals(arr2[i])) continue;
                return false;
            }
        } else if (arr1 == null && arr2 != null) {
            return false;
        }
        SessionModel model1 = this.getModel();
        SessionModel model2 = node.getModel();
        if (model1 == null && model2 != null) {
            return false;
        }
        if (model1 != null && model2 == null) {
            return false;
        }
        if (model1 != null && !model1.equals(model2)) {
            return false;
        }
        set1.clear();
        for (SessionNode sessionNode : this.getParents()) {
            model = sessionNode.getModel();
            if (model == null) continue;
            set1.add(model.getClass());
        }
        set2.clear();
        for (SessionNode sessionNode1 : node.getParents()) {
            model = sessionNode1.getModel();
            if (model == null) continue;
            set2.add(model.getClass());
        }
        if (!set1.equals(set2)) {
            return false;
        }
        set1.clear();
        for (SessionNode sessionNode2 : this.getChildren()) {
            model = sessionNode2.getModel();
            if (model == null) continue;
            set1.add(model.getClass());
        }
        set2.clear();
        for (SessionNode sessionNode3 : node.getChildren()) {
            model = sessionNode3.getModel();
            if (model == null) continue;
            set2.add(model.getClass());
        }
        return set1.equals(set2);
    }

    public String getBoxType() {
        return this.boxType;
    }

    public final void setBoxType(String boxType) {
        if (boxType == null) {
            throw new NullPointerException();
        }
        this.boxType = boxType;
    }

    public void putParam(Class modelClass, Parameters param) {
        if (param instanceof SessionListener) {
            SessionListener listener = (SessionListener)((Object)param);
            this.getSessionSupport().addSessionListener(listener);
        }
        this.paramMap.put(modelClass, param);
    }

    public Parameters getParam(Class modelClass) {
        return this.paramMap.get(modelClass);
    }

    public void removeParam(Class modelClass) {
        Parameters param = this.paramMap.get(modelClass);
        if (param != null && param instanceof SessionListener) {
            SessionListener listener = (SessionListener)((Object)param);
            this.getSessionSupport().removeSessionListener(listener);
        }
        this.paramMap.remove(modelClass);
    }

    public Object[] getModelConstructorArguments(Class modelClass) {
        Constructor<?>[] constructors;
        List<Object> parentModels = this.getParentModels();
        parentModels.add(this.getParam(modelClass));
        for (Constructor<?> constructor : constructors = modelClass.getConstructors()) {
            Class[] parameterTypes = constructor.getParameterTypes();
            Object[] arguments = this.assignParameters(parameterTypes, parentModels);
            if (arguments == null) continue;
            return arguments;
        }
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public NodeType getNodeType() {
        return null;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
    }

    @Override
    public String toString() {
        return this.getBoxType();
    }

    @Override
    public int getCenterX() {
        return 0;
    }

    @Override
    public void setCenterX(int centerX) {
    }

    @Override
    public int getCenterY() {
        return 0;
    }

    @Override
    public void setCenterY(int centerY) {
    }

    @Override
    public void setCenter(int centerX, int centerY) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public Node like(String name) {
        return null;
    }

    @Override
    public int compareTo(Node node) {
        return 0;
    }

    public boolean existsParameterizedConstructor(Class modelClass) {
        Parameters param = this.getParam(modelClass);
        List<Object> parentModels = this.listParentModels();
        parentModels.add(param);
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = modelClass.getConstructors()) {
                Class[] parameterTypes = constructor.getParameterTypes();
                Object[] arguments = this.assignParameters(parameterTypes, parentModels);
                if (arguments == null) continue;
                return true;
            }
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not construct model.", e);
        }
    }

    public int getRepetition() {
        return this.repetition;
    }

    public void setRepetition(int repetition) {
        if (repetition < 1) {
            throw new IllegalArgumentException("Repetition must be >= 1.");
        }
        this.repetition = repetition;
    }

    public boolean useClonedModel() {
        return false;
    }

    public void forgetSavedModel() {
        this.savedModel = null;
    }

    public void restoreOriginalModel() {
        this.model = this.savedModel;
        this.model.setName(this.getDisplayName());
        this.savedModel = null;
    }

    public boolean isConsistentModelClass(Class<Type1> modelClass, List nodes, boolean exact) {
        Class[][] nodeClasses = new Class[nodes.size()][];
        for (int i = 0; i < nodes.size(); ++i) {
            SessionNode node = (SessionNode)nodes.get(i);
            nodeClasses[i] = node.getModelClasses();
        }
        return this.isConsistentModelClass(modelClass, nodeClasses, exact, null);
    }

    public boolean existsConstructor(Class modelClass, Class[] argumentTypes) {
        Constructor<?>[] constructors;
        for (Class argumentType1 : argumentTypes) {
            if (argumentType1 != null) continue;
            throw new IllegalArgumentException("Argument classes must be non-null");
        }
        block1: for (Constructor<?> constructor : constructors = modelClass.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            ArrayList<Class> remainingParameterTypes = new ArrayList<Class>(Arrays.asList(parameterTypes));
            for (Class argumentType : argumentTypes) {
                Class type = this.findMatchingType(remainingParameterTypes, argumentType);
                if (type == null) continue block1;
                remainingParameterTypes.remove(type);
            }
            return true;
        }
        return false;
    }

    public Class getAssignableClass(List classes, Class clazz) {
        for (Object aClass : classes) {
            Class assignableTo = (Class)aClass;
            if (!assignableTo.isAssignableFrom(clazz)) continue;
            return assignableTo;
        }
        return null;
    }

    public Object[] assignParameters(Class[] parameterTypes, List objects) throws RuntimeException {
        int[] perm;
        if (parameterTypes.length > 5) {
            System.out.println("Oops");
        }
        for (Class parameterType1 : parameterTypes) {
            if (parameterType1 != null) continue;
            throw new NullPointerException("Parameter types must all be non-null.");
        }
        Object[] arguments = new Object[parameterTypes.length];
        List<Object> _objects = this.removeNulls(objects);
        if (parameterTypes.length != _objects.size()) {
            return null;
        }
        PermutationGenerator gen = new PermutationGenerator(parameterTypes.length);
        boolean foundAConstructor = false;
        while ((perm = gen.next()) != null) {
            boolean allAssigned = true;
            for (int i = 0; i < perm.length; ++i) {
                Class parameterType = parameterTypes[i];
                Class<?> aClass = _objects.get(perm[i]).getClass();
                if (parameterType.isAssignableFrom(aClass)) {
                    arguments[i] = _objects.get(perm[i]);
                    continue;
                }
                allAssigned = false;
            }
            if (!allAssigned) continue;
            foundAConstructor = true;
            break;
        }
        if (foundAConstructor) {
            return arguments;
        }
        return null;
    }

    public boolean assignClasses(Class[] constructorTypes, Class[] modelTypes, boolean exact, List<SessionNode> existingNodes) throws RuntimeException {
        int[] paramPerm;
        for (Class parameterType1 : constructorTypes) {
            if (parameterType1 != null) continue;
            throw new NullPointerException("Parameter types must all be non-null.");
        }
        if (existingNodes != null) {
            existingNodes.remove(this);
            for (Class type : constructorTypes) {
                if (type.equals(Parameters.class)) continue;
                boolean foundNode = false;
                block2: for (SessionNode node : existingNodes) {
                    for (Class clazz : node.getModelClasses()) {
                        if (!clazz.equals(type)) continue;
                        foundNode = true;
                        break block2;
                    }
                }
                if (foundNode) continue;
                return false;
            }
        }
        if (exact ? modelTypes.length != constructorTypes.length : modelTypes.length > constructorTypes.length) {
            return false;
        }
        if (this.numWithoutParams(modelTypes) == 0 && this.numWithoutParams(constructorTypes) > 0) {
            return false;
        }
        PermutationGenerator gen0 = new PermutationGenerator(constructorTypes.length);
        while ((paramPerm = gen0.next()) != null) {
            int[] modelPerm;
            PermutationGenerator gen = new PermutationGenerator(modelTypes.length);
            while ((modelPerm = gen.next()) != null) {
                boolean allAssigned = true;
                for (int i = 0; i < modelPerm.length; ++i) {
                    Class constructorType = constructorTypes[paramPerm[i]];
                    Class modelType = modelTypes[modelPerm[i]];
                    if (constructorType.isAssignableFrom(modelType)) continue;
                    allAssigned = false;
                }
                if (!allAssigned) continue;
                return true;
            }
        }
        return false;
    }

    private int numWithoutParams(Class[] modelTypes) {
        int n = 0;
        for (Class clazz : modelTypes) {
            if (clazz == Parameters.class) continue;
            ++n;
        }
        return n;
    }

    public int[] getValueCombination(int index, int[] numValues) {
        int[] values = new int[numValues.length];
        for (int i = numValues.length - 1; i >= 0; --i) {
            values[i] = index % numValues[i];
            index /= numValues[i];
        }
        return values;
    }

    public int getProduct(int[] arr) {
        int n = 1;
        for (int anArr : arr) {
            n *= anArr;
        }
        return n;
    }

    SessionHandler getSessionHandler() {
        if (this.sessionHandler == null) {
            this.sessionHandler = new SessionHandler();
        }
        return this.sessionHandler;
    }

    private boolean containsParent(SessionNode parent) {
        return this.parents.contains(parent);
    }

    private Class[] getModelParamTypes() {
        return this.modelParamTypes;
    }

    private boolean isNextEdgeAddAllowed() {
        return this.nextEdgeAddAllowed;
    }

    public void setNextEdgeAddAllowed(boolean nextEdgeAddAllowed) {
        this.nextEdgeAddAllowed = nextEdgeAddAllowed;
    }

    private List<Object> getParentModels() {
        ArrayList<Object> models = new ArrayList<Object>();
        for (SessionNode node : this.parents) {
            SessionModel model = node.getModel();
            if (model != null) {
                models.add(model);
                continue;
            }
            return null;
        }
        return models;
    }

    private List<Object> listParentModels() {
        ArrayList<Object> models = new ArrayList<Object>();
        for (SessionNode node : this.parents) {
            SessionModel model = node.getModel();
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    private void createModelUsingArguments(Class modelClass, List<Object> models) throws Exception {
        Constructor<?>[] constructors;
        if (!SessionModel.class.isAssignableFrom(modelClass)) {
            throw new ClassCastException("Model class must implement SessionModel: " + modelClass);
        }
        for (Constructor<?> constructor : constructors = modelClass.getConstructors()) {
            Class[] constructorTypes = constructor.getParameterTypes();
            Object[] arguments = null;
            if (constructorTypes.length == 2 && constructorTypes[0].isArray() && constructorTypes[1] == Parameters.class) {
                int i;
                Object o;
                ArrayList<Object> _objects = new ArrayList<Object>();
                Class<?> c1 = constructorTypes[0].getComponentType();
                Parameters parameters = null;
                for (Object value : models) {
                    Class<?> c2 = value.getClass();
                    if (c1.isAssignableFrom(c2)) {
                        _objects.add(value);
                    }
                    if (c2 != Parameters.class) continue;
                    parameters = (Parameters)value;
                }
                if (_objects.isEmpty()) {
                    return;
                }
                if (parameters != null) {
                    o = Array.newInstance(c1, _objects.size());
                    for (i = 0; i < _objects.size(); ++i) {
                        Array.set(o, i, _objects.get(i));
                    }
                    arguments = new Object[]{o, parameters};
                } else {
                    o = Array.newInstance(c1, _objects.size());
                    for (i = 0; i < _objects.size(); ++i) {
                        Array.set(o, i, _objects.get(i));
                    }
                    arguments = new Object[]{o};
                }
            }
            if (constructorTypes.length == 0) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "UI models shouldn't have blank constructors. This one did: " + modelClass.getName());
                continue;
            }
            if (arguments == null) {
                arguments = this.assignParameters(constructorTypes, models);
            }
            if (arguments == null) continue;
            try {
                this.model = (SessionModel)constructor.newInstance(arguments);
                this.model.setName(this.getDisplayName());
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                String packagePath = modelClass.getName();
                int begin = packagePath.lastIndexOf(46) + 1;
                String name = packagePath.substring(begin);
                e.printStackTrace();
                if (e.getCause().getMessage() != null && !e.getCause().getMessage().isEmpty()) {
                    throw new InvocationTargetException(e, e.getCause().getMessage());
                }
                throw new InvocationTargetException(e, "Could not construct node; root cause: " + e.getCause().getMessage() + " " + packagePath + " " + begin + " " + name);
            }
            this.modelParamTypes = constructorTypes;
            this.lastModelClass = modelClass;
            this.getSessionSupport().fireModelCreated(this);
            break;
        }
    }

    private boolean isConsistentModelClass(Class modelClass, Class[][] parentClasses, boolean exact, List<SessionNode> existingNodes) {
        Constructor<?>[] constructors;
        block0: for (Constructor<?> constructor : constructors = modelClass.getConstructors()) {
            int i;
            int j;
            Class[] constructorTypes = constructor.getParameterTypes();
            boolean hasParameters = false;
            for (Class<?> clazz : constructorTypes) {
                if (clazz != Parameters.class) continue;
                hasParameters = true;
                break;
            }
            if (constructorTypes.length == 2 && constructorTypes[0].isArray() && constructorTypes[1] == Parameters.class) {
                if (this.parents != null && this.parents.size() == 0) {
                    return false;
                }
                for (Class<?> clazz : parentClasses) {
                    boolean found = false;
                    for (j = 0; j < ((Class<?>)clazz).length; ++j) {
                        Class<?> c1 = constructorTypes[0].getComponentType();
                        Class<?> c2 = clazz[j];
                        if (c2 != Parameters.class && !c1.isAssignableFrom(c2)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                return true;
            }
            ArrayList summary = new ArrayList();
            for (i = 0; i < parentClasses.length; ++i) {
                summary.add(new ArrayList());
            }
            for (i = 0; i < parentClasses.length; ++i) {
                for (int j2 = 0; j2 < parentClasses[i].length; ++j2) {
                    Class[] classArray = constructorTypes;
                    int found = classArray.length;
                    for (j = 0; j < found; ++j) {
                        Class<?> constructorType = classArray[j];
                        if (!constructorType.isAssignableFrom(parentClasses[i][j2]) || ((List)summary.get(i)).contains(constructorType)) continue;
                        ((List)summary.get(i)).add(constructorType);
                    }
                }
            }
            int[] dims = new int[parentClasses.length];
            for (int i2 = 0; i2 < parentClasses.length; ++i2) {
                dims[i2] = ((List)summary.get(i2)).size();
                if (dims[i2] == 0) continue block0;
            }
            CombinationIterator iterator = new CombinationIterator(dims);
            while (iterator.hasNext()) {
                Class[] modelTypes;
                if (hasParameters) {
                    int[] nArray = iterator.next();
                    modelTypes = new Class[nArray.length + 1];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        modelTypes[i2] = (Class)((List)summary.get(i2)).get(nArray[i2]);
                    }
                    modelTypes[nArray.length] = Parameters.class;
                    if (!this.assignClasses(constructorTypes, modelTypes, exact, existingNodes)) continue;
                    return true;
                }
                int[] nArray = iterator.next();
                modelTypes = new Class[nArray.length];
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    modelTypes[i3] = (Class)((List)summary.get(i3)).get(nArray[i3]);
                }
                if (!this.assignClasses(constructorTypes, modelTypes, exact, existingNodes)) continue;
                return true;
            }
        }
        return false;
    }

    private Class findMatchingType(List<Class> parameterTypes, Class argumentType) {
        for (Class type : parameterTypes) {
            if (!type.isAssignableFrom(argumentType)) continue;
            return type;
        }
        return null;
    }

    private List<Object> removeNulls(List objects) {
        ArrayList<Object> _objects = new ArrayList<Object>();
        for (Object o : objects) {
            if (o == null) continue;
            _objects.add(o);
        }
        return _objects;
    }

    private void reassessModel() {
        if (this.modelParamTypes == null) {
            return;
        }
        for (Class clazz : this.modelParamTypes) {
            if (clazz != null) continue;
            return;
        }
        ArrayList list1 = new ArrayList();
        for (SessionNode node : this.parents) {
            SessionModel model = node.getModel();
            if (model == null) continue;
            list1.add(model.getClass());
        }
        List<Class> list2 = Arrays.asList(this.modelParamTypes);
        if (!list1.contains(list2) || !list2.contains(list1)) {
            this.destroyModel();
        }
    }

    private SessionSupport getSessionSupport() {
        if (this.sessionSupport == null) {
            this.sessionSupport = new SessionSupport(this);
            for (SessionNode child : this.children) {
                this.sessionSupport.addSessionListener(child.getSessionHandler());
            }
        }
        return this.sessionSupport;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(String displayName) {
        if (displayName == null) {
            throw new NullPointerException();
        }
        this.displayName = displayName;
        if (this.getModel() != null) {
            this.getModel().setName(displayName);
        }
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public NodeVariableType getNodeVariableType() {
        return this.nodeVariableType;
    }

    @Override
    public void setNodeVariableType(NodeVariableType nodeVariableType) {
        this.nodeVariableType = nodeVariableType;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.boxType == null) {
            throw new NullPointerException();
        }
        if (this.displayName == null) {
            throw new NullPointerException();
        }
        if (this.modelClasses == null) {
            throw new NullPointerException();
        }
        if (this.paramMap == null) {
            throw new NullPointerException();
        }
        if (this.parents == null) {
            throw new NullPointerException();
        }
        if (this.children == null) {
            throw new NullPointerException();
        }
        if (this.repetition < 1) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    private class SessionHandler
    extends SessionAdapter {
        private SessionHandler() {
        }

        @Override
        public void modelDestroyed(SessionEvent event) {
            SessionNode.this.reassessModel();
        }

        @Override
        public void executionStarted(SessionEvent event) {
            SessionModel model = SessionNode.this.getModel();
            for (Class clazz : SessionNode.this.modelClasses) {
                Parameters param = SessionNode.this.getParam(clazz);
                if (!(param instanceof ExecutionRestarter)) continue;
                ExecutionRestarter restarter = (ExecutionRestarter)((Object)param);
                restarter.newExecution();
            }
            SessionNode.this.getSessionSupport().fireSessionEvent(event);
        }
    }
}

