/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.session.SessionAdapter;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionListener;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.SessionSupport;
import edu.cmu.tetrad.session.SimulationParamsSource;
import edu.cmu.tetrad.util.MillisecondTimes;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;

public final class SimulationStudy {
    private final Session session;
    private transient SessionSupport sessionSupport;
    private Set<SessionNode> nodesToExecute;

    public SimulationStudy(Session session) {
        if (session == null) {
            throw new NullPointerException();
        }
        this.session = session;
        session.addSessionListener(new SessionAdapter(){

            @Override
            public void nodeRemoved(SessionEvent e) {
                SessionNode node = e.getNode();
                SimulationStudy.removeRepetition(node);
            }
        });
    }

    public static int getRepetition(SessionNode node) {
        if (node.getRepetition() < 1) {
            node.setRepetition(1);
        }
        return node.getRepetition();
    }

    private static void removeRepetition(SessionNode sessionNode) {
        sessionNode.setRepetition(1);
    }

    public static Set getDescendants(SessionNode node) {
        HashSet<SessionNode> descendants = new HashSet<SessionNode>();
        SimulationStudy.doChildClosureVisit(node, descendants);
        return descendants;
    }

    private static void doChildClosureVisit(SessionNode node, Set<SessionNode> closure) {
        if (!closure.contains(node)) {
            closure.add(node);
            Set<SessionNode> children = node.getChildren();
            for (SessionNode child : children) {
                SimulationStudy.doChildClosureVisit(child, closure);
            }
        }
    }

    public void setRepetition(SessionNode node, int repetition) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (repetition <= 0) {
            throw new IllegalArgumentException("Repeat must be > 0: " + repetition);
        }
        node.setRepetition(repetition);
        this.getSessionSupport().fireRepetitionChanged(node);
    }

    public void execute(SessionNode sessionNode, boolean overwrite) {
        if (!this.session.contains(sessionNode)) {
            throw new IllegalArgumentException("Session node not in the session: " + sessionNode.getDisplayName());
        }
        this.nodesToExecute = this.session.getNodes();
        LinkedList<SessionNode> tierOrdering = new LinkedList<SessionNode>(this.getTierOrdering(sessionNode));
        this.notifyDownstreamOfStart(sessionNode);
        boolean doRepetition = true;
        boolean simulation = true;
        TetradLogger.getInstance().forceLogMessage("\n\n===STARTING SIMULATION STUDY===");
        long time1 = MillisecondTimes.timeMillis();
        this.execute(tierOrdering, true, true, overwrite);
        TetradLogger.getInstance().forceLogMessage("\n\n===FINISHING SIMULATION STUDY===");
        long time2 = MillisecondTimes.timeMillis();
        TetradLogger.getInstance().forceLogMessage("Elapsed time = " + (double)(time2 - time1) / 1000.0 + " s");
    }

    public boolean createDescendantModels(SessionNode sessionNode, boolean overwrite) {
        if (!this.session.contains(sessionNode)) {
            throw new IllegalArgumentException("Session node not in the session: " + sessionNode.getDisplayName());
        }
        this.nodesToExecute = this.session.getNodes();
        LinkedList<SessionNode> tierOrdering = this.getTierOrdering(sessionNode);
        if (sessionNode.getModel() != null) {
            tierOrdering.remove(sessionNode);
        }
        this.notifyDownstreamOfStart(sessionNode);
        boolean doRepetition = false;
        boolean simulation = true;
        return this.execute(tierOrdering, false, true, overwrite);
    }

    public void addSessionListener(SessionListener l) {
        this.getSessionSupport().addSessionListener(l);
    }

    private HashSet<SessionNode> nodesWithModels() {
        HashSet<SessionNode> nodesWithModels = new HashSet<SessionNode>();
        for (SessionNode node : this.session.getNodes()) {
            if (node.getModel() == null) continue;
            nodesWithModels.add(node);
        }
        return nodesWithModels;
    }

    private void notifyDownstreamOfStart(SessionNode sessionNode) {
        SessionSupport sessionSupport = new SessionSupport(this);
        sessionSupport.addSessionListener(sessionNode.getSessionHandler());
        sessionSupport.fireExecutionStarted();
    }

    private boolean execute(LinkedList<SessionNode> tierOrdering, boolean doRepetition, boolean simulation, boolean overwrite) {
        if (tierOrdering.isEmpty()) {
            return true;
        }
        SessionNode sessionNode = tierOrdering.getFirst();
        if (!this.session.contains(sessionNode)) {
            throw new IllegalArgumentException("Session node not in the session: " + sessionNode.getDisplayName());
        }
        if (!this.nodesToExecute.contains(sessionNode)) {
            return false;
        }
        int repetition = doRepetition ? SimulationStudy.getRepetition(sessionNode) : 1;
        Preferences.userRoot().putBoolean("errorFound", false);
        for (int i = 0; i < repetition; ++i) {
            if (!Preferences.userRoot().getBoolean("experimental", false) || Preferences.userRoot().getBoolean("errorFound", false)) {
                // empty if block
            }
            if (!overwrite && sessionNode.getModel() != null) {
                return false;
            }
            sessionNode.destroyModel();
            try {
                boolean created;
                if (repetition > 1) {
                    TetradLogger.getInstance().forceLogMessage("\nREPETITION #" + (i + 1) + " FOR " + sessionNode.getDisplayName() + "\n");
                }
                if (created = sessionNode.createModel(simulation)) {
                    SessionModel source = sessionNode.getModel();
                    LinkedHashMap<String, String> paramSettings = new LinkedHashMap<String, String>();
                    this.collectParentParamSettings(sessionNode, paramSettings);
                    if (source instanceof SimulationParamsSource) {
                        ((SimulationParamsSource)((Object)source)).setAllParamSettings(paramSettings);
                    }
                }
                if (!created) {
                    return false;
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return false;
            }
            LinkedList<SessionNode> _tierOrdering = new LinkedList<SessionNode>(tierOrdering);
            _tierOrdering.removeFirst();
            boolean success = this.execute(_tierOrdering, doRepetition, simulation, overwrite);
            if (success) continue;
            return false;
        }
        return true;
    }

    private void collectParentParamSettings(SessionNode sessionNode, Map<String, String> paramSettings) {
        for (SessionNode parent : sessionNode.getParents()) {
            this.collectParentParamSettings(parent, paramSettings);
        }
    }

    private LinkedList<SessionNode> getTierOrdering(SessionNode node) {
        Session session = this.session;
        Set<SessionNode> sessionNodes = session.getNodes();
        LinkedList<SessionNode> found = new LinkedList<SessionNode>();
        HashSet<SessionNode> notFound = new HashSet<SessionNode>(sessionNodes);
        while (!notFound.isEmpty()) {
            Iterator it = notFound.iterator();
            while (it.hasNext()) {
                SessionNode sessionNode = (SessionNode)it.next();
                if (!found.containsAll(sessionNode.getParents())) continue;
                found.add(sessionNode);
                it.remove();
            }
        }
        found.retainAll(SimulationStudy.getDescendants(node));
        return found;
    }

    private SessionSupport getSessionSupport() {
        if (this.sessionSupport == null) {
            this.sessionSupport = new SessionSupport(this);
        }
        return this.sessionSupport;
    }

    public Session getSession() {
        return this.session;
    }
}

