/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.simulation.Vicinity;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.math3.util.FastMath;

public class Gdistance {
    private final DataSet locationMap;
    private final double xDist;
    private final double yDist;
    private final double zDist;
    private final List<Double> leastList;
    private final int chunksize = 2;
    private final int cores = Runtime.getRuntime().availableProcessors();

    public Gdistance(DataSet locationMap, double xDist, double yDist, double zDist) {
        this.locationMap = locationMap;
        this.xDist = xDist;
        this.yDist = yDist;
        this.zDist = zDist;
        this.leastList = new ArrayList<Double>();
    }

    private static double nodesDistance(Node node1, Node node2, DataSet locationMap, double x, double y, double z) {
        int column1 = locationMap.getColumn(node1);
        int column2 = locationMap.getColumn(node2);
        double value11 = locationMap.getDouble(0, column1);
        double value12 = locationMap.getDouble(1, column1);
        double value13 = locationMap.getDouble(2, column1);
        double value21 = locationMap.getDouble(0, column2);
        double value22 = locationMap.getDouble(1, column2);
        double value23 = locationMap.getDouble(2, column2);
        return FastMath.sqrt((value11 - value21) * x * (value11 - value21) * x + (value12 - value22) * y * (value12 - value22) * y + (value13 - value23) * z * (value13 - value23) * z);
    }

    private static double edgesDistance(Edge edge1, Edge edge2, DataSet locationMap, double xD, double yD, double zD) {
        if (edge1.isDirected() && edge2.isDirected()) {
            Node edge1h = Edges.getDirectedEdgeHead(edge1);
            Node edge1t = Edges.getDirectedEdgeTail(edge1);
            Node edge2h = Edges.getDirectedEdgeHead(edge2);
            Node edge2t = Edges.getDirectedEdgeTail(edge2);
            double tDistance = Gdistance.nodesDistance(edge1t, edge2t, locationMap, xD, yD, zD);
            double hDistance = Gdistance.nodesDistance(edge1h, edge2h, locationMap, xD, yD, zD);
            return tDistance + hDistance;
        }
        Node node11 = edge1.getNode1();
        Node node12 = edge1.getNode2();
        Node node21 = edge2.getNode1();
        Node node22 = edge2.getNode2();
        double dist11 = Gdistance.nodesDistance(node11, node21, locationMap, xD, yD, zD);
        double dist22 = Gdistance.nodesDistance(node12, node22, locationMap, xD, yD, zD);
        double dist12 = Gdistance.nodesDistance(node11, node22, locationMap, xD, yD, zD);
        double dist21 = Gdistance.nodesDistance(node12, node21, locationMap, xD, yD, zD);
        return FastMath.min(dist11 + dist22, dist12 + dist21);
    }

    public List<Double> distances(Graph graph1, Graph graph2) {
        System.out.println("Synchronizing variables between graph1, graph2, and the locationMap");
        long time1 = System.nanoTime();
        graph1 = GraphUtils.replaceNodes(graph1, this.locationMap.getVariables());
        graph2 = GraphUtils.replaceNodes(graph2, this.locationMap.getVariables());
        long time2 = System.nanoTime();
        System.out.println("Synchronizing time: " + (time2 - time1) / 1000000000L + "s");
        System.out.println("Constructing vicinity object");
        long timevic1 = System.nanoTime();
        ArrayList<Edge> graph2edges = new ArrayList<Edge>(graph2.getEdges());
        Vicinity vicinity = new Vicinity(graph2edges, this.locationMap, 0, 100, 0, 100, 0, 100, this.xDist, this.yDist, this.zDist);
        long timevic2 = System.nanoTime();
        System.out.println("Done constructing vicinity object. Construction Time : " + (timevic2 - timevic1) / 1000000000L + "s");
        ArrayList<Callable<Void>> todo = new ArrayList<Callable<Void>>();
        ExecutorService executorService = Executors.newCachedThreadPool();
        ArrayList<Edge> taskEdges = new ArrayList<Edge>();
        int taskSize = (int)FastMath.ceil((double)graph1.getNumEdges() / (5.0 * (double)this.cores));
        System.out.println(" edges1: " + graph1.getNumEdges() + " taskSize: " + taskSize);
        for (Edge edge1 : graph1.getEdges()) {
            taskEdges.add(edge1);
            if (taskEdges.size() < taskSize) continue;
            ArrayList runEdges = new ArrayList(taskEdges);
            todo.add(() -> {
                FindLeastDistanceTask FLDtask = new FindLeastDistanceTask(vicinity);
                FLDtask.compute(runEdges);
                return null;
            });
            taskEdges.clear();
        }
        if (!taskEdges.isEmpty()) {
            ArrayList runEdges = new ArrayList(taskEdges);
            todo.add(() -> {
                FindLeastDistanceTask FLDtask = new FindLeastDistanceTask(vicinity);
                FLDtask.compute(runEdges);
                return null;
            });
            taskEdges.clear();
        }
        try {
            System.out.println("number of parallel tasks being invoked: " + todo.size());
            executorService.invokeAll(todo);
            executorService.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(this.leastList.size());
        return this.leastList;
    }

    private synchronized void add(Double value) {
        this.leastList.add(value);
    }

    class FindLeastDistanceTask {
        Vicinity vicinity;

        private FindLeastDistanceTask(Vicinity vicinity) {
            this.vicinity = vicinity;
        }

        protected void compute(List<Edge> edges) {
            for (Edge edge1 : edges) {
                int count = 1;
                double leastDistance = -1.0;
                List<Edge> vicEdges = this.vicinity.getVicinity(edge1, 2);
                for (Edge edge2 : vicEdges) {
                    double thisDistance = Gdistance.edgesDistance(edge1, edge2, Gdistance.this.locationMap, Gdistance.this.xDist, Gdistance.this.yDist, Gdistance.this.zDist);
                    if (count == 1) {
                        leastDistance = thisDistance;
                    } else if (thisDistance < leastDistance) {
                        leastDistance = thisDistance;
                    }
                    ++count;
                }
                Gdistance.this.add(leastDistance);
            }
        }
    }
}

