/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphTransforms;
import edu.cmu.tetrad.graph.RandomGraph;
import edu.cmu.tetrad.simulation.Gdistance;
import java.util.ArrayList;
import java.util.List;

public class GdistanceRandom {
    private static DataSet locationMap;
    double xdist = 2.4;
    double ydist = 2.4;
    double zdist = 2.0;
    private int numEdges1;
    private int numEdges2;
    private boolean verbose;

    public GdistanceRandom(DataSet inMap) {
        this.setLocationMap(inMap);
    }

    public List<List<Double>> randomSimulation(int repeat) {
        ArrayList<List<Double>> simdata = new ArrayList<List<Double>>();
        if (this.verbose) {
            System.out.println("starting simulation loop");
        }
        for (int counter = 0; counter < repeat; ++counter) {
            if (this.verbose) {
                System.out.println("counter = " + counter);
            }
            List<Double> distance = this.randomPairSimulation();
            if (this.verbose) {
                System.out.println("adding distance to simdata");
            }
            simdata.add(distance);
        }
        return simdata;
    }

    private List<Double> randomPairSimulation() {
        int numVars = locationMap.getNumColumns();
        if (this.verbose) {
            System.out.println("generating pair of random dags");
        }
        Graph dag1 = RandomGraph.randomGraphRandomForwardEdges(locationMap.getVariables(), 0, this.numEdges1, numVars, numVars, numVars, false, false);
        if (this.verbose) {
            System.out.println(dag1);
        }
        Graph dag2 = RandomGraph.randomGraphRandomForwardEdges(locationMap.getVariables(), 0, this.numEdges2, numVars, numVars, numVars, false, false);
        if (this.verbose) {
            System.out.println("converting dags to CPDAGs");
        }
        Graph graph1 = GraphTransforms.cpdagForDag(dag1);
        Graph graph2 = GraphTransforms.cpdagForDag(dag2);
        if (this.verbose) {
            System.out.println("running Gdistance on the CPDAGs");
        }
        Gdistance gdist = new Gdistance(locationMap, this.xdist, this.ydist, this.zdist);
        return gdist.distances(graph1, graph2);
    }

    public void setLocationMap(DataSet map) {
        locationMap = map;
    }

    public void setNumEdges1(int edges) {
        this.numEdges1 = edges;
    }

    public void setNumEdges2(int edges) {
        this.numEdges2 = edges;
    }

    public void setVerbose(boolean wantverbose) {
        this.verbose = wantverbose;
    }
}

