/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.simulation.GdistanceRandom;
import edu.cmu.tetrad.simulation.GdistanceUtils;
import edu.cmu.tetrad.util.DataConvertUtils;
import edu.pitt.dbmi.data.reader.Delimiter;
import edu.pitt.dbmi.data.reader.tabular.ContinuousTabularDatasetFileReader;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

public class GdistanceRandomApply {
    public static void main(String ... args) {
        double[] thresholds = new double[]{0.0, 2.0, 4.0, 6.0, 8.0};
        String workingDirectory = System.getProperty("user.dir");
        System.out.println(workingDirectory);
        Path mapPath = Paths.get("erich_coordinates.txt", new String[0]);
        System.out.println(mapPath);
        ContinuousTabularDatasetFileReader dataReaderMap = new ContinuousTabularDatasetFileReader(mapPath, Delimiter.COMMA);
        try {
            DataSet locationMap = (DataSet)DataConvertUtils.toDataModel(dataReaderMap.readInData());
            System.out.println("locationMap loaded");
            GdistanceRandom simRandGdistances = new GdistanceRandom(locationMap);
            System.out.println("GdistanceRandom constructed");
            simRandGdistances.setNumEdges1(300);
            simRandGdistances.setNumEdges2(300);
            simRandGdistances.setVerbose(false);
            System.out.println("Edge parameters set, starting simulations");
            List<List<Double>> GdistanceLists = simRandGdistances.randomSimulation(2);
            System.out.println("Simulations done, calculating histograms");
            for (List<Double> gdist : GdistanceLists) {
                double[] histogram = GdistanceUtils.histogram(gdist, thresholds);
                String histString = " ";
                for (int i = 0; i < Array.getLength(histogram); ++i) {
                    histString = histString + " " + histogram[i];
                }
                System.out.println(histString);
            }
        }
        catch (Exception IOException2) {
            IOException2.printStackTrace();
        }
    }
}

