/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.simulation;

import java.lang.reflect.Array;
import java.util.List;

public class GdistanceUtils {
    public static double[] histogram(List<Double> input, double[] thresholds) {
        double[] output = new double[Array.getLength(thresholds) + 1];
        double total = input.size();
        for (int i = 0; i < Array.getLength(output); ++i) {
            output[i] = 0.0;
        }
        for (Double i : input) {
            boolean nobinfound = true;
            for (int j = 0; j < Array.getLength(thresholds); ++j) {
                if (!(i <= thresholds[j])) continue;
                int n = j;
                output[n] = output[n] + 1.0;
                nobinfound = false;
                break;
            }
            if (!nobinfound) continue;
            if (i > thresholds[Array.getLength(thresholds) - 1]) {
                int n = Array.getLength(thresholds);
                output[n] = output[n] + 1.0;
                continue;
            }
            throw new IllegalArgumentException("Something weird happened?");
        }
        for (int i = 0; i < Array.getLength(output); ++i) {
            output[i] = output[i] / total;
        }
        return output;
    }
}

